/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.rcp.MainPlugin;
import org.eclipse.epf.rcp.MainWorkbenchWindowAdvisor;
import org.eclipse.epf.rcp.RCPResources;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;

public class MainWorkbenchAdvisor
extends WorkbenchAdvisor {
    protected Logger logger;

    public void initialize(IWorkbenchConfigurer configurer) {
        this.logger = MainPlugin.getDefault().getLogger();
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        String appStartDir = System.getProperty("user.dir");
        this.logger.logInfo(String.valueOf(RCPResources.getString("RCP.rmc.startup.dir.log.info.text")) + appStartDir);
        String[] rmcArgs = Platform.getApplicationArgs();
        int i = 0;
        while (i < rmcArgs.length) {
            if (rmcArgs[i].equalsIgnoreCase("-library") && i < rmcArgs.length - 1) {
                LibraryUIManager.setCommandLineLibraryPath((String)rmcArgs[i + 1]);
            }
            ++i;
        }
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new MainWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return AuthoringPerspective.PERSPECTIVE_ID;
    }

    public void preStartup() {
        super.preStartup();
        WorkbenchAdapterBuilder.registerAdapters();
    }

    public boolean preShutdown() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = activeWindow.getActivePage();
        if (page != null && page instanceof WorkbenchPage) {
            IViewReference[] vwRefList = page.getViewReferences();
            boolean introViewExists = false;
            int i = 0;
            while (i < vwRefList.length) {
                if (vwRefList[i].getId().equals("org.eclipse.ui.internal.introview")) {
                    introViewExists = true;
                    break;
                }
                ++i;
            }
            IPreferenceStore store = MainPlugin.getDefault().getPreferenceStore();
            store.setValue("welcome_intro_view_exists", introViewExists);
            MainPlugin.getDefault().savePluginPreferences();
        }
        return true;
    }

    public void postShutdown() {
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (CoreException coreException) {}
    }
}

