/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.configuration.ConfigurationFactory;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;

public class ConfigurationExportService {
    private ConfigurationExportData data;

    public ConfigurationExportService(ConfigurationExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        try {
            if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
                return;
            }
            monitor.setTaskName(ExportResources.getString("Export.ConfigurationExportService.MSG0"));
            String exportLibPath = this.data.llData.getParentFolder();
            File exportLibFolder = new File(exportLibPath);
            if (!exportLibFolder.exists()) {
                exportLibFolder.mkdir();
            }
            MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
            this.exportConfig(config.getName(), exportLibFolder.getAbsolutePath(), monitor);
        }
        catch (Exception e) {
            ExportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void exportConfig(String selectedConfigName, String filePath, IProgressMonitor monitor) throws Exception {
        MethodLibrary currentLib = LibraryProcessor.getInstance().getLibrary();
        try {
            LibraryUtil.loadAll((MethodLibrary)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error loading library", e);
            this.data.errorMsg = ExportResources.getString("Export.ConfigurationExportService.MSG2");
            return;
        }
        MethodLibrary newLibrary = null;
        try {
            newLibrary = (MethodLibrary)EcoreUtil.copy((EObject)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError(e);
            this.data.errorMsg = ExportResources.getString("Export.ConfigurationExportService.MSG4");
            return;
        }
        LibraryProcessor proc = new LibraryProcessor(null);
        ConfigurationFactory newFactory = null;
        ConfigurationClosure closure = null;
        try {
            LibraryUtil.detachFromResource((MethodLibrary)newLibrary);
            proc.newLibrary("library.xmi", filePath, true);
            proc.setLibrary(newLibrary);
            MethodConfiguration config = proc.getConfiguration(selectedConfigName);
            LibraryUtil.validateMethodConfiguration((MethodConfiguration)config);
            newFactory = new ConfigurationFactory(proc);
            closure = new ConfigurationClosure(newFactory, config);
            closure.packageLibrary(this.data.removeBrokenReferences);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error making library configuration closure", e);
            this.data.errorMsg = ExportResources.getString("Export.ConfigurationExportService.MSG1");
            if (closure != null) {
                closure.dispose();
            }
            if (newFactory != null) {
                newFactory.clear();
            }
            proc.closeOpenedLibrary();
            return;
        }
        try {
            LibraryUtil.saveAll((MethodLibrary)newLibrary);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error saving library", e);
            this.data.errorMsg = ExportResources.getString("Export.ConfigurationExportService.MSG9");
            if (closure != null) {
                closure.dispose();
            }
            if (newFactory != null) {
                newFactory.clear();
            }
            proc.closeOpenedLibrary();
            return;
        }
        String includes = "resources/**, **/resources/**";
        File srcDir = LibraryUtil.getLibraryRootPath((MethodLibrary)currentLib);
        File destDir = LibraryUtil.getLibraryRootPath((MethodLibrary)newLibrary);
        LayoutResources.copyDir((File)srcDir, (File)destDir, (String)includes, null);
        if (closure != null) {
            closure.dispose();
        }
        if (newFactory != null) {
            newFactory.clear();
        }
        proc.closeOpenedLibrary();
    }
}

