/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.PluginExportData;

public class PluginExportService
extends BaseExportService {
    PluginExportData data;

    public PluginExportService(PluginExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        monitor.setTaskName(ExportResources.getString("Export.PluginExportService.MSG0"));
        List plugins = this.data.selectedPlugins;
        if (plugins == null || plugins.size() == 0) {
            return;
        }
        monitor.setTaskName(ExportResources.getString("Export.PluginExportService.MSG1"));
        String exportLibPath = this.data.llData.getParentFolder();
        File exportLibFolder = new File(exportLibPath);
        if (!exportLibFolder.exists()) {
            exportLibFolder.mkdir();
        }
        File libFolder = null;
        monitor.setTaskName(ExportResources.getString("Export.PluginExportService.MSG2"));
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (plugin == null) continue;
            URI uri = plugin.eResource().getURI();
            String path = uri.toFileString();
            File pluginFolder = new File(path).getParentFile();
            if (libFolder == null) {
                libFolder = pluginFolder.getParentFile();
            }
            String pluginPath = libFolder.toURI().relativize(pluginFolder.toURI()).getPath();
            File exportPluginFolder = new File(exportLibFolder, pluginPath);
            PluginExportService.copyDir(pluginFolder, exportPluginFolder);
        }
        monitor.setTaskName(ExportResources.getString("Export.PluginExportService.MSG3"));
        this.getSelectedIds(this.data.selectedPlugins, this.data.associatedConfigMap);
        this.processLibraryFile(new File(libFolder, "library.xmi"), new File(exportLibFolder, "export.xmi"));
        monitor.setTaskName(ExportResources.getString("Export.PluginExportService.MSG4"));
    }

    public static void copyDir(File fromDir, File toDir) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        FileSet set = new FileSet();
        set.setDir(fromDir);
        cp.addFileset(set);
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.execute();
    }

    private void getSelectedIds(List plugins, Map configsMap) {
        MethodLibrary lib;
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        MethodPlugin plugin = null;
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            plugin = (MethodPlugin)it.next();
            String guid = plugin.getGuid();
            this.selectedPluginNames.add(plugin.getName());
            if (this.selectedIds.contains(guid)) continue;
            this.selectedIds.add(guid);
        }
        if (plugin != null && (lib = (MethodLibrary)plugin.eContainer()) != null) {
            this.selectedIds.add(lib.getGuid());
        }
        Iterator itc = configsMap.values().iterator();
        while (itc.hasNext()) {
            List configs = (List)itc.next();
            if (configs == null || configs.size() == 0) continue;
            Iterator it2 = configs.iterator();
            while (it2.hasNext()) {
                MethodConfiguration config = (MethodConfiguration)it2.next();
                String guid = config.getGuid();
                if (this.selectedIds.contains(guid)) continue;
                this.selectedIds.add(guid);
                EList refs = config.eCrossReferences();
                Iterator itr = refs.iterator();
                while (itr.hasNext()) {
                    Object o = itr.next();
                    if (o instanceof MethodPlugin || o instanceof MethodPackage) {
                        guid = ((MethodElement)o).getGuid();
                        if (this.selectedIds.contains(guid)) continue;
                        this.selectedIds.add(guid);
                        continue;
                    }
                    System.out.println("Unexpected element type '" + ((MethodElement)o).getType().getName() + "' in configuration '" + config.getName() + "'");
                }
            }
        }
    }
}

