/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.preferences.CommonPrefPage;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PublishingPreferencePage
extends CommonPrefPage
implements IWorkbenchPreferencePage,
SelectionListener,
ModifyListener {
    private Composite composite;
    private Text destinationPathText;
    private Text feedbackURLText;
    private Button browseButton;

    protected Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Group destinationGroup = new Group(this.composite, 0);
        destinationGroup.setLayout((Layout)new GridLayout(3, false));
        destinationGroup.setLayoutData((Object)new GridData(768));
        destinationGroup.setText(PublishingUIResources.getString("PublishingUI.publishConfigWizard.destinationGroup.text"));
        this.createLabel((Composite)destinationGroup, PublishingUIResources.getString("PublishingUI.preferencePage.defaultPath.text"));
        this.destinationPathText = this.createEditableText((Composite)destinationGroup, "");
        this.destinationPathText.setText(PublishingUIPreferences.getDefaultPublishPath());
        this.browseButton = new Button((Composite)destinationGroup, 0);
        this.browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        Group webSiteGroup = new Group(this.composite, 0);
        webSiteGroup.setLayout((Layout)new GridLayout(2, false));
        webSiteGroup.setLayoutData((Object)new GridData(768));
        webSiteGroup.setText(PublishingUIResources.getString("PublishingUI.publishConfigWizard.webSite.text"));
        this.createLabel((Composite)webSiteGroup, PublishingUIResources.getString("PublishingUI.publishConfigWizard.feedbackURL.text"));
        this.feedbackURLText = this.createEditableText((Composite)webSiteGroup, "");
        this.feedbackURLText.setText(PublishingUIPreferences.getDefaultFeedbackURL());
        this.createLabel((Composite)webSiteGroup, "");
        this.initializeValues();
        this.destinationPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!PublishingPreferencePage.this.isPathValid(PublishingPreferencePage.this.destinationPathText.getText())) {
                    PublishingPreferencePage.this.setValid(false);
                } else {
                    PublishingPreferencePage.this.setValid(true);
                }
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PublishingPreferencePage.this.openDirectoryDialog();
            }
        });
        return this.composite;
    }

    public void init(IWorkbench workbench) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        LibraryPlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void storeValues() {
        PublishingUIPreferences.setDefaultPublishPath(this.destinationPathText.getText().trim());
        PublishingUIPreferences.setDefaultFeedbackURL(this.feedbackURLText.getText().trim());
    }

    private void initializeDefaults() {
        this.destinationPathText.setText(PublishingUIPreferences.getInitDefaultPublishPath());
        this.feedbackURLText.setText(PublishingUIPreferences.getInitDefaultFeedbackURL());
    }

    private void initializeValues() {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PublishingPlugin.getDefault().getPreferenceStore();
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(text);
        return label;
    }

    protected Text createEditableText(Composite parent, String defaultText) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.composite.getShell(), 0);
            String destination = dd.open();
            if (destination != null) {
                this.destinationPathText.setText(destination);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean isPathValid(String path) {
        if (path == null || path.length() <= 0) {
            this.setErrorMessage(PublishingUIResources.getString("PublishingUI.invalidPathError.msg"));
            return false;
        }
        IPath ecPath = Path.fromOSString((String)path);
        boolean isValid = ecPath.isValidPath(path);
        if (!isValid) {
            this.setErrorMessage(PublishingUIResources.getString("PublishingUI.invalidPathError.msg"));
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)path)) {
            this.setErrorMessage(PublishingUIResources.getString("PublishingUI.invalidPathCharsError.msg"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

