/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.preferences;

import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;

public class PublishingUIPreferences {
    public static final String PUBLISH_PATH = "publishPath";
    public static final String PUBLISH_PATH_DEFAULT = "publishPathDefault";
    public static final String TITLE = "title";
    public static final String BANNER_IMAGE = "bannerImage";
    public static final String ABOUT_HTML = "aboutHTML";
    public static final String FEEDBACK_URL = "feedbackURL";
    public static final String FEEDBACK_URL_DEFAULT = "feedbackURLDefault";
    public static final String INCLUDE_GLOSSARY = "includeGlossary";
    public static final String INCLUDE_INDEX = "includeIndex";
    public static final String INCLUDE_SEARCH = "includeSearch";
    public static final String INCLUDE_PROCESS_CUSTOMIZATION = "includeProcessCustomization";
    public static final String CHECK_EXTERNAL_LINKS = "checkExternalLinks";
    private static String defaultPublishPath = null;
    private static String defaultTitle = null;
    private static String defaultBannerImage = null;
    private static String defaultAboutHTML = null;
    private static String defaultFeedbackURL = null;

    static {
        IPreferenceStore store = PublishingUIPlugin.getDefault().getPreferenceStore();
        store.setDefault(PUBLISH_PATH, PublishingUIPreferences.getPublishPath());
        store.setDefault(PUBLISH_PATH_DEFAULT, PublishingUIPreferences.getDefaultPublishPath());
        store.setDefault(TITLE, PublishingUIPreferences.getDefaultTitle());
        store.setDefault(BANNER_IMAGE, PublishingUIPreferences.getDefaultBannerImage());
        store.setDefault(ABOUT_HTML, PublishingUIPreferences.getDefaultAboutHTML());
        store.setDefault(FEEDBACK_URL, PublishingUIPreferences.getFeedbackURL());
        store.setDefault(FEEDBACK_URL_DEFAULT, PublishingUIPreferences.getDefaultFeedbackURL());
        store.setDefault(INCLUDE_GLOSSARY, true);
        store.setDefault(INCLUDE_INDEX, true);
        store.setDefault(INCLUDE_SEARCH, true);
        store.setDefault(INCLUDE_PROCESS_CUSTOMIZATION, true);
        store.setDefault(CHECK_EXTERNAL_LINKS, true);
    }

    public static String getPublishPath() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(PUBLISH_PATH);
    }

    public static void setPublishPath(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(PUBLISH_PATH, path);
    }

    public static String getTitle() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(TITLE);
    }

    public static void setTitle(String title) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(TITLE, title);
    }

    public static String getBannerImage() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(BANNER_IMAGE);
    }

    public static void setBannerImage(String image) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(BANNER_IMAGE, image);
    }

    public static String getAboutHTML() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(ABOUT_HTML);
    }

    public static void setAboutHTML(String file) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(ABOUT_HTML, file);
    }

    public static String getFeedbackURL() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getString(FEEDBACK_URL);
    }

    public static void setFeedbackURL(String url) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(FEEDBACK_URL, url);
    }

    public static boolean getIncludeGlossary() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(INCLUDE_GLOSSARY);
    }

    public static void setIncludeGlossary(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(INCLUDE_GLOSSARY, flag);
    }

    public static boolean getIncludeIndex() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(INCLUDE_INDEX);
    }

    public static void setIncludeIndex(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(INCLUDE_INDEX, flag);
    }

    public static boolean getIncludeSearch() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(INCLUDE_SEARCH);
    }

    public static void setIncludeSearch(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(INCLUDE_SEARCH, flag);
    }

    public static boolean getIncludeProcessCustomization() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(INCLUDE_PROCESS_CUSTOMIZATION);
    }

    public static void setIncludeProcessCustomization(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(INCLUDE_PROCESS_CUSTOMIZATION, flag);
    }

    public static boolean getCheckExternalLinks() {
        return PublishingUIPlugin.getDefault().getPreferenceStore().getBoolean(CHECK_EXTERNAL_LINKS);
    }

    public static void setCheckExternalLinks(boolean flag) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(CHECK_EXTERNAL_LINKS, flag);
    }

    public static String getDefaultPublishPath() {
        defaultPublishPath = PublishingUIPlugin.getDefault().getPreferenceStore().getString(PUBLISH_PATH_DEFAULT).trim();
        if (defaultPublishPath == null || defaultPublishPath.length() <= 0) {
            defaultPublishPath = PublishingUIPreferences.getInitDefaultPublishPath();
        }
        return defaultPublishPath;
    }

    public static String getInitDefaultPublishPath() {
        String userHome = System.getProperty("user.home").replace('\\', '/');
        String path = PublishingUIPlugin.getDefault().getString(PUBLISH_PATH);
        if (path == null || path.length() == 0 || path.startsWith("[")) {
            path = String.valueOf(userHome) + "/publish";
        } else if (path.startsWith("<user.home>")) {
            path = String.valueOf(userHome) + path.substring(11);
        }
        if (System.getProperty("file.separator").equals("\\")) {
            path = path.replace('/', '\\');
        }
        return path;
    }

    public static void setDefaultPublishPath(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(PUBLISH_PATH_DEFAULT, path);
    }

    public static String getDefaultTitle() {
        if (defaultTitle == null) {
            String url = PublishingUIPlugin.getDefault().getString(TITLE);
            if (url == null || url.length() == 0 || url.startsWith("[")) {
                url = "";
            }
            defaultTitle = url;
        }
        return defaultTitle;
    }

    public static String getDefaultBannerImage() {
        if (defaultBannerImage == null) {
            String image = PublishingUIPlugin.getDefault().getString(BANNER_IMAGE);
            if (image == null || image.length() == 0 || image.startsWith("[")) {
                image = "";
            }
            defaultBannerImage = image;
        }
        return defaultBannerImage;
    }

    public static String getDefaultAboutHTML() {
        if (defaultAboutHTML == null) {
            String file = PublishingUIPlugin.getDefault().getString(ABOUT_HTML);
            if (file == null || file.length() == 0 || file.startsWith("[")) {
                file = "";
            }
            defaultAboutHTML = file;
        }
        return defaultAboutHTML;
    }

    public static String getDefaultFeedbackURL() {
        defaultFeedbackURL = PublishingUIPlugin.getDefault().getPreferenceStore().getString(FEEDBACK_URL_DEFAULT).trim();
        if (defaultFeedbackURL == null || defaultFeedbackURL.length() <= 0) {
            defaultFeedbackURL = PublishingUIPreferences.getInitDefaultFeedbackURL();
        }
        return defaultFeedbackURL;
    }

    public static String getInitDefaultFeedbackURL() {
        String url = PublishingUIPlugin.getDefault().getString(FEEDBACK_URL);
        if (url == null || url.length() == 0 || url.startsWith("[")) {
            url = "http://www.published_website.com/feedback";
        }
        return url;
    }

    public static void setDefaultFeedbackURL(String path) {
        PublishingUIPlugin.getDefault().getPreferenceStore().setValue(FEEDBACK_URL_DEFAULT, path);
    }
}

