/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.wizards;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;

class PublishingOperation
implements IRunnableWithProgress {
    private static final String PUBLISH_CONFIG_ERROR_TITLE = PublishingUIResources.getString("PublishingUI.publishConfigDialog.title");
    private static final String PUBLISH_CONFIG_ERROR_MSG = PublishingUIResources.getString("PublishingUI.publishConfigError.msg");
    private static final String PUBLISH_CONFIG_ERROR_REASON = PublishingUIResources.getString("PublishingUI.publishConfigError.reason");
    private static final String PREVIEW_CONFIG_ERROR_TITLE = PublishingUIResources.getString("PublishingUI.previewConfigError.title");
    private static final String PREVIEW_CONFIG_ERROR_MSG = PublishingUIResources.getString("PublishingUI.previewConfigError.msg");
    private static final String VIEW_REPORT_ERROR_TITLE = PublishingUIResources.getString("PublishingUI.viewReportError.title");
    private static final String VIEW_REPORT_ERROR_MSG = PublishingUIResources.getString("PublishingUI.viewReportError.msg");
    private static final String OPEN_BROWSER_ERROR_REASON = PublishingUIResources.getString("PublishingUI.openBrowserError.reason");
    private static final String PUBLISH_CONFIG_CANCEL_MSG = PublishingUIResources.getString("PublishingUI.cancelPublishConfig.msg");
    private AbstractViewBuilder viewBuilder;
    private String published_url;
    private String report_url;
    private MsgDialog msgDialog;
    private Exception runException;

    public PublishingOperation(AbstractViewBuilder viewBuilder) {
        this.viewBuilder = viewBuilder;
        this.msgDialog = PublishingUIPlugin.getDefault().getMsgDialog();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.viewBuilder;
    }

    public String getPublishedUrl() {
        return this.published_url;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.runException = null;
        try {
            PublishManager mgr = new PublishManager(this.viewBuilder);
            monitor.setTaskName(PublishingResources.getString((String)"Publishing.publishingConfigurationTask.name"));
            mgr.publish(monitor);
            this.published_url = mgr.getPublishedUrl();
            this.report_url = mgr.getPublishingReport();
        }
        catch (Exception e) {
            this.runException = e;
        }
        final boolean canceled = monitor.isCanceled();
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String reason;
                if (canceled) {
                    PublishingOperation.this.msgDialog.displayInfo(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_CANCEL_MSG);
                    return;
                }
                if (PublishingOperation.this.published_url == null || PublishingOperation.this.report_url == null) {
                    PublishingOperation.this.msgDialog.displayError(PUBLISH_CONFIG_ERROR_TITLE, PUBLISH_CONFIG_ERROR_MSG, PUBLISH_CONFIG_ERROR_REASON, (Throwable)PublishingOperation.this.runException);
                    return;
                }
                if (!PublishingOperation.this.openBrowser(PublishingOperation.this.published_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.published_url);
                    PublishingOperation.this.msgDialog.displayError(PREVIEW_CONFIG_ERROR_TITLE, PREVIEW_CONFIG_ERROR_MSG, reason);
                }
                if (!PublishingOperation.this.openBrowser(PublishingOperation.this.report_url)) {
                    reason = MessageFormat.format(OPEN_BROWSER_ERROR_REASON, PublishingOperation.this.report_url);
                    PublishingOperation.this.msgDialog.displayError(VIEW_REPORT_ERROR_TITLE, VIEW_REPORT_ERROR_MSG, reason);
                }
            }
        });
    }

    public boolean openBrowser(String url) {
        boolean success = false;
        try {
            if (SWT.getPlatform().equals("win32")) {
                success = Program.launch((String)url);
            } else {
                IBrowser browser = BrowserManager.getInstance().createBrowser(true);
                if (browser == null) {
                    try {
                        browser.displayURL(url);
                        success = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return success;
    }
}

