/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui;

import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.ProcessElement;
import com.ibm.uma.util.UmaUtil;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ContentView;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.search.ui.internal.MethodElementViewSorter;
import org.eclipse.epf.search.ui.internal.SearchResultLabelProvider;
import org.eclipse.epf.search.ui.internal.SearchResultTableContentProvider;
import org.eclipse.epf.search.ui.internal.SearchResultTreeContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class MethodSearchResultPage
extends AbstractTextSearchViewPage
implements ISelectionChangedListener {
    private IStructuredContentProvider contentProvider;
    private SearchResultLabelProvider labelProvider = new SearchResultLabelProvider();

    public boolean isLayoutSupported(int layout) {
        return (layout & 1) != 0 || (layout & 2) != 0;
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.contentProvider = new SearchResultTreeContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setSorter((ViewerSorter)new MethodElementViewSorter());
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void configureTableViewer(TableViewer viewer) {
        this.contentProvider = new SearchResultTableContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        viewer.setSorter((ViewerSorter)new MethodElementViewSorter());
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).elementsChanged(objects);
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).elementsChanged(objects);
            }
        }
    }

    protected void clear() {
        if (this.contentProvider != null) {
            if (this.contentProvider instanceof SearchResultTreeContentProvider) {
                ((SearchResultTreeContentProvider)this.contentProvider).clear();
            } else if (this.contentProvider instanceof SearchResultTableContentProvider) {
                ((SearchResultTableContentProvider)this.contentProvider).clear();
            }
        }
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match.getElement() instanceof MethodElement && activate) {
            MethodElement element = (MethodElement)match.getElement();
            if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID)) {
                IViewPart view;
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null && (view = activePage.findView("org.eclipse.search.ui.views.SearchView")) != null) {
                    activePage.showView("org.eclipse.search.ui.views.SearchView");
                }
            }
            this.displayEditor(element);
        }
    }

    protected void displayEditor(MethodElement element) {
        if (element instanceof ProcessElement) {
            EditorChooser.getInstance().openEditor((Object)UmaUtil.getProcessComponent((MethodElement)element));
        } else {
            EditorChooser.getInstance().openEditor((Object)element);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel;
        Object[] selectedElements;
        ISelection selection;
        if (PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID) && (selection = event.getSelection()) instanceof IStructuredSelection && (selectedElements = (sel = (IStructuredSelection)selection).toArray()) != null && selectedElements.length > 0 && selectedElements[0] instanceof MethodElement) {
            try {
                this.displayHTMLPage((MethodElement)selectedElements[0]);
            }
            catch (PartInitException partInitException) {}
        }
    }

    protected void displayHTMLPage(MethodElement element) throws PartInitException {
        if (element instanceof MethodPlugin || element instanceof ContentPackage) {
            return;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IViewPart view = activePage.findView(ContentView.VIEW_ID);
            if (view == null) {
                view = activePage.showView(ContentView.VIEW_ID);
            }
            if (view != null) {
                ((ContentView)view).displayHTMLContentPage((Object)element);
            }
        }
    }
}

