/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Practice;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessElement;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.util.UmaUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.MethodSearchResult;
import org.eclipse.epf.search.ui.internal.SearchResultUIFolder;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultTreeContentProvider
implements ITreeContentProvider {
    private static final String PKG_NAME_CONTENT = "Content";
    private static final String PKG_NAME_CORE_CONTENT = "CoreContent";
    private static final String PKG_NAME_CATEGORIES = "Categories";
    private static final String PKG_NAME_DISCIPLINES = "Disciplines";
    private static final String PKG_NAME_DOMAINS = "Domains";
    private static final String PKG_NAME_WORK_PRODUCT_TYPES = "WP Types";
    private static final String PKG_NAME_ROLESETS = "RoleSets";
    private static final String PKG_NAME_TOOLS = "Tools";
    private static final String PKG_NAME_CUSTOM_CATEGORIES = "CustomCategories";
    private static final String PKG_NAME_CAPABILITY_PATTERNS = "CapabilityPatterns";
    private static final String PKG_NAME_DELIVERY_PROCESSES = "DeliveryProcesses";
    private static final String METHOD_CONTENT = SearchUIResources.getString("SearchUI.searchResult.methodContent");
    private static final String CONTENT_PACKAGES = SearchUIResources.getString("SearchUI.searchResult.contentPackages");
    private static final String STANDARD_CATEGORIES = SearchUIResources.getString("SearchUI.searchResult.standardCategories");
    private static final String DISCIPLINES = SearchUIResources.getString("SearchUI.searchResult.disciplines");
    private static final String DOMAINS = SearchUIResources.getString("SearchUI.searchResult.domains");
    private static final String WORK_PRODUCT_TYPES = SearchUIResources.getString("SearchUI.searchResult.workProductTypes");
    private static final String ROLESETS = SearchUIResources.getString("SearchUI.searchResult.roleSets");
    private static final String TOOLS = SearchUIResources.getString("SearchUI.searchResult.tools");
    private static final String CUSTOM_CATEGORIES = SearchUIResources.getString("SearchUI.searchResult.customCategories");
    private static final String PROCESSES = SearchUIResources.getString("SearchUI.searchResult.processes");
    private static final String CAPABILITY_PATTERNS = SearchUIResources.getString("SearchUI.searchResult.capabilityPatterns");
    private static final String DELIVERY_PROCESSES = SearchUIResources.getString("SearchUI.searchResult.deliveryProcesses");
    private static final Object[] EMPTY_LIST = new Object[0];
    private TreeViewer treeViewer;
    private MethodSearchResult searchResult;
    private Map elementMap;

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof MethodSearchResult) {
            Object[] elements = ((MethodSearchResult)((Object)inputElement)).getElements();
            if (elements.length == 0) {
                return EMPTY_LIST;
            }
            this.elementMap = new HashMap();
            int i = 0;
            while (i < elements.length) {
                this.insert(elements[i], false);
                ++i;
            }
            this.insertUIFolders(inputElement);
        }
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null && newInput instanceof MethodSearchResult) {
            this.treeViewer = (TreeViewer)viewer;
            this.searchResult = (MethodSearchResult)((Object)newInput);
        }
    }

    public void elementsChanged(Object[] updatedElements) {
        int i = 0;
        while (i < updatedElements.length) {
            if (this.searchResult.getMatchCount(updatedElements[i]) > 0) {
                if (this.treeViewer.testFindItem(updatedElements[i]) != null) {
                    this.insert(updatedElements[i], true);
                } else {
                    this.remove(updatedElements[i], true);
                }
            } else {
                this.treeViewer.remove(updatedElements[i]);
            }
            ++i;
        }
        this.treeViewer.refresh();
    }

    public Object[] getChildren(Object parentElement) {
        if (this.elementMap == null) {
            return EMPTY_LIST;
        }
        Set children = (Set)this.elementMap.get(parentElement);
        if (children == null) {
            return EMPTY_LIST;
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        ProcessPackage processPackage;
        if (element instanceof MethodPlugin) {
            return null;
        }
        if (element instanceof SearchResultUIFolder) {
            return ((SearchResultUIFolder)element).getParent();
        }
        if (element instanceof ProcessPackage) {
            ProcessPackage processPackage2 = (ProcessPackage)element;
            EObject parent = processPackage2.eContainer();
            if (parent instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)parent;
                return processComponent.getProcess();
            }
            return parent;
        }
        if (element instanceof MethodPackage) {
            MethodPackage methodPackage = (MethodPackage)element;
            EObject parent = methodPackage.eContainer();
            if (parent instanceof MethodPlugin) {
                return parent;
            }
            MethodPackage parentPackage = methodPackage.getParentPackage();
            return parentPackage;
        }
        if (element instanceof Artifact) {
            Artifact artifact = (Artifact)element;
            Artifact containerArtifact = artifact.getContainerArtifact();
            if (containerArtifact != null) {
                return containerArtifact;
            }
            return UmaUtil.getContentPackage((EObject)artifact);
        }
        if (element instanceof Practice) {
            Practice practice = (Practice)element;
            return practice.getContainer();
        }
        if (element instanceof ContentElement) {
            return UmaUtil.getContentPackage((EObject)((ContentElement)element));
        }
        if (element instanceof Process) {
            Process process = (Process)element;
            ProcessPackage parent = (ProcessPackage)process.eContainer();
            if (parent != null) {
                return parent.eContainer();
            }
        } else if (element instanceof Activity) {
            ProcessPackage parentPackage;
            ProcessPackage processPackage3 = UmaUtil.getProcessPackage((EObject)((ProcessElement)element));
            if (processPackage3 != null && (parentPackage = (ProcessPackage)processPackage3.getParentPackage()) != null) {
                if (parentPackage instanceof ProcessComponent) {
                    ProcessComponent processComponent = (ProcessComponent)parentPackage;
                    return processComponent.getProcess();
                }
                List processElements = parentPackage.getProcessElements();
                Iterator i = processElements.iterator();
                while (i.hasNext()) {
                    ProcessElement processElement = (ProcessElement)i.next();
                    if (!(processElement instanceof Activity) || !processElement.getName().equals(parentPackage.getName())) continue;
                    return processElement;
                }
            }
        } else if (element instanceof ProcessElement && (processPackage = UmaUtil.getProcessPackage((EObject)((ProcessElement)element))) != null) {
            if (processPackage instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)processPackage;
                return processComponent.getProcess();
            }
            List processElements = processPackage.getProcessElements();
            Iterator i = processElements.iterator();
            while (i.hasNext()) {
                ProcessElement processElement = (ProcessElement)i.next();
                if (!(processElement instanceof Activity) || !processElement.getName().equals(processPackage.getName())) continue;
                return processElement;
            }
            return processPackage;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void clear() {
        this.treeViewer.refresh();
    }

    public void dispose() {
    }

    protected void insert(Object child, boolean refreshViewer) {
        Object parent = this.getParent(child);
        while (parent != null) {
            if (this.insertChild(parent, child)) {
                if (refreshViewer) {
                    this.treeViewer.add(parent, child);
                }
            } else {
                if (refreshViewer) {
                    this.treeViewer.refresh(parent);
                }
                return;
            }
            child = parent;
            parent = this.getParent(child);
        }
        if (this.insertChild((Object)this.searchResult, child) && refreshViewer) {
            this.treeViewer.add((Object)this.searchResult, child);
        }
    }

    protected boolean insertChild(Object parent, Object child) {
        HashSet<Object> children = (HashSet<Object>)this.elementMap.get(parent);
        if (children == null) {
            children = new HashSet<Object>();
            this.elementMap.put(parent, children);
        }
        return children.add(child);
    }

    protected void replace(Object parent, Object child, Object newChild) {
        this.insert(newChild, false);
        this.elementMap.put(newChild, (Set)this.elementMap.get(child));
        this.elementMap.remove(child);
        Set children = (Set)this.elementMap.get(parent);
        children.remove(child);
    }

    protected void remove(Object element, boolean refreshViewer) {
        if (this.hasChildren(element)) {
            if (refreshViewer) {
                this.treeViewer.refresh(element);
            }
        } else if (this.searchResult.getMatchCount(element) == 0) {
            this.elementMap.remove(element);
            Object parent = this.getParent(element);
            if (parent != null) {
                this.removeFromSiblings(element, parent);
                this.remove(parent, refreshViewer);
            } else {
                this.removeFromSiblings(element, (Object)this.searchResult);
                if (refreshViewer) {
                    this.treeViewer.refresh();
                }
            }
        } else if (refreshViewer) {
            this.treeViewer.refresh(element);
        }
    }

    protected void removeFromSiblings(Object element, Object parent) {
        Set siblings = (Set)this.elementMap.get(parent);
        if (siblings != null) {
            siblings.remove(element);
        }
    }

    protected void insertUIFolders(Object inputElement) {
        Object[] elements = this.getChildren(inputElement);
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof MethodPlugin) {
                SearchResultUIFolder methodContentFolder = new SearchResultUIFolder(METHOD_CONTENT, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Content"), element);
                SearchResultUIFolder processesFolder = new SearchResultUIFolder(PROCESSES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Processes"), element);
                Object[] methodPackages = this.getChildren(element);
                int j = 0;
                while (j < methodPackages.length) {
                    Object methodPackage = methodPackages[j];
                    if (methodPackage instanceof ContentPackage && ((ContentPackage)methodPackage).getName().equals(PKG_NAME_CONTENT)) {
                        Object[] packages = this.getChildren(methodPackage);
                        int k = 0;
                        while (k < packages.length) {
                            Object pkg = packages[k];
                            if (pkg instanceof ContentPackage) {
                                if (((ContentPackage)pkg).getName().equals(PKG_NAME_CORE_CONTENT)) {
                                    this.replace(element, pkg, new SearchResultUIFolder(CONTENT_PACKAGES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/MethodPackages"), methodContentFolder));
                                } else if (((ContentPackage)pkg).getName().equals(PKG_NAME_CATEGORIES)) {
                                    SearchResultUIFolder standardCategoriesFolder = new SearchResultUIFolder(STANDARD_CATEGORIES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/StandardCategories"), methodContentFolder);
                                    SearchResultUIFolder customCategoriesFolder = new SearchResultUIFolder(CUSTOM_CATEGORIES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/CustomCategories"), methodContentFolder);
                                    Object[] contentPackages = this.getChildren(pkg);
                                    int l = 0;
                                    while (l < contentPackages.length) {
                                        Object contentPackage = contentPackages[l];
                                        if (contentPackage instanceof ContentPackage) {
                                            String pkgName = ((ContentPackage)contentPackage).getName();
                                            if (pkgName.equals(PKG_NAME_CUSTOM_CATEGORIES)) {
                                                this.insert(customCategoriesFolder, false);
                                                this.elementMap.put(customCategoriesFolder, (Set)this.elementMap.get(contentPackage));
                                            } else if (pkgName.equals(PKG_NAME_DISCIPLINES)) {
                                                this.insert(standardCategoriesFolder, false);
                                                this.replace(element, contentPackage, new SearchResultUIFolder(DISCIPLINES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Disciplines"), standardCategoriesFolder));
                                            } else if (pkgName.equals(PKG_NAME_DOMAINS)) {
                                                this.insert(standardCategoriesFolder, false);
                                                this.replace(element, contentPackage, new SearchResultUIFolder(DOMAINS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Domains"), standardCategoriesFolder));
                                            } else if (pkgName.equals(PKG_NAME_WORK_PRODUCT_TYPES)) {
                                                this.insert(standardCategoriesFolder, false);
                                                this.replace(element, contentPackage, new SearchResultUIFolder(WORK_PRODUCT_TYPES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProductTypes"), standardCategoriesFolder));
                                            } else if (pkgName.equals(PKG_NAME_ROLESETS)) {
                                                this.insert(standardCategoriesFolder, false);
                                                this.replace(element, contentPackage, new SearchResultUIFolder(ROLESETS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles"), standardCategoriesFolder));
                                            } else if (pkgName.equals(PKG_NAME_TOOLS)) {
                                                this.insert(standardCategoriesFolder, false);
                                                this.replace(element, contentPackage, new SearchResultUIFolder(TOOLS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools"), standardCategoriesFolder));
                                            }
                                        }
                                        ++l;
                                    }
                                    this.elementMap.remove(pkg);
                                }
                            } else if (pkg instanceof ProcessPackage && ((ProcessPackage)pkg).getName().equals(PKG_NAME_CAPABILITY_PATTERNS)) {
                                this.replace(element, pkg, new SearchResultUIFolder(CAPABILITY_PATTERNS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns"), processesFolder));
                            }
                            ++k;
                        }
                        Set children = (Set)this.elementMap.get(element);
                        children.remove(methodPackage);
                    } else if (methodPackage instanceof ProcessPackage && ((ProcessPackage)methodPackage).getName().equals(PKG_NAME_DELIVERY_PROCESSES)) {
                        this.replace(element, methodPackage, new SearchResultUIFolder(DELIVERY_PROCESSES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses"), processesFolder));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

