/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.ui.properties.internal.view;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabItem;
import org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabListContentProvider;
import org.eclipse.wst.common.ui.properties.internal.provisional.IDynamicTabListSection;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabSelectionListener;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.view.Tab;
import org.eclipse.wst.common.ui.properties.internal.view.TabDescriptor;
import org.eclipse.wst.common.ui.properties.internal.view.TabbedPropertyRegistry;
import org.eclipse.wst.common.ui.properties.internal.view.TabbedPropertyViewer;

public class DynamicTabListContentProvider
implements IDynamicTabListContentProvider,
ITabSelectionListener {
    private IWorkbenchPart currentPart;
    private TabbedPropertyRegistry tabbedPropertyRegistry;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private TabbedPropertyViewer tabbedPropertyViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public DynamicTabListContentProvider(TabbedPropertyRegistry tabbedPropertyRegistry) {
        this.tabbedPropertyRegistry = tabbedPropertyRegistry;
    }

    public Object[] getElements(Object inputElement) {
        if (this.tabbedPropertySheetPage.getCurrentTab() == null) {
            return this.tabbedPropertyRegistry.getTabDescriptors(this.currentPart, (ISelection)inputElement);
        }
        return this.getOverrideTabs(inputElement);
    }

    public void dispose() {
        this.stopListening();
        this.tabbedPropertyViewer = null;
        this.currentPart = null;
        this.tabbedPropertySheetPage = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.tabbedPropertyViewer == null) {
            Assert.isTrue((boolean)(viewer instanceof TabbedPropertyViewer));
            this.init((TabbedPropertyViewer)viewer);
        }
    }

    private void init(TabbedPropertyViewer newTabbedPropertyViewer) {
        this.tabbedPropertyViewer = newTabbedPropertyViewer;
        this.currentPart = this.tabbedPropertyViewer.getWorkbenchPart();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.currentPart.getAdapter((Class)clazz) != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.tabbedPropertySheetPage = (TabbedPropertySheetPage)((Object)this.currentPart.getAdapter((Class)clazz2));
        } else {
            IWorkbenchPart part;
            IContributedContentsView view;
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IContributedContentsView");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (IContributedContentsView)this.currentPart.getAdapter((Class)clazz3)) != null && (part = view.getContributingPart()) != null) {
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.tabbedPropertySheetPage = (TabbedPropertySheetPage)((Object)part.getAdapter((Class)clazz4));
            }
        }
        Assert.isNotNull((Object)((Object)this.tabbedPropertySheetPage), (String)"DynamicTabListContentProvider could not find the TabbedPropertySheetPage for the active part");
        this.startListening();
    }

    private void startListening() {
        this.tabbedPropertySheetPage.addTabSelectionListener(this);
    }

    private void stopListening() {
        this.tabbedPropertySheetPage.removeTabSelectionListener(this);
    }

    public void tabSelected(TabDescriptor tabDescriptor) {
        IDynamicTabListSection section = this.getDynamicTabListSection();
        Assert.isNotNull((Object)section);
        int selectedIndex = this.tabbedPropertyViewer.getSelectionIndex();
        section.selectTab(selectedIndex);
    }

    private void setSelectedTab() {
        IDynamicTabListSection section;
        TabDescriptor currentSelectedTabInList = null;
        IStructuredSelection selectionFromList = (IStructuredSelection)this.tabbedPropertyViewer.getSelection();
        if (!selectionFromList.equals(StructuredSelection.EMPTY)) {
            currentSelectedTabInList = (TabDescriptor)selectionFromList.getFirstElement();
        }
        if ((section = this.getDynamicTabListSection()) == null) {
            TabDescriptor newSelectedTab;
            if (currentSelectedTabInList == null && (newSelectedTab = (TabDescriptor)this.tabbedPropertyViewer.getElementAt(0)) != null) {
                this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedTab), true);
            }
            return;
        }
        IDynamicTabItem[] dynamicTabItems = section.getTabs();
        if (dynamicTabItems == null) {
            return;
        }
        int selectedTabIndex = -1;
        int i = 0;
        while (i < dynamicTabItems.length) {
            if (dynamicTabItems[i].isSelected()) {
                selectedTabIndex = i;
            }
            ++i;
        }
        if (currentSelectedTabInList == null || !currentSelectedTabInList.getText().equals(dynamicTabItems[selectedTabIndex].getText())) {
            TabDescriptor newSelectedTab = (TabDescriptor)this.tabbedPropertyViewer.getElementAt(selectedTabIndex);
            this.tabbedPropertyViewer.setSelection((ISelection)new StructuredSelection((Object)newSelectedTab), true);
        }
    }

    private TabDescriptor[] getOverrideTabs(Object inputElement) {
        TabDescriptor[] tabDescriptors = this.tabbedPropertyRegistry.getTabDescriptors(this.currentPart, (ISelection)inputElement);
        if (tabDescriptors == TabbedPropertyRegistry.EMPTY_DESCRIPTOR_ARRAY) {
            return tabDescriptors;
        }
        IDynamicTabListSection section = this.getDynamicTabListSection();
        Assert.isNotNull((Object)section);
        IDynamicTabItem[] dynamicTabItems = section.getTabs();
        if (dynamicTabItems == null) {
            return tabDescriptors;
        }
        TabDescriptor[] overrideTabDescriptors = new TabDescriptor[dynamicTabItems.length];
        TabDescriptor target = tabDescriptors[0];
        int i = 0;
        while (i < dynamicTabItems.length) {
            overrideTabDescriptors[i] = (TabDescriptor)target.clone();
            overrideTabDescriptors[i].setLabel(dynamicTabItems[i].getText());
            overrideTabDescriptors[i].setImage(dynamicTabItems[i].getImage());
            overrideTabDescriptors[i].setIndented(dynamicTabItems[i].isIndented());
            overrideTabDescriptors[i].setSelected(dynamicTabItems[i].isSelected());
            ++i;
        }
        return overrideTabDescriptors;
    }

    public void overrideTabs() {
        this.stopListening();
        Object input = this.tabbedPropertyViewer.getInput();
        this.tabbedPropertyViewer.setInput(input);
        this.setSelectedTab();
        this.startListening();
    }

    private IDynamicTabListSection getDynamicTabListSection() {
        Tab tab = this.tabbedPropertySheetPage.getCurrentTab();
        if (tab != null) {
            return (IDynamicTabListSection)tab.getSectionAtIndex(0);
        }
        return null;
    }
}

