/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class HippieCompletionEngine {
    private static final String COMPLETION_WORD_REGEX = "[\\p{L}[\\p{Mn}[\\p{Pc}[\\p{Nd}[\\p{Nl}[\\p{Sc}]]]]]]+";
    private static final boolean CASE_SENSITIVE = true;

    private String asRegPattern(CharSequence string) {
        StringBuffer out = new StringBuffer(string.length());
        boolean quoting = false;
        int i = 0;
        int length = string.length();
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
            } else {
                if (!quoting) {
                    out.append("\\Q");
                    quoting = true;
                }
                out.append(ch);
            }
            ++i;
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    public List getCompletions(IDocument document, CharSequence prefix) throws BadLocationException {
        return this.getCompletionsForward(document, prefix, 0);
    }

    public List getCompletionsForward(IDocument document, CharSequence prefix, int firstPosition) throws BadLocationException {
        ArrayList<String> res = new ArrayList<String>();
        if (firstPosition == document.getLength()) {
            return res;
        }
        FindReplaceDocumentAdapter searcher = new FindReplaceDocumentAdapter(document);
        String searchPattern = "\\b" + this.asRegPattern(prefix);
        IRegion reg = searcher.find(firstPosition, searchPattern, true, true, false, true);
        while (reg != null) {
            int nextPos;
            IRegion word = searcher.find(reg.getOffset(), COMPLETION_WORD_REGEX, true, true, false, true);
            if (word.getLength() > reg.getLength()) {
                String found = document.get(word.getOffset(), word.getLength());
                res.add(found.substring(prefix.length()));
            }
            if ((nextPos = word.getOffset() + word.getLength()) >= document.getLength()) break;
            reg = searcher.find(nextPos, searchPattern, true, true, false, true);
        }
        return res;
    }

    public List getCompletionsBackwards(IDocument document, CharSequence prefix, int firstPosition) throws BadLocationException {
        ArrayList<String> res = new ArrayList<String>();
        if (firstPosition == 0) {
            return res;
        }
        FindReplaceDocumentAdapter searcher = new FindReplaceDocumentAdapter(document);
        String searchPattern = "\\b" + this.asRegPattern(prefix);
        IRegion reg = searcher.find(0, searchPattern, true, true, false, true);
        while (reg != null) {
            int nextPos;
            IRegion word = searcher.find(reg.getOffset(), COMPLETION_WORD_REGEX, true, true, false, true);
            if (word.getOffset() > firstPosition) break;
            if (word.getLength() > reg.getLength()) {
                String found = document.get(word.getOffset(), word.getLength());
                res.add(found.substring(prefix.length()));
            }
            if ((nextPos = word.getOffset() + word.getLength()) >= firstPosition) break;
            reg = searcher.find(nextPos, searchPattern, true, true, false, true);
        }
        Collections.reverse(res);
        return res;
    }

    public List makeUnique(List suggestions) {
        HashSet<String> seenAlready = new HashSet<String>();
        ArrayList<String> uniqueSuggestions = new ArrayList<String>();
        Iterator i = suggestions.iterator();
        while (i.hasNext()) {
            String suggestion = (String)i.next();
            if (seenAlready.contains(suggestion)) continue;
            seenAlready.add(suggestion);
            uniqueSuggestions.add(suggestion);
        }
        return uniqueSuggestions;
    }
}

