/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.List;
import java.util.Locale;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;

public class FileUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final int LINE_SEP_LENGTH = LINE_SEP.length();
    public static final String UNC_PATH_PREFIX = "\\\\";
    public static final int UNC_PATH_PREFIX_LENGTH = "\\\\".length();
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";

    private FileUtil() {
    }

    public static String getAbsolutePath(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    public static String getAbsolutePath(String file) {
        return FileUtil.getAbsolutePath(new File(file));
    }

    public static String getAbsolutePath(URL url) {
        String pathName = url.getFile().substring(1);
        String result = NetUtil.decodeUrl(pathName, null);
        return result;
    }

    public static String getParentDirectory(String path) {
        return new File(path).getParent();
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, true);
    }

    public static String getFileName(String path, boolean withExtension) {
        String normalizedPath = path.replace('\\', '/');
        int prefixLength = 0;
        if (normalizedPath.startsWith("file:/")) {
            prefixLength = NetUtil.FILE_URI_PREFIX_LENGTH;
        } else if (normalizedPath.startsWith("http://")) {
            prefixLength = NetUtil.HTTP_URI_PREFIX_LENGTH;
        }
        int index = normalizedPath.lastIndexOf("/");
        String fileName = index < prefixLength ? normalizedPath.substring(prefixLength) : path.substring(index + 1);
        if (withExtension) {
            return fileName;
        }
        index = fileName.indexOf(".");
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    public static String getRelativePathToBase(File path, File basePath) {
        try {
            String dir = path.toURL().toExternalForm();
            String baseDir = basePath.toURL().toExternalForm();
            StringBuffer result = new StringBuffer();
            if (dir.indexOf(baseDir) == 0) {
                String delta = dir.substring(baseDir.length());
                int i = 0;
                while (i < delta.length()) {
                    if (delta.charAt(i) == '/') {
                        result.append("../");
                    }
                    ++i;
                }
            }
            return result.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getRelativePath(File path, File basePath) {
        try {
            String dir = path.toURL().toExternalForm();
            String baseDir = FileUtil.appendSeparator(basePath.toURL().toExternalForm(), "/");
            StringBuffer result = new StringBuffer();
            while (dir.indexOf(baseDir) == -1) {
                basePath = basePath.getParentFile();
                baseDir = FileUtil.appendSeparator(basePath.toURL().toExternalForm(), "/");
                result.append("../");
            }
            if (dir.indexOf(baseDir) == 0) {
                String delta = dir.substring(baseDir.length());
                result.append(delta);
            }
            return result.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String appendSeparator(String path) {
        return FileUtil.appendSeparator(path, File.separator);
    }

    public static String appendSeparator(String path, String separator) {
        return path.endsWith(separator) ? path : String.valueOf(path) + separator;
    }

    public static String removeSeparator(String path) {
        return path.endsWith(File.separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeAllSeparator(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeSeparator(String path, String separator) {
        return path.endsWith(separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String replaceFileName(String path, String oldFileName, String newFileName) {
        int index = path.lastIndexOf(oldFileName);
        return String.valueOf(path.substring(0, index)) + newFileName;
    }

    public static String replaceExtension(String path, String oldExt, String newExt) {
        int index = path.lastIndexOf(oldExt);
        return String.valueOf(path.substring(0, index)) + newExt;
    }

    public static String getLocalePath(String path, String localeStr) {
        if (StrUtil.isBlank(localeStr)) {
            return path;
        }
        String fileName = FileUtil.getFileName(path);
        return FileUtil.replaceFileName(path, fileName, String.valueOf(localeStr) + "/" + fileName);
    }

    public static String getLocalePath(String path, Locale locale) {
        return locale == null ? path : FileUtil.getLocalePath(path, locale.toString());
    }

    /*
     * Exception decompiling
     */
    public static boolean writeFile(String filename, String text) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 49->52)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeUTF8File(String filename, String text) {
        FileOutputStream fileOut;
        block12: {
            OutputStreamWriter writer = null;
            fileOut = null;
            try {
                try {
                    fileOut = new FileOutputStream(filename);
                    writer = new OutputStreamWriter((OutputStream)fileOut, ENCODING_UTF_8);
                    writer.write(text);
                    writer.flush();
                    fileOut.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (writer != null) {
                    try {
                        writer.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                if (fileOut == null) throw throwable;
                try {
                    fileOut.close();
                    return true;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var5_7 = null;
                if (writer == null) break block12;
            }
            try {}
            catch (Exception exception) {}
            writer.close();
            return true;
        }
        if (fileOut == null) return false;
        try {}
        catch (Exception exception) {
            return false;
        }
        fileOut.close();
        return true;
    }

    /*
     * Exception decompiling
     */
    public static void writeFile(String uri, OutputStream output) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 76->80)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void writeFile(String uri, PrintWriter pw) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 83->87)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean deleteAllFiles(String dir) {
        boolean ret = true;
        File targetDir = new File(dir);
        File[] files = targetDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    ret = ret && FileUtil.deleteAllFiles(files[i].getAbsolutePath());
                }
                ret = ret && files[i].delete();
                ++i;
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File srcFile, File tgtFile) throws IOException {
        block21: {
            block22: {
                block25: {
                    if (srcFile.equals(tgtFile)) {
                        return;
                    }
                    if (srcFile.exists() == false) return;
                    if (!srcFile.canRead()) {
                        return;
                    }
                    if (tgtFile.exists() && !tgtFile.canWrite()) {
                        return;
                    }
                    if (srcFile.isFile()) break block25;
                    files = srcFile.listFiles();
                    if (files == null) return;
                    i = 0;
                    if (true) ** GOTO lbl52
                }
                src = null;
                tgt = null;
                try {
                    src = new FileInputStream(srcFile);
                    if (tgtFile.isFile()) {
                        tgt = new FileOutputStream(tgtFile);
                    } else {
                        srcPath = srcFile.toURL().toString();
                        srcFileName = srcPath.substring((index = srcPath.lastIndexOf("/")) + 1);
                        if (srcFile.equals(new File(tgtFile, srcFileName))) {
                            var7_9 = null;
                            if (src == null) break block21;
                            break block22;
                        }
                        tgt = new FileOutputStream(new File(tgtFile, srcFileName));
                    }
                    buffer = new byte[4096];
                    while ((bytes_read = src.read(buffer)) != -1) {
                        tgt.write(buffer, 0, bytes_read);
                    }
                }
                catch (Throwable var8_12) {
                    var7_10 = null;
                    if (src != null) {
                        try {
                            src.close();
                        }
                        catch (Exception v0) {}
                    }
                    if (tgt == null) throw var8_12;
                    try {
                        tgt.close();
                        throw var8_12;
                    }
                    catch (Exception v1) {}
                    throw var8_12;
                }
                do {
                    FileUtil.copyFile(files[i], tgtFile);
                    ++i;
lbl52:
                    // 2 sources

                } while (i < files.length);
                return;
            }
            try {}
            catch (Exception v2) {}
            src.close();
        }
        if (tgt == null) return;
        try {}
        catch (Exception v3) {}
        tgt.close();
        return;
        return;
        var7_11 = null;
        if (src != null) {
            try {}
            catch (Exception v4) {}
            src.close();
        }
        if (tgt == null) return;
        try {}
        catch (Exception v5) {
            return;
        }
        tgt.close();
    }

    public static void copyFile(String srcFileName, String tgtFileName) throws IOException {
        FileUtil.copyFile(new File(srcFileName), new File(tgtFileName));
    }

    public static void copyDir(String srcDirName, String tgtDirName) throws IOException {
        FileUtil.copyFile(new File(srcDirName), new File(tgtDirName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyfile(File source, File dest) throws IOException {
        FileOutputStream output;
        block13: {
            if (source.equals(dest)) {
                return;
            }
            FileInputStream input = null;
            output = null;
            try {
                input = new FileInputStream(source);
                FileChannel in = input.getChannel();
                if (!dest.exists()) {
                    dest.getParentFile().mkdirs();
                }
                output = new FileOutputStream(dest);
                FileChannel out = output.getChannel();
                out.transferFrom(in, 0L, source.length());
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (input == null) break block13;
            }
            try {}
            catch (IOException iOException) {}
            input.close();
        }
        if (output == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        output.close();
    }

    public static void copydirectory(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.exists() || !destDir.exists()) {
            return;
        }
        if (!sourceDir.isDirectory() || !destDir.isDirectory()) {
            return;
        }
        File[] files = sourceDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String destName = destDir + File.separator + files[i].getAbsolutePath().substring(sourceDir.getAbsolutePath().length() + 1);
                if (files[i].isFile()) {
                    FileUtil.copyfile(files[i], new File(destName));
                } else if (files[i].isDirectory()) {
                    File destFile = new File(destName);
                    destFile.mkdirs();
                    FileUtil.copydirectory(files[i], destFile);
                }
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static CharBuffer readFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 87->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuffer readFile(File file, String encoding) throws IOException {
        InputStreamReader reader;
        StringBuffer result;
        block5: {
            result = new StringBuffer();
            FileInputStream fis = null;
            reader = null;
            try {
                int size;
                char[] buffer = new char[1024];
                fis = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)fis, encoding);
                while ((size = reader.read(buffer, 0, 1024)) > 0) {
                    result.append(buffer, 0, size);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fis != null) {
                    fis.close();
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            {
                Object var7_9 = null;
                if (fis == null) break block5;
            }
            fis.close();
        }
        if (reader == null) return result;
        reader.close();
        return result;
    }

    /*
     * Exception decompiling
     */
    public static boolean isFileLocked(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 126->129)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FileLock lockFile(File file) {
        FileLock lock;
        FileOutputStream input;
        block14: {
            FileLock fileLock;
            input = null;
            lock = null;
            try {
                try {
                    input = new FileOutputStream(file);
                    FileChannel fileChannel = input.getChannel();
                    lock = fileChannel.tryLock();
                    if (!lock.isValid()) break block14;
                    fileLock = lock;
                    Object var4_6 = null;
                }
                catch (Exception exception) {
                    FileLock fileLock2 = null;
                    Object var4_7 = null;
                    try {
                        if (input == null) return fileLock2;
                        if (lock != null) {
                            if (lock.isValid()) return fileLock2;
                        }
                        input.close();
                        return fileLock2;
                    }
                    catch (Exception exception2) {}
                    return fileLock2;
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                try {}
                catch (Exception exception) {}
                if (input == null) throw throwable;
                if (lock != null) {
                    if (lock.isValid()) throw throwable;
                }
                input.close();
                throw throwable;
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            if (input == null) return fileLock;
            if (lock != null) {
                if (lock.isValid()) return fileLock;
            }
            input.close();
            return fileLock;
        }
        Object var4_9 = null;
        try {}
        catch (Exception exception) {
            return null;
        }
        if (input == null) return null;
        if (lock != null) {
            if (lock.isValid()) return null;
        }
        input.close();
        return null;
    }

    public static void getAllFiles(File path, List fileList, boolean recursive) {
        File[] files;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    fileList.add(files[i]);
                } else if (recursive) {
                    FileUtil.getAllFiles(files[i], fileList, recursive);
                }
                ++i;
            }
        }
    }
}

