/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.uma.Property;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.ChangePropertyValueCommand;
import org.eclipse.epf.authoring.gef.edit.LabelTextCellEditorLocator;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.ValidatingFreeTextEditManager;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;

public class FreeTextEditPart
extends NodeEditPart {
    private Font font;
    private Color color;
    private FontData fData;
    private NodeEditPart part = this;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FreeTextEditPart(Node model) {
        super(model);
    }

    protected IFigure createFigure() {
        SelectableLabel l = new SelectableLabel();
        l.setLabelAlignment(1);
        l.setTextPlacement(4);
        return l;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!((Node)this.getModel()).isReadOnly()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.createDirectEditPolicy());
        }
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                return new ChangePropertyValueCommand(FreeTextEditPart.this.part, (String)request.getCellEditor().getValue());
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
                IFigure fig = FreeTextEditPart.this.getDirectEditFigure();
                if (fig instanceof Label) {
                    ((Label)fig).setText((String)request.getCellEditor().getValue());
                    fig.getUpdateManager().performUpdate();
                }
            }
        };
    }

    protected void handlePropertyChanged(Notification msg) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.diagram.model.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        switch (msg.getFeatureID((Class)clazz)) {
            case 7: {
                this.refreshVisuals();
                return;
            }
        }
        super.handlePropertyChanged(msg);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && !((Node)this.getModel()).isReadOnly()) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure fig = this.getDirectEditFigure();
        if (fig instanceof Label) {
            Label l = (Label)fig;
            List alist = ((Node)this.getModel()).getGraphNode().getProperty();
            String fontName = TemplateConstants.DEFAULT_FONT_NAME;
            int fontStyle = 0;
            int fontHeight = 8;
            int fontRed = 3;
            int fontBlue = 9;
            int fontGreen = 5;
            if (alist.size() > 0) {
                Iterator ior = alist.iterator();
                while (ior.hasNext()) {
                    Property prop = (Property)ior.next();
                    if (prop.getKey().equals("free text")) {
                        l.setText(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("property_font_name")) {
                        fontName = prop.getValue();
                        continue;
                    }
                    if (prop.getKey().equals("property_font_style")) {
                        fontStyle = new Integer(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("property_font_height")) {
                        fontHeight = new Integer(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("property_font_red")) {
                        fontRed = new Integer(prop.getValue());
                        continue;
                    }
                    if (prop.getKey().equals("property_font_blue")) {
                        fontBlue = new Integer(prop.getValue());
                        continue;
                    }
                    if (!prop.getKey().equals("property_font_green")) continue;
                    fontGreen = new Integer(prop.getValue());
                }
            } else {
                l.setText(((Node)this.getModel()).getGraphNode().getName());
            }
            if (this.font != null && !this.font.isDisposed()) {
                this.font.dispose();
            }
            if (this.color != null && !this.color.isDisposed()) {
                this.color.dispose();
            }
            this.fData = new FontData(fontName, fontHeight, fontStyle);
            this.font = new Font((Device)PlatformUI.getWorkbench().getDisplay(), this.fData);
            this.color = new Color(null, fontRed, fontGreen, fontBlue);
            l.setFont(this.font);
            l.setForegroundColor(this.color);
        }
    }

    protected DirectEditManager createDirectEditManager() {
        Label l = (Label)this.getFigure();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new ValidatingFreeTextEditManager((GraphicalEditPart)this, clazz, new LabelTextCellEditorLocator(l), l){

            protected String validate(String txt) {
                return super.validate(txt);
            }
        };
    }

    IFigure getDirectEditFigure() {
        return this.getFigure();
    }

    public void deactivate() {
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
        }
        super.deactivate();
    }
}

