/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.viewer;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.DiagramElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.authoring.gef.edit.DiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDiagramGraphicalViewer {
    protected Composite parent;
    private GraphicalViewer graphicalViewer;

    public AbstractDiagramGraphicalViewer(Composite parent) {
        this.parent = parent;
        this.createGraphicalViewer();
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected IFigure getFigure() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        return figure;
    }

    protected void setSuppressionToDiagram(Diagram diagram) {
        Process proc;
        Object e = diagram.getObject();
        if (e instanceof BreakdownElement && (proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)e))) != null) {
            diagram.setSuppression(Suppression.getSuppression((Process)proc));
        }
    }

    public void loadDiagram(Object wrapper, boolean needReset, IFilter filter, Suppression sup) {
        IFigure figure;
        EditPart editPart = this.createEditPart(wrapper, filter, sup);
        this.graphicalViewer.setContents(editPart);
        this.parent.pack(true);
        if (needReset) {
            this.cleanUpDiagram();
        }
        if ((figure = this.getFigure()) != null) {
            Rectangle bounds = figure.getBounds();
            if (bounds.x < 0 || bounds.y < 0) {
                ((DiagramEditPart)editPart).moveFigure(-bounds.x, -bounds.y);
                this.parent.pack(true);
                bounds = figure.getBounds();
            }
        }
    }

    private void loadDiagramInfo(GraphicalEditPart part, DiagramInfo diagramInfo) {
        List children = part.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof NodeContainerEditPart) {
                this.loadDiagramInfo((GraphicalEditPart)o, diagramInfo);
                continue;
            }
            if (!(o instanceof GraphicalEditPart)) continue;
            part = (GraphicalEditPart)o;
            Object model = part.getModel();
            Object e = model;
            if (e instanceof LinkedObject) {
                e = ((LinkedObject)e).getObject();
            }
            if (e instanceof DiagramElement || !(e instanceof MethodElement)) continue;
            boolean suppressed = model instanceof NamedNode ? ((NamedNode)model).isSuppressed() : ((MethodElement)e).getSuppressed().booleanValue();
            IFigure f = part.getFigure();
            Rectangle bounds = f.getBounds();
            String altTag = null;
            if (f instanceof SelectableLabel) {
                altTag = ((SelectableLabel)f).getText();
            }
            diagramInfo.addArea((MethodElement)e, bounds.x, bounds.y, bounds.width, bounds.height, altTag, suppressed);
        }
    }

    public DiagramInfo getDiagramInfo() {
        DiagramInfo diagramInfo = null;
        DiagramEditPart part = (DiagramEditPart)this.graphicalViewer.getContents();
        Object element = part.getModel();
        if (element instanceof LinkedObject) {
            element = ((LinkedObject)element).getObject();
        }
        if (element instanceof MethodElement) {
            diagramInfo = new DiagramInfo(this.getDiagramType(), (MethodElement)element);
            this.loadDiagramInfo((GraphicalEditPart)part, diagramInfo);
        }
        return diagramInfo;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image createDiagramImage() {
        Image image;
        GC gc;
        block6: {
            IFigure figure = this.getFigure();
            SWTGraphics graphics = null;
            gc = null;
            image = null;
            try {
                try {
                    Rectangle bounds = figure.getBounds();
                    int height = bounds.height;
                    int width = bounds.width;
                    Display display = Display.getDefault();
                    image = new Image((Device)display, width, height);
                    gc = new GC((Drawable)image);
                    graphics = new SWTGraphics(gc);
                    figure.paint((Graphics)graphics);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (graphics != null) {
                    graphics.dispose();
                }
                if (gc == null) throw throwable;
                gc.dispose();
                throw throwable;
            }
            {
                Object var9_12 = null;
                if (graphics == null) break block6;
            }
            graphics.dispose();
        }
        if (gc == null) return image;
        gc.dispose();
        return image;
    }

    public void dispose() {
        try {
            if (this.graphicalViewer != null) {
                Control ctrl = this.graphicalViewer.getControl();
                if (ctrl != null) {
                    ctrl.dispose();
                }
                this.graphicalViewer = null;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected abstract EditPart createEditPart(Object var1, IFilter var2, Suppression var3);

    protected abstract String getDiagramType();

    protected void cleanUpDiagram() {
    }
}

