/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.filters;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.library.edit.configuration.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class ProcessActivityFilter
extends DescriptorConfigurationFilter {
    private Activity activity = null;
    private int command = 0;

    public ProcessActivityFilter(MethodConfiguration config, TableViewer viewer, String tabName, Activity activity, int command) {
        super(config, (Viewer)viewer, tabName);
        this.activity = activity;
        this.command = command;
    }

    public boolean childAccept(Object obj) {
        if (obj instanceof ProcessesItemProvider) {
            return true;
        }
        if (obj instanceof CategorizedProcessesItemProvider) {
            return true;
        }
        if (obj instanceof Activity || obj instanceof ProcessPackage) {
            Process proc;
            if (obj instanceof ProcessComponent) {
                proc = ((ProcessComponent)obj).getProcess();
                if (this.command != 1 && proc.equals(this.activity)) {
                    return false;
                }
            }
            if (obj instanceof Process) {
                proc = (Process)obj;
                if (this.command != 1 && proc.equals(this.activity)) {
                    return false;
                }
            }
            if (obj instanceof BreakdownElement) {
                Process srcProc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)obj));
                Process targetProc = TngUtil.getOwningProcess((BreakdownElement)this.activity);
                if (srcProc instanceof DeliveryProcess && targetProc instanceof CapabilityPattern) {
                    return false;
                }
            }
            return !(obj instanceof Process) || !(proc = (Process)obj).equals(this.activity);
        }
        return false;
    }
}

