/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.NamedElement;
import com.ibm.uma.UmaPackage;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ConfigurationDescription
extends FormPage
implements IRefreshable {
    private static final String FORM_PREFIX = AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionFormPrefix");
    private MethodConfiguration config = null;
    private ScrolledForm form = null;
    private Text nameText;
    private Text despText;
    private ModifyListener modelModifyListener;
    private IActionManager actionMgr;

    public ConfigurationDescription(FormEditor editor) {
        super(editor, AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionDescription"), AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionDescription"));
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ConfigurationEditorInput configInput = (ConfigurationEditorInput)input;
        this.config = configInput.getConfiguration();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        this.form.setText(String.valueOf(FORM_PREFIX) + this.config.getName());
        FormToolkit toolkit = managedForm.getToolkit();
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section genSection = toolkit.createSection(this.form.getBody(), 450);
        this.createGeneralContent(toolkit, genSection);
        this.addListeners();
    }

    public void createGeneralContent(FormToolkit toolkit, Section section) {
        section.setLayoutData((Object)new TableWrapData(256));
        section.setText(AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionGeneralInfo"));
        section.setDescription(AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionDescription.text"));
        Composite sectionClient = toolkit.createComposite((Composite)section);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        sectionClient.setLayout((Layout)layout);
        toolkit.createLabel(sectionClient, AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionName"), 0);
        this.nameText = toolkit.createText(sectionClient, "", 0);
        TableWrapData td = new TableWrapData(256);
        this.nameText.setLayoutData((Object)td);
        this.nameText.setText(this.config.getName());
        Label despLabel = toolkit.createLabel(sectionClient, AuthoringUIResources.getString("AuthoringUI.ConfigurationDescriptionDescriptionLabel"), 0);
        TableWrapData twd0 = new TableWrapData();
        despLabel.setLayoutData((Object)twd0);
        this.despText = toolkit.createText(sectionClient, "", 578);
        TableWrapData twd = new TableWrapData(256);
        twd.heightHint = 50;
        this.despText.setLayoutData((Object)twd);
        this.despText.setText(this.config.getBriefDescription());
        section.setClient((Control)sectionClient);
        toolkit.paintBordersFor(sectionClient);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)sectionClient.getParent(), AuthoringUIHelpContexts.CONFIGURATION_EDITOR_ALL_CONTEXT);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ConfigurationDescription.this.nameText.setFocus();
                    ConfigurationDescription.this.nameText.setSelection(0, ConfigurationDescription.this.nameText.getText().length());
                }
            });
        }
    }

    private void addListeners() {
        ConfigurationEditor editor = (ConfigurationEditor)this.getEditor();
        this.modelModifyListener = editor.createModifyListener((EObject)this.config);
        this.actionMgr = ((ConfigurationEditor)this.getEditor()).getActionManager();
        this.nameText.addModifyListener(this.modelModifyListener);
        this.nameText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldContent = ConfigurationDescription.this.config.getName();
                MethodConfiguration iConfig = ConfigurationDescription.this.config;
                if (((MethodElementEditor)ConfigurationDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                if (ConfigurationDescription.isTextNonEmpty(ConfigurationDescription.this.nameText)) {
                    String name = ConfigurationDescription.this.nameText.getText();
                    Set<EClass> eClasses = Collections.singleton(UmaPackage.eINSTANCE.getMethodConfiguration());
                    String msg = TngUtil.checkName((NamedElement)ConfigurationDescription.this.config, (String)name, eClasses);
                    if (msg != null) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.createDialog.title"), msg);
                        ConfigurationDescription.this.nameText.getDisplay().asyncExec(new Runnable(this, iConfig){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ MethodConfiguration val$iConfig;
                            {
                                this.this$1 = var1_1;
                                this.val$iConfig = methodConfiguration;
                            }

                            public void run() {
                                ConfigurationDescription.access$0(2.access$0(this.this$1)).setText(this.val$iConfig.getName());
                                ConfigurationDescription.access$0(2.access$0(this.this$1)).selectAll();
                                ConfigurationDescription.access$0(2.access$0(this.this$1)).setFocus();
                            }
                        });
                        return;
                    }
                    if (!name.equals(ConfigurationDescription.this.config.getName())) {
                        LibraryProcessor lp = LibraryProcessor.getInstance();
                        String[] configNames = lp.getConfigurationNames();
                        int i = 0;
                        while (i < configNames.length) {
                            if (name.equals(configNames[i])) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.renameDialog.title"), AuthoringUIResources.formatString("AuthoringUI.duplicateElementNameError.msg", name));
                                ConfigurationDescription.this.nameText.getDisplay().asyncExec(new Runnable(this, iConfig){
                                    final /* synthetic */ 2 this$1;
                                    private final /* synthetic */ MethodConfiguration val$iConfig;
                                    {
                                        this.this$1 = var1_1;
                                        this.val$iConfig = methodConfiguration;
                                    }

                                    public void run() {
                                        ConfigurationDescription.access$0(2.access$0(this.this$1)).setText(this.val$iConfig.getName());
                                        ConfigurationDescription.access$0(2.access$0(this.this$1)).selectAll();
                                        ConfigurationDescription.access$0(2.access$0(this.this$1)).setFocus();
                                    }
                                });
                                return;
                            }
                            ++i;
                        }
                        boolean status = ConfigurationDescription.this.actionMgr.doAction(1, (EObject)ConfigurationDescription.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)name, -1);
                        if (status) {
                            ConfigurationDescription.this.form.setText(String.valueOf(FORM_PREFIX) + ConfigurationDescription.this.config.getName());
                            ConfigurationDescription.this.nameText.setText(name);
                        }
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.renameDialog.title"), AuthoringUIResources.formatString("AuthoringUI.emptyElementNameError.msg", StrUtil.toLower((String)LibraryUIText.TEXT_METHOD_CONFIGURATON)));
                    ConfigurationDescription.this.nameText.setText(ConfigurationDescription.this.config.getName());
                    ConfigurationDescription.this.nameText.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ConfigurationDescription.access$0(2.access$0(this.this$1)).setFocus();
                            ConfigurationDescription.access$0(2.access$0(this.this$1)).setSelection(0, ConfigurationDescription.access$0(2.access$0(this.this$1)).getText().length());
                        }
                    });
                }
            }

            static /* synthetic */ ConfigurationDescription access$0(2 var0) {
                return var0.ConfigurationDescription.this;
            }
        });
        this.despText.addModifyListener(this.modelModifyListener);
        this.despText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldContent = ConfigurationDescription.this.config.getBriefDescription();
                if (((MethodElementEditor)ConfigurationDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String desc1 = ConfigurationDescription.this.despText.getText();
                if (!desc1.equals(ConfigurationDescription.this.config.getBriefDescription())) {
                    ConfigurationDescription.this.actionMgr.doAction(1, (EObject)ConfigurationDescription.this.config, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)desc1, -1);
                }
            }
        });
    }

    private static boolean isTextNonEmpty(Text t) {
        String s = t.getText();
        return s != null && s.trim().length() > 0;
    }

    public void dispose() {
        super.dispose();
    }

    public void refreshName(String newName) {
        if (newName != null && this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.removeModifyListener(this.modelModifyListener);
            this.nameText.setText(newName);
            this.nameText.addModifyListener(this.modelModifyListener);
            this.form.setText(String.valueOf(FORM_PREFIX) + this.config.getName());
        }
    }
}

