/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.SupportingMaterial;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ChangeHistoryDialog;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.RemoveReferencesCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.PluginReferenceChecker;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class MethodPluginDescriptionPage
extends BaseFormPage
implements IRefreshable {
    private static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_METHOD_PLUGIN) + ": ";
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private Text ctrl_r_brief_desc;
    private CheckboxTableViewer ctrl_refModel;
    private Section generalSection;
    private Section refModelSection;
    private Composite generalComposite;
    private Composite refModelComposite;
    private boolean descExpandFlag = false;
    private MethodPlugin plugin;
    private IActionManager actionMgr;
    protected Section versionSection;
    protected Composite versionComposite;
    private Text ctrl_authors;
    private Text ctrl_change_date;
    private Text ctrl_change_desc;
    private Text ctrl_version;
    protected boolean versionSectionOn = true;
    protected boolean anyAttributeModified = false;
    protected static final int VERSION_SECTION_ID = 3;
    protected IMethodRichTextEditor ctrl_version_expanded;
    protected ImageHyperlink expandVersionLink;
    protected Label expandVersionLabel;
    protected Composite expandedVersionComposite;
    protected ModifyListener modelModifyListener;
    protected ModifyListener contentModifyListener;
    protected static final int GENERAL_SECTION_ID = 1;
    private IMethodRichText activeControl;
    protected Label label_copyright;
    protected TableViewer copyright_viewer;
    protected Table ctrl_copyright;
    protected IStructuredContentProvider copyrightContentProvider;
    private ILabelProvider labelProviderBase = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    private Button copyright_button;
    private Button copyright_button_deselect;
    private Button ctrl_changeable;
    private Button view_history_button;
    public boolean notificationEnabled = true;
    protected Adapter userChangeableAdapter;
    private ModifyListener nameModifyListener;
    private String lastChangeHistory = "";

    public MethodPluginDescriptionPage(FormEditor editor) {
        super(editor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
        this.actionMgr = ((MethodElementEditor)editor).getActionManager();
        this.userChangeableAdapter = new UserChangeableAdapter();
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        MethodElement obj = methodElementInput.getMethodElement();
        this.plugin = (MethodPlugin)obj;
        if (this.userChangeableAdapter != null) {
            this.plugin.eAdapters().add((Object)this.userChangeableAdapter);
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.createEditorContent(this.toolkit);
        this.createReferenceContent(this.toolkit);
        this.setContextHelp();
        this.loadData();
        this.addListeners();
    }

    private void setContextHelp() {
        if (this.generalComposite != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.generalComposite.getParent().getParent(), AuthoringUIHelpContexts.PLUGIN_EDITOR_DESCRIPTION_ALL_CONTEXT);
        }
    }

    protected void createEditorContent(FormToolkit toolkit) {
        this.form.setText(String.valueOf(FORM_PREFIX) + this.plugin.getName());
        this.generalSection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)td);
        this.generalSection.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        this.generalSection.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.methodElement)));
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(3, false));
        this.generalSection.setClient((Control)this.generalComposite);
        this.ctrl_name = MethodPluginDescriptionPage.createTextEditWithLabel(toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT);
        this.ctrl_brief_desc = MethodPluginDescriptionPage.createTextEditWithLabel2(toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        if (this.versionSectionOn) {
            this.createVersionSection(toolkit);
            this.createVersionSectionContent();
        }
        toolkit.paintBordersFor(this.generalComposite);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    MethodPluginDescriptionPage.this.ctrl_name.setFocus();
                }
            });
        }
    }

    private void createReferenceContent(FormToolkit toolkit) {
        this.refModelSection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td1 = new TableWrapData(256);
        this.refModelSection.setLayoutData((Object)td1);
        this.refModelSection.setText(AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        this.refModelSection.setDescription(AuthoringUIText.REFERENCED_PLUGINS_SECTION_DESC);
        this.refModelSection.setLayout((Layout)new GridLayout());
        this.refModelComposite = toolkit.createComposite((Composite)this.refModelSection);
        this.refModelComposite.setLayoutData((Object)new GridData(768));
        this.refModelComposite.setLayout((Layout)new GridLayout(2, false));
        this.refModelSection.setClient((Control)this.refModelComposite);
        Table ctrl_table = toolkit.createTable(this.refModelComposite, 32);
        GridData gridData = new GridData(1809);
        gridData.heightHint = 100;
        ctrl_table.setLayoutData((Object)gridData);
        this.ctrl_refModel = new CheckboxTableViewer(ctrl_table);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                MethodPlugin plugin = (MethodPlugin)element;
                return plugin.getName();
            }
        };
        this.ctrl_refModel.setLabelProvider((IBaseLabelProvider)labelProvider);
        Label l_r_brief_desc = toolkit.createLabel(this.refModelComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 3;
        l_r_brief_desc.setLayoutData((Object)gridData2);
        this.ctrl_r_brief_desc = toolkit.createText(this.refModelComposite, "", 578);
        gridData2 = new GridData(768);
        gridData2.heightHint = 80;
        this.ctrl_r_brief_desc.setLayoutData((Object)gridData2);
        toolkit.paintBordersFor(this.refModelComposite);
    }

    private void setCheckboxForCurrentBase(List currentBaseList) {
        this.ctrl_refModel.setAllChecked(false);
        int i = 0;
        while (i < currentBaseList.size()) {
            MethodPlugin model = (MethodPlugin)currentBaseList.get(i);
            this.ctrl_refModel.setChecked((Object)model, true);
            ++i;
        }
    }

    private void addListeners() {
        MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                MethodPluginDescriptionPage.this.ctrl_refModel.getTable().clearAll();
                MethodPluginDescriptionPage.this.ctrl_refModel.refresh();
                List allowableList = PluginReferenceChecker.getApplicableBasePlugins((MethodPlugin)MethodPluginDescriptionPage.this.plugin);
                MethodPluginDescriptionPage.this.ctrl_refModel.add(allowableList.toArray());
                List currentBaseList = MethodPluginDescriptionPage.this.plugin.getBases();
                MethodPluginDescriptionPage.this.setCheckboxForCurrentBase(currentBaseList);
                if (!MethodPluginDescriptionPage.this.plugin.getUserChangeable().booleanValue()) {
                    MethodPluginDescriptionPage.this.enableControls(false);
                } else {
                    MethodPluginDescriptionPage.this.enableControls(true);
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        MethodElementEditor.ModifyListener modifyListener = editor.createModifyListener((EObject)this.plugin);
        this.nameModifyListener = editor.createModifyListener((EObject)this.plugin, true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                String oldContent = MethodPluginDescriptionPage.this.plugin.getName();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                if (MethodPluginDescriptionPage.this.ctrl_name.getText().equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                    return;
                }
                String msg = LibraryUtil.checkPluginName(null, (String)MethodPluginDescriptionPage.this.ctrl_name.getText());
                String validName = StrUtil.makeValidFileName((String)MethodPluginDescriptionPage.this.ctrl_name.getText());
                if (msg == null) {
                    msg = LibraryUtil.checkPluginName((MethodPlugin)MethodPluginDescriptionPage.this.plugin, (String)validName);
                }
                if (msg == null) {
                    if (!validName.equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                        Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                        msg = AuthoringUIResources.formatString("AuthoringUI.methodPluginDescriptionPage.confirmRename", new Object[]{MethodPluginDescriptionPage.this.plugin.getName(), MethodPluginDescriptionPage.this.ctrl_name.getText()});
                        String title = AuthoringUIResources.getString("AuthoringUI.methodPluginDescriptionPage.confirmRename.title");
                        if (!MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg)) {
                            MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                            return;
                        }
                        e.doit = true;
                        MethodPluginDescriptionPage.this.ctrl_name.setText(validName);
                        boolean status = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)validName, -1);
                        if (!status) {
                            return;
                        }
                        MethodPluginDescriptionPage.this.form.setText(String.valueOf(FORM_PREFIX) + MethodPluginDescriptionPage.this.plugin.getName());
                        MethodPluginDescriptionPage.this.updateChangeDate();
                        BusyIndicator.showWhile((Display)MethodPluginDescriptionPage.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                MethodElementEditor editor = (MethodElementEditor)4.access$0(this.this$1).getEditor();
                                editor.doSave((IProgressMonitor)new NullProgressMonitor());
                                IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = editor.getPersister();
                                try {
                                    persister.adjustLocation(MethodPluginDescriptionPage.access$2(4.access$0(this.this$1)).eResource());
                                    persister.commit();
                                }
                                catch (RuntimeException e) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                    try {
                                        persister.rollback();
                                    }
                                    catch (Exception ex) {
                                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                                        ViewHelper.reloadCurrentLibaryOnRollbackError(4.access$0(this.this$1).getSite().getShell());
                                        return;
                                    }
                                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(4.access$0(this.this$1).getSite().getShell().getText(), AuthoringUIResources.getString("AuthoringUI.methodPluginDescriptionPage.cannotRenamePluginFolder"), e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                } else {
                    MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                    Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(shell.getText(), msg);
                    e.doit = false;
                    MethodPluginDescriptionPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            MethodPluginDescriptionPage.access$0(4.access$0(this.this$1)).setFocus();
                            MethodPluginDescriptionPage.access$0(4.access$0(this.this$1)).selectAll();
                        }
                    });
                }
            }

            static /* synthetic */ MethodPluginDescriptionPage access$0(4 var0) {
                return var0.MethodPluginDescriptionPage.this;
            }
        });
        this.ctrl_brief_desc.addModifyListener((ModifyListener)modifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                boolean status;
                String oldContent = MethodPluginDescriptionPage.this.plugin.getBriefDescription();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = MethodPluginDescriptionPage.this.ctrl_brief_desc.getText();
                if (!newContent.equals(oldContent) && (status = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                    MethodPluginDescriptionPage.this.ctrl_brief_desc.setText(newContent);
                }
            }
        });
        this.ctrl_refModel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selectedList = (StructuredSelection)event.getSelection();
                MethodPlugin selectedObj = (MethodPlugin)selectedList.getFirstElement();
                if (selectedObj == null) {
                    return;
                }
                MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(selectedObj.getBriefDescription());
            }
        });
        this.ctrl_refModel.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getElement();
                MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(((MethodPlugin)obj).getBriefDescription());
                if (TngUtil.isLocked((EObject)MethodPluginDescriptionPage.this.plugin)) {
                    MethodPluginDescriptionPage.this.ctrl_refModel.setChecked(obj, !event.getChecked());
                    return;
                }
                if (event.getChecked()) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(3, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)obj), -1);
                } else {
                    MethodPlugin base = (MethodPlugin)obj;
                    if (UmaUtil.hasReference((MethodPlugin)MethodPluginDescriptionPage.this.plugin, (MethodPlugin)base)) {
                        String message = AuthoringUIResources.formatString("AuthoringUI.methodPluginDescriptionRemoveRefConfirm.message", MethodPluginDescriptionPage.this.plugin.getName());
                        Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                        if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), message)) {
                            MethodPluginDescriptionPage.this.actionMgr.execute((IResourceAwareCommand)new RemoveReferencesCommand(MethodPluginDescriptionPage.this.plugin, base));
                            MethodPluginDescriptionPage.this.ctrl_refModel.setChecked((Object)base, false);
                        } else {
                            Display.getCurrent().asyncExec(new Runnable(this, base){
                                final /* synthetic */ 9 this$1;
                                private final /* synthetic */ MethodPlugin val$base;
                                {
                                    this.this$1 = var1_1;
                                    this.val$base = methodPlugin;
                                }

                                public void run() {
                                    MethodPluginDescriptionPage.access$1(9.access$0(this.this$1)).setChecked((Object)this.val$base, true);
                                }
                            });
                            return;
                        }
                    }
                    MethodPluginDescriptionPage.this.actionMgr.doAction(4, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)obj), -1);
                }
                PluginReferenceChecker.hasCircularConflictWithPlugin((MethodPlugin)MethodPluginDescriptionPage.this.plugin);
                MethodPluginDescriptionPage.this.updateChangeDate();
            }

            static /* synthetic */ MethodPluginDescriptionPage access$0(9 var0) {
                return var0.MethodPluginDescriptionPage.this;
            }
        });
        if (this.versionSectionOn) {
            this.addVersionSectionListeners();
        }
    }

    protected void enableControls(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_authors.setEditable(editable);
        this.ctrl_brief_desc.setEditable(editable);
        this.ctrl_version.setEditable(editable);
        this.ctrl_change_desc.setEditable(editable);
        this.copyright_button.setEnabled(editable);
        this.copyright_button_deselect.setEnabled(editable);
        this.ctrl_r_brief_desc.setEditable(editable);
    }

    private void loadData() {
        String name = this.plugin.getName();
        String desc = this.plugin.getBriefDescription();
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_brief_desc.setText(desc == null ? "" : desc);
        if (this.versionSectionOn) {
            this.loadVersionSectionData();
        }
    }

    public boolean isVersionSectionOn() {
        return this.versionSectionOn;
    }

    public void setVersionSectionOn(boolean versionSectionOn) {
        this.versionSectionOn = versionSectionOn;
    }

    private void createVersionSection(FormToolkit toolkit) {
        this.versionSection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.versionSection.setLayoutData((Object)td);
        this.versionSection.setText(AuthoringUIText.VERSION_INFO_SECTION_NAME);
        this.versionSection.setDescription(MessageFormat.format(AuthoringUIText.VERSION_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.methodElement)));
        this.versionSection.setLayout((Layout)new GridLayout());
        this.versionComposite = toolkit.createComposite((Composite)this.versionSection);
        this.versionComposite.setLayoutData((Object)new GridData(768));
        this.versionComposite.setLayout((Layout)new GridLayout(4, false));
        this.versionSection.setClient((Control)this.versionComposite);
    }

    private void createVersionSectionContent() {
        this.ctrl_version = MethodPluginDescriptionPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.VERSION_TEXT, -1, 4);
        this.ctrl_change_date = MethodPluginDescriptionPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DATE_TEXT, -1, 4);
        this.ctrl_change_date.setEditable(false);
        this.ctrl_change_desc = MethodPluginDescriptionPage.createTextEditWithLabel2(this.toolkit, this.versionComposite, AuthoringUIText.CHANGE_DESCRIPTION_TEXT);
        GridData gridData = new GridData(769);
        gridData.heightHint = 40;
        this.ctrl_change_desc.setLayoutData((Object)gridData);
        Composite viewHistoryButtonPane = MethodPluginDescriptionPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 2);
        GridData gridData2 = new GridData(128);
        viewHistoryButtonPane.setLayoutData((Object)gridData2);
        this.view_history_button = this.toolkit.createButton(viewHistoryButtonPane, AuthoringUIText.VIEW_HISTORY_BUTTON_TEXT, 8);
        this.ctrl_authors = MethodPluginDescriptionPage.createTextEditWithLabel3(this.toolkit, this.versionComposite, AuthoringUIText.AUTHORS_TEXT, 40, 2);
        this.label_copyright = MethodPluginDescriptionPage.createLabel(this.toolkit, this.versionComposite, AuthoringUIText.COPYRIGHT_TEXT, 2);
        this.ctrl_copyright = MethodPluginDescriptionPage.createTable(this.toolkit, this.versionComposite, 12, 769, 5, 500, 1, 1);
        gridData2 = new GridData(769);
        gridData2.heightHint = 7;
        this.ctrl_copyright.setLayoutData((Object)gridData2);
        this.copyright_viewer = new TableViewer(this.ctrl_copyright);
        this.initContentProviderCopyright();
        this.copyright_viewer.setLabelProvider((IBaseLabelProvider)this.labelProviderBase);
        this.copyright_viewer.setInput((Object)this.plugin);
        Composite buttonpane = MethodPluginDescriptionPage.createComposite(this.toolkit, this.versionComposite, 128, 1, 1, 2);
        GridData gridData3 = new GridData(128);
        buttonpane.setLayoutData((Object)gridData3);
        this.copyright_button = this.toolkit.createButton(buttonpane, AuthoringUIResources.getString("AuthoringUI.selectButton.text"), 64);
        this.copyright_button_deselect = this.toolkit.createButton(buttonpane, AuthoringUIResources.getString("AuthoringUI.deselectButton.text"), 64);
        this.ctrl_changeable = this.toolkit.createButton(this.versionComposite, AuthoringUIResources.getString("AuthoringUI.methodPluginDescriptionPage.lockPluginLabel"), 32);
        this.expandedVersionComposite = this.toolkit.createComposite((Composite)this.versionSection, 0);
        this.expandedVersionComposite.setLayoutData((Object)new GridData(768));
        this.expandedVersionComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedVersionComposite.setVisible(false);
        this.expandVersionLink = this.toolkit.createImageHyperlink(this.expandedVersionComposite, 0);
        this.expandVersionLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandVersionLink.setUnderlined(false);
        this.expandVersionLink.setToolTipText(AuthoringUIResources.getString("AuthoringUI.closeRTE"));
        this.expandVersionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                MethodPluginDescriptionPage.this.toggle(e, 3);
            }
        });
        this.expandVersionLabel = MethodPluginDescriptionPage.createLabel(this.toolkit, this.expandedVersionComposite, "");
        this.toolkit.paintBordersFor(this.expandedVersionComposite);
        this.toolkit.paintBordersFor(this.versionComposite);
        this.toolkit.paintBordersFor(viewHistoryButtonPane);
    }

    private void initContentProviderCopyright() {
        this.copyrightContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<SupportingMaterial> list = new ArrayList<SupportingMaterial>();
                if (MethodPluginDescriptionPage.this.plugin.getCopyrightStatement() != null) {
                    list.add(MethodPluginDescriptionPage.this.plugin.getCopyrightStatement());
                }
                return list.toArray();
            }
        };
        this.copyright_viewer.setContentProvider((IContentProvider)this.copyrightContentProvider);
    }

    protected void addVersionSectionListeners() {
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = editor.createModifyListener((EObject)this.plugin);
        this.contentModifyListener = editor.createModifyListener((EObject)this.plugin);
        this.ctrl_version.addModifyListener(this.contentModifyListener);
        this.ctrl_version.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldContent = MethodPluginDescriptionPage.this.plugin.getVersion();
                String newContent = StrUtil.getPlainText((String)MethodPluginDescriptionPage.this.ctrl_version.getText());
                if (!newContent.equals(oldContent)) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Version(), (Object)newContent, -1);
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_authors.addModifyListener(this.contentModifyListener);
        this.ctrl_authors.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldContent = MethodPluginDescriptionPage.this.plugin.getAuthors();
                String newContent = StrUtil.getPlainText((String)MethodPluginDescriptionPage.this.ctrl_authors.getText());
                if (!newContent.equals(oldContent)) {
                    MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_Authors(), (Object)newContent, -1);
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.copyright_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                ContentFilter filter = new ContentFilter(this){
                    final /* synthetic */ 15 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    protected boolean childAccept(Object obj) {
                        if (obj instanceof Guidance) {
                            return obj instanceof SupportingMaterial;
                        }
                        return false;
                    }
                };
                ArrayList<Object> alreadyExsting = new ArrayList<Object>();
                if (MethodPluginDescriptionPage.this.ctrl_copyright.getItemCount() > 0 && (item = MethodPluginDescriptionPage.this.ctrl_copyright.getItems()[0]).getData() != null) {
                    alreadyExsting.add(item.getData());
                }
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, MethodPluginDescriptionPage.this.plugin, FilterConstants.SUPPORTING_MATERIALS, alreadyExsting);
                fd.setViewerSelectionSingle(true);
                fd.defultImage(AuthoringUIPlugin.getDefault().getSharedImage("Authoring.gif"));
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.SUPPORTING_MATERIALS);
                fd.open();
                fd.getSelectedItems();
                if (fd.getSelectedItems().size() > 0) {
                    editor.getActionManager().doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), (Object)((SupportingMaterial)fd.getSelectedItems().get(0)), -1);
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        this.ctrl_change_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_change_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String oldContent = MethodPluginDescriptionPage.this.plugin.getChangeDescription();
                char delimiter = AuthoringUIResources.getString("AuthoringUI.ChangeHistoryDialog.delimiter").charAt(0);
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = MethodPluginDescriptionPage.this.ctrl_change_desc.getText();
                if (!(newContent = newContent.replace(delimiter, ' ')).equals(MethodPluginDescriptionPage.this.lastChangeHistory)) {
                    MethodPluginDescriptionPage.this.lastChangeHistory = newContent;
                    if (oldContent != null && !StrUtil.isBlank((String)oldContent)) {
                        newContent = String.valueOf(oldContent) + delimiter + newContent;
                    }
                    MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDescription(), (Object)newContent, -1);
                    MethodPluginDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.view_history_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangeHistoryDialog dlg = new ChangeHistoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (MethodElement)MethodPluginDescriptionPage.this.plugin);
                dlg.open();
            }
        });
        this.copyright_button_deselect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_CopyrightStatement(), null, -1);
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }
        });
        this.ctrl_changeable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodPluginDescriptionPage.this.notificationEnabled = true;
                boolean ret = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)new Boolean(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection()), -1);
                if (!ret) {
                    MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    return;
                }
                String message = AuthoringUIResources.formatString("AuthoringUI.methodPluginDescriptionPage.lockPlugin.message", MethodPluginDescriptionPage.this.plugin.getName());
                Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), message)) {
                    this.getDirtyEditors(null);
                    MethodPluginDescriptionPage.this.enableControls(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                } else {
                    MethodPluginDescriptionPage.this.actionMgr.undo();
                    MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    MethodPluginDescriptionPage.this.enableControls(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
            }

            List getDirtyEditors(MethodPlugin methodplugin) {
                IWorkbenchPage workbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
                ArrayList<IEditorReference> closeEditorRefs = new ArrayList<IEditorReference>();
                int i = 0;
                while (i < editorReferences.length) {
                    IEditorReference reference = editorReferences[i];
                    IEditorPart editor = reference.getEditor(true);
                    if (editor != null) {
                        IEditorInput input = editor.getEditorInput();
                        MethodElement element = null;
                        if (input instanceof MethodElementEditorInput) {
                            element = ((MethodElementEditorInput)input).getMethodElement();
                        } else if (input instanceof ConfigurationEditorInput) {
                            element = ((ConfigurationEditorInput)input).getConfiguration();
                        }
                        if (element != null && (element.eContainer() == null || UmaUtil.isContainedBy((EObject)element, (Object)MethodPluginDescriptionPage.this.plugin)) && !element.equals(MethodPluginDescriptionPage.this.plugin)) {
                            closeEditorRefs.add(reference);
                        }
                    }
                    ++i;
                }
                int size = closeEditorRefs.size();
                IEditorReference[] references = new IEditorReference[size];
                int i2 = 0;
                while (i2 < size) {
                    references[i2] = (IEditorReference)closeEditorRefs.get(i2);
                    ++i2;
                }
                workbenchPage.closeEditors(references, true);
                return null;
            }
        });
    }

    protected void updateChangeDate() {
        Date currentDate;
        String newContent;
        Date changeDate = this.plugin.getChangeDate();
        DateFormat df = DateFormat.getDateInstance(0);
        String oldContent = "";
        if (changeDate != null) {
            oldContent = df.format(changeDate);
        }
        if (!(newContent = df.format(currentDate = new Date())).equals(oldContent)) {
            this.actionMgr.doAction(1, (EObject)this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodUnit_ChangeDate(), (Object)currentDate, -1);
            this.ctrl_change_date.setText(newContent);
        }
    }

    protected void loadVersionSectionData() {
        this.ctrl_version.setText(this.plugin.getVersion() == null ? "" : this.plugin.getVersion());
        this.ctrl_authors.setText(this.plugin.getAuthors() == null ? "" : this.plugin.getAuthors());
        this.ctrl_change_desc.setText("");
        this.ctrl_change_date.setText(this.plugin.getChangeDate() == null ? "" : DateFormat.getDateInstance(0).format(this.plugin.getChangeDate()));
        this.ctrl_changeable.setSelection(this.plugin.getUserChangeable() == false);
    }

    protected void toggle(HyperlinkEvent e, int id) {
        if (id == 1) {
            this.toggle(e);
        }
        if (id == 3) {
            this.toggleVersionSection(e);
        }
    }

    private void toggleVersionSection(HyperlinkEvent e) {
        if (this.ctrl_version_expanded == null) {
            this.ctrl_version_expanded = this.createRichTextEditor(this.toolkit, this.expandedVersionComposite, 578, 1808, 400, 400, 2);
            this.ctrl_version_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.versionComposite.setVisible(true);
            this.expandedVersionComposite.setVisible(false);
            this.versionSection.setClient((Control)this.versionComposite);
            this.refModelSection.setExpanded(true);
            this.generalSection.setExpanded(true);
            IMethodRichText richText = this.getActiveRichTextControl();
            richText.setText(this.ctrl_version_expanded.getText());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_version_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_version_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_version_expanded);
            }
            richText.setFocus();
        } else {
            this.versionComposite.setVisible(false);
            this.expandedVersionComposite.setVisible(true);
            this.versionSection.setClient((Control)this.expandedVersionComposite);
            this.refModelSection.setExpanded(false);
            this.generalSection.setExpanded(false);
            this.expandVersionLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_version_expanded.setText(richText.getText());
            this.ctrl_version_expanded.setModalObject(richText.getModalObject());
            this.ctrl_version_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_version_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            this.ctrl_version_expanded.setFocus();
            this.setActiveRichTextControl(richText);
        }
        this.versionSection.layout(true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText ctrl) {
        this.activeControl = ctrl;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    public void setUserChangeable(boolean userChangeable) {
        if (!this.notificationEnabled) {
            return;
        }
        this.notificationEnabled = false;
        this.plugin.setUserChangeable(Boolean.valueOf(userChangeable));
    }

    public void dispose() {
        this.plugin.eAdapters().remove((Object)this.userChangeableAdapter);
        super.dispose();
    }

    public void refreshName(String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener(this.nameModifyListener);
            this.ctrl_name.setText(newName);
            this.ctrl_name.addModifyListener(this.nameModifyListener);
            this.form.setText(String.valueOf(FORM_PREFIX) + this.plugin.getName());
        }
    }

    protected class UserChangeableAdapter
    extends AdapterImpl {
        static /* synthetic */ Class class$0;

        protected UserChangeableAdapter() {
        }

        public void notifyChanged(Notification msg) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.uma.MethodPlugin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (msg.getFeatureID((Class)clazz)) {
                case 11: {
                    Boolean b = (Boolean)msg.getNewValue();
                    MethodPluginDescriptionPage.this.setUserChangeable(b);
                    return;
                }
            }
        }
    }
}

