/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.Role;
import com.ibm.uma.RoleDescription;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RoleDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "roleDescriptionPage";
    private static final String BASE_ROLE = AuthoringUIText.BASE_ELEMENT_TEXT;
    private IMethodRichText ctrl_skills;
    private IMethodRichText ctrl_assign;
    private IMethodRichText ctrl_synonyms;
    private Role role;

    public RoleDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.role = (Role)this.contentElement;
        this.notationSectionOn = true;
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.label_base.setText(BASE_ROLE);
    }

    protected void createNotationSectionContent() {
        super.createNotationSectionContent();
        this.notationSection.setText(AuthoringUIText.STAFFING_SECTION_NAME);
        this.notationSection.setDescription(AuthoringUIText.STAFFING_SECTION_DESC);
        this.ctrl_skills = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.SKILLS_TEXT, 40, 400, 4);
        this.ctrl_assign = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.ASSIGNMENT_APPROACHES_TEXT, 40, 400, 4);
        this.ctrl_synonyms = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.SYNONYMS_TEXT, 40, 400, 4);
    }

    protected void addListeners() {
        super.addListeners();
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.ctrl_skills.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_skills.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_Skills());
        this.ctrl_skills.addModifyListener(this.contentModifyListener);
        this.ctrl_skills.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = RoleDescriptionPage.this.descExpandFlag ? RoleDescriptionPage.this.ctrl_expanded : RoleDescriptionPage.this.ctrl_skills;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((RoleDescription)RoleDescriptionPage.this.role.getPresentation()).getSkills();
                if (((MethodElementEditor)RoleDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)RoleDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_Skills(), (Object)newContent, -1)) && RoleDescriptionPage.this.isVersionSectionOn()) {
                    RoleDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_assign.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_assign.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_AssignmentApproaches());
        this.ctrl_assign.addModifyListener(this.contentModifyListener);
        this.ctrl_assign.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = RoleDescriptionPage.this.descExpandFlag ? RoleDescriptionPage.this.ctrl_expanded : RoleDescriptionPage.this.ctrl_assign;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((RoleDescription)RoleDescriptionPage.this.role.getPresentation()).getAssignmentApproaches();
                if (((MethodElementEditor)RoleDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)RoleDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_AssignmentApproaches(), (Object)newContent, -1)) && RoleDescriptionPage.this.isVersionSectionOn()) {
                    RoleDescriptionPage.this.updateChangeDate();
                }
            }
        });
        this.ctrl_synonyms.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_synonyms.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_Synonyms());
        this.ctrl_synonyms.addModifyListener(this.contentModifyListener);
        this.ctrl_synonyms.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = RoleDescriptionPage.this.descExpandFlag ? RoleDescriptionPage.this.ctrl_expanded : RoleDescriptionPage.this.ctrl_synonyms;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = ((RoleDescription)RoleDescriptionPage.this.role.getPresentation()).getSynonyms();
                if (((MethodElementEditor)RoleDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)RoleDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescription_Synonyms(), (Object)newContent, -1)) && RoleDescriptionPage.this.isVersionSectionOn()) {
                    RoleDescriptionPage.this.updateChangeDate();
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_skills.setEditable(editable);
        this.ctrl_assign.setEditable(editable);
        this.ctrl_synonyms.setEditable(editable);
    }

    protected void loadData() {
        super.loadData();
        String skills = ((RoleDescription)this.role.getPresentation()).getSkills();
        String assign = ((RoleDescription)this.role.getPresentation()).getAssignmentApproaches();
        String synonyms = ((RoleDescription)this.role.getPresentation()).getSynonyms();
        this.ctrl_skills.setText(skills == null ? "" : skills);
        this.ctrl_assign.setText(assign == null ? "" : assign);
        this.ctrl_synonyms.setText(synonyms == null ? "" : synonyms);
    }

    protected Object getContentElement() {
        return this.role;
    }

    protected String getTabString() {
        return FilterConstants.ROLES;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof Role;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.role)});
        return this.filter;
    }
}

