/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.Deliverable;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProduct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductDeliverablePartsPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "workProductDeliverablePartsPage";
    private WorkProduct workProduct;
    private IActionManager actionMgr;

    public WorkProductDeliverablePartsPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DELIVERABLE_PARTS_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.workProduct = (WorkProduct)this.contentElement;
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.setUseCategory2(false);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                Deliverable wp = (Deliverable)WorkProductDeliverablePartsPage.this.workProduct;
                return wp.getDeliveredWorkProducts().toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                WorkProduct item = (WorkProduct)it.next();
                this.actionMgr.doAction(3, (EObject)this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (Object)item, -1);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                WorkProduct item = (WorkProduct)it.next();
                this.actionMgr.doAction(4, (EObject)this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (Object)item, -1);
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){
            List badlist = new ArrayList();

            protected boolean childAccept(Object obj) {
                if (obj instanceof WorkProduct) {
                    if (obj instanceof Deliverable && WorkProductDeliverablePartsPage.this.workProduct instanceof Deliverable) {
                        if (!UIHelper.checkCircularDeliverables((Deliverable)obj, (Deliverable)WorkProductDeliverablePartsPage.this.workProduct)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        if (!WorkProductDeliverablePartsPage.this.checkVariability((Deliverable)obj, this.badlist)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        ArrayList templist = new ArrayList();
                        Iterator iterator = this.badlist.iterator();
                        while (iterator.hasNext()) {
                            Object bad = iterator.next();
                            UIHelper.deliverablePartsChain((Deliverable)bad, templist);
                        }
                        if (templist.contains(obj)) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        return this.filter;
    }

    public boolean checkVariability(Deliverable e, List badlist) {
        VariabilityElement obj;
        VariabilityElement obj2;
        if (this.workProduct.getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables(e, (Deliverable)(obj2 = this.workProduct.getVariabilityBasedOnElement()))) {
            return false;
        }
        Iterator it = TngUtil.getGeneralizers((VariabilityElement)this.workProduct);
        while (it.hasNext()) {
            VariabilityElement ve = (VariabilityElement)it.next();
            if (ve == null) continue;
            badlist.add(ve);
            if (ve.equals(e)) {
                return false;
            }
            if (UIHelper.checkCircularDeliverables(e, (Deliverable)ve)) continue;
            return false;
        }
        if (e.getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables((Deliverable)(obj = e.getVariabilityBasedOnElement()), (Deliverable)this.workProduct)) {
            return false;
        }
        Iterator it1 = TngUtil.getGeneralizers((VariabilityElement)e);
        while (it1.hasNext()) {
            VariabilityElement ve = (VariabilityElement)it1.next();
            if (ve == null) continue;
            if (ve.equals(e)) {
                return false;
            }
            if (UIHelper.checkCircularDeliverables((Deliverable)ve, (Deliverable)this.workProduct)) continue;
            return false;
        }
        ArrayList list = new ArrayList();
        this.deliverablePartsVariability((Deliverable)this.workProduct, list);
        if (list.contains(e)) {
            return false;
        }
        this.deliverablePartsVariability(e, list);
        return !list.contains(this.workProduct);
    }

    private void deliverablePartsVariability(Deliverable e, List roots) {
        List list = e.getDeliveredWorkProducts();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Deliverable)) continue;
                if (((Deliverable)obj).getVariabilityBasedOnElement() != null) {
                    roots.add(((Deliverable)obj).getVariabilityBasedOnElement());
                } else {
                    Iterator it1 = TngUtil.getGeneralizers((VariabilityElement)e);
                    while (it1.hasNext()) {
                        VariabilityElement ve = (VariabilityElement)it1.next();
                        UIHelper.deliverablePartsChain((Deliverable)ve, roots);
                    }
                }
                this.deliverablePartsVariability((Deliverable)obj, roots);
            }
        }
        if (e instanceof Deliverable) {
            Iterator it1 = TngUtil.getGeneralizers((VariabilityElement)e);
            while (it1.hasNext()) {
                VariabilityElement ve = (VariabilityElement)it1.next();
                UIHelper.deliverablePartsChain((Deliverable)ve, roots);
            }
        }
    }
}

