/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.Activity;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Iteration;
import com.ibm.uma.Phase;
import com.ibm.uma.Process;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.dialogs.ConvertActivityDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ActivityGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected Activity element;
    private String[] items = new String[]{LibraryUIText.TEXT_ACTIVITY, LibraryUIText.TEXT_ITERATION, LibraryUIText.TEXT_PHASE};
    private Text modelInfoText;
    private Label activityTypeLabel;
    private Label ctrl_type_label;
    private Button ctrl_type_button;

    protected void init() {
        super.init();
        this.element = (Activity)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Activity.ModelInfo"));
        this.modelInfoText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.modelInfoText.setEnabled(false);
        this.modelInfoText.setText(this.getModelInfo());
        this.activityTypeLabel = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Activity.Type"));
        this.ctrl_type_label = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 90;
        this.ctrl_type_label.setBackground(Display.getCurrent().getSystemColor(19));
        this.ctrl_type_label.setLayoutData((Object)gridData);
        this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_type_button.setLayoutData((Object)gridData);
        if (ConvertActivityDialog.getValidNewActivityTypes((Activity)this.element) == null) {
            this.ctrl_type_button.setVisible(false);
        }
    }

    protected void addListeners() {
        super.addListeners();
        this.ctrl_type_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessEditor editor = ActivityGeneralSection.this.getEditor();
                if (editor.isDirty()) {
                    String title = AuthoringUIResources.getString("AuthoringUI.changeActivityTypeWarningDialog.title");
                    String message = AuthoringUIResources.getString("AuthoringUI.descriptionTabGuidanceWarningDialog.message1");
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(title, message);
                } else if (ActivityGeneralSection.this.element instanceof Activity) {
                    ProcessDeleteAction deleteAction = new ProcessDeleteAction();
                    deleteAction.setEditingDomain(ActivityGeneralSection.this.getEditor().getEditingDomain());
                    deleteAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)ActivityGeneralSection.this.element));
                    Command cmd = deleteAction.createCommand(Collections.singleton(ActivityGeneralSection.this.element));
                    if (cmd instanceof DeleteMethodElementCommand) {
                        ActivityGeneralSection.this.nameText.removeListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                        ActivityGeneralSection.this.presentationNameText.removeListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                        Activity newActivity = ConvertActivityDialog.queryUserAndConvert((Activity)ActivityGeneralSection.this.element, null, (DeleteMethodElementCommand)((DeleteMethodElementCommand)cmd));
                        if (newActivity != null) {
                            StructuredSelection sel = new StructuredSelection((Object)newActivity);
                            ActivityGeneralSection.this.getPropertySheetPage().selectionChanged(ActivityGeneralSection.this.getPart(), (ISelection)sel);
                            ActivityGeneralSection.this.refresh();
                            ((ProcessViewer)((ProcessBreakdownStructureFormPage)ActivityGeneralSection.this.getEditor().getActivePageInstance()).getViewer()).expandToLevel(newActivity, 3);
                        }
                        ActivityGeneralSection.this.nameText.addListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                        ActivityGeneralSection.this.presentationNameText.addListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private String getModelInfo() {
        String info = null;
        try {
            ItemProviderAdapter o = this.getAdapter();
            if (o instanceof IBSItemProvider) {
                IBSItemProvider adapter = (IBSItemProvider)o;
                info = adapter.getAttribute((Object)this.element, "model_info");
            }
        }
        catch (Exception exception) {}
        if (!StrUtil.isBlank(info)) {
            return info;
        }
        return PropertiesResources.getString("Process.None");
    }

    protected void updateControls() {
        super.updateControls();
        this.ctrl_type_button.setEnabled(this.editable);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                super.refresh();
                this.element = (Activity)this.getElement();
                this.modelInfoText.setText(this.getModelInfo());
                this.ctrl_type_label.setText(PropertiesUtil.getType(this.element));
                if (this.element instanceof Process && (this.element.getSuperActivities() == null || this.element.getSuperActivities().isEmpty())) {
                    this.activityTypeLabel.setVisible(false);
                    this.ctrl_type_label.setVisible(false);
                    this.ctrl_type_button.setVisible(false);
                } else {
                    this.activityTypeLabel.setVisible(true);
                    this.ctrl_type_label.setVisible(true);
                    this.ctrl_type_button.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Activity general section : " + this.element, (Throwable)ex);
        }
    }

    public String getNamePrefix() {
        if (this.element instanceof CapabilityPattern) {
            return String.valueOf(LibraryUIText.TEXT_CAPABILITY_PATTERN) + ": ";
        }
        if (this.element instanceof DeliveryProcess) {
            return String.valueOf(LibraryUIText.TEXT_DELIVERY_PROCESS) + ": ";
        }
        if (this.element instanceof Phase) {
            return String.valueOf(LibraryUIText.TEXT_PHASE) + ": ";
        }
        if (this.element instanceof Iteration) {
            return String.valueOf(LibraryUIText.TEXT_ITERATION) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ACTIVITY) + ": ";
    }
}

