/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Process;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.TNGPropertySheetPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;

public class OBSRelationSection
extends AbstractSection {
    protected IStructuredContentProvider contentProvider = null;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
    private FormToolkit toolkit;
    private Button ctrl_add_1;
    private Button ctrl_add_2;
    private Button ctrl_remove;
    private Table ctrl_selected;
    protected TableViewer viewer;
    private String elementName;
    private String tabName;
    protected BreakdownElement element;
    protected IActionManager actionMgr;
    protected boolean showAddFromProcessButton = false;
    private IFilter filter = null;

    public IFilter getFilter() {
        if (this.filter == null) {
            this.filter = new ProcessRoleFilter(this.getConfiguration(), null, FilterConstants.ROLES);
        }
        return this.filter;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createSection(parent);
        this.addListeners();
        this.updateControls();
    }

    protected void init() {
        this.element = this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.actionMgr = TNGPropertySheetPage.getActionManager();
    }

    protected void setTabData(String elementName, String tabName) {
        this.elementName = elementName;
        this.tabName = tabName;
    }

    private void createSection(Composite parent) {
        String title = String.valueOf(this.elementName) + "." + this.tabName + "." + "SectionTitle";
        String desc = String.valueOf(this.elementName) + "." + this.tabName + "." + "SectionDescription";
        String table1 = String.valueOf(this.elementName) + "." + this.tabName + "." + "Table1";
        Section aSection = FormUI.createSection(this.toolkit, parent, PropertiesResources.getString(title), PropertiesResources.getString(desc));
        Composite composite = FormUI.createComposite(this.toolkit, aSection, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, composite, 1808);
        FormUI.createLabel(this.toolkit, pane1, PropertiesResources.getString(table1));
        this.ctrl_selected = FormUI.createTable(this.toolkit, pane1);
        this.viewer = new TableViewer(this.ctrl_selected);
        this.initContentProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, composite, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        if (this.showAddFromProcessButton) {
            this.ctrl_add_2 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.AddFromProcess"));
        }
        this.ctrl_remove = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(composite);
        this.toolkit.paintBordersFor(pane1);
        this.toolkit.paintBordersFor(pane2);
    }

    protected MethodConfiguration getDefaultConfiguration() {
        ItemProviderAdapter adapter = this.getAdapter();
        Object parent = null;
        if (adapter instanceof IBSItemProvider) {
            IBSItemProvider bsItemProvider = (IBSItemProvider)adapter;
            parent = bsItemProvider.getTopItem();
            MethodConfiguration config = ((Process)parent).getDefaultContext();
            return config;
        }
        this.logger.logError("OBSRelationSection::getDefaultConfiguration - IBSItemProvider is null");
        return null;
    }

    private void addListeners() {
        this.ctrl_selected.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (selection.size() > 0 && OBSRelationSection.this.editable) {
                    OBSRelationSection.this.ctrl_remove.setEnabled(true);
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (selection.size() > 0 && OBSRelationSection.this.editable) {
                    OBSRelationSection.this.ctrl_remove.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OBSRelationSection.this.openAddDialog();
                OBSRelationSection.this.viewer.refresh();
            }
        });
        if (this.showAddFromProcessButton) {
            this.ctrl_add_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OBSRelationSection.this.openAddFromProcessDialog();
                    OBSRelationSection.this.viewer.refresh();
                }
            });
        }
        this.ctrl_remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)OBSRelationSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    OBSRelationSection.this.remove(rmItems);
                    OBSRelationSection.this.viewer.refresh();
                    OBSRelationSection.this.viewer.setSelection(null, true);
                }
                OBSRelationSection.this.ctrl_remove.setEnabled(false);
            }
        });
    }

    public void updateControls() {
        IStructuredSelection selection;
        if (this.ctrl_add_1 != null) {
            this.ctrl_add_1.setEnabled(this.editable);
        }
        if (this.ctrl_add_2 != null) {
            this.ctrl_add_2.setEnabled(this.editable);
        }
        if ((selection = (IStructuredSelection)this.viewer.getSelection()).size() > 0 && this.editable) {
            if (this.ctrl_remove != null) {
                this.ctrl_remove.setEnabled(true);
            }
        } else if (this.ctrl_remove != null) {
            this.ctrl_remove.setEnabled(false);
        }
    }

    public void refresh() {
        this.updateControls();
        super.refresh();
    }

    protected void initContentProvider() {
    }

    protected void openAddDialog() {
    }

    protected void openAddFromProcessDialog() {
    }

    protected void remove(ArrayList rmItems) {
    }

    public void disose() {
        super.dispose();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }
}

