/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.jface.util.IOpenEventListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ProcessTreeViewer
extends TreeViewer
implements IActionTypeProvider {
    private int actionType = 1;
    private Menu actionTypePopup;
    private Point actionTypePopupLocation;
    private Command command;
    private IActionManager actionManager;
    static /* synthetic */ Class class$0;

    public ProcessTreeViewer(Composite parent, int style) {
        super(parent, style);
        Tree tree = this.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                ProcessTreeViewer.this.setItemProviderExpanded(event.getElement(), false);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                ProcessTreeViewer.this.setItemProviderExpanded(event.getElement(), true);
            }
        });
    }

    public void setupColumns(ColumnDescriptor[] columnDescriptors) {
        TreeColumn[] cols = this.getTree().getColumns();
        int size = cols.length;
        int i = 0;
        while (i < size) {
            cols[i].dispose();
            ++i;
        }
        String[] colProps = new String[columnDescriptors.length];
        int i2 = 0;
        while (i2 < columnDescriptors.length) {
            colProps[i2] = columnDescriptors[i2].id;
            TreeColumn column = new TreeColumn(this.getTree(), columnDescriptors[i2].alignment);
            column.setText(columnDescriptors[i2].label);
            column.setResizable(columnDescriptors[i2].resizable);
            column.setWidth(columnDescriptors[i2].width);
            ++i2;
        }
        this.setColumnProperties(colProps);
    }

    private void setItemProviderExpanded(Object element, boolean expand) {
        Object adapter;
        AdapterFactory adapterFactory = this.getAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adapterFactory.adapt(element, (Object)clazz)) instanceof IBSItemProvider) {
            ((IBSItemProvider)adapter).setExpanded(Boolean.valueOf(expand));
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.getContentProvider() == null ? null : ((AdapterFactoryContentProvider)this.getContentProvider()).getAdapterFactory();
    }

    protected void setExpanded(Item node, boolean expand) {
        IBSItemProvider bsItemProvider;
        Object adapter;
        super.setExpanded(node, expand);
        AdapterFactory adapterFactory = this.getAdapterFactory();
        Object object = node.getData();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adapterFactory.adapt(object, (Object)clazz)) instanceof IBSItemProvider && (bsItemProvider = (IBSItemProvider)adapter).isExpanded() == null) {
            bsItemProvider.setExpanded(Boolean.valueOf(expand));
        }
    }

    protected void createTreeItem(Widget parent, Object element, int index) {
        Boolean expand;
        Object adapter;
        super.createTreeItem(parent, element, index);
        AdapterFactory adapterFactory = this.getAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = adapterFactory.adapt(element, (Object)clazz)) instanceof IBSItemProvider && (expand = ((IBSItemProvider)adapter).isExpanded()) != null) {
            this.setExpandedState(element, expand);
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        super.doUpdateItem(item, element);
        this.setExpanded(item, element);
    }

    private void setExpanded(Item item, Object element) {
        Boolean expand;
        ITreeItemContentProvider adapter;
        AdapterFactory adapterFactory = this.getAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ITreeItemContentProvider)adapterFactory.adapt(element, (Object)clazz)).hasChildren(element) && adapter instanceof IBSItemProvider && (expand = ((IBSItemProvider)adapter).isExpanded()) != null) {
            this.setExpandedState(item, expand);
        }
    }

    protected void internalRefresh(Widget widget, Object element, boolean doStruct, boolean updateLabels) {
        super.internalRefresh(widget, element, doStruct, updateLabels);
        if (doStruct) {
            if (widget instanceof Item) {
                this.setExpanded((Item)widget, element);
            } else {
                Item[] children = this.getChildren(widget);
                int i = 0;
                while (i < children.length) {
                    Item child = children[i];
                    if (child instanceof Item) {
                        Item item = child;
                        this.setExpanded(item, item.getData());
                    }
                    ++i;
                }
            }
        }
    }

    public int getActionType() {
        if (this.actionTypePopup == null) {
            this.createActionTypePopup();
        }
        Display.getCurrent().syncExec(new Runnable(){

            public void run() {
                ProcessTreeViewer.this.actionType = 0;
                ProcessTreeViewer.this.actionTypePopup.setLocation(ProcessTreeViewer.this.actionTypePopupLocation);
                ProcessTreeViewer.this.actionTypePopup.setVisible(true);
            }
        });
        return this.actionType;
    }

    private void createActionTypePopup() {
        final String COPY_TXT = AuthoringUIResources.getString("AuthoringUI.copy.text");
        final String EXTEND_TXT = AuthoringUIResources.getString("AuthoringUI.extend.text");
        this.actionTypePopup = new Menu(this.getControl());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.getSource();
                if (item.getText() == COPY_TXT) {
                    ProcessTreeViewer.this.actionType = 1;
                } else if (item.getText() == EXTEND_TXT) {
                    ProcessTreeViewer.this.actionType = 2;
                }
                if (ProcessTreeViewer.this.command instanceof ActivityDropCommand) {
                    ((ActivityDropCommand)ProcessTreeViewer.this.command).setType(ProcessTreeViewer.this.actionType);
                }
                if (ProcessTreeViewer.this.actionManager != null && ProcessTreeViewer.this.command instanceof IResourceAwareCommand) {
                    ProcessTreeViewer.this.actionManager.execute((IResourceAwareCommand)ProcessTreeViewer.this.command);
                } else {
                    ProcessTreeViewer.this.command.execute();
                }
                ProcessTreeViewer.this.actionTypePopup.setVisible(false);
            }
        };
        MenuItem menuItem = new MenuItem(this.actionTypePopup, 64);
        menuItem.setText(COPY_TXT);
        menuItem.addSelectionListener((SelectionListener)selectionListener);
        menuItem = new MenuItem(this.actionTypePopup, 64);
        menuItem.setText(EXTEND_TXT);
        menuItem.addSelectionListener((SelectionListener)selectionListener);
    }

    public void setInputData(Object object) {
        this.actionTypePopupLocation = (Point)object;
    }

    public void execute(Command cmd) {
        if (this.actionTypePopup == null) {
            this.createActionTypePopup();
        }
        this.command = cmd;
        this.actionTypePopup.setLocation(this.actionTypePopupLocation);
        this.actionTypePopup.setVisible(true);
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ProcessTreeViewer.this.handleDispose(event);
            }
        });
        OpenStrategy handler = new OpenStrategy(control);
        handler.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProcessTreeViewer.this.handleSelect(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProcessTreeViewer.this.handleDoubleSelect(e);
            }
        });
        handler.addPostSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessTreeViewer.this.handlePostSelect(e);
            }
        });
        handler.addOpenListener(new IOpenEventListener(){

            public void handleOpen(SelectionEvent e) {
                ProcessTreeViewer.this.handleOpen(e);
            }
        });
        this.addTreeListener(control, new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                ProcessTreeViewer.this.handleTreeExpand(event);
            }

            public void treeCollapsed(TreeEvent event) {
                ProcessTreeViewer.this.handleTreeCollapse(event);
            }
        });
        this.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                int columnToEdit;
                TreeItem[] treeItems = ProcessTreeViewer.this.getTree().getSelection();
                if (treeItems == null || treeItems.length != 1) {
                    return;
                }
                TreeItem treeItem = treeItems[0];
                if (treeItem == null || treeItem.isDisposed()) {
                    return;
                }
                int columns = ProcessTreeViewer.this.getTree().getColumnCount();
                if (columns == 0) {
                    columnToEdit = 0;
                } else {
                    columnToEdit = -1;
                    int i = 0;
                    while (i < columns) {
                        Rectangle bounds = treeItem.getBounds(i);
                        if (bounds.contains(event.x, event.y)) {
                            columnToEdit = i;
                            break;
                        }
                        ++i;
                    }
                    if (columnToEdit == -1) {
                        return;
                    }
                }
                ProcessTreeViewer.this.editElement(treeItem.getData(), columnToEdit);
            }
        });
    }

    public void setActionManager(IActionManager actionMgr) {
        this.actionManager = actionMgr;
    }
}

