/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.SaveAsDialog;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.ViewPart;

public abstract class SaveableLibraryViewPart
extends ViewPart
implements ISaveablePart {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSave(IProgressMonitor monitor) {
        if (monitor == null) return;
        monitor.beginTask(AuthoringUIResources.getString("AuthoringUI.savingLibraryTask.name"), -1);
        String libPath = LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath();
        try {
            try {
                LibraryProcessor.getInstance().saveLibrary();
                this.firePropertyChange(257);
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.saveLibraryDialog.title"), AuthoringUIResources.formatString("AuthoringUI.saveLibraryToError.msg", libPath), AuthoringUIResources.getString("AuthoringUI.error.reason"), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    public void doSaveAs() {
        LibraryLocationData llData = new LibraryLocationData();
        llData.setParentFolder(LibraryUIPreferences.getSavedLibraryPath());
        SaveAsDialog dialog = new SaveAsDialog(Display.getCurrent().getActiveShell(), llData);
        dialog.open();
        if (!llData.isOkPressed()) {
            return;
        }
        String libPath = llData.getParentFolder();
        LibraryUIPreferences.setSavedLibraryPath((String)libPath);
        String filePath = String.valueOf(libPath) + File.separator + llData.getLibName();
        Path savePath = new Path(filePath);
        String ext = savePath.getFileExtension();
        SaveLibraryOperation operation = null;
        if (llData.isSingleLibFile()) {
            operation = ext != null && ext.equals("uma") ? new SaveLibraryOperation(filePath, false) : new SaveLibraryOperation(String.valueOf(filePath) + '.' + "uma", false);
        } else {
            File file = new File(filePath);
            file.mkdir();
            filePath = String.valueOf(filePath) + File.separator + "library.xmi";
            operation = new SaveLibraryOperation(filePath, true);
        }
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            Exception error = operation.getError();
            if (error == null) {
                this.firePropertyChange(257);
            } else {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.saveLibraryDialog.title"), AuthoringUIResources.formatString("AuthoringUI.saveLibraryToError.msg", libPath), AuthoringUIResources.getString("AuthoringUI.error.reason"), (Throwable)error);
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.saveLibraryDialog.title"), AuthoringUIResources.getString("AuthoringUI.internalError.msg"), (Throwable)e);
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void setDirty(boolean b) {
        LibraryProcessor.getInstance().setDirty(b);
    }

    public void doSave() {
        IAction saveAction = this.getViewSite().getActionBars().getGlobalActionHandler(ActionFactory.SAVE.getId());
        if (saveAction != null) {
            saveAction.run();
        }
    }

    class SaveLibraryOperation
    extends WorkspaceModifyOperation {
        private String fileName = null;
        private Exception error;

        SaveLibraryOperation(String fileName, boolean bMultiple) {
            this.fileName = fileName;
        }

        public Exception getError() {
            return this.error;
        }

        public void execute(IProgressMonitor monitor) {
            try {
                if (this.fileName == null) {
                    LibraryProcessor.getInstance().saveLibrary();
                } else {
                    LibraryProcessor.getInstance().saveLibraryAs(this.fileName, true, monitor);
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }
}

