/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLibraryWizard
extends Wizard
implements INewWizard {
    protected NewLibraryMainPage mainPage;
    protected boolean okToComplete = false;
    protected LibraryLocationData llData;

    public NewLibraryWizard(LibraryLocationData llData) {
        this.llData = llData;
        this.setWindowTitle(AuthoringUIResources.getString("AuthoringUI.newLibraryWizard.title"));
    }

    public NewLibraryWizard() {
        this(null);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new NewLibraryMainPage(this.llData);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        this.mainPage.saveData();
        String libName = this.llData.getLibName();
        String msg = TngUtil.checkElementName((String)libName, (String)LibraryUIText.TEXT_METHOD_LIBARARY);
        if (msg != null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.newLibraryWizard.title"), msg);
            this.llData.setOkPressed(false);
            return false;
        }
        this.llData.setOkPressed(true);
        boolean answer = this.checkAndCreateDir();
        if (answer) {
            return true;
        }
        this.llData.setOkPressed(false);
        return false;
    }

    private boolean checkAndCreateDir() {
        boolean answer = false;
        String tmpLibPath = this.llData.getParentFolder();
        IStatus status = LibraryProcessor.isValidLibrary((String)(tmpLibPath = LibraryUIManager.toAbsoluteLibraryPath((String)tmpLibPath)));
        if (!status.isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.newLibraryWizard.title"), AuthoringUIResources.getString("AuthoringUI.newLibraryError.msg"), String.valueOf(AuthoringUIResources.formatString("AuthoringUI.newLibraryError.reason1", tmpLibPath)) + "\n\n" + AuthoringUIResources.getString("AuthoringUI.newLibraryError.advice"));
            return false;
        }
        this.llData.setParentFolder(tmpLibPath);
        String dir = this.llData.getParentFolder();
        File file = new File(dir);
        if (file.exists()) {
            String libraryFilePath = String.valueOf(dir) + (dir.endsWith(File.separator) ? "" : File.separator) + "library.xmi";
            File libraryFile = new File(libraryFilePath);
            if (libraryFile.exists()) {
                answer = false;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.newLibraryWizard.title"), AuthoringUIResources.getString("AuthoringUI.newLibraryError.msg"), String.valueOf(AuthoringUIResources.formatString("AuthoringUI.newLibraryError.reason2", tmpLibPath)) + "\n\n" + AuthoringUIResources.getString("AuthoringUI.newLibraryError.advice"));
            } else {
                answer = true;
            }
        } else if (!file.mkdirs()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.newLibraryWizard.title"), AuthoringUIResources.getString("AuthoringUI.newLibraryError.msg"), String.valueOf(AuthoringUIResources.formatString("AuthoringUI.newLibraryError.reason3", file.getAbsolutePath())) + "\n\n" + AuthoringUIResources.getString("AuthoringUI.newLibraryError.advice"));
            answer = false;
        } else {
            answer = true;
        }
        return answer;
    }
}

