/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveablesList
implements ISaveablesLifecycleListener {
    private ListenerList listeners = new ListenerList();
    private Map modelMap = new HashMap();
    private Map modelRefCounts = new HashMap();

    public Saveable[] getOpenModels() {
        return this.modelRefCounts.keySet().toArray(new Saveable[this.modelRefCounts.size()]);
    }

    private boolean addModel(Object source, Saveable model) {
        boolean result = false;
        HashSet<Saveable> modelsForSource = (HashSet<Saveable>)this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet<Saveable>();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.add(model)) {
            result = this.incrementRefCount(this.modelRefCounts, model);
        }
        return result;
    }

    private boolean incrementRefCount(Map referenceMap, Object key) {
        boolean result = false;
        Integer refCount = (Integer)referenceMap.get(key);
        if (refCount == null) {
            result = true;
            refCount = new Integer(0);
        }
        referenceMap.put(key, new Integer(refCount + 1));
        return result;
    }

    private boolean decrementRefCount(Map referenceMap, Object key) {
        boolean result = false;
        Integer refCount = (Integer)referenceMap.get(key);
        Assert.isTrue((refCount != null ? 1 : 0) != 0);
        if (refCount == 1) {
            referenceMap.remove(key);
            result = true;
        } else {
            referenceMap.put(key, new Integer(refCount - 1));
        }
        return result;
    }

    private boolean removeModel(Object source, Saveable model) {
        boolean result = false;
        HashSet modelsForSource = (HashSet)this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.remove(model)) {
            result = this.decrementRefCount(this.modelRefCounts, model);
            if (modelsForSource.isEmpty()) {
                this.modelMap.remove(source);
            }
        }
        return result;
    }

    public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
        Saveable[] modelArray = event.getSaveables();
        switch (event.getEventType()) {
            case 1: {
                this.addModels(event.getSource(), modelArray);
                break;
            }
            case 2: {
                Saveable[] models = event.getSaveables();
                HashMap modelsDecrementing = new HashMap();
                HashSet modelsClosing = new HashSet();
                int i = 0;
                while (i < models.length) {
                    this.incrementRefCount(modelsDecrementing, models[i]);
                    ++i;
                }
                this.fillModelsClosing(modelsClosing, modelsDecrementing);
                boolean canceled = this.promptForSavingIfNecessary(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), modelsClosing, modelsDecrementing, !event.isForce());
                if (!canceled) break;
                event.setVeto(true);
                break;
            }
            case 3: {
                this.removeModels(event.getSource(), modelArray);
                break;
            }
            case 4: {
                this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, event.getEventType(), event.getSaveables(), false));
            }
        }
    }

    private void removeModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        int i = 0;
        while (i < modelArray.length) {
            Saveable model = modelArray[i];
            if (this.removeModel(source, model)) {
                removed.add(model);
            }
            ++i;
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private void addModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> added = new ArrayList<Saveable>();
        int i = 0;
        while (i < modelArray.length) {
            Saveable model = modelArray[i];
            if (this.addModel(source, model)) {
                added.add(model);
            }
            ++i;
        }
        if (added.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, added.toArray(new Saveable[added.size()]), false));
        }
    }

    private void fireModelLifecycleEvent(SaveablesLifecycleEvent event) {
        Object[] listenerArray = this.listeners.getListeners();
        int i = 0;
        while (i < listenerArray.length) {
            ((ISaveablesLifecycleListener)listenerArray[i]).handleLifecycleEvent(event);
            ++i;
        }
    }

    public void addModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Object preCloseParts(List editorsToClose, boolean save, IWorkbenchWindow window) {
        boolean canceled;
        PostCloseInfo postCloseInfo = new PostCloseInfo();
        Iterator it = editorsToClose.iterator();
        while (it.hasNext()) {
            ISaveablePart2 saveablePart2;
            int response;
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            postCloseInfo.partsClosing.add(part);
            if (part instanceof ISaveablePart) {
                ISaveablePart saveablePart = (ISaveablePart)((Object)part);
                if (save && !saveablePart.isSaveOnCloseNeeded()) continue;
            }
            if (save && part instanceof ISaveablePart2 && (response = SaveableHelper.savePart(saveablePart2 = (ISaveablePart2)((Object)part), window, true)) != 3) continue;
            Saveable[] modelsFromSource = this.getSaveables(part);
            int i = 0;
            while (i < modelsFromSource.length) {
                this.incrementRefCount(postCloseInfo.modelsDecrementing, modelsFromSource[i]);
                ++i;
            }
        }
        this.fillModelsClosing(postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing);
        if (save && (canceled = this.promptForSavingIfNecessary(window, postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing, true))) {
            return null;
        }
        return postCloseInfo;
    }

    private boolean promptForSavingIfNecessary(IWorkbenchWindow window, Set modelsClosing, Map modelsDecrementing, boolean canCancel) {
        boolean shouldCancel;
        ArrayList<Saveable> modelsToOptionallySave = new ArrayList<Saveable>();
        Iterator it = modelsDecrementing.keySet().iterator();
        while (it.hasNext()) {
            Saveable modelDecrementing = (Saveable)it.next();
            if (!modelDecrementing.isDirty() || modelsClosing.contains(modelDecrementing)) continue;
            modelsToOptionallySave.add(modelDecrementing);
        }
        boolean bl = shouldCancel = modelsToOptionallySave.isEmpty() ? false : this.promptForSaving(modelsToOptionallySave, window, canCancel, true);
        if (shouldCancel) {
            return true;
        }
        ArrayList<Saveable> modelsToSave = new ArrayList<Saveable>();
        Iterator it2 = modelsClosing.iterator();
        while (it2.hasNext()) {
            Saveable modelClosing = (Saveable)it2.next();
            if (!modelClosing.isDirty()) continue;
            modelsToSave.add(modelClosing);
        }
        return modelsToSave.isEmpty() ? false : this.promptForSaving(modelsToSave, window, canCancel, false);
    }

    private void fillModelsClosing(Set modelsClosing, Map modelsDecrementing) {
        Iterator it = modelsDecrementing.keySet().iterator();
        while (it.hasNext()) {
            Saveable model = (Saveable)it.next();
            if (!modelsDecrementing.get(model).equals(this.modelRefCounts.get(model))) continue;
            modelsClosing.add(model);
        }
    }

    private boolean promptForSaving(List modelsToSave, IWorkbenchWindow window, boolean canCancel, boolean stillOpenElsewhere) {
        List<Object> finalModels;
        IRunnableWithProgress progressOp;
        block7: {
            block8: {
                if (modelsToSave.size() <= 0) break block7;
                if (modelsToSave.size() != 1) break block8;
                Saveable model = (Saveable)modelsToSave.get(0);
                String message = NLS.bind((String)(stillOpenElsewhere ? WorkbenchMessages.EditorManager_saveChangesOptionallyQuestion : WorkbenchMessages.EditorManager_saveChangesQuestion), (Object)model.getName());
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                MessageDialog d = new MessageDialog(window.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, buttons, 0);
                int choice = SaveableHelper.testGetAutomatedResponse();
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    choice = d.open();
                }
                switch (choice) {
                    case 0: {
                        break block7;
                    }
                    case 1: {
                        modelsToSave.clear();
                        break block7;
                    }
                    default: {
                        return true;
                    }
                }
            }
            MyListSelectionDialog dlg = new MyListSelectionDialog(window.getShell(), modelsToSave, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), stillOpenElsewhere ? WorkbenchMessages.EditorManager_saveResourcesOptionallyMessage : WorkbenchMessages.EditorManager_saveResourcesMessage, canCancel);
            dlg.setInitialSelections(modelsToSave.toArray());
            dlg.setTitle(EditorManager.SAVE_RESOURCES_TITLE);
            if (SaveableHelper.testGetAutomatedResponse() == -1) {
                int result = dlg.open();
                if (result == 1) {
                    return true;
                }
                modelsToSave = Arrays.asList(dlg.getResult());
            }
        }
        return !SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, progressOp = new IRunnableWithProgress(finalModels = modelsToSave, window){
            private final /* synthetic */ List val$finalModels;
            private final /* synthetic */ IWorkbenchWindow val$window;
            {
                this.val$finalModels = list;
                this.val$window = iWorkbenchWindow;
            }

            public void run(IProgressMonitor monitor) {
                EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
                monitorWrap.beginTask("", this.val$finalModels.size());
                Iterator i = this.val$finalModels.iterator();
                while (i.hasNext()) {
                    Saveable model = (Saveable)i.next();
                    if (!model.isDirty()) {
                        monitor.worked(1);
                        continue;
                    }
                    try {
                        model.doSave((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitorWrap, 1));
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)this.val$window.getShell(), (String)WorkbenchMessages.Error, (String)e.getMessage(), (IStatus)e.getStatus());
                    }
                    if (monitorWrap.isCanceled()) break;
                }
                monitorWrap.done();
            }
        }, window);
    }

    public void postClose(Object postCloseInfoObject) {
        PostCloseInfo postCloseInfo = (PostCloseInfo)postCloseInfoObject;
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        Iterator it = postCloseInfo.partsClosing.iterator();
        while (it.hasNext()) {
            IWorkbenchPart part = (IWorkbenchPart)it.next();
            Set saveables = (Set)this.modelMap.get(part);
            if (saveables == null) continue;
            Iterator it2 = saveables.iterator();
            while (it2.hasNext()) {
                Saveable saveable = (Saveable)it2.next();
                if (!this.removeModel(part, saveable)) continue;
                removed.add(saveable);
            }
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 3, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private Saveable[] getSaveables(IWorkbenchPart part) {
        if (part instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)((Object)part);
            return source.getSaveables();
        }
        if (part instanceof ISaveablePart) {
            return new Saveable[]{new DefaultSaveable(part)};
        }
        return new Saveable[0];
    }

    public void postOpen(IWorkbenchPart part) {
        this.addModels(part, this.getSaveables(part));
    }

    public void dirtyChanged(IWorkbenchPart part) {
        Saveable[] saveables = this.getSaveables(part);
        if (saveables.length > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 4, saveables, false));
        }
    }

    public Object[] testGetSourcesForModel(Saveable model) {
        ArrayList result = new ArrayList();
        Iterator it = this.modelMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set values = (Set)entry.getValue();
            if (!values.contains(model)) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    private static final class MyListSelectionDialog
    extends ListSelectionDialog {
        private final boolean canCancel;

        private MyListSelectionDialog(Shell shell, Object input, IStructuredContentProvider contentprovider, ILabelProvider labelProvider, String message, boolean canCancel) {
            super(shell, input, contentprovider, labelProvider, message);
            this.canCancel = canCancel;
            if (!canCancel) {
                int shellStyle = this.getShellStyle();
                this.setShellStyle(shellStyle &= 0xFFFFFFBF);
            }
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            if (this.canCancel) {
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }
        }
    }

    private static class PostCloseInfo {
        private List partsClosing = new ArrayList();
        private Map modelsDecrementing = new HashMap();
        private Set modelsClosing = new HashSet();

        private PostCloseInfo() {
        }
    }
}

