/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.debug.FrameworkDebugOptions;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.GenericCapability;
import org.eclipse.osgi.internal.module.GenericConstraint;
import org.eclipse.osgi.internal.module.GroupingChecker;
import org.eclipse.osgi.internal.module.MappedList;
import org.eclipse.osgi.internal.module.PermissionChecker;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;
import org.eclipse.osgi.internal.module.VersionHashMap;
import org.eclipse.osgi.internal.module.VersionSupplier;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class ResolverImpl
implements Resolver {
    private static final String RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_DEBUG = "org.eclipse.osgi/resolver/debug";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_IMPORTS = "org.eclipse.osgi/resolver/imports";
    private static final String OPTION_REQUIRES = "org.eclipse.osgi/resolver/requires";
    private static final String OPTION_GENERICS = "org.eclipse.osgi/resolver/generics";
    private static final String OPTION_GROUPING = "org.eclipse.osgi/resolver/grouping";
    private static final String OPTION_CYCLES = "org.eclipse.osgi/resolver/cycles";
    public static boolean DEBUG = false;
    public static boolean DEBUG_WIRING = false;
    public static boolean DEBUG_IMPORTS = false;
    public static boolean DEBUG_REQUIRES = false;
    public static boolean DEBUG_GENERICS = false;
    public static boolean DEBUG_GROUPING = false;
    public static boolean DEBUG_CYCLES = false;
    private static String[][] CURRENT_EES;
    private State state;
    private PermissionChecker permissionChecker;
    private MappedList removalPending = new MappedList();
    private boolean initialized = false;
    private VersionHashMap resolverExports = null;
    private VersionHashMap resolverBundles = null;
    private VersionHashMap resolverGenerics = null;
    private ArrayList unresolvedBundles = null;
    private HashMap bundleMapping = null;
    private GroupingChecker groupingChecker;
    private Comparator selectionPolicy;

    public ResolverImpl(BundleContext context, boolean checkPermissions) {
        this.permissionChecker = new PermissionChecker(context, checkPermissions, this);
    }

    PermissionChecker getPermissionChecker() {
        return this.permissionChecker;
    }

    private void initialize() {
        this.resolverExports = new VersionHashMap(this);
        this.resolverBundles = new VersionHashMap(this);
        this.resolverGenerics = new VersionHashMap(this);
        this.unresolvedBundles = new ArrayList();
        this.bundleMapping = new HashMap();
        BundleDescription[] bundles = this.state.getBundles();
        this.groupingChecker = new GroupingChecker();
        ArrayList fragmentBundles = new ArrayList();
        int i = 0;
        while (i < bundles.length) {
            this.initResolverBundle(bundles[i], fragmentBundles, false);
            ++i;
        }
        Object[] removedBundles = this.removalPending.getAllValues();
        int i2 = 0;
        while (i2 < removedBundles.length) {
            this.initResolverBundle((BundleDescription)removedBundles[i2], fragmentBundles, true);
            ++i2;
        }
        Iterator iter = fragmentBundles.iterator();
        while (iter.hasNext()) {
            ResolverBundle fragment = (ResolverBundle)iter.next();
            BundleDescription[] hosts = ((HostSpecification)fragment.getHost().getVersionConstraint()).getHosts();
            int i3 = 0;
            while (i3 < hosts.length) {
                ResolverBundle host = (ResolverBundle)this.bundleMapping.get(hosts[i3]);
                if (host != null) {
                    host.attachFragment(fragment, false);
                }
                ++i3;
            }
        }
        this.rewireBundles();
        ResolverBundle[] initBundles = this.bundleMapping.values().toArray(new ResolverBundle[this.bundleMapping.size()]);
        int i4 = 0;
        while (i4 < initBundles.length) {
            if (initBundles[i4].isResolved()) {
                this.groupingChecker.addInitialGroupingConstraints(initBundles[i4]);
            }
            ++i4;
        }
        this.setDebugOptions();
        this.initialized = true;
    }

    private void initResolverBundle(BundleDescription bundleDesc, ArrayList fragmentBundles, boolean pending) {
        ResolverBundle bundle = new ResolverBundle(bundleDesc, this);
        this.bundleMapping.put(bundleDesc, bundle);
        if (!pending || bundleDesc.isResolved()) {
            this.resolverExports.put(bundle.getExportPackages());
            this.resolverBundles.put(bundle.getName(), bundle);
            this.resolverGenerics.put(bundle.getGenericCapabilities());
        }
        if (bundleDesc.isResolved()) {
            bundle.setState(2);
            if (bundleDesc.getHost() != null) {
                fragmentBundles.add(bundle);
            }
        } else if (!pending) {
            this.unresolvedBundles.add(bundle);
        }
    }

    private void rewireBundles() {
        ArrayList visited = new ArrayList(this.bundleMapping.size());
        Iterator iter = this.bundleMapping.values().iterator();
        while (iter.hasNext()) {
            ResolverBundle rb = (ResolverBundle)iter.next();
            if (!rb.getBundle().isResolved() || rb.isFragment()) continue;
            this.rewireBundle(rb, visited);
        }
    }

    private void rewireBundle(ResolverBundle rb, ArrayList visited) {
        if (visited.contains(rb)) {
            return;
        }
        visited.add(rb);
        BundleConstraint[] requires = rb.getRequires();
        int i = 0;
        while (i < requires.length) {
            this.rewireRequire(requires[i], visited);
            ++i;
        }
        ResolverImport[] imports = rb.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            this.rewireImport(imports[i2], visited);
            ++i2;
        }
        GenericConstraint[] genericRequires = rb.getGenericRequires();
        int i3 = 0;
        while (i3 < genericRequires.length) {
            this.rewireGeneric(genericRequires[i3], visited);
            ++i3;
        }
    }

    private void rewireGeneric(GenericConstraint constraint, ArrayList visited) {
        if (constraint.getMatchingCapabilities() != null) {
            return;
        }
        GenericDescription[] suppliers = ((GenericSpecification)constraint.getVersionConstraint()).getSuppliers();
        if (suppliers == null) {
            return;
        }
        Object[] matches = this.resolverGenerics.get(constraint.getName());
        int i = 0;
        while (i < matches.length) {
            GenericCapability match = (GenericCapability)matches[i];
            int j = 0;
            while (j < suppliers.length) {
                if (match.getBaseDescription() == suppliers[j]) {
                    constraint.setMatchingCapability(match);
                }
                ++j;
            }
            ++i;
        }
        GenericCapability[] matchingCapabilities = constraint.getMatchingCapabilities();
        if (matchingCapabilities != null) {
            int i2 = 0;
            while (i2 < matchingCapabilities.length) {
                this.rewireBundle(matchingCapabilities[i2].getResolverBundle(), visited);
                ++i2;
            }
        }
    }

    private void rewireRequire(BundleConstraint req, ArrayList visited) {
        if (req.getMatchingBundle() != null) {
            return;
        }
        ResolverBundle matchingBundle = (ResolverBundle)this.bundleMapping.get(req.getVersionConstraint().getSupplier());
        req.setMatchingBundle(matchingBundle);
        if (matchingBundle == null && !req.isOptional()) {
            System.err.println("Could not find matching bundle for " + req.getVersionConstraint());
        }
        if (matchingBundle != null) {
            this.rewireBundle(matchingBundle, visited);
        }
    }

    private void rewireImport(ResolverImport imp, ArrayList visited) {
        if (imp.isDynamic() || imp.getMatchingExport() != null) {
            return;
        }
        ResolverExport matchingExport = null;
        ExportPackageDescription importSupplier = (ExportPackageDescription)imp.getVersionConstraint().getSupplier();
        ResolverBundle exporter = importSupplier == null ? null : (ResolverBundle)this.bundleMapping.get(importSupplier.getExporter());
        Object[] matches = this.resolverExports.get(imp.getName());
        int j = 0;
        while (j < matches.length) {
            ResolverExport export = (ResolverExport)matches[j];
            if (export.getExporter() == exporter && imp.isSatisfiedBy(export)) {
                matchingExport = export;
                break;
            }
            ++j;
        }
        imp.setMatchingExport(matchingExport);
        if (matchingExport == null && exporter != null) {
            ResolverExport reprovidedExport = new ResolverExport(exporter, importSupplier);
            if (exporter.getExport(imp.getName()) == null) {
                exporter.addExport(reprovidedExport);
                this.resolverExports.put(reprovidedExport.getName(), reprovidedExport);
            }
            imp.setMatchingExport(reprovidedExport);
        }
        if (imp.getMatchingExport() == null && !imp.isOptional()) {
            System.err.println("Could not find matching export for " + imp.getVersionConstraint());
        }
        if (imp.getMatchingExport() != null) {
            this.rewireBundle(imp.getMatchingExport().getExporter(), visited);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isResolvable(BundleDescription bundle, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        String[] ees;
        boolean matchedEE;
        Object[] sameName;
        if (rejectedSingletons.contains(bundle)) {
            return false;
        }
        if (bundle.isSingleton() && (sameName = this.resolverBundles.get(bundle.getName())).length > 1) {
            int i = 0;
            while (i < sameName.length) {
                if (sameName[i] != bundle && ((ResolverBundle)sameName[i]).getBundle().isSingleton() && ((ResolverBundle)sameName[i]).getBundle().isResolved()) {
                    rejectedSingletons.add(bundle);
                    return false;
                }
                ++i;
            }
        }
        boolean bl = matchedEE = (ees = bundle.getExecutionEnvironments()).length == 0;
        if (!matchedEE) {
            int i = 0;
            while (i < CURRENT_EES.length && !matchedEE) {
                int j = 0;
                while (j < CURRENT_EES[i].length && !matchedEE) {
                    int k = 0;
                    while (k < ees.length && !matchedEE) {
                        if (CURRENT_EES[i][j].equals(ees[k])) {
                            ((BundleDescriptionImpl)bundle).setEquinoxEE(i);
                            matchedEE = true;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (!matchedEE) {
            StringBuffer bundleEE = new StringBuffer("Bundle-RequiredExecutionEnvironment".length() + 20);
            bundleEE.append("Bundle-RequiredExecutionEnvironment").append(": ");
            int i = 0;
            while (i < ees.length) {
                if (i > 0) {
                    bundleEE.append(",");
                }
                bundleEE.append(ees[i]);
                ++i;
            }
            this.state.addResolverError(bundle, 16384, bundleEE.toString(), null);
            return false;
        }
        String platformFilter = bundle.getPlatformFilter();
        if (platformFilter == null) {
            return true;
        }
        if (platformProperties == null) {
            return false;
        }
        try {
            Filter filter = FrameworkUtil.createFilter(platformFilter);
            int i = 0;
            while (i < platformProperties.length) {
                if (filter.match(platformProperties[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.state.addResolverError(bundle, 8192, platformFilter, null);
        return false;
    }

    private void attachFragment(ResolverBundle bundle, ArrayList rejectedSingletons) {
        BundleDescription bundleDesc;
        Object[] sameName;
        if (!bundle.isFragment() || !bundle.isResolvable() || rejectedSingletons.contains(bundle.getBundle())) {
            return;
        }
        if (bundle.getBundle().isSingleton() && (sameName = this.resolverBundles.get((bundleDesc = bundle.getBundle()).getName())).length > 1) {
            int j = 0;
            while (j < sameName.length) {
                BundleDescription sameNameDesc = ((ResolverBundle)sameName[j]).getBundle();
                if (sameName[j] != bundle && sameNameDesc.isSingleton() && !rejectedSingletons.contains(sameNameDesc)) {
                    boolean rejectedPolicy;
                    if (this.selectionPolicy == null) {
                        rejectedPolicy = sameNameDesc.isResolved() || sameNameDesc.getVersion().compareTo(bundle.getBundle().getVersion()) > 0;
                    } else {
                        boolean bl = rejectedPolicy = this.selectionPolicy.compare(sameNameDesc, bundle.getBundle()) < 0;
                    }
                    if (rejectedPolicy) {
                        rejectedSingletons.add(bundle.getBundle());
                        return;
                    }
                    rejectedSingletons.add(sameNameDesc);
                }
                ++j;
            }
        }
        BundleConstraint hostConstraint = bundle.getHost();
        Object[] hosts = this.resolverBundles.get(hostConstraint.getVersionConstraint().getName());
        int i = 0;
        while (i < hosts.length) {
            if (((ResolverBundle)hosts[i]).isResolvable() && hostConstraint.isSatisfiedBy((ResolverBundle)hosts[i])) {
                this.resolverExports.put(((ResolverBundle)hosts[i]).attachFragment(bundle, true));
            }
            ++i;
        }
    }

    public synchronized void resolve(BundleDescription[] reRefresh, Dictionary[] platformProperties) {
        if (DEBUG) {
            ResolverImpl.log("*** BEGIN RESOLUTION ***");
        }
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if (reRefresh != null) {
            int i = 0;
            while (i < reRefresh.length) {
                ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(reRefresh[i]);
                if (rb != null) {
                    this.unresolveBundle(rb, false);
                }
                ++i;
            }
        }
        this.resolverExports.reorder();
        this.resolverBundles.reorder();
        this.resolverGenerics.reorder();
        this.getCurrentEEs(platformProperties);
        ArrayList rejectedSingletons = new ArrayList();
        boolean resolveOptional = platformProperties.length == 0 ? false : "true".equals(platformProperties[0].get("osgi.resolveOptional"));
        ResolverBundle[] currentlyResolved = null;
        if (resolveOptional) {
            BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
            currentlyResolved = new ResolverBundle[resolvedBundles.length];
            int i = 0;
            while (i < resolvedBundles.length) {
                currentlyResolved[i] = (ResolverBundle)this.bundleMapping.get(resolvedBundles[i]);
                ++i;
            }
        }
        ResolverBundle[] bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
        this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        if (this.selectSingletons(bundles, rejectedSingletons)) {
            bundles = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            this.resolveBundles(bundles, platformProperties, rejectedSingletons);
        }
        Iterator rejected = rejectedSingletons.iterator();
        while (rejected.hasNext()) {
            BundleDescription reject = (BundleDescription)rejected.next();
            BundleDescription sameName = this.state.getBundle(reject.getSymbolicName(), null);
            this.state.addResolverError(reject, 8, sameName.toString(), null);
        }
        if (resolveOptional) {
            this.resolveOptionalConstraints(currentlyResolved);
        }
        if (DEBUG) {
            ResolverImpl.log("*** END RESOLUTION ***");
        }
    }

    private void resolveOptionalConstraints(ResolverBundle[] bundles) {
        int i = 0;
        while (i < bundles.length) {
            if (bundles[i] != null) {
                this.resolveOptionalConstraints(bundles[i]);
            }
            ++i;
        }
    }

    private void resolveOptionalConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        ArrayList cycle = new ArrayList();
        boolean resolvedOptional = false;
        int i = 0;
        while (i < requires.length) {
            if (requires[i].isOptional() && requires[i].getMatchingBundle() == null) {
                cycle.clear();
                this.resolveRequire(requires[i], cycle);
                if (requires[i].getMatchingBundle() != null) {
                    resolvedOptional = true;
                }
            }
            ++i;
        }
        ResolverImport[] imports = bundle.getImportPackages();
        int i2 = 0;
        while (i2 < imports.length) {
            if (imports[i2].isOptional() && imports[i2].getMatchingExport() == null) {
                cycle.clear();
                this.resolveImport(imports[i2], true, cycle);
                if (imports[i2].getMatchingExport() != null) {
                    resolvedOptional = true;
                }
            }
            ++i2;
        }
        if (resolvedOptional) {
            this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null);
            this.stateResolveConstraints(bundle);
            this.stateResolveBundle(bundle);
        }
    }

    private void getCurrentEEs(Dictionary[] platformProperties) {
        CURRENT_EES = new String[platformProperties.length][];
        int i = 0;
        while (i < platformProperties.length) {
            String eeSpecs = (String)platformProperties[i].get("org.osgi.framework.executionenvironment");
            ResolverImpl.CURRENT_EES[i] = ManifestElement.getArrayFromList(eeSpecs, ",");
            ++i;
        }
    }

    private void resolveBundles(ResolverBundle[] bundles, Dictionary[] platformProperties, ArrayList rejectedSingletons) {
        int i = 0;
        while (i < bundles.length) {
            this.state.removeResolverErrors(bundles[i].getBundle());
            bundles[i].setResolvable(this.isResolvable(bundles[i].getBundle(), platformProperties, rejectedSingletons));
            bundles[i].clearRefs();
            this.groupingChecker.removeAllExportConstraints(bundles[i]);
            ++i;
        }
        i = 0;
        while (i < bundles.length) {
            this.attachFragment(bundles[i], rejectedSingletons);
            ++i;
        }
        i = 0;
        while (i < bundles.length) {
            this.groupingChecker.addInitialGroupingConstraints(bundles[i]);
            ++i;
        }
        ArrayList cycle = new ArrayList(1);
        ArrayList<ResolverBundle> resolvedBundles = new ArrayList<ResolverBundle>(bundles.length);
        int i2 = 0;
        while (i2 < bundles.length) {
            if (DEBUG) {
                ResolverImpl.log("** RESOLVING " + bundles[i2] + " **");
            }
            cycle.clear();
            this.resolveBundle(bundles[i2], cycle);
            this.checkCycle(cycle);
            if (bundles[i2].isResolvable()) {
                resolvedBundles.add(bundles[i2]);
            }
            ++i2;
        }
        if (this.unresolvedBundles.size() > 0) {
            ResolverBundle[] unresolved = this.unresolvedBundles.toArray(new ResolverBundle[this.unresolvedBundles.size()]);
            int i3 = 0;
            while (i3 < unresolved.length) {
                this.resolveFragment(unresolved[i3]);
                ++i3;
            }
        }
        if (DEBUG_WIRING) {
            this.printWirings();
        }
        this.stateResolveBundles(bundles);
    }

    private void checkCycle(ArrayList cycle) {
        int cycleSize = cycle.size();
        if (cycleSize == 0) {
            return;
        }
        int i = cycleSize - 1;
        while (i >= 0) {
            ResolverBundle cycleBundle = (ResolverBundle)cycle.get(i);
            this.groupingChecker.removeAllExportConstraints(cycleBundle);
            this.groupingChecker.addInitialGroupingConstraints(cycleBundle);
            if (!cycleBundle.isResolvable()) {
                cycle.remove(i);
            }
            --i;
        }
        boolean reresolveCycle = cycle.size() != cycleSize || !this.isCycleConsistent(cycle);
        int i2 = 0;
        while (i2 < cycle.size()) {
            ResolverBundle rb = (ResolverBundle)cycle.get(0);
            ResolverImport[] imports = rb.getImportPackages();
            int j = 0;
            while (j < imports.length) {
                if (imports[j].getMatchingExport() != null && imports[j].getMatchingExport().isDropped()) {
                    imports[j].addUnresolvableWiring(imports[j].getMatchingExport().getExporter());
                    reresolveCycle = true;
                }
                ++j;
            }
            ++i2;
        }
        if (reresolveCycle) {
            i2 = 0;
            while (i2 < cycle.size()) {
                ResolverBundle cycleBundle = (ResolverBundle)cycle.get(i2);
                this.groupingChecker.removeAllExportConstraints(cycleBundle);
                this.groupingChecker.addInitialGroupingConstraints(cycleBundle);
                cycleBundle.clearWires(false);
                cycleBundle.clearRefs();
                ++i2;
            }
            this.groupingChecker.setCheckCycles(true);
            ArrayList innerCycle = new ArrayList(cycle.size());
            int i3 = 0;
            while (i3 < cycle.size()) {
                this.resolveBundle((ResolverBundle)cycle.get(i3), innerCycle);
                ++i3;
            }
            this.groupingChecker.setCheckCycles(false);
            this.checkCycle(innerCycle);
        } else {
            i2 = 0;
            while (i2 < cycle.size()) {
                if (DEBUG || DEBUG_CYCLES) {
                    ResolverImpl.log("Pushing " + cycle.get(i2) + " to RESOLVED");
                }
                this.setBundleResolved((ResolverBundle)cycle.get(i2));
                ++i2;
            }
        }
    }

    private boolean isCycleConsistent(ArrayList cycle) {
        Iterator iter = cycle.iterator();
        while (iter.hasNext()) {
            ResolverBundle bundle = (ResolverBundle)iter.next();
            BundleConstraint[] requires = bundle.getRequires();
            int i = 0;
            while (i < requires.length) {
                if (requires[i].getMatchingBundle() != null && this.groupingChecker.isConsistent(requires[i], requires[i].getMatchingBundle()) != null) {
                    return false;
                }
                ++i;
            }
            ResolverImport[] imports = bundle.getImportPackages();
            int i2 = 0;
            while (i2 < imports.length) {
                if (imports[i2].getMatchingExport() != null && this.groupingChecker.isConsistent(imports[i2], imports[i2].getMatchingExport()) != null) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    private boolean selectSingletons(ResolverBundle[] bundles, ArrayList rejectedSingletons) {
        boolean result = false;
        int i = 0;
        while (i < bundles.length) {
            Object[] sameName;
            BundleDescription bundleDesc = bundles[i].getBundle();
            if (bundleDesc.isSingleton() && bundleDesc.isResolved() && !rejectedSingletons.contains(bundleDesc) && (sameName = this.resolverBundles.get(bundleDesc.getName())).length > 1) {
                int j = 0;
                while (j < sameName.length) {
                    BundleDescription sameNameDesc = ((VersionSupplier)sameName[j]).getBundle();
                    ResolverBundle sameNameBundle = (ResolverBundle)sameName[j];
                    if (sameName[j] != bundles[i] && sameNameDesc.isSingleton() && sameNameDesc.isResolved() && !rejectedSingletons.contains(sameNameDesc)) {
                        boolean rejectedPolicy;
                        result = true;
                        boolean bl = this.selectionPolicy != null ? this.selectionPolicy.compare(sameNameDesc, bundleDesc) < 0 : (rejectedPolicy = sameNameDesc.getVersion().compareTo(bundleDesc.getVersion()) > 0);
                        if (rejectedPolicy && sameNameBundle.getRefs() >= bundles[i].getRefs()) {
                            if (rejectedSingletons.contains(bundles[i].getBundle())) break;
                            rejectedSingletons.add(bundles[i].getBundle());
                            break;
                        }
                        if (!rejectedSingletons.contains(sameNameDesc)) {
                            rejectedSingletons.add(sameNameDesc);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Iterator rejects = rejectedSingletons.iterator();
        while (rejects.hasNext()) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(rejects.next()), false);
        }
        return result;
    }

    private void resolveFragment(ResolverBundle fragment) {
        if (!fragment.isFragment()) {
            return;
        }
        if (fragment.getHost().foundMatchingBundles()) {
            this.stateResolveFragConstraints(fragment);
            this.setBundleResolved(fragment);
        } else {
            this.state.addResolverError(fragment.getBundle(), 4, fragment.getHost().getVersionConstraint().toString(), fragment.getHost().getVersionConstraint());
        }
    }

    private boolean resolveBundle(ResolverBundle bundle, ArrayList cycle) {
        int i;
        boolean failed;
        if (bundle.isFragment()) {
            return false;
        }
        if (!bundle.isResolvable()) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " is unresolvable");
            }
            return false;
        }
        if (bundle.getState() == 2) {
            if (DEBUG) {
                ResolverImpl.log("  - " + bundle + " already resolved");
            }
            return true;
        }
        if (bundle.getState() == 0) {
            bundle.clearWires(true);
            this.setBundleResolving(bundle);
        }
        if (!(failed = false)) {
            GenericConstraint[] genericRequires = bundle.getGenericRequires();
            i = 0;
            while (i < genericRequires.length) {
                if (!this.resolveGenericReq(genericRequires[i], cycle)) {
                    if (DEBUG || DEBUG_GENERICS) {
                        ResolverImpl.log("** GENERICS " + genericRequires[i].getVersionConstraint().getName() + "[" + genericRequires[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(genericRequires[i].getVersionConstraint().getBundle(), 32768, genericRequires[i].getVersionConstraint().toString(), genericRequires[i].getVersionConstraint());
                    if (genericRequires[i].isFromFragment()) {
                        this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(genericRequires[i].getVersionConstraint().getBundle()), null));
                    } else {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            BundleConstraint[] requires = bundle.getRequires();
            i = 0;
            while (i < requires.length) {
                if (!this.resolveRequire(requires[i], cycle)) {
                    if (DEBUG || DEBUG_REQUIRES) {
                        ResolverImpl.log("** REQUIRE " + requires[i].getVersionConstraint().getName() + "[" + requires[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(requires[i].getVersionConstraint().getBundle(), 2, requires[i].getVersionConstraint().toString(), requires[i].getVersionConstraint());
                    if (requires[i].isFromFragment()) {
                        this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(requires[i].getVersionConstraint().getBundle()), requires[i]));
                    } else {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (!failed) {
            ResolverImport[] imports = bundle.getImportPackages();
            i = 0;
            while (i < imports.length) {
                if (!imports[i].isDynamic() && !this.resolveImport(imports[i], true, cycle)) {
                    if (DEBUG || DEBUG_IMPORTS) {
                        ResolverImpl.log("** IMPORT " + imports[i].getName() + "[" + imports[i].getBundleDescription() + "] failed to resolve");
                    }
                    this.state.addResolverError(imports[i].getVersionConstraint().getBundle(), 1, imports[i].getVersionConstraint().toString(), imports[i].getVersionConstraint());
                    if (imports[i].isFromFragment()) {
                        this.resolverExports.remove(bundle.detachFragment((ResolverBundle)this.bundleMapping.get(imports[i].getBundleDescription()), imports[i]));
                    } else {
                        failed = true;
                        break;
                    }
                }
                ++i;
            }
        }
        if (failed) {
            this.setBundleUnresolved(bundle, false);
            if (DEBUG) {
                ResolverImpl.log(bundle + " NOT RESOLVED");
            }
        } else if (!cycle.contains(bundle)) {
            this.setBundleResolved(bundle);
            if (DEBUG) {
                ResolverImpl.log(bundle + " RESOLVED");
            }
        }
        if (bundle.getState() == 0) {
            bundle.setResolvable(false);
        }
        this.stateResolveConstraints(bundle);
        return bundle.getState() != 0;
    }

    private boolean resolveGenericReq(GenericConstraint constraint, ArrayList cycle) {
        GenericCapability[] matchingCapabilities;
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + constraint.getBundle() + ", " + constraint.getVersionConstraint());
        }
        if ((matchingCapabilities = constraint.getMatchingCapabilities()) != null) {
            int i = 0;
            while (i < matchingCapabilities.length) {
                if (matchingCapabilities[i].getResolverBundle().getState() == 1 && !cycle.contains(constraint.getBundle())) {
                    cycle.add(constraint.getBundle());
                }
                ++i;
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] capabilities = this.resolverGenerics.get(constraint.getVersionConstraint().getName());
        boolean result = false;
        int i = 0;
        while (i < capabilities.length) {
            GenericCapability capability = (GenericCapability)capabilities[i];
            if (DEBUG_GENERICS) {
                ResolverImpl.log("CHECKING GENERICS: " + capability.getBaseDescription());
            }
            if (constraint.isSatisfiedBy(capability)) {
                capability.getResolverBundle().addRef(constraint.getBundle());
                if (!result || (((GenericSpecification)constraint.getVersionConstraint()).getResolution() & 2) != 0) {
                    constraint.setMatchingCapability(capability);
                    if (constraint.getBundle() == capability.getResolverBundle()) {
                        result = true;
                    } else {
                        ResolverBundle[] resolverBundleArray;
                        if (capability.isFromFragment()) {
                            resolverBundleArray = capability.getResolverBundle().getHost().getMatchingBundles();
                        } else {
                            ResolverBundle[] resolverBundleArray2 = new ResolverBundle[1];
                            resolverBundleArray = resolverBundleArray2;
                            resolverBundleArray2[0] = capability.getResolverBundle();
                        }
                        ResolverBundle[] capabilityHosts = resolverBundleArray;
                        boolean foundResolvedMatch = false;
                        int j = 0;
                        while (capabilityHosts != null && j < capabilityHosts.length) {
                            if (capabilityHosts[j].getState() == 2 || this.resolveBundle(capabilityHosts[j], cycle)) {
                                foundResolvedMatch |= !capability.isFromFragment() ? true : capability.getResolverBundle().getHost().getMatchingBundles() != null;
                                if (capabilityHosts[j].getState() == 1 && !cycle.contains(capabilityHosts[j])) {
                                    cycle.add(capabilityHosts[j]);
                                }
                            }
                            ++j;
                        }
                        if (!foundResolvedMatch) {
                            constraint.removeMatchingCapability(capability);
                        } else {
                            if (DEBUG_GENERICS) {
                                ResolverImpl.log("Found match: " + capability.getBaseDescription() + ". Wiring");
                            }
                            result = true;
                        }
                    }
                }
            }
            ++i;
        }
        return result ? true : (((GenericSpecification)constraint.getVersionConstraint()).getResolution() & 1) != 0;
    }

    private boolean resolveRequire(BundleConstraint req, ArrayList cycle) {
        if (DEBUG_REQUIRES) {
            ResolverImpl.log("Trying to resolve: " + req.getBundle() + ", " + req.getVersionConstraint());
        }
        if (req.getMatchingBundle() != null) {
            if (req.getMatchingBundle().getState() == 1 && !cycle.contains(req.getBundle())) {
                cycle.add(req.getBundle());
                if (DEBUG_CYCLES) {
                    ResolverImpl.log("require-bundle cycle: " + req.getBundle() + " -> " + req.getMatchingBundle());
                }
            }
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        Object[] bundles = this.resolverBundles.get(req.getVersionConstraint().getName());
        boolean result = false;
        int i = 0;
        while (i < bundles.length) {
            ResolverBundle bundle = (ResolverBundle)bundles[i];
            if (DEBUG_REQUIRES) {
                ResolverImpl.log("CHECKING: " + bundle.getBundle());
            }
            if (req.isSatisfiedBy(bundle)) {
                bundle.addRef(req.getBundle());
                if (!result) {
                    req.setMatchingBundle(bundle);
                    if (req.getBundle() == bundle) {
                        result = true;
                    } else if (bundle.getState() != 2 && !this.resolveBundle(bundle, cycle)) {
                        req.setMatchingBundle(null);
                    } else {
                        if (bundle.getState() == 1 && !cycle.contains(req.getBundle())) {
                            cycle.add(req.getBundle());
                            if (DEBUG_CYCLES) {
                                ResolverImpl.log("require-bundle cycle: " + req.getBundle() + " -> " + req.getMatchingBundle());
                            }
                        }
                        if (DEBUG_REQUIRES) {
                            ResolverImpl.log("Found match: " + bundle.getBundle() + ". Wiring");
                        }
                        result = this.checkRequiresConstraints(req, req.getMatchingBundle());
                    }
                }
            }
            ++i;
        }
        return result || req.isOptional();
    }

    private boolean checkRequiresConstraints(BundleConstraint req, ResolverBundle bundle) {
        if (this.groupingChecker.isConsistent(req, bundle) != null) {
            req.setMatchingBundle(null);
            this.state.addResolverError(req.getBundleDescription(), 64, bundle.getBundle().toString(), req.getVersionConstraint());
            return req.isOptional();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean resolveImport(ResolverImport imp, boolean checkReexportsFromRequires, ArrayList cycle) {
        if (ResolverImpl.DEBUG_IMPORTS) {
            ResolverImpl.log("Trying to resolve: " + imp.getBundle() + ", " + imp.getName());
        }
        if (imp.getMatchingExport() != null) {
            if (imp.getMatchingExport().getExporter().getState() == 1 && !cycle.contains(imp.getBundle())) {
                cycle.add(imp.getBundle());
                if (ResolverImpl.DEBUG_CYCLES) {
                    ResolverImpl.log("import-package cycle: " + imp.getBundle() + " -> " + imp.getMatchingExport() + " from " + imp.getMatchingExport().getBundle());
                }
            }
            if (ResolverImpl.DEBUG_IMPORTS) {
                ResolverImpl.log("  - already wired");
            }
            return true;
        }
        result = false;
        exports = this.resolverExports.get(imp.getName());
        i = 0;
        while (i < exports.length) {
            block25: {
                export = (ResolverExport)exports[i];
                if (ResolverImpl.DEBUG_IMPORTS) {
                    ResolverImpl.log("CHECKING: " + export.getExporter().getBundle() + ", " + export.getName());
                }
                if (!imp.isSatisfiedBy(export) || !imp.isNotAnUnresolvableWiring(export)) break block25;
                originalState = export.getExporter().getState();
                if (imp.isDynamic() && originalState != 2 || imp.getBundle() == export.getExporter() && !export.getExportPackageDescription().isRoot()) break block25;
                export.getExporter().addRef(imp.getBundle());
                if (result) break block25;
                imp.setMatchingExport(export);
                if (imp.getBundle() == export.getExporter()) ** GOTO lbl-1000
                exps = imp.getBundle().getExports(imp.getName());
                j = 0;
                while (j < exps.length) {
                    if (!exps[j].getExportPackageDescription().isRoot() || export.getExportPackageDescription().isRoot()) {
                        if (exps[j].getExportPackageDescription().isRoot()) {
                            this.resolverExports.remove(exps[j]);
                        }
                        ++j;
                        continue;
                    }
                    break block25;
                }
                if (originalState != 2 && !this.resolveBundle(export.getExporter(), cycle) || export.isDropped()) {
                    if (imp.getMatchingExport() != null && imp.getMatchingExport() != export) {
                        return true;
                    }
                    j = 0;
                    while (j < exps.length) {
                        this.resolverExports.put(exps[j].getName(), exps[j]);
                        ++j;
                    }
                    imp.setMatchingExport(null);
                } else lbl-1000:
                // 2 sources

                {
                    if (!imp.getBundle().isResolvable()) {
                        return false;
                    }
                    if (this.checkImportConstraints(imp, imp.getMatchingExport(), cycle) && imp.getMatchingExport() != null) {
                        if (export != imp.getMatchingExport()) {
                            export = imp.getMatchingExport();
                        }
                        if (imp.getBundle() != export.getExporter() && export.getExporter().getState() == 1 && !cycle.contains(imp.getBundle())) {
                            cycle.add(imp.getBundle());
                            if (ResolverImpl.DEBUG_CYCLES) {
                                ResolverImpl.log("import-package cycle: " + imp.getBundle() + " -> " + imp.getMatchingExport() + " from " + imp.getMatchingExport().getBundle());
                            }
                        }
                        if (ResolverImpl.DEBUG_IMPORTS) {
                            ResolverImpl.log("Found match: " + export.getExporter() + ". Wiring " + imp.getBundle() + ":" + imp.getName());
                        }
                        result = true;
                    } else if (!imp.getBundle().isResolvable()) {
                        return false;
                    }
                    if (!result && imp.getMatchingExport() != null && imp.getMatchingExport() != export) {
                        return true;
                    }
                }
            }
            ++i;
        }
        if (result) {
            return true;
        }
        if (checkReexportsFromRequires && this.resolveImportReprovide(imp, cycle)) {
            return true;
        }
        return imp.isOptional() != false;
    }

    private boolean resolveImportReprovide(ResolverImport imp, ArrayList cycle) {
        String bsn = ((ImportPackageSpecification)imp.getVersionConstraint()).getBundleSymbolicName();
        if (bsn == null) {
            return false;
        }
        if (DEBUG_IMPORTS) {
            ResolverImpl.log("Checking reprovides: " + imp.getName());
        }
        Object[] bundles = this.resolverBundles.get(bsn);
        int i = 0;
        while (i < bundles.length) {
            if (this.resolveBundle((ResolverBundle)bundles[i], cycle) && this.resolveImportReprovide0(imp, (ResolverBundle)bundles[i], (ResolverBundle)bundles[i], cycle, new ArrayList(5))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean resolveImportReprovide0(ResolverImport imp, ResolverBundle reexporter, ResolverBundle rb, ArrayList cycle, ArrayList visited) {
        if (visited.contains(rb)) {
            return false;
        }
        visited.add(rb);
        BundleConstraint[] requires = rb.getRequires();
        int i = 0;
        while (i < requires.length) {
            if (((BundleSpecification)requires[i].getVersionConstraint()).isExported() && requires[i].getMatchingBundle() != null) {
                ResolverExport[] exports = requires[i].getMatchingBundle().getExports(imp.getName());
                int j = 0;
                while (j < exports.length) {
                    Map directives = exports[j].getExportPackageDescription().getDirectives();
                    directives.remove("uses");
                    ExportPackageDescription epd = this.state.getFactory().createExportPackageDescription(exports[j].getName(), exports[j].getVersion(), directives, exports[j].getExportPackageDescription().getAttributes(), false, reexporter.getBundle());
                    if (imp.getVersionConstraint().isSatisfiedBy(epd)) {
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log(" - Creating re-export for reprovide: " + reexporter + ":" + epd.getName());
                        }
                        ResolverExport re = new ResolverExport(reexporter, epd);
                        reexporter.addExport(re);
                        this.resolverExports.put(re.getName(), re);
                        if (this.resolveImport(imp, false, cycle)) {
                            return true;
                        }
                    }
                    ++j;
                }
                if (this.resolveImportReprovide0(imp, reexporter, requires[i].getMatchingBundle(), cycle, visited)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean checkImportConstraints(ResolverImport imp, ResolverExport exp, ArrayList cycle) {
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  Checking grouping for " + imp.getBundle() + ":" + imp.getName() + " -> " + exp.getExporter() + ":" + exp.getName());
        }
        ResolverBundle importer = imp.getBundle();
        ResolverExport clash = this.groupingChecker.isConsistent(imp, exp);
        if (clash == null) {
            return true;
        }
        if (DEBUG_GROUPING) {
            ResolverImpl.log("  * grouping clash with " + clash.getExporter() + ":" + clash.getName());
        }
        imp.addUnresolvableWiring(exp.getExporter());
        imp.setMatchingExport(null);
        if (this.resolveImport(imp, false, cycle)) {
            return true;
        }
        if (imp.isDynamic()) {
            return false;
        }
        imp.clearUnresolvableWirings();
        imp.setMatchingExport(exp);
        ResolverImport[] imports = importer.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getMatchingExport() != null && imports[i].getMatchingExport().getName().equals(clash.getName())) {
                imports[i].addUnresolvableWiring(imports[i].getMatchingExport().getExporter());
                imports[i].setMatchingExport(null);
                VersionSupplier[] removed = importer.getExports(imports[i].getName());
                this.resolverExports.put(removed);
            }
            ++i;
        }
        if (this.resolveBundle(importer, cycle)) {
            return true;
        }
        this.state.addResolverError(imp.getVersionConstraint().getBundle(), 32, imp.getVersionConstraint().toString(), imp.getVersionConstraint());
        return false;
    }

    private void setBundleUnresolved(ResolverBundle bundle, boolean removed) {
        if (bundle.getState() == 0) {
            return;
        }
        if (bundle.getBundle().isResolved()) {
            this.resolverExports.remove(bundle.getExportPackages());
            bundle.initialize(false);
            if (!removed) {
                this.resolverExports.put(bundle.getExportPackages());
            }
        }
        if (!removed) {
            this.unresolvedBundles.add(bundle);
        }
        bundle.detachAllFragments();
        bundle.setState(0);
    }

    private void setBundleResolved(ResolverBundle bundle) {
        if (bundle.getState() == 2) {
            return;
        }
        this.unresolvedBundles.remove(bundle);
        bundle.setState(2);
    }

    private void setBundleResolving(ResolverBundle bundle) {
        if (bundle.getState() == 1) {
            return;
        }
        this.unresolvedBundles.remove(bundle);
        bundle.setState(1);
    }

    private void stateResolveBundles(ResolverBundle[] resolvedBundles) {
        int i = 0;
        while (i < resolvedBundles.length) {
            if (resolvedBundles[i].isResolved() && !resolvedBundles[i].getBundle().isResolved()) {
                this.stateResolveBundle(resolvedBundles[i]);
            }
            ++i;
        }
    }

    private void stateResolveConstraints(ResolverBundle rb) {
        ResolverImport[] imports = rb.getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverExport export = imports[i].getMatchingExport();
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i].getVersionConstraint(), supplier);
            ++i;
        }
        BundleConstraint[] requires = rb.getRequires();
        int i2 = 0;
        while (i2 < requires.length) {
            ResolverBundle bundle = requires[i2].getMatchingBundle();
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i2].getVersionConstraint(), supplier);
            ++i2;
        }
        GenericConstraint[] genericRequires = rb.getGenericRequires();
        int i3 = 0;
        while (i3 < genericRequires.length) {
            GenericCapability[] matchingCapabilities = genericRequires[i3].getMatchingCapabilities();
            if (matchingCapabilities == null) {
                this.state.resolveConstraint(genericRequires[i3].getVersionConstraint(), null);
            } else {
                int j = 0;
                while (j < matchingCapabilities.length) {
                    this.state.resolveConstraint(genericRequires[i3].getVersionConstraint(), matchingCapabilities[j].getBaseDescription());
                    ++j;
                }
            }
            ++i3;
        }
    }

    private void stateResolveFragConstraints(ResolverBundle rb) {
        ResolverBundle host = rb.getHost().getMatchingBundle();
        ImportPackageSpecification[] imports = rb.getBundle().getImportPackages();
        int i = 0;
        while (i < imports.length) {
            ResolverImport hostImport = host.getImport(imports[i].getName());
            ResolverExport export = hostImport == null ? null : hostImport.getMatchingExport();
            ExportPackageDescription supplier = export == null ? null : export.getExportPackageDescription();
            this.state.resolveConstraint(imports[i], supplier);
            ++i;
        }
        BundleSpecification[] requires = rb.getBundle().getRequiredBundles();
        int i2 = 0;
        while (i2 < requires.length) {
            BundleConstraint hostRequire = host.getRequire(requires[i2].getName());
            ResolverBundle bundle = hostRequire == null ? null : hostRequire.getMatchingBundle();
            BundleDescription supplier = bundle == null ? null : bundle.getBundle();
            this.state.resolveConstraint(requires[i2], supplier);
            ++i2;
        }
    }

    private void stateResolveBundle(ResolverBundle rb) {
        ResolverBundle[] matchingBundles;
        ResolverExport[] exports = rb.getSelectedExports();
        ArrayList<ExportPackageDescription> selectedExports = new ArrayList<ExportPackageDescription>(exports.length);
        int i = 0;
        while (i < exports.length) {
            selectedExports.add(exports[i].getExportPackageDescription());
            ++i;
        }
        ExportPackageDescription[] selectedExportsArray = selectedExports.toArray(new ExportPackageDescription[selectedExports.size()]);
        ResolverImport[] imports = rb.getImportPackages();
        ArrayList<ExportPackageDescription> exportsWiredTo = new ArrayList<ExportPackageDescription>(imports.length);
        int i2 = 0;
        while (i2 < imports.length) {
            if (imports[i2].getMatchingExport() != null) {
                exportsWiredTo.add(imports[i2].getMatchingExport().getExportPackageDescription());
            }
            ++i2;
        }
        ExportPackageDescription[] exportsWiredToArray = exportsWiredTo.toArray(new ExportPackageDescription[exportsWiredTo.size()]);
        BundleConstraint[] requires = rb.getRequires();
        ArrayList<BundleDescription> bundlesWiredTo = new ArrayList<BundleDescription>(requires.length);
        int i3 = 0;
        while (i3 < requires.length) {
            if (requires[i3].getMatchingBundle() != null) {
                bundlesWiredTo.add(requires[i3].getMatchingBundle().getBundle());
            }
            ++i3;
        }
        BundleDescription[] bundlesWiredToArray = bundlesWiredTo.toArray(new BundleDescription[bundlesWiredTo.size()]);
        BundleDescription[] hostBundles = null;
        if (rb.isFragment() && (matchingBundles = rb.getHost().getMatchingBundles()) != null && matchingBundles.length > 0) {
            hostBundles = new BundleDescription[matchingBundles.length];
            int i4 = 0;
            while (i4 < matchingBundles.length) {
                hostBundles[i4] = matchingBundles[i4].getBundle();
                if (rb.isNewFragmentExports()) {
                    ResolverExport[] hostExports = matchingBundles[i4].getSelectedExports();
                    ExportPackageDescription[] hostExportsArray = new ExportPackageDescription[hostExports.length];
                    int j = 0;
                    while (j < hostExports.length) {
                        hostExportsArray[j] = hostExports[j].getExportPackageDescription();
                        ++j;
                    }
                    this.state.resolveBundle(hostBundles[i4], true, null, hostExportsArray, hostBundles[i4].getResolvedRequires(), hostBundles[i4].getResolvedImports());
                }
                ++i4;
            }
        }
        this.state.resolveBundle(rb.getBundle(), true, hostBundles, selectedExportsArray, bundlesWiredToArray, exportsWiredToArray);
    }

    public synchronized ExportPackageDescription resolveDynamicImport(BundleDescription importingBundle, String requestedPackage) {
        ResolverBundle rb;
        if (this.state == null) {
            throw new IllegalStateException("RESOLVER_NO_STATE");
        }
        if (!this.initialized) {
            this.initialize();
        }
        if ((rb = (ResolverBundle)this.bundleMapping.get(importingBundle)).getExport(requestedPackage) != null) {
            return null;
        }
        ResolverImport[] resolverImports = rb.getImportPackages();
        boolean found = false;
        int j = 0;
        while (j < resolverImports.length) {
            if (resolverImports[j].isDynamic()) {
                String importName = resolverImports[j].getName();
                if (importName.equals("*") || importName.endsWith(".*") && requestedPackage.startsWith(importName.substring(0, importName.length() - 2))) {
                    resolverImports[j].setName(requestedPackage);
                }
                if (requestedPackage.equals(resolverImports[j].getName())) {
                    found = true;
                    if (this.resolveImport(resolverImports[j], true, new ArrayList())) {
                        resolverImports[j].setName(null);
                        if (DEBUG_IMPORTS) {
                            ResolverImpl.log("Resolved dynamic import: " + rb + ":" + resolverImports[j].getName() + " -> " + resolverImports[j].getMatchingExport().getExporter() + ":" + requestedPackage);
                        }
                        ExportPackageDescription matchingExport = resolverImports[j].getMatchingExport().getExportPackageDescription();
                        if (importName.endsWith("*")) {
                            resolverImports[j].setMatchingExport(null);
                        }
                        return matchingExport;
                    }
                }
                resolverImports[j].setName(null);
            }
            ++j;
        }
        if (!found) {
            HashMap<String, String> directives = new HashMap<String, String>(1);
            directives.put("resolution", "dynamic");
            ImportPackageSpecification packageSpec = this.state.getFactory().createImportPackageSpecification(requestedPackage, null, null, null, directives, null, importingBundle);
            ResolverImport newImport = new ResolverImport(rb, packageSpec);
            if (this.resolveImport(newImport, true, new ArrayList())) {
                return newImport.getMatchingExport().getExportPackageDescription();
            }
        }
        if (DEBUG || DEBUG_IMPORTS) {
            ResolverImpl.log("Failed to resolve dynamic import: " + requestedPackage);
        }
        return null;
    }

    public void bundleAdded(BundleDescription bundle) {
        if (!this.initialized) {
            return;
        }
        boolean alreadyThere = false;
        int i = 0;
        while (i < this.unresolvedBundles.size()) {
            ResolverBundle rb = (ResolverBundle)this.unresolvedBundles.get(i);
            if (rb.getBundle() == bundle) {
                alreadyThere = true;
            }
            ++i;
        }
        if (!alreadyThere) {
            ResolverBundle rb = new ResolverBundle(bundle, this);
            this.bundleMapping.put(bundle, rb);
            this.unresolvedBundles.add(rb);
            this.resolverExports.put(rb.getExportPackages());
            this.resolverBundles.put(rb.getName(), rb);
            this.resolverGenerics.put(rb.getGenericCapabilities());
        }
    }

    public void bundleRemoved(BundleDescription bundle, boolean pending) {
        if (pending) {
            this.removalPending.put(new Long(bundle.getBundleId()), bundle);
        }
        if (!this.initialized) {
            return;
        }
        ResolverBundle rb = (ResolverBundle)this.bundleMapping.get(bundle);
        if (rb == null) {
            return;
        }
        if (!pending) {
            this.bundleMapping.remove(bundle);
            this.groupingChecker.removeAllExportConstraints(rb);
        }
        if (!pending || !bundle.isResolved()) {
            this.resolverExports.remove(rb.getExportPackages());
            this.resolverBundles.remove(rb);
            this.resolverGenerics.remove(rb.getGenericCapabilities());
        }
        this.unresolvedBundles.remove(rb);
    }

    private void unresolveBundle(ResolverBundle bundle, boolean removed) {
        if (bundle == null) {
            return;
        }
        Object[] removedBundles = this.removalPending.remove(new Long(bundle.getBundle().getBundleId()));
        int i = 0;
        while (i < removedBundles.length) {
            ResolverBundle re = (ResolverBundle)this.bundleMapping.get(removedBundles[i]);
            this.unresolveBundle(re, true);
            this.state.removeBundleComplete((BundleDescription)removedBundles[i]);
            this.resolverExports.remove(re.getExportPackages());
            this.resolverBundles.remove(re);
            this.resolverGenerics.remove(re.getGenericCapabilities());
            this.bundleMapping.remove(removedBundles[i]);
            this.groupingChecker.removeAllExportConstraints(re);
            if (removedBundles[i] == bundle.getBundle()) {
                removed = true;
            }
            ++i;
        }
        if (!bundle.getBundle().isResolved()) {
            return;
        }
        this.setBundleUnresolved(bundle, removed);
        BundleDescription[] dependents = bundle.getBundle().getDependents();
        this.state.resolveBundle(bundle.getBundle(), false, null, null, null, null);
        int i2 = 0;
        while (i2 < dependents.length) {
            this.unresolveBundle((ResolverBundle)this.bundleMapping.get(dependents[i2]), false);
            ++i2;
        }
    }

    public void bundleUpdated(BundleDescription newDescription, BundleDescription existingDescription, boolean pending) {
        this.bundleRemoved(existingDescription, pending);
        this.bundleAdded(newDescription);
    }

    public void flush() {
        this.resolverExports = null;
        this.resolverBundles = null;
        this.resolverGenerics = null;
        this.unresolvedBundles = null;
        this.bundleMapping = null;
        Object[] removed = this.removalPending.getAllValues();
        int i = 0;
        while (i < removed.length) {
            this.state.removeBundleComplete((BundleDescription)removed[i]);
            ++i;
        }
        this.removalPending.clear();
        this.initialized = false;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State newState) {
        this.state = newState;
        this.flush();
    }

    private void setDebugOptions() {
        FrameworkDebugOptions options = FrameworkDebugOptions.getDefault();
        if (options == null) {
            return;
        }
        DEBUG = options.getBooleanOption(OPTION_DEBUG, false);
        DEBUG_WIRING = options.getBooleanOption(OPTION_WIRING, false);
        DEBUG_IMPORTS = options.getBooleanOption(OPTION_IMPORTS, false);
        DEBUG_REQUIRES = options.getBooleanOption(OPTION_REQUIRES, false);
        DEBUG_GENERICS = options.getBooleanOption(OPTION_GENERICS, false);
        DEBUG_GROUPING = options.getBooleanOption(OPTION_GROUPING, false);
        DEBUG_CYCLES = options.getBooleanOption(OPTION_CYCLES, false);
    }

    private void printWirings() {
        ResolverImpl.log("****** Result Wirings ******");
        Object[] bundles = this.resolverBundles.getAllValues();
        int j = 0;
        while (j < bundles.length) {
            ResolverBundle rb = (ResolverBundle)bundles[j];
            if (!rb.getBundle().isResolved()) {
                ResolverImport[] imports;
                int i;
                ResolverBundle[] hosts;
                ResolverImpl.log("    * WIRING for " + rb);
                BundleConstraint[] requireBundles = rb.getRequires();
                if (requireBundles.length == 0) {
                    ResolverImpl.log("        (r) no requires");
                } else {
                    int i2 = 0;
                    while (i2 < requireBundles.length) {
                        if (requireBundles[i2].getMatchingBundle() == null) {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (r) " + rb.getBundle() + " -> " + requireBundles[i2].getMatchingBundle());
                        }
                        ++i2;
                    }
                }
                BundleConstraint hostSpec = rb.getHost();
                if (hostSpec != null && (hosts = hostSpec.getMatchingBundles()) != null) {
                    i = 0;
                    while (i < hosts.length) {
                        ResolverImpl.log("        (h) " + rb.getBundle() + " -> " + hosts[i].getBundle());
                        ++i;
                    }
                }
                if ((imports = rb.getImportPackages()).length == 0) {
                    ResolverImpl.log("        (w) no imports");
                } else {
                    i = 0;
                    while (i < imports.length) {
                        if (imports[i].isDynamic() && imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> DYNAMIC");
                        } else if (imports[i].isOptional() && imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> OPTIONAL (could not be wired)");
                        } else if (imports[i].getMatchingExport() == null) {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> NULL!!!");
                        } else {
                            ResolverImpl.log("        (w) " + imports[i].getBundle() + ":" + imports[i].getName() + " -> " + imports[i].getMatchingExport().getExporter() + ":" + imports[i].getMatchingExport().getName());
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    static void log(String message) {
        Debug.println(message);
    }

    VersionHashMap getResolverExports() {
        return this.resolverExports;
    }

    public void setSelectionPolicy(Comparator selectionPolicy) {
        this.selectionPolicy = selectionPolicy;
    }

    public Comparator getSelectionPolicy() {
        return this.selectionPolicy;
    }
}

