/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.util.UmaUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;

public class MoveInCategoryCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private ContentCategory category;
    private EStructuralFeature feature;
    private List elementsList;
    private String[] categoryPkgPath;
    private boolean checkForExistingContributor;
    private ContentCategory usedCategory = null;
    private ContentPackage categoryPkg;
    private Collection modifiedResources;
    private static int UP = 1;
    private static int Down = 0;
    private int direction = -1;
    private boolean moved;

    public MoveInCategoryCommand() {
    }

    public MoveInCategoryCommand(ContentCategory category, List elementsList, EStructuralFeature feature, String[] categoryPkgPath, boolean checkForExistingContributor, int direction) {
        this.category = category;
        this.feature = feature;
        this.elementsList = elementsList;
        this.categoryPkgPath = categoryPkgPath;
        this.checkForExistingContributor = checkForExistingContributor;
        this.direction = direction;
    }

    protected boolean prepare() {
        return true;
    }

    public MoveInCategoryCommand(String label) {
        super(label);
    }

    public MoveInCategoryCommand(String label, String description) {
        super(label, description);
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }

    public void execute() {
        MethodPlugin elementPlugin;
        MethodPlugin categoryPlugin = UmaUtil.getMethodPlugin((EObject)this.category);
        this.usedCategory = categoryPlugin != (elementPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)this.elementsList.get(0)))) && Misc.isBaseOf(categoryPlugin, elementPlugin) ? TngUtil.findContributor(UmaUtil.findContentPackage((MethodPlugin)elementPlugin, (String[])this.categoryPkgPath), this.category) : this.category;
        this.modifiedResources = new HashSet();
        this.redo();
    }

    public void redo() {
        if (this.usedCategory == null) {
            return;
        }
        Iterator it = this.elementsList.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (this.feature.isMany()) {
                EList list = (EList)this.usedCategory.eGet(this.feature);
                int index = list.indexOf(object);
                if (this.direction == UP) {
                    if (index > 0) {
                        list.move(index - 1, object);
                    }
                } else if (this.direction == Down && index < list.size()) {
                    list.move(index + this.elementsList.size(), object);
                }
                this.moved = true;
                continue;
            }
            this.usedCategory.eSet(this.feature, null);
        }
        if (this.usedCategory.eResource() != null) {
            this.modifiedResources.add(this.usedCategory.eResource());
        }
    }

    public void undo() {
        if (this.moved) {
            Iterator it = this.elementsList.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (this.feature.isMany()) {
                    EList list = (EList)this.usedCategory.eGet(this.feature);
                    int index = list.indexOf(object);
                    if (this.direction == UP) {
                        if (index < list.size()) {
                            list.move(index + this.elementsList.size(), object);
                        }
                    } else if (this.direction == Down && index > 0) {
                        list.move(index - 1, object);
                    }
                    this.moved = true;
                    continue;
                }
                this.usedCategory.eSet(this.feature, object);
            }
            this.moved = false;
        }
        if (TngUtil.isEmpty(this.usedCategory)) {
            EcoreUtil.remove((EObject)this.usedCategory);
            this.usedCategory = null;
        }
    }

    public Collection getAffectedObjects() {
        return Collections.singletonList(this.usedCategory);
    }
}

