/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.Domain;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.Role;
import com.ibm.uma.Task;
import com.ibm.uma.Tool;
import com.ibm.uma.ToolMentor;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductType;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.epf.library.edit.IConfigurable;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.category.CustomCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.DisciplineCategoriesItemProvider;
import org.eclipse.epf.library.edit.category.RoleSetsItemProvider;
import org.eclipse.epf.library.edit.configuration.CategoriesItemProvider;
import org.eclipse.epf.library.edit.configuration.GuidanceGroupingItemProvider;
import org.eclipse.epf.library.edit.configuration.ProcessesItemProvider;
import org.eclipse.epf.library.edit.configuration.WorkProductTypesItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.swt.graphics.Image;

public class MethodConfigurationItemProvider
extends com.ibm.uma.provider.MethodConfigurationItemProvider
implements IGroupContainer,
IConfigurable,
IStatefulItemProvider {
    private Map groupItemProviderMap;
    protected ArrayList children;
    private static final IFilter disciplinesFilter = new IFilter(){

        public boolean accept(Object obj) {
            ContentCategory element = (ContentCategory)obj;
            return DisciplineCategoriesItemProvider.accept(element);
        }
    };
    private static final IFilter domainFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof Domain;
        }
    };
    private static final IFilter workProductTypesFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof WorkProductType;
        }
    };
    private static final IFilter roleSetsFilter = new IFilter(){

        public boolean accept(Object obj) {
            return RoleSetsItemProvider.accept(obj);
        }
    };
    private static final IFilter toolsFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof Tool;
        }
    };
    private static final IFilter customCategoriesFilter = new IFilter(){

        public boolean accept(Object obj) {
            return CustomCategoriesItemProvider.accept(obj);
        }
    };
    private static final IFilter uncategorizedTaskFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof Task && AssociationHelper.getDiscipline((Task)((Task)obj)) == null;
        }
    };
    private static final IFilter domainUncategorizedWorkProductFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof WorkProduct && AssociationHelper.getDomain((WorkProduct)((WorkProduct)obj)) == null;
        }
    };
    private static final IFilter wpTypeUncategorizedWorkProductFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof WorkProduct && AssociationHelper.getWorkProductTypes((WorkProduct)((WorkProduct)obj)).isEmpty();
        }
    };
    private static final IFilter uncategorizedRoleFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof Role && AssociationHelper.getRoleSets((Role)((Role)obj)).isEmpty();
        }
    };
    private static final IFilter uncategorizedToolMentorFilter = new IFilter(){

        public boolean accept(Object obj) {
            return obj instanceof ToolMentor && AssociationHelper.getTool((ToolMentor)((ToolMentor)obj)) == null;
        }
    };
    private IConfigurator configurator;
    private IFilter filter;
    static /* synthetic */ Class class$0;

    public MethodConfigurationItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public void dispose() {
        if (this.groupItemProviderMap != null) {
            Iterator iter = this.groupItemProviderMap.values().iterator();
            while (iter.hasNext()) {
                Object adapter = iter.next();
                if (!(adapter instanceof IDisposable)) continue;
                ((IDisposable)adapter).dispose();
            }
            this.groupItemProviderMap.clear();
            this.groupItemProviderMap = null;
        }
        if (this.children != null) {
            this.children.clear();
            this.children = null;
        }
        super.dispose();
    }

    public Collection getChildren(Object object) {
        MethodConfiguration conf = (MethodConfiguration)object;
        if (this.children == null) {
            this.children = new ArrayList();
            this.groupItemProviderMap = new HashMap();
            String name = LibraryEditPlugin.INSTANCE.getString("_UI_Disciplines_group");
            CategoriesItemProvider child = new CategoriesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tasks_cfv"), ModelStructure.DEFAULT.disciplineDefinitionPath);
            child.setParent(conf);
            child.setUncategorizedFilter(uncategorizedTaskFilter);
            child.setCategorizedFilter(disciplinesFilter);
            child.setUncategorizedLabel(LibraryEditPlugin.INSTANCE.getString("_UI_Uncategorized_Tasks_text"));
            Image uncategorizedImage = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tasks");
            child.setUncategorizedImage(uncategorizedImage);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Domains_group");
            child = new CategoriesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Domains"), ModelStructure.DEFAULT.domainPath);
            child.setParent(conf);
            child.setUncategorizedFilter(domainUncategorizedWorkProductFilter);
            uncategorizedImage = LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts");
            child.setUncategorizedImage(uncategorizedImage);
            child.setCategorizedFilter(domainFilter);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_WorkProductTypes_group");
            child = new WorkProductTypesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts"), ModelStructure.DEFAULT.workProductTypePath);
            child.setParent(conf);
            child.setUncategorizedFilter(wpTypeUncategorizedWorkProductFilter);
            uncategorizedImage = LibraryEditPlugin.INSTANCE.getImage("full/obj16/WorkProducts");
            child.setUncategorizedImage(uncategorizedImage);
            child.setCategorizedFilter(workProductTypesFilter);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Role_Sets_group");
            child = new CategoriesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles"), ModelStructure.DEFAULT.roleSetPath);
            child.setParent(conf);
            child.setUncategorizedFilter(uncategorizedRoleFilter);
            child.setCategorizedFilter(roleSetsFilter);
            child.setUncategorizedLabel(LibraryEditPlugin.INSTANCE.getString("_UI_Uncategorized_Roles_text"));
            uncategorizedImage = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Roles");
            child.setUncategorizedImage(uncategorizedImage);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Tools_group");
            child = new CategoriesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools"), ModelStructure.DEFAULT.toolPath);
            child.setParent(conf);
            child.setCategorizedFilter(toolsFilter);
            child.setUncategorizedFilter(uncategorizedToolMentorFilter);
            uncategorizedImage = LibraryEditPlugin.INSTANCE.getImage("full/obj16/Tools");
            child.setUncategorizedImage(uncategorizedImage);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Processes_group");
            ProcessesItemProvider otherChild = new ProcessesItemProvider(this.adapterFactory, conf, ModelStructure.DEFAULT);
            this.children.add(otherChild);
            this.groupItemProviderMap.put(name, otherChild);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group");
            child = new CategoriesItemProvider(this.adapterFactory, conf, name, LibraryEditPlugin.INSTANCE.getImage("full/obj16/MethodPackages"), ModelStructure.DEFAULT.customCategoryPath);
            child.setParent(conf);
            child.setCategorizedFilter(customCategoriesFilter);
            this.children.add(child);
            this.groupItemProviderMap.put(name, child);
            name = LibraryEditPlugin.INSTANCE.getString("_UI_Guidances_group");
            GuidanceGroupingItemProvider child1 = new GuidanceGroupingItemProvider(this.adapterFactory, conf);
            child1.setFilter(this.filter);
            this.children.add(child1);
            this.groupItemProviderMap.put(name, child1);
        }
        return this.children;
    }

    public boolean hasChildren(Object object) {
        return super.hasChildren(object);
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object, this.getString("_UI_MethodConfiguration_type"));
    }

    public Object getGroupItemProvider(String name) {
        return this.groupItemProviderMap.get(name);
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        return Collections.EMPTY_LIST;
    }

    public void setFilter(IFilter filter) {
        if (filter instanceof IConfigurator) {
            this.configurator = (IConfigurator)filter;
        }
        this.filter = filter;
    }

    public void setLabel(String label) {
    }

    public void setParent(Object parent) {
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.configurator != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.uma.MethodConfiguration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (notification.getFeatureID((Class)clazz)) {
                case 6: 
                case 7: {
                    this.configurator.notifyChanged(notification);
                }
            }
        }
    }
}

