/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.Milestone;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.ComposedWPDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.PBSDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.PBSDropCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class PBSActivityItemProvider
extends BSActivityItemProvider
implements ICachedChildrenItemProvider {
    private Disposable rolledUpWrappers;

    public PBSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createPhase()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createIteration()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createActivity()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createWorkProductDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createMilestone()));
    }

    protected boolean acceptAsChild(Object child) {
        if ((child = TngUtil.unwrap(child)) instanceof Activity || child instanceof WorkProductDescriptor || child instanceof Milestone) {
            return super.acceptAsChild(child);
        }
        return false;
    }

    public Collection getChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        if (this.isRolledUp()) {
            HashMap workProductToWrappersMap = new HashMap();
            Collection children = super.getChildren(object);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Iterator iterator;
                Object child = iter.next();
                Object e = TngUtil.unwrap(child);
                if (!(e instanceof WorkProductDescriptor)) continue;
                WorkProductDescriptor desc = (WorkProductDescriptor)e;
                List list = AssociationHelper.getDeliverableDescriptors((WorkProductDescriptor)desc);
                WorkProductDescriptor wrapperKey = desc.getWorkProduct() == null ? desc : desc.getWorkProduct();
                ArrayList<ComposedWPDescriptorWrapperItemProvider> wrappers = (ArrayList<ComposedWPDescriptorWrapperItemProvider>)workProductToWrappersMap.get(wrapperKey);
                if (list.size() < 1) {
                    if (wrappers == null) {
                        wrappers = new ArrayList<ComposedWPDescriptorWrapperItemProvider>();
                        workProductToWrappersMap.put(wrapperKey, wrappers);
                        wrappers.add(new ComposedWPDescriptorWrapperItemProvider(child, object, this.adapterFactory));
                        continue;
                    }
                    int i = wrappers.size() - 1;
                    while (i > -1) {
                        ((ComposedWPDescriptorWrapperItemProvider)wrappers.get(i)).addWorkProductDescriptor(child);
                        --i;
                    }
                    continue;
                }
                boolean checkExist = true;
                if (wrappers == null) {
                    wrappers = new ArrayList();
                    workProductToWrappersMap.put(wrapperKey, wrappers);
                    checkExist = false;
                }
                if (checkExist) {
                    iterator = wrappers.iterator();
                    while (iterator.hasNext()) {
                        Object wrapper = iterator.next();
                        if (wrapper instanceof DeliverableWorkProductDescriptorItemProvider) continue;
                        iter.remove();
                    }
                    checkExist = wrappers.size() > 0;
                }
                iterator = list.iterator();
                block3: while (iterator.hasNext()) {
                    Object deliverableDescriptor = iterator.next();
                    if (checkExist) {
                        int i = wrappers.size() - 1;
                        while (i > -1) {
                            DeliverableWorkProductDescriptorItemProvider wrapper = (DeliverableWorkProductDescriptorItemProvider)wrappers.get(i);
                            if (wrapper.deliverableDescriptor == deliverableDescriptor) {
                                wrapper.addWorkProductDescriptor(child);
                                continue block3;
                            }
                            --i;
                        }
                    }
                    DeliverableWorkProductDescriptorItemProvider itemProvider = new DeliverableWorkProductDescriptorItemProvider(desc, object, this.adapterFactory);
                    itemProvider.deliverableDescriptor = deliverableDescriptor;
                    wrappers.add(itemProvider);
                }
            }
            ArrayList rolledUpChildren = new ArrayList();
            Iterator iter2 = workProductToWrappersMap.values().iterator();
            while (iter2.hasNext()) {
                rolledUpChildren.addAll((Collection)iter2.next());
            }
            List result = this.removeSubartifactsFromChildren(rolledUpChildren, true);
            if (this.rolledUpWrappers == null) {
                this.rolledUpWrappers = new Disposable();
            }
            this.rolledUpWrappers.addAll((Collection)result);
            int i = rolledUpChildren.size() - 1;
            while (i > -1) {
                IWrapperItemProvider wrapper = (IWrapperItemProvider)rolledUpChildren.get(i);
                if (!this.rolledUpWrappers.contains((Object)wrapper)) {
                    wrapper.dispose();
                }
                --i;
            }
            Collections.sort(result, Comparators.PRESENTATION_NAME_COMPARATOR);
            this.updateCachedChildren(result);
            return result;
        }
        List children = this.removeSubartifactsFromChildren(super.getChildren(object), false);
        this.updateCachedChildren(children);
        return children;
    }

    public void dispose() {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        super.dispose();
    }

    protected boolean isNewDescriptor(List children, Object child) {
        return true;
    }

    protected void createOrMovePackageFor(List newChildren) {
        super.createOrMovePackageFor(newChildren);
        Iterator iter = newChildren.iterator();
        while (iter.hasNext()) {
            Object e = iter.next();
            if (!(e instanceof WorkProductDescriptor)) continue;
            WorkProductDescriptor wpd = (WorkProductDescriptor)e;
            Iterator iterator = wpd.getDeliverableParts().iterator();
            while (iterator.hasNext()) {
                WorkProductDescriptor part = (WorkProductDescriptor)iterator.next();
                ProcessUtil.addToContainer((BreakdownElement)part, (ItemProviderAdapter)this, false);
            }
        }
    }

    protected Object getObject(Descriptor descriptor) {
        return ((WorkProductDescriptor)descriptor).getWorkProduct();
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        return new PBSDragAndDropCommand(domain, owner, location, operations, operation, collection);
    }

    public IResourceAwareCommand createDropCommand(Object owner, List dropElements) {
        return new PBSDropCommand((Activity)owner, dropElements);
    }

    protected boolean acceptAsRolledUpChild(Object child) {
        Object obj = TngUtil.unwrap(child);
        if (obj instanceof WorkProductDescriptor && !((WorkProductDescriptor)obj).getSuperActivities().isEmpty()) {
            return super.acceptAsRolledUpChild(obj);
        }
        return false;
    }

    public Collection getEClasses() {
        return ProcessUtil.getPBSEclasses();
    }

    protected List removeSubartifactsFromChildren(Collection children, boolean unwrap) {
        return ProcessUtil.removeSubartifactsFromChildren(children, unwrap);
    }

    private static class DeliverableWorkProductDescriptorItemProvider
    extends ComposedWPDescriptorWrapperItemProvider {
        private Object deliverableDescriptor;

        public DeliverableWorkProductDescriptorItemProvider(WorkProductDescriptor value, Object owner, AdapterFactory adapterFactory) {
            super((Object)value, owner, adapterFactory);
            this.readOnly = false;
        }

        public String getAttribute(Object object, String property) {
            if (property == "deliverable") {
                return TngUtil.getPresentationName(this.deliverableDescriptor);
            }
            return super.getAttribute(object, property);
        }
    }
}

