/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.DescribableElement;
import com.ibm.uma.Element;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.ProcessFamily;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IMethodLibraryPersister;
import com.ibm.uma.util.UmaUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.navigator.ProcessPackageItemProvider;
import org.eclipse.epf.library.edit.ui.NewProcessComponentDialog;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CreateProcessComponentCommand
extends CreateChildCommand {
    private static final Collection ECLASSES = new HashSet();
    private Process process;
    private IStatus status;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        ECLASSES.add(UmaPackage.eINSTANCE.getMethodPackage());
    }

    public CreateProcessComponentCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object child, int index, Collection selection, CreateChildCommand.Helper helper) {
        super(domain, owner, feature, child, index, selection, helper);
    }

    public boolean canUndo() {
        return false;
    }

    public void execute() {
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)this.owner);
        Shell shell = MsgBox.getDefaultShell();
        this.status = UserInteractionHelper.checkModify(this.owner, shell);
        if (!this.status.isOK()) {
            return;
        }
        List configs = lib.getPredefinedConfigurations();
        ArrayList methodConfigs = new ArrayList();
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof ProcessFamily) continue;
            methodConfigs.add(element);
        }
        if (methodConfigs.isEmpty()) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.noConfigError.msg"));
            return;
        }
        ProcessPackageItemProvider adapter = (ProcessPackageItemProvider)this.helper;
        ArrayList procClasses = new ArrayList();
        if (adapter.getProcessType() == UmaPackage.eINSTANCE.getProcessContribution()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.uma.CapabilityPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            procClasses.add(clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.ibm.uma.DeliveryProcess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            procClasses.add(clazz2);
        } else if (adapter.getProcessType() == UmaPackage.eINSTANCE.getProcessPlanningTemplate()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.ibm.uma.DeliveryProcess");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            procClasses.add(clazz);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.ibm.uma.CapabilityPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            procClasses.add(clazz3);
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("com.ibm.uma.ProcessContribution");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            procClasses.add(clazz4);
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)((Element)this.owner));
        List baseProcList = TngUtil.getAvailableBaseProcesses(plugin, procClasses);
        if (adapter.getProcessType() == UmaPackage.eINSTANCE.getProcessContribution() && baseProcList.isEmpty()) {
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.noDeliveryProcessError.msg"));
            return;
        }
        MethodConfiguration[] procCtxs = new MethodConfiguration[methodConfigs.size()];
        methodConfigs.toArray(procCtxs);
        Process[] baseProcesses = new Process[baseProcList.size()];
        baseProcList.toArray(baseProcesses);
        final ProcessComponent procComp = (ProcessComponent)this.child;
        procComp.setProcess((Process)UmaFactory.eINSTANCE.create(adapter.getProcessType()));
        NewProcessComponentDialog dialog = new NewProcessComponentDialog(Display.getCurrent().getActiveShell(), procCtxs, procComp, baseProcesses, plugin, (ProcessPackage)this.owner);
        boolean canExecute = true;
        while (true) {
            int ret;
            if ((ret = dialog.open()) == 1) {
                canExecute = false;
                break;
            }
            if (procComp.getProcess().getDefaultContext() == null) {
                LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.noDefaultConfigError.msg"));
                continue;
            }
            if (procComp.getProcess() instanceof ProcessContribution && ((ProcessContribution)procComp.getProcess()).getBaseProcess() == null) {
                LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.noBaseProcessError.msg"));
                continue;
            }
            String msg = IValidatorFactory.INSTANCE.createNameValidator((Object)this.owner, (NamedElement)procComp).isValid(procComp.getName());
            if (msg == null) {
                this.process = procComp.getProcess();
                break;
            }
            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), msg);
        }
        if (canExecute) {
            IStatus status;
            this.status = UserInteractionHelper.checkModify((EObject)procComp.getProcess().getDefaultContext(), shell);
            if (!this.status.isOK()) {
                return;
            }
            super.execute();
            Command cmd = this.getCommand();
            if (cmd instanceof MethodElementAddCommand && (status = ((MethodElementAddCommand)cmd).getStatus()) != null && !status.isOK()) {
                this.status = status;
                return;
            }
            final MethodConfiguration procCtx = this.process.getDefaultContext();
            List pkgs = procCtx.getMethodPackageSelection();
            ProcessComponent obj = procComp;
            while (obj != null) {
                if (obj instanceof MethodPackage) {
                    pkgs.add(obj);
                }
                obj = obj.eContainer();
            }
            procCtx.getMethodPluginSelection().add(plugin);
            this.process.getValidContext().add(procCtx);
            this.process.setPresentation(ContentDescriptionFactory.createContentDescription((DescribableElement)this.process));
            Runnable runnable = new Runnable(){

                public void run() {
                    Resource resource = CreateProcessComponentCommand.this.owner.eResource();
                    if (resource != null) {
                        IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                        try {
                            persister.save(procComp.eResource());
                            persister.save(resource);
                            persister.save(procCtx.eResource());
                            persister.commit();
                        }
                        catch (Exception e) {
                            try {
                                persister.rollback();
                            }
                            catch (Exception ex) {
                                LibraryEditPlugin.INSTANCE.log(ex);
                                LibraryEditPlugin.INSTANCE.log(e);
                            }
                            LibraryEditPlugin.getDefault().getMsgDialog().displayError(LibraryEditResources.getString("LibraryEdit.createProcess.text"), LibraryEditResources.getString("LibraryEdit.createProcessError.msg"), LibraryEditResources.formatString("LibraryEdit.saveProcessError.reason", procComp.getName()), (Throwable)e);
                        }
                    }
                }
            };
            UserInteractionHelper.runWithProgress(runnable, MessageFormat.format(LibraryEditResources.getString("LibraryEdit.creatingProcessComponentTask.name"), procComp.getName()));
        }
    }

    public void redo() {
        super.redo();
        ProcessComponent procComp = (ProcessComponent)this.child;
        MethodConfiguration procCtx = this.process.getDefaultContext();
        if (procCtx instanceof MethodConfiguration) {
            procCtx.getMethodPackageSelection().add(procComp);
        }
    }

    public void undo() {
        MethodConfiguration procCtx = this.process.getDefaultContext();
        if (procCtx instanceof MethodConfiguration) {
            procCtx.getMethodPackageSelection().remove(this.child);
        }
        super.undo();
    }

    public IStatus getStatus() {
        return this.status;
    }
}

