/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.Descriptor;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.RemoveUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;

public class DeleteRoleDescriptor
extends RemoveUnusedDescriptorsCommand {
    private Activity activity;
    private RoleDescriptor roleDesc;
    private Collection modifiedResources;
    private List notUsedReferences = new ArrayList();
    private boolean forceRemoveUnusedReferences;
    static /* synthetic */ Class class$0;

    public DeleteRoleDescriptor(RoleDescriptor roleDesc) {
        ItemProviderAdapter adapter;
        Object parent;
        this.roleDesc = roleDesc;
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = (adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)roleDesc, (Object)clazz)).getParent((Object)roleDesc)) instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
        if (this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        if (roleDesc.eResource() != null) {
            this.modifiedResources.add(roleDesc.eResource());
        }
    }

    public DeleteRoleDescriptor(RoleDescriptor roleDesc, boolean forceRemoveUnusedReferences) {
        this(roleDesc);
        this.forceRemoveUnusedReferences = forceRemoveUnusedReferences;
    }

    public void execute() {
        HashSet refList = new HashSet();
        refList.addAll(this.roleDesc.getAssistsIn());
        refList.addAll(this.roleDesc.getPerformsAdditionally());
        refList.addAll(this.roleDesc.getPerformsAsOwner());
        refList.addAll(this.roleDesc.getResponsibleFor());
        Iterator itor = refList.iterator();
        while (itor.hasNext()) {
            Object object = itor.next();
            if (!(object instanceof Descriptor) || ProcessUtil.checkDescriptorReferences((Descriptor)this.roleDesc, (Descriptor)object) || !this.activity.getBreakdownElements().contains(object)) continue;
            this.notUsedReferences.add(object);
        }
        if (!this.notUsedReferences.isEmpty()) {
            try {
                Object[] refToBeDeleted = this.forceRemoveUnusedReferences ? this.notUsedReferences.toArray() : ReferenceSelection.getReferences(this.notUsedReferences, (Descriptor)this.roleDesc);
                this.delete(refToBeDeleted);
            }
            catch (OperationCanceledException operationCanceledException) {
                this.aborted = true;
            }
        }
        this.clear(this.roleDesc.getAssistsIn());
        this.clear(this.roleDesc.getPerformsAdditionally());
        this.clear(this.roleDesc.getPerformsAsOwner());
        this.clear(this.roleDesc.getResponsibleFor());
        List teams = AssociationHelper.getTeamProfiles((RoleDescriptor)this.roleDesc);
        Iterator itor2 = teams.iterator();
        while (itor2.hasNext()) {
            TeamProfile team = (TeamProfile)itor2.next();
            team.getTeamRoles().remove(this.roleDesc);
            Object teamRoleDesc = ProcessUtil.findRoleDescriptor(team, this.roleDesc);
            team.getTeamRoles().remove(teamRoleDesc);
        }
        this.redo();
    }

    private void clear(List list) {
        try {
            if (list != null && list.size() > 0) {
                list.clear();
            }
        }
        catch (Exception exception) {}
    }

    public void redo() {
    }

    public void undo() {
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

