/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.Deliverable;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class PBSDropCommand
extends BSDropCommand {
    private ArrayList wpDescList;
    private ArrayList roleDescList;
    private Map wpDescToDeliverableParts;
    private HashMap wpdToDeliverableDescriptorMap;
    private BatchCommand updateDeliverablePartsCmd;
    private boolean newDuplicatesRemoved;
    private IConfigurator configurator;
    private ArrayList linkedTasks;
    private HashMap wpdToTaskFeaturesMap;

    public PBSDropCommand(Activity activity, List workProducts) {
        super(activity, workProducts);
        this.activity = activity;
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof WorkProduct) continue;
            iter.remove();
        }
    }

    public PBSDropCommand(Activity activity, List dropElements, boolean synch) {
        super(activity, dropElements, synch);
    }

    public PBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures, IConfigurator configurator) {
        super(activity, dropElements, config, synchFeatures);
        this.configurator = configurator;
    }

    protected boolean preExecute() {
        Object wpDesc;
        if (!super.preExecute()) {
            return false;
        }
        this.wpDescList = new ArrayList();
        this.taskDescList = new ArrayList();
        this.roleDescList = new ArrayList();
        this.wpDescToDeliverableParts = new HashMap();
        this.wpdToDeliverableDescriptorMap = new HashMap();
        if (!this.synchronize || this.synchronize && this.synchFeatures.contains(UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts())) {
            Iterator iter = new ArrayList(this.dropElements).iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof Artifact)) continue;
                AbstractTreeIterator iterator = new AbstractTreeIterator(element, false){
                    private static final long serialVersionUID = -4820477887426087262L;

                    protected Iterator getChildren(Object object) {
                        Object subArtifacts = Providers.getConfigurationApplicator().getReference((VariabilityElement)object, UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), PBSDropCommand.this.getMethodConfiguration());
                        return ((Collection)subArtifacts).iterator();
                    }
                };
                while (iterator.hasNext()) {
                    Artifact subArtifact = (Artifact)iterator.next();
                    if (this.dropElements.contains(subArtifact) || !this.prepareAdd((WorkProduct)subArtifact)) continue;
                    this.dropElements.add(subArtifact);
                }
            }
        }
        MethodConfiguration config = this.getMethodConfiguration();
        Set descriptorsToRefresh = this.synchronize ? this.batchCommand.getDescriptorsToRefresh() : null;
        int i = 0;
        while (i < this.dropElements.size()) {
            WorkProduct wp = (WorkProduct)this.dropElements.get(i);
            if (TngUtil.isContributor((VariabilityElement)wp)) {
                wp = (WorkProduct)TngUtil.getBase((VariabilityElement)wp);
            }
            if ((wpDesc = (WorkProductDescriptor)ProcessCommandUtil.getDescriptor((Object)wp, this.activity, config)) == null) {
                Map featuresMap;
                wpDesc = ProcessCommandUtil.createWorkProductDescriptor(wp, config, this.wpDescToDeliverableParts);
                this.wpDescList.add(wpDesc);
                WorkProductDescriptor descriptor = UserInteractionHelper.getDeliverable(this.activity, wp);
                if (descriptor != null) {
                    this.wpdToDeliverableDescriptorMap.put(wpDesc, descriptor);
                }
                if (this.wpdToTaskFeaturesMap != null && (featuresMap = (Map)this.wpdToTaskFeaturesMap.get(wp)) != null) {
                    this.wpdToTaskFeaturesMap.remove(wp);
                    this.wpdToTaskFeaturesMap.put(wpDesc, featuresMap);
                }
            } else {
                if (descriptorsToRefresh != null && wpDesc.getIsSynchronizedWithSource().booleanValue()) {
                    descriptorsToRefresh.add(wpDesc);
                }
                if (wp instanceof Deliverable && this.synchFeatures.contains(UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())) {
                    ProcessCommandUtil.createDeliverableParts(wpDesc, (Deliverable)wp, config, this.wpDescToDeliverableParts, descriptorsToRefresh);
                }
                if (this.wpdToTaskFeaturesMap != null) {
                    this.wpdToTaskFeaturesMap.remove(wp);
                }
            }
            if (!this.synchronize) {
                List tasks = ProcessUtil.getTasksForWorkProduct(wp, config);
                if (tasks != null && tasks.size() > 0) {
                    List selectedTasks = UserInteractionHelper.selectTasks(tasks, wp);
                    if (selectedTasks != null && !selectedTasks.isEmpty()) {
                        int j = 0;
                        while (j < selectedTasks.size()) {
                            Task task = (Task)selectedTasks.get(j);
                            PBSDropCommand.addToDescriptorLists(task, this.activity, this.taskDescList, this.roleDescList, this.wpDescList, this.wpDescToDeliverableParts, descriptorsToRefresh, this.batchCommand.getObjectToNewFeatureValuesMap(), config, this.synchFeatures);
                            ++j;
                        }
                    } else {
                        PBSDropCommand.addResponsibleRole(wpDesc, this.activity, this.roleDescList, descriptorsToRefresh, config);
                    }
                } else {
                    PBSDropCommand.addResponsibleRole(wpDesc, this.activity, this.roleDescList, descriptorsToRefresh, config);
                }
            }
            ++i;
        }
        if (!this.wpDescToDeliverableParts.isEmpty()) {
            this.updateDeliverablePartsCmd = new BatchCommand(true);
            Iterator iter = this.wpDescToDeliverableParts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                wpDesc = entry.getKey();
                this.updateDeliverablePartsCmd.getObjectToNewFeatureValuesMap().put(wpDesc, Collections.singletonMap(UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), entry.getValue()));
            }
        }
        return !this.taskDescList.isEmpty() || !this.roleDescList.isEmpty() || !this.wpDescList.isEmpty() || this.updateDeliverablePartsCmd != null && this.updateDeliverablePartsCmd.canExecute() || !this.wpdToDeliverableDescriptorMap.isEmpty() || descriptorsToRefresh != null && !descriptorsToRefresh.isEmpty() || this.batchCommand.canExecute();
    }

    private boolean prepareAdd(WorkProduct wp) {
        if (this.synchronize) {
            Map featuresMap;
            List tasks = this.getLinkedTasks();
            if (!tasks.isEmpty() && !(featuresMap = ProcessCommandUtil.getFeaturesMap(tasks, wp, this.getMethodConfiguration())).isEmpty()) {
                if (this.wpdToTaskFeaturesMap == null) {
                    this.wpdToTaskFeaturesMap = new HashMap();
                }
                this.wpdToTaskFeaturesMap.put(wp, featuresMap);
                return true;
            }
            return false;
        }
        return true;
    }

    private List getLinkedTasks() {
        if (this.linkedTasks == null) {
            this.linkedTasks = new ArrayList();
            Iterator iter = this.activity.getBreakdownElements().iterator();
            while (iter.hasNext()) {
                Task task;
                Object element = iter.next();
                if (!(element instanceof TaskDescriptor) || (task = ((TaskDescriptor)element).getTask()) == null || !this.configurator.accept(element)) continue;
                this.linkedTasks.add(task);
            }
        }
        return this.linkedTasks;
    }

    private void removeNewDuplicates() {
        if (this.synchronize && !this.newDuplicatesRemoved) {
            Iterator iter = this.roleDescList.iterator();
            while (iter.hasNext()) {
                RoleDescriptor roleDesc = (RoleDescriptor)iter.next();
                Object desc = ProcessCommandUtil.getDescriptor((Object)roleDesc.getRole(), this.activity, this.getMethodConfiguration());
                if (desc == null) continue;
                iter.remove();
            }
            this.newDuplicatesRemoved = true;
        }
    }

    protected void doExecute() {
        ProcessPackage pkg;
        Map.Entry entry;
        Iterator iter;
        this.removeNewDuplicates();
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            iter = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().add(entry.getKey());
            }
        }
        this.activity.getBreakdownElements().addAll(this.wpDescList);
        this.activity.getBreakdownElements().addAll(this.taskDescList);
        this.activity.getBreakdownElements().addAll(this.roleDescList);
        if (this.wpdToTaskFeaturesMap != null) {
            iter = this.wpdToTaskFeaturesMap.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                Map taskFeatures = (Map)entry.getValue();
                Iterator iterator = taskFeatures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry ent = iterator.next();
                    TaskDescriptor taskDesc = (TaskDescriptor)ProcessCommandUtil.getDescriptor(ent.getKey(), this.activity.getBreakdownElements(), this.getMethodConfiguration(), false);
                    Iterator iterator1 = ((Collection)ent.getValue()).iterator();
                    while (iterator1.hasNext()) {
                        EStructuralFeature f = (EStructuralFeature)iterator1.next();
                        EStructuralFeature descFeature = (EStructuralFeature)FEATURE_MAP.get(f);
                        if (descFeature.isMany()) {
                            ((List)taskDesc.eGet(descFeature)).add(entry.getKey());
                            continue;
                        }
                        taskDesc.eSet(descFeature, entry.getKey());
                    }
                }
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().addAll(this.taskDescList);
            pkg.getProcessElements().addAll(this.roleDescList);
            pkg.getProcessElements().addAll(this.wpDescList);
            Iterator iter2 = this.wpDescToDeliverableParts.values().iterator();
            while (iter2.hasNext()) {
                pkg.getProcessElements().addAll((Collection)iter2.next());
            }
        }
        this.getModifiedResources().add(this.activity.eResource());
    }

    protected void updateDescriptors() {
        super.updateDescriptors();
        if (this.updateDeliverablePartsCmd != null) {
            this.updateDeliverablePartsCmd.execute();
        }
    }

    protected void undoUpdateDescriptors() {
        if (this.updateDeliverablePartsCmd != null) {
            this.updateDeliverablePartsCmd.undo();
        }
        super.undoUpdateDescriptors();
    }

    protected void doUndo() {
        Iterator iter;
        ProcessPackage pkg;
        this.activity.getBreakdownElements().removeAll(this.wpDescList);
        this.activity.getBreakdownElements().removeAll(this.roleDescList);
        this.activity.getBreakdownElements().removeAll(this.taskDescList);
        if (!this.wpdToDeliverableDescriptorMap.isEmpty()) {
            Iterator iter2 = this.wpdToDeliverableDescriptorMap.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry = iter2.next();
                WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                deliverable.getDeliverableParts().remove(entry.getKey());
            }
        }
        if ((pkg = (ProcessPackage)this.activity.eContainer()) != null) {
            pkg.getProcessElements().removeAll(this.taskDescList);
            pkg.getProcessElements().removeAll(this.roleDescList);
            pkg.getProcessElements().removeAll(this.wpDescList);
            iter = this.wpDescToDeliverableParts.values().iterator();
            while (iter.hasNext()) {
                pkg.getProcessElements().removeAll((Collection)((Object)iter.next()));
            }
        }
        if (this.wpdToTaskFeaturesMap != null) {
            iter = this.wpdToTaskFeaturesMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Map taskFeatures = (Map)entry.getValue();
                Iterator iterator = taskFeatures.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry ent = iterator.next();
                    TaskDescriptor taskDesc = (TaskDescriptor)ProcessCommandUtil.getDescriptor(ent.getKey(), this.activity, this.getMethodConfiguration());
                    Iterator iterator1 = ((Collection)ent.getValue()).iterator();
                    while (iterator1.hasNext()) {
                        EStructuralFeature f = (EStructuralFeature)iterator1.next();
                        EStructuralFeature descFeature = (EStructuralFeature)FEATURE_MAP.get(f);
                        if (descFeature.isMany()) {
                            ((List)taskDesc.eGet(descFeature)).remove(entry.getKey());
                            continue;
                        }
                        taskDesc.eSet(descFeature, null);
                    }
                }
            }
        }
    }

    public Collection getAffectedObjects() {
        if (this.wpDescList != null) {
            return this.wpDescList;
        }
        return super.getAffectedObjects();
    }

    static boolean addToDescriptorLists(Task task, Activity activity, List taskDescList, List roleDescList, List wpDescList, Map wpDescToDeliverableParts, Set descriptorsToRefresh, Map descriptorToNewFeatureValuesMap, MethodConfiguration config, Set synchFeatures) {
        TaskDescriptor desc = ProcessCommandUtil.createTaskDescriptor(task, activity, roleDescList, wpDescList, wpDescToDeliverableParts, null, descriptorsToRefresh, descriptorToNewFeatureValuesMap, config, synchFeatures);
        if (desc != null && taskDescList != null && !taskDescList.contains(desc)) {
            taskDescList.add(desc);
        }
        return desc != null;
    }

    static void addResponsibleRole(WorkProductDescriptor wpDesc, Activity activity, List roleDescList, Set descriptorsToRefresh, MethodConfiguration config) {
        ProcessCommandUtil.createRoleDescriptor(wpDesc, activity, roleDescList, descriptorsToRefresh, config);
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        if (this.wpdToTaskFeaturesMap != null) {
            this.wpdToTaskFeaturesMap.clear();
        }
        super.dispose();
    }
}

