/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.BreakdownElement;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodElement;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public final class Comparators {
    public static final Comparator DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof MethodElement && o2 instanceof MethodElement) {
                return ((MethodElement)o1).getName().compareToIgnoreCase(((MethodElement)o2).getName());
            }
            Object o1unwrap = TngUtil.unwrap(o1);
            Object o2unwrap = TngUtil.unwrap(o2);
            if (o1unwrap instanceof MethodElement && o2unwrap instanceof MethodElement) {
                return ((MethodElement)o1unwrap).getName().compareToIgnoreCase(((MethodElement)o2unwrap).getName());
            }
            return 0;
        }
    };
    public static final Comparator PRESENTATION_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (!(o1 instanceof DescribableElement) && !((o1 = TngUtil.unwrap(o1)) instanceof DescribableElement)) {
                return 0;
            }
            if (!(o2 instanceof DescribableElement) && !((o2 = TngUtil.unwrap(o2)) instanceof DescribableElement)) {
                return 0;
            }
            return Comparators.comparePresentationName((DescribableElement)o1, (DescribableElement)o2);
        }
    };

    private static int comparePresentationName(DescribableElement e1, DescribableElement e2) {
        String name1 = e1 instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)e1) : e1.getPresentationName();
        String name2 = e2 instanceof BreakdownElement ? ProcessUtil.getPresentationName((BreakdownElement)e2) : e2.getPresentationName();
        return name1.compareToIgnoreCase(name2);
    }

    public static abstract class TypeComparator
    implements Comparator {
        protected Comparator getDefaultComparator() {
            return DEFAULT_COMPARATOR;
        }

        protected abstract int getOrderId(Object var1);

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            int ret = 0;
            ret = this.getOrderId((EObject)o1) - this.getOrderId((EObject)o2);
            if (ret == 0) {
                return this.getDefaultComparator().compare(o1, o2);
            }
            return ret;
        }
    }
}

