/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.NamedElement;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProductDescriptor;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.INameProvider;

public final class NameChecker {
    private static final String ELEMENT_TEXT = LibraryEditResources.getString("LibraryEdit.element.text");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, final Class type, INameProvider nameProvider, String newName, Suppression suppresion, boolean ignoreSuppressed) {
        IFilter childFilter = new IFilter(){

            public boolean accept(Object obj) {
                return type.isInstance(obj);
            }
        };
        return NameChecker.checkName(adapterFactory, parent, e, childFilter, nameProvider, newName, suppresion, ignoreSuppressed);
    }

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, IFilter childFilter, EStructuralFeature nameFeature, String newName, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName(adapterFactory, parent, e, childFilter, NameChecker.createNameProvider(nameFeature), newName, suppression, ignoreSuppressed);
    }

    private static String checkName(AdapterFactory adapterFactory, Object parent, Object e, IFilter childFilter, INameProvider nameProvider, String newName, Suppression suppression, boolean ignoreSuppressed) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
        if (ignoreSuppressed && suppression != null && suppression.isSuppressed(e)) {
            return null;
        }
        Collection children = adapter.getChildren(parent);
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            String name;
            Object child;
            Object item = iter.next();
            if (suppression != null && suppression.isSuppressed(item) || (child = TngUtil.unwrap(item)) == e || !childFilter.accept(child) || !(name = nameProvider.getName(child)).equalsIgnoreCase(newName)) continue;
            return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
        }
        return null;
    }

    private static INameProvider createNameProvider(final EStructuralFeature nameFeature) {
        return new INameProvider(){

            public String getName(Object object) {
                if (object instanceof BreakdownElement && nameFeature == UmaPackage.eINSTANCE.getDescribableElement_PresentationName()) {
                    return ProcessUtil.getPresentationName((BreakdownElement)object);
                }
                if (object instanceof EObject) {
                    return (String)((EObject)object).eGet(nameFeature);
                }
                return null;
            }
        };
    }

    public static String checkName(AdapterFactory adapterFactory, Object e, Class type, EStructuralFeature nameFeature, String newName, Suppression suppression) {
        return NameChecker.checkName(adapterFactory, e, type, NameChecker.createNameProvider(nameFeature), newName, suppression, false);
    }

    private static String checkName(AdapterFactory adapterFactory, Object e, Class type, INameProvider nameProvider, String newName, Suppression suppression, boolean ignoreSuppressed) {
        ITreeItemContentProvider adapter;
        Object parent;
        String elementType = e instanceof NamedElement ? TngUtil.getTypeText((EObject)((NamedElement)e)) : ELEMENT_TEXT;
        if (newName == null || newName.trim().length() == 0) {
            return LibraryEditResources.formatString("LibraryEdit.emptyElementNameError.msg", StrUtil.toLower((String)elementType));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = (adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, (Object)clazz)).getParent(e)) == null) {
            return null;
        }
        return NameChecker.checkName(adapterFactory, parent, e, type, nameProvider, newName, suppression, ignoreSuppressed);
    }

    private static Class chooseType(BreakdownElement e) {
        if (e instanceof Activity) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.ibm.uma.Activity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (e instanceof TaskDescriptor) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.ibm.uma.TaskDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (e instanceof RoleDescriptor) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("com.ibm.uma.RoleDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        if (e instanceof WorkProductDescriptor) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("com.ibm.uma.WorkProductDescriptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return e.getClass();
    }

    private static String checkNameInScope(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, IFilter childFilter, Suppression suppression, boolean ignoreSuppressed) {
        Object currentParent;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider itemProvider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, (Object)clazz);
        Object parent = currentParent = itemProvider.getParent((Object)e);
        while (parent != null) {
            String msg = NameChecker.checkName(adapterFactory, parent, (Object)e, childFilter, feature, name, suppression, ignoreSuppressed);
            if (msg != null) {
                return msg;
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            itemProvider = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz2);
            parent = itemProvider.getParent(parent);
        }
        if (currentParent != null) {
            AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, currentParent, false);
            while (iter.hasNext()) {
                String childName;
                Object child = TngUtil.unwrap(iter.next());
                if (child == e || !childFilter.accept(child) || !name.equalsIgnoreCase(childName = (String)((EObject)child).eGet(feature))) continue;
                return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", name);
            }
        }
        return null;
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, Suppression suppression) {
        return NameChecker.checkName_(adapterFactory, e, feature, name, suppression, false);
    }

    public static String checkName(AdapterFactory adapterFactory, BreakdownElement e, EStructuralFeature feature, String name, Suppression suppression, boolean ignoreSuppressed) {
        return NameChecker.checkName_(adapterFactory, e, feature, name, suppression, ignoreSuppressed);
    }

    private static String checkName_(AdapterFactory adapterFactory, final BreakdownElement e, EStructuralFeature feature, String name, Suppression suppression, boolean ignoreSuppressed) {
        Class type = NameChecker.chooseType(e);
        String msg = null;
        msg = ignoreSuppressed ? NameChecker.checkName(adapterFactory, e, type, NameChecker.createNameProvider(feature), name, suppression, ignoreSuppressed) : NameChecker.checkName(adapterFactory, (Object)e, type, feature, name, suppression);
        if (msg != null) {
            return msg;
        }
        IFilter childFilter = null;
        if (e instanceof TeamProfile) {
            childFilter = new IFilter(){

                public boolean accept(Object obj) {
                    return e instanceof TeamProfile;
                }
            };
        }
        if (childFilter != null) {
            return NameChecker.checkNameInScope(adapterFactory, e, feature, name, childFilter, suppression, ignoreSuppressed);
        }
        return null;
    }
}

