/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.UmaUtil;
import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;

public class ContentElementNameValidator
extends UniquenessValidator {
    public ContentElementNameValidator(EObject container, ContentElement e, IFilter childFilter) {
        super(container, (EStructuralFeature)UmaPackage.eINSTANCE.getContentPackage_ContentElements(), childFilter, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), "element name");
    }

    public ContentElementNameValidator(EObject parent, EStructuralFeature containingFeature, ContentElement e, IFilter childFilter) {
        super(parent, containingFeature, childFilter, (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), "element name");
    }

    public String isValid(String newText) {
        ContentElement e = (ContentElement)this.object;
        String msg = TngUtil.checkElementName(newText, TngUtil.getTypeText((EObject)e));
        if (msg != null) {
            return msg;
        }
        if (this.container != null && ContentDescriptionFactory.hasPresentation((MethodElement)e)) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)this.container);
            File pluginDir = new File(plugin.eResource().getURI().toFileString()).getParentFile();
            String folderPath = ContentDescriptionFactory.getMethodLibraryPersister().getFolderRelativePath((MethodElement)e);
            String dir = pluginDir.getAbsolutePath() + File.separator + folderPath;
            String fileName = String.valueOf(newText) + ContentDescriptionFactory.getMethodLibraryPersister().getFileExtension((Object)e);
            File file = new File(dir, fileName);
            File currentFile = null;
            ContentDescription content = e.getPresentation();
            currentFile = content.eResource() != null ? new File(content.eResource().getURI().toFileString()) : file;
            if (file.exists() && !file.equals(currentFile)) {
                return LibraryEditResources.formatString("LibraryEdit.duplicateContentFileError.msg", file);
            }
        }
        return super.isValid(newText);
    }
}

