/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.util.XMLTypeFeatures;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public final class FeatureMapUtil {
    protected static final Class VALIDATOR_CLASS;
    protected static Validator NULL_VALIDATOR;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.ecore.util.FeatureMapUtil$Validator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VALIDATOR_CLASS = clazz;
        NULL_VALIDATOR = new Validator(){

            public boolean isValid(EStructuralFeature eStructuralFeature) {
                return true;
            }
        };
    }

    private FeatureMapUtil() {
    }

    public static void addText(FeatureMap featureMap, String text) {
        featureMap.add(XMLTypeFeatures.TEXT, text);
    }

    public static void addText(FeatureMap featureMap, int index, String text) {
        featureMap.add(index, XMLTypeFeatures.TEXT, text);
    }

    public static boolean isText(FeatureMap.Entry entry) {
        return entry.getEStructuralFeature() == XMLTypeFeatures.TEXT;
    }

    public static boolean isText(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature == XMLTypeFeatures.TEXT;
    }

    public static void addCDATA(FeatureMap featureMap, String cdata) {
        featureMap.add(XMLTypeFeatures.CDATA, cdata);
    }

    public static void addCDATA(FeatureMap featureMap, int index, String cdata) {
        featureMap.add(index, XMLTypeFeatures.CDATA, cdata);
    }

    public static boolean isCDATA(FeatureMap.Entry entry) {
        return entry.getEStructuralFeature() == XMLTypeFeatures.CDATA;
    }

    public static boolean isCDATA(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature == XMLTypeFeatures.CDATA;
    }

    public static void addComment(FeatureMap featureMap, String comment) {
        featureMap.add(XMLTypeFeatures.COMMENT, comment);
    }

    public static void addComment(FeatureMap featureMap, int index, String comment) {
        featureMap.add(index, XMLTypeFeatures.COMMENT, comment);
    }

    public static boolean isComment(FeatureMap.Entry entry) {
        return entry.getEStructuralFeature() == XMLTypeFeatures.COMMENT;
    }

    public static boolean isComment(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature == XMLTypeFeatures.COMMENT;
    }

    public static boolean isFeatureMap(EStructuralFeature eStructuralFeature) {
        return ((EStructuralFeatureImpl)eStructuralFeature).isFeatureMap();
    }

    public static boolean isFeatureMapEntry(EClassifier eClassifier) {
        return eClassifier.getInstanceClassName() == "org.eclipse.emf.ecore.util.FeatureMap$Entry";
    }

    public static FeatureMap.Entry createTextEntry(String value) {
        return XMLTypeFeatures.TEXT_PROTOTYPE.createEntry(value);
    }

    public static FeatureMap.Entry createCDATAEntry(String value) {
        return XMLTypeFeatures.CDATA_PROTOTYPE.createEntry(value);
    }

    public static FeatureMap.Entry createCommentEntry(String value) {
        return XMLTypeFeatures.COMMENT_PROTOTYPE.createEntry(value);
    }

    public static FeatureMap.Entry createEntry(EStructuralFeature eStructuralFeature, Object value) {
        FeatureMap.Entry.Internal prototype = ((EStructuralFeature.Internal)eStructuralFeature).getFeatureMapEntryPrototype();
        prototype.validate(value);
        return prototype.createEntry(value);
    }

    public static FeatureMap.Entry.Internal createRawEntry(EStructuralFeature eStructuralFeature, Object value) {
        FeatureMap.Entry.Internal prototype = ((EStructuralFeature.Internal)eStructuralFeature).getFeatureMapEntryPrototype();
        return prototype.createEntry(value);
    }

    public static FeatureMap.Entry.Internal createRawTextEntry(String value) {
        return XMLTypeFeatures.TEXT_PROTOTYPE.createEntry(value);
    }

    public static FeatureMap.Entry.Internal createRawCDATAEntry(String value) {
        return XMLTypeFeatures.CDATA_PROTOTYPE.createEntry(value);
    }

    public static FeatureMap.Entry.Internal createRawCommentEntry(String value) {
        return XMLTypeFeatures.COMMENT_PROTOTYPE.createEntry(value);
    }

    public static Validator getValidator(EClass containingClass, EStructuralFeature eStructuralFeature) {
        Map validatorMap;
        Validator result;
        if (eStructuralFeature == null) {
            return NULL_VALIDATOR;
        }
        BasicExtendedMetaData.EStructuralFeatureExtendedMetaData.Holder holder = (BasicExtendedMetaData.EStructuralFeatureExtendedMetaData.Holder)((Object)eStructuralFeature);
        BasicExtendedMetaData.EStructuralFeatureExtendedMetaData extendedMetaData = holder.getExtendedMetaData();
        if (extendedMetaData == null) {
            ExtendedMetaData.INSTANCE.getName(eStructuralFeature);
            extendedMetaData = holder.getExtendedMetaData();
        }
        if ((result = (Validator)(validatorMap = extendedMetaData.getValidatorMap()).get(containingClass)) == null) {
            result = new BasicValidator(containingClass, eStructuralFeature);
            validatorMap.put(containingClass, result);
        }
        return result;
    }

    public static boolean isMany(EObject owner, EStructuralFeature feature) {
        int upperBound = feature.getUpperBound();
        if (upperBound == -2) {
            EClass eclass = owner.eClass();
            if (eclass.getFeatureID(feature) >= 0) {
                return false;
            }
            if (feature.getEContainingClass().getEPackage() == XMLTypePackage.eINSTANCE) {
                return true;
            }
            EStructuralFeature affiliation = ExtendedMetaData.INSTANCE.getAffiliation(eclass, feature);
            return affiliation == null || affiliation.isMany() && ExtendedMetaData.INSTANCE.getFeatureKind(affiliation) != 3;
        }
        return upperBound == -1 || upperBound > 1 || FeatureMapUtil.isFeatureMap(feature);
    }

    public static class EntryImpl
    implements FeatureMap.Entry {
        protected final EStructuralFeature eStructuralFeature;
        protected final Object value;

        public EntryImpl(EStructuralFeature eStructuralFeature, Object value) {
            this.eStructuralFeature = eStructuralFeature;
            this.value = value;
            this.validate();
        }

        protected void validate() {
            if (this.value != null && !this.eStructuralFeature.getEType().isInstance(this.value)) {
                String valueClass = this.value instanceof EObject ? ((EObject)this.value).eClass().getName() : this.value.getClass().getName();
                throw new ClassCastException("The feature '" + this.eStructuralFeature.getName() + "'s type '" + this.eStructuralFeature.getEType().getName() + "' does not permit a value of type '" + valueClass + "'");
            }
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.eStructuralFeature;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof FeatureMap.Entry)) {
                return false;
            }
            FeatureMap.Entry entry = (FeatureMap.Entry)that;
            return entry.getEStructuralFeature() == this.eStructuralFeature && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return this.eStructuralFeature.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            String prefix = this.eStructuralFeature.getEContainingClass().getEPackage().getNsPrefix();
            this.eStructuralFeature.getName();
            return String.valueOf(prefix != null && prefix.length() != 0 ? String.valueOf(prefix) + ":" + this.eStructuralFeature.getName() : this.eStructuralFeature.getName()) + "=" + this.value;
        }
    }

    public static abstract class BasicFeatureEIterator
    implements ListIterator {
        protected final EStructuralFeature eStructuralFeature;
        protected final FeatureMap.Internal featureMap;
        protected int entryCursor;
        protected int cursor;
        protected int prepared;
        protected Object preparedResult;
        protected int expectedModCount;
        protected int lastCursor;
        protected boolean isFeatureMap;
        protected Validator validator;

        public BasicFeatureEIterator(EStructuralFeature eStructuralFeature, FeatureMap.Internal featureMap) {
            this.eStructuralFeature = eStructuralFeature;
            this.featureMap = featureMap;
            this.expectedModCount = featureMap.getModCount();
            this.isFeatureMap = FeatureMapUtil.isFeatureMap(eStructuralFeature);
            this.validator = FeatureMapUtil.getValidator(featureMap.getEObject().eClass(), eStructuralFeature);
        }

        protected boolean resolve() {
            return false;
        }

        protected Object extractValue(FeatureMap.Entry entry) {
            return this.isFeatureMap ? entry : entry.getValue();
        }

        public boolean hasNext() {
            switch (this.prepared) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: {
                    ++this.entryCursor;
                }
            }
            return this.scanNext();
        }

        protected abstract boolean scanNext();

        public Object next() {
            if (this.hasNext()) {
                this.checkModCount();
                if (this.resolve()) {
                    this.preparedResult = this.featureMap.resolveProxy(this.eStructuralFeature, this.entryCursor, this.cursor, this.preparedResult);
                }
                this.lastCursor = this.cursor++;
                ++this.entryCursor;
                this.prepared = 0;
                return this.preparedResult;
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this.cursor;
        }

        public boolean hasPrevious() {
            switch (this.prepared) {
                case -2: {
                    return true;
                }
                case -1: {
                    return false;
                }
                case 1: {
                    --this.entryCursor;
                }
            }
            return this.scanPrevious();
        }

        protected abstract boolean scanPrevious();

        public Object previous() {
            if (this.hasPrevious()) {
                this.checkModCount();
                this.lastCursor = --this.cursor;
                if (this.resolve()) {
                    this.preparedResult = this.featureMap.resolveProxy(this.eStructuralFeature, this.entryCursor, this.cursor, this.preparedResult);
                }
                this.prepared = 0;
                return this.preparedResult;
            }
            throw new NoSuchElementException();
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void add(Object o) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                this.featureMap.add(this.eStructuralFeature, this.cursor, o);
                this.expectedModCount = this.featureMap.getModCount();
                this.next();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void remove() {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                this.featureMap.remove(this.eStructuralFeature, this.lastCursor);
                this.expectedModCount = this.featureMap.getModCount();
                if (this.lastCursor < this.cursor) {
                    --this.cursor;
                    --this.entryCursor;
                }
                --this.lastCursor;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void set(Object o) {
            if (this.lastCursor == -1) {
                throw new IllegalStateException();
            }
            this.checkModCount();
            try {
                this.featureMap.set(this.eStructuralFeature, this.lastCursor, o);
                this.expectedModCount = this.featureMap.getModCount();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        protected void checkModCount() {
            if (this.featureMap.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    public static class FeatureEList
    extends AbstractList
    implements InternalEList.Unsettable,
    EStructuralFeature.Setting {
        protected EStructuralFeature feature;
        protected FeatureMap.Internal featureMap;

        public FeatureEList(EStructuralFeature feature, FeatureMap.Internal featureMap) {
            this.feature = feature;
            this.featureMap = featureMap;
        }

        public int size() {
            return this.featureMap.size(this.getEStructuralFeature());
        }

        public boolean isEmpty() {
            return this.featureMap.isEmpty(this.getEStructuralFeature());
        }

        public boolean contains(Object object) {
            return this.featureMap.contains(this.getEStructuralFeature(), object);
        }

        public int indexOf(Object object) {
            return this.featureMap.indexOf(this.getEStructuralFeature(), object);
        }

        public int lastIndexOf(Object object) {
            return this.featureMap.lastIndexOf(this.getEStructuralFeature(), object);
        }

        public boolean containsAll(Collection collection) {
            return this.featureMap.containsAll(this.getEStructuralFeature(), collection);
        }

        public Iterator iterator() {
            return this.featureMap.iterator(this.getEStructuralFeature());
        }

        public ListIterator listIterator() {
            return this.featureMap.listIterator(this.getEStructuralFeature());
        }

        public ListIterator listIterator(int index) {
            return this.featureMap.listIterator(this.getEStructuralFeature(), index);
        }

        public Object basicGet(int index) {
            return this.featureMap.get(this.getEStructuralFeature(), index, false);
        }

        public List basicList() {
            return this.featureMap.basicList(this.getEStructuralFeature());
        }

        public Iterator basicIterator() {
            return this.featureMap.basicIterator(this.getEStructuralFeature());
        }

        public ListIterator basicListIterator() {
            return this.featureMap.basicListIterator(this.getEStructuralFeature());
        }

        public ListIterator basicListIterator(int index) {
            return this.featureMap.basicListIterator(this.getEStructuralFeature(), index);
        }

        public Object[] toArray() {
            return this.featureMap.toArray(this.getEStructuralFeature());
        }

        public Object[] toArray(Object[] array) {
            return this.featureMap.toArray(this.getEStructuralFeature(), array);
        }

        public boolean add(Object object) {
            return this.featureMap.add(this.getEStructuralFeature(), object);
        }

        public void add(int index, Object object) {
            this.featureMap.add(this.getEStructuralFeature(), index, object);
        }

        public boolean addAll(Collection collection) {
            return this.featureMap.addAll(this.getEStructuralFeature(), collection);
        }

        public boolean addAll(int index, Collection collection) {
            return this.featureMap.addAll(this.getEStructuralFeature(), index, collection);
        }

        public void addUnique(Object object) {
            this.featureMap.addUnique(this.getEStructuralFeature(), object);
        }

        public void addUnique(int index, Object object) {
            this.featureMap.addUnique(this.getEStructuralFeature(), index, object);
        }

        public boolean addAllUnique(Collection collection) {
            this.modCount = -1;
            return this.featureMap.addAllUnique(collection);
        }

        public void addUnique(FeatureMap.Entry.Internal entry) {
            this.modCount = -1;
            this.featureMap.addUnique(entry);
        }

        public boolean addAllUnique(FeatureMap.Entry.Internal[] entries, int start, int end) {
            this.modCount = -1;
            BasicEList collection = new BasicEList();
            if (start == 0) {
                collection.setData(end, (Object[])entries);
            } else {
                collection.grow(end - start);
                int i = start;
                while (i < end) {
                    collection.add((Object)entries[i]);
                    ++i;
                }
            }
            return this.featureMap.addAllUnique((Collection)collection);
        }

        public NotificationChain basicAdd(Object object, NotificationChain notifications) {
            return this.featureMap.basicAdd(this.getEStructuralFeature(), object, notifications);
        }

        public boolean remove(Object object) {
            return this.featureMap.remove(this.getEStructuralFeature(), object);
        }

        public Object remove(int index) {
            return this.featureMap.remove(this.getEStructuralFeature(), index);
        }

        public NotificationChain basicRemove(Object object, NotificationChain notifications) {
            return this.featureMap.basicRemove(this.getEStructuralFeature(), object, notifications);
        }

        public boolean removeAll(Collection collection) {
            return this.featureMap.removeAll(this.getEStructuralFeature(), collection);
        }

        public boolean retainAll(Collection collection) {
            return this.featureMap.retainAll(this.getEStructuralFeature(), collection);
        }

        public void clear() {
            this.featureMap.clear(this.getEStructuralFeature());
        }

        public void move(int index, Object object) {
            this.featureMap.move(this.getEStructuralFeature(), index, object);
        }

        public Object move(int targetIndex, int sourceIndex) {
            return this.featureMap.move(this.getEStructuralFeature(), targetIndex, sourceIndex);
        }

        public Object get(int index) {
            return this.featureMap.get(this.getEStructuralFeature(), index, true);
        }

        public Object set(int index, Object object) {
            return this.featureMap.set(this.getEStructuralFeature(), index, object);
        }

        public Object setUnique(int index, Object object) {
            return this.featureMap.setUnique(this.getEStructuralFeature(), index, object);
        }

        public Object get(boolean resolve) {
            return this;
        }

        public void set(Object newValue) {
            this.clear();
            this.addAll((Collection)((List)newValue));
        }

        public boolean isSet() {
            return !this.isEmpty();
        }

        public void unset() {
            this.clear();
        }

        public Object getFeature() {
            return this.getEStructuralFeature();
        }

        public int getFeatureID() {
            return this.getEStructuralFeature().getFeatureID();
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        public EObject getEObject() {
            return this.featureMap.getEObject();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            Iterator i = this.basicIterator();
            while (i.hasNext()) {
                stringBuffer.append(String.valueOf(i.next()));
                if (!i.hasNext()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public static class Basic
        extends FeatureEList {
            public Basic(EStructuralFeature feature, FeatureMap.Internal featureMap) {
                super(feature, featureMap);
            }

            public Iterator iterator() {
                return this.basicIterator();
            }

            public ListIterator listIterator() {
                return this.basicListIterator();
            }

            public ListIterator listIterator(int index) {
                return this.basicListIterator(index);
            }

            public List basicList() {
                return this;
            }
        }
    }

    public static class FeatureFeatureMap
    extends FeatureEList
    implements FeatureMap.Internal,
    FeatureMap.Internal.Wrapper {
        protected FeatureMap.Internal.Wrapper wrapper = this;

        public FeatureFeatureMap(EStructuralFeature feature, FeatureMap.Internal featureMap) {
            super(feature, featureMap);
        }

        public FeatureMap.ValueListIterator valueListIterator() {
            return this.featureMap.valueListIterator();
        }

        public FeatureMap.ValueListIterator valueListIterator(int index) {
            return this.featureMap.valueListIterator(index);
        }

        public EList list(EStructuralFeature feature) {
            return this.featureMap.list(feature);
        }

        public EStructuralFeature getEStructuralFeature(int index) {
            return ((FeatureMap.Entry)this.featureMap.get(this.getEStructuralFeature(), index, false)).getEStructuralFeature();
        }

        public Object getValue(int index) {
            return ((FeatureMap.Entry)this.featureMap.get(this.getEStructuralFeature(), index, false)).getValue();
        }

        public Object setValue(int index, Object value) {
            FeatureMap.Entry entry = (FeatureMap.Entry)this.featureMap.get(this.getEStructuralFeature(), index, false);
            this.set(index, (Object)FeatureMapUtil.createEntry(entry.getEStructuralFeature(), value));
            return entry.getValue();
        }

        public boolean add(EStructuralFeature feature, Object value) {
            return this.featureMap.add(feature, value);
        }

        public void add(int index, EStructuralFeature feature, Object value) {
            this.add(index, FeatureMapUtil.isFeatureMap(feature) ? value : FeatureMapUtil.createEntry(feature, value));
        }

        public void add(EStructuralFeature feature, int index, Object value) {
            this.featureMap.add(feature, index, value);
        }

        public boolean addAll(EStructuralFeature feature, Collection values) {
            return this.featureMap.addAll(feature, values);
        }

        public boolean addAll(int index, EStructuralFeature feature, Collection values) {
            if (FeatureMapUtil.isFeatureMap(feature)) {
                return this.addAll(index, values);
            }
            ArrayList<FeatureMap.Entry> entries = new ArrayList<FeatureMap.Entry>(values.size());
            Iterator i = values.iterator();
            while (i.hasNext()) {
                entries.add(FeatureMapUtil.createEntry(feature, i.next()));
            }
            return this.addAll(index, (Collection)entries);
        }

        public boolean addAll(EStructuralFeature feature, int index, Collection values) {
            return this.featureMap.addAll(feature, index, values);
        }

        public int getModCount() {
            return this.featureMap.getModCount();
        }

        public EObject getEObject() {
            return this.featureMap.getEObject();
        }

        public Object resolveProxy(EStructuralFeature feature, int entryIndex, int index, Object object) {
            return this.featureMap.resolveProxy(feature, entryIndex, index, object);
        }

        public int size(EStructuralFeature feature) {
            return this.featureMap.size(feature);
        }

        public boolean isEmpty(EStructuralFeature feature) {
            return this.featureMap.isEmpty(feature);
        }

        public boolean contains(EStructuralFeature feature, Object object) {
            return this.featureMap.contains(feature, object);
        }

        public boolean containsAll(EStructuralFeature feature, Collection collection) {
            return this.featureMap.containsAll(feature, collection);
        }

        public int indexOf(EStructuralFeature feature, Object object) {
            return this.featureMap.indexOf(feature, object);
        }

        public int lastIndexOf(EStructuralFeature feature, Object object) {
            return this.featureMap.lastIndexOf(feature, object);
        }

        public Iterator iterator(EStructuralFeature feature) {
            return this.featureMap.iterator(feature);
        }

        public ListIterator listIterator(EStructuralFeature feature) {
            return this.featureMap.listIterator(feature);
        }

        public ListIterator listIterator(EStructuralFeature feature, int index) {
            return this.featureMap.listIterator(feature, index);
        }

        public EStructuralFeature.Setting setting(EStructuralFeature feature) {
            return this.featureMap.setting(feature);
        }

        public List basicList(EStructuralFeature feature) {
            return this.featureMap.basicList(feature);
        }

        public Iterator basicIterator(EStructuralFeature feature) {
            return this.featureMap.basicIterator(feature);
        }

        public ListIterator basicListIterator(EStructuralFeature feature) {
            return this.featureMap.basicListIterator(feature);
        }

        public ListIterator basicListIterator(EStructuralFeature feature, int index) {
            return this.featureMap.basicListIterator(feature, index);
        }

        public Object[] toArray(EStructuralFeature feature) {
            return this.featureMap.toArray(feature);
        }

        public Object[] toArray(EStructuralFeature feature, Object[] array) {
            return this.featureMap.toArray(feature, array);
        }

        public void addUnique(EStructuralFeature feature, Object object) {
            this.featureMap.addUnique(feature, object);
        }

        public void addUnique(EStructuralFeature feature, int index, Object object) {
            this.featureMap.addUnique(feature, index, object);
        }

        public NotificationChain basicAdd(EStructuralFeature feature, Object object, NotificationChain notifications) {
            return this.featureMap.basicAdd(feature, object, notifications);
        }

        public boolean remove(EStructuralFeature feature, Object object) {
            return this.featureMap.remove(feature, object);
        }

        public Object remove(EStructuralFeature feature, int index) {
            return this.featureMap.remove(feature, index);
        }

        public boolean removeAll(EStructuralFeature feature, Collection collection) {
            return this.featureMap.removeAll(feature, collection);
        }

        public NotificationChain basicRemove(EStructuralFeature feature, Object object, NotificationChain notifications) {
            return this.featureMap.basicRemove(feature, object, notifications);
        }

        public boolean retainAll(EStructuralFeature feature, Collection collection) {
            return this.featureMap.retainAll(feature, collection);
        }

        public void clear(EStructuralFeature feature) {
            this.featureMap.clear(feature);
        }

        public void move(EStructuralFeature feature, int index, Object object) {
            this.featureMap.move(feature, index, object);
        }

        public Object move(EStructuralFeature feature, int targetIndex, int sourceIndex) {
            return this.featureMap.move(feature, targetIndex, sourceIndex);
        }

        public Object get(EStructuralFeature feature, boolean resolve) {
            return this.featureMap.get(feature, resolve);
        }

        public Object get(EStructuralFeature feature, int index, boolean resolve) {
            return this.featureMap.get(feature, index, resolve);
        }

        public void set(EStructuralFeature feature, Object object) {
            this.featureMap.set(feature, object);
        }

        public Object set(EStructuralFeature feature, int index, Object object) {
            return this.featureMap.set(feature, index, object);
        }

        public Object setUnique(EStructuralFeature feature, int index, Object object) {
            return this.featureMap.setUnique(feature, index, object);
        }

        public boolean isSet(EStructuralFeature feature) {
            return this.featureMap.isSet(feature);
        }

        public void unset(EStructuralFeature feature) {
            this.featureMap.unset(feature);
        }

        public FeatureMap.Internal.Wrapper getWrapper() {
            return this.wrapper;
        }

        public void setWrapper(FeatureMap.Internal.Wrapper wrapper) {
            this.wrapper = wrapper;
        }

        public FeatureMap featureMap() {
            return this;
        }
    }

    public static class FeatureValue
    implements EStructuralFeature.Setting {
        protected EStructuralFeature feature;
        protected FeatureMap.Internal featureMap;

        public FeatureValue(EStructuralFeature feature, FeatureMap.Internal featureMap) {
            this.feature = feature;
            this.featureMap = featureMap;
        }

        public Object get(boolean resolve) {
            return this.featureMap.get(this.getEStructuralFeature(), -1, resolve);
        }

        public void set(Object newValue) {
            this.featureMap.set(this.getEStructuralFeature(), newValue);
        }

        public boolean isSet() {
            return !this.featureMap.isEmpty(this.getEStructuralFeature());
        }

        public void unset() {
            this.featureMap.clear(this.getEStructuralFeature());
        }

        public Object getFeature() {
            return this.getEStructuralFeature();
        }

        public int getFeatureID() {
            return this.getEStructuralFeature().getFeatureID();
        }

        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }

        public EObject getEObject() {
            return this.featureMap.getEObject();
        }
    }

    public static class FeatureENotificationImpl
    extends ENotificationImpl {
        public FeatureENotificationImpl(InternalEObject owner, int eventType, EStructuralFeature feature, Object oldObject, Object newObject, int index) {
            super(owner, eventType, feature, oldObject, newObject, index);
        }

        public FeatureENotificationImpl(InternalEObject owner, int eventType, EStructuralFeature feature, Object oldObject, Object newObject, int index, boolean wasSet) {
            super(owner, eventType, feature, oldObject, newObject, index, wasSet);
        }

        public int getFeatureID(Class expectedClass) {
            if (this.featureID == -1 && this.feature != null) {
                Class containerClass = this.feature.getContainerClass();
                this.featureID = containerClass == null ? this.notifier.eClass().getFeatureID(this.feature) : this.notifier.eDerivedStructuralFeatureID(this.feature.getFeatureID(), containerClass);
            }
            return this.notifier.eBaseStructuralFeatureID(this.featureID, expectedClass);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean merge(Notification notification) {
            switch (this.eventType) {
                case 1: 
                case 2: {
                    Object notificationNotifier = notification.getNotifier();
                    if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                    this.newValue = notification.getNewValue();
                    if (notification.getEventType() != 1) return true;
                    this.eventType = 1;
                    return true;
                }
                case 3: {
                    int notificationEventType = notification.getEventType();
                    switch (notificationEventType) {
                        case 3: {
                            Object notificationNotifier = notification.getNotifier();
                            if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                            this.eventType = 5;
                            BasicEList addedValues = new BasicEList(2);
                            addedValues.add(this.newValue);
                            addedValues.add(notification.getNewValue());
                            this.newValue = addedValues;
                            return true;
                        }
                    }
                    return false;
                }
                case 5: {
                    int notificationEventType = notification.getEventType();
                    switch (notificationEventType) {
                        case 3: {
                            Object notificationNotifier = notification.getNotifier();
                            if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                            ((Collection)this.newValue).add(notification.getNewValue());
                            return true;
                        }
                    }
                    return false;
                }
                case 4: {
                    int notificationEventType = notification.getEventType();
                    switch (notificationEventType) {
                        case 3: {
                            Object notificationNotifier = notification.getNotifier();
                            if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                            this.eventType = 1;
                            this.newValue = notification.getNewValue();
                            return true;
                        }
                        case 4: {
                            Object notificationNotifier = notification.getNotifier();
                            if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                            this.eventType = 6;
                            BasicEList removedValues = new BasicEList(2);
                            removedValues.add(this.oldValue);
                            removedValues.add(notification.getOldValue());
                            this.oldValue = removedValues;
                            int[] positions = new int[]{this.position, notification.getPosition()};
                            this.newValue = positions;
                            return true;
                        }
                    }
                    return false;
                }
                case 6: {
                    int notificationEventType = notification.getEventType();
                    switch (notificationEventType) {
                        case 4: {
                            Object notificationNotifier = notification.getNotifier();
                            if (notificationNotifier != this.getNotifier() || this.getFeatureID(null) != notification.getFeatureID(null)) return false;
                            ((Collection)this.oldValue).add(notification.getOldValue());
                            int[] positions = (int[])this.newValue;
                            int[] newPositions = new int[positions.length + 1];
                            System.arraycopy(positions, 0, newPositions, 0, positions.length);
                            newPositions[positions.length] = notification.getPosition();
                            this.newValue = newPositions;
                            return true;
                        }
                    }
                }
            }
            return false;
        }
    }

    public static interface Validator {
        public boolean isValid(EStructuralFeature var1);
    }

    public static class BasicValidator
    implements Validator {
        protected static final List ANY_WILDCARD = Collections.singletonList("##any");
        protected EClass containingClass;
        protected EStructuralFeature eStructuralFeature;
        protected List groupMembers;
        protected List wildcards;
        protected String name;
        protected boolean isElement;
        protected Cache cache = new Cache();

        public BasicValidator(EClass containingClass, EStructuralFeature eStructuralFeature) {
            this.containingClass = containingClass;
            this.eStructuralFeature = eStructuralFeature;
            this.wildcards = ExtendedMetaData.INSTANCE.getWildcards(eStructuralFeature);
            if (!this.wildcards.isEmpty()) {
                boolean bl = this.isElement = ExtendedMetaData.INSTANCE.getFeatureKind(eStructuralFeature) == 5;
                if (this.wildcards.equals(ANY_WILDCARD)) {
                    this.wildcards = ANY_WILDCARD;
                }
            } else if (ExtendedMetaData.INSTANCE.getMixedFeature(containingClass) == eStructuralFeature) {
                this.isElement = true;
                this.groupMembers = new ArrayList();
                this.wildcards = new UniqueEList();
                this.wildcards.add("http://www.eclipse.org/emf/2003/XMLType");
                if (ExtendedMetaData.INSTANCE.getDocumentRoot(containingClass.getEPackage()) == containingClass) {
                    this.wildcards.add(ExtendedMetaData.INSTANCE.getNamespace(containingClass));
                }
                Iterator i = ExtendedMetaData.INSTANCE.getAllElements(containingClass).iterator();
                while (i.hasNext()) {
                    EStructuralFeature feature = (EStructuralFeature)i.next();
                    switch (ExtendedMetaData.INSTANCE.getFeatureKind(feature)) {
                        case 4: {
                            this.groupMembers.add(feature);
                            break;
                        }
                        case 5: {
                            this.wildcards.addAll(ExtendedMetaData.INSTANCE.getWildcards(feature));
                        }
                    }
                }
            } else if (FeatureMapUtil.isFeatureMap(eStructuralFeature)) {
                this.isElement = true;
                this.wildcards = null;
                this.groupMembers = new ArrayList();
                int i = 0;
                int size = containingClass.getFeatureCount();
                while (i < size) {
                    EStructuralFeature feature = containingClass.getEStructuralFeature(i);
                    EStructuralFeature group = ExtendedMetaData.INSTANCE.getGroup(feature);
                    while (group != null) {
                        if (group == eStructuralFeature) {
                            this.groupMembers.add(feature);
                        }
                        group = ExtendedMetaData.INSTANCE.getGroup(group);
                    }
                    ++i;
                }
            } else {
                this.wildcards = null;
                this.isElement = true;
                this.groupMembers = Collections.singletonList(eStructuralFeature);
            }
        }

        public boolean isValid(EStructuralFeature feature) {
            if (this.eStructuralFeature == feature) {
                return true;
            }
            Boolean result = this.cache.get(feature);
            if (result == null) {
                if (this.isIncluded(feature)) {
                    this.cache.put(feature, Boolean.TRUE);
                    return true;
                }
                this.cache.put(feature, Boolean.FALSE);
                return false;
            }
            return result == Boolean.TRUE;
        }

        public boolean isIncluded(EStructuralFeature feature) {
            if (this.wildcards == ANY_WILDCARD) {
                int featureKind = ExtendedMetaData.INSTANCE.getFeatureKind(feature);
                return this.isElement ? featureKind == 4 && feature != XMLTypeFeatures.TEXT && feature != XMLTypeFeatures.CDATA && feature != XMLTypeFeatures.COMMENT : featureKind == 2;
            }
            if (this.groupMembers != null && (this.groupMembers.contains(feature) || this.groupMembers.contains(ExtendedMetaData.INSTANCE.getGroup(feature)) || this.groupMembers.contains(ExtendedMetaData.INSTANCE.getAffiliation(this.containingClass, feature)))) {
                return true;
            }
            if (this.wildcards != null && ExtendedMetaData.INSTANCE.matches(this.wildcards, ExtendedMetaData.INSTANCE.getNamespace(feature))) {
                int featureKind = ExtendedMetaData.INSTANCE.getFeatureKind(feature);
                return this.isElement ? featureKind == 4 : featureKind == 2;
            }
            return false;
        }

        protected class Cache
        extends WeakHashMap {
            protected Cache() {
            }

            public Boolean get(EStructuralFeature eStructuralFeature) {
                return (Boolean)this.get((Object)eStructuralFeature);
            }

            public void put(EStructuralFeature eStructuralFeature, Boolean isValid) {
                Cache newCache = new Cache();
                newCache.putAll(BasicValidator.this.cache);
                newCache.put(eStructuralFeature, isValid);
                BasicValidator.this.cache = newCache;
            }
        }
    }
}

