/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import com.ibm.uma.MethodPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.xml.wizards.ExportXmlWizard;
import org.eclipse.epf.export.xml.wizards.SelectXmlFilePage;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.BaseWizardPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class SelectPluginPage
extends BaseWizardPage
implements ISelectionChangedListener,
ICheckStateListener,
Listener {
    public static final String PAGE_NAME;
    private Table table;
    private CheckboxTableViewer ctrl_chkboxTableViewer;
    private Text ctrl_author;
    private Text ctrl_version;
    private Text ctrl_briefDesc;
    private int checkedCount = 0;
    private List checkedPluginList = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.export.xml.wizards.SelectPluginPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
    }

    public SelectPluginPage() {
        super(PAGE_NAME);
        this.setTitle(ExportResources.getString((String)"Export.selectPluginsPage.title"));
        this.setDescription(ExportResources.getString((String)"Export.selectPluginsPage.desc"));
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportMethodPlugins.gif"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.createLabel(container, ExportResources.getString((String)"Export.selectPluginsPage.pluginsLabel.text"));
        this.ctrl_chkboxTableViewer = this.createCheckboxTableViewer(container, 1);
        this.table = this.ctrl_chkboxTableViewer.getTable();
        List plugins = LibraryProcessor.getInstance().getMethodModels();
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_chkboxTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_chkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (plugins != null) {
            this.ctrl_chkboxTableViewer.setInput((Object)plugins.toArray());
        }
        this.createLabel(container, AuthoringUIText.AUTHORS_TEXT);
        this.ctrl_author = this.createTextMulti(container, "", 360, 40, 3);
        this.createLabel(container, AuthoringUIText.VERSION_TEXT);
        this.ctrl_version = this.createText(container, "", 360, 3);
        this.createLabel(container, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_briefDesc = this.createTextMulti(container, "", 360, 80, 3);
        if (plugins != null && !plugins.isEmpty()) {
            this.table.select(0);
            this.setDisplayAttributes((MethodPlugin)plugins.get(0));
        }
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void addListeners() {
        this.ctrl_chkboxTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ctrl_chkboxTableViewer.addCheckStateListener((ICheckStateListener)this);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object obj = event.getElement();
        if (event.getChecked()) {
            ++this.checkedCount;
            this.checkedPluginList.add(obj);
        } else {
            --this.checkedCount;
            this.checkedPluginList.remove(obj);
        }
        this.setPageComplete(this.isPageComplete());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] plugin = selection.toArray();
            this.setDisplayAttributes((MethodPlugin)plugin[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    private void setDisplayAttributes(MethodPlugin plugin) {
        this.ctrl_author.setText(plugin.getAuthors());
        this.ctrl_version.setText(plugin.getVersion());
        this.ctrl_briefDesc.setText(plugin.getBriefDescription());
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.checkedCount > 0;
    }

    public IWizardPage getNextPage() {
        ExportXmlWizard wizard = (ExportXmlWizard)this.getWizard();
        wizard.data.selectedPlugins = this.checkedPluginList;
        SelectXmlFilePage page = wizard.filePage;
        return page;
    }
}

