/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.figures;

import java.text.BreakIterator;
import java.util.StringTokenizer;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class WrappableLabel
extends Figure
implements PositionConstants {
    private static String ELLIPSIS = "...";
    private Image icon;
    private String text = "";
    private String subStringText;
    private Dimension textSize;
    private Dimension subStringTextSize;
    private Dimension iconSize = new Dimension(0, 0);
    private Point iconLocation;
    private Point textLocation;
    private int textAlignment = 2;
    private int iconAlignment = 2;
    private int labelAlignment = 2;
    private int textPlacement = 4;
    private int iconTextGap = 3;
    private static final int FLAG_SELECTED = MAX_FLAG << 1;
    private static final int FLAG_HASFOCUS = MAX_FLAG << 2;
    private static final int FLAG_WRAP = MAX_FLAG << 5;
    private static final int FLAG_WRAP_ALIGN = MAX_FLAG << 6;
    private Dimension textDimension = new Dimension(-1, -1);
    private Dimension prefSizeDimension = new Dimension(-1, -1);
    private int wrapWidth;

    public WrappableLabel() {
    }

    public WrappableLabel(String s) {
        this.setText(s);
    }

    public WrappableLabel(Image i) {
        this.setIcon(i);
    }

    public WrappableLabel(String s, Image i) {
        this.setText(s);
        this.setIcon(i);
    }

    private void alignOnHeight(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 8: {
                loc.y = insets.top;
                break;
            }
            case 32: {
                loc.y = this.bounds.height - size.height - insets.bottom;
                break;
            }
            default: {
                loc.y = (this.bounds.height - size.height) / 2;
            }
        }
    }

    private void alignOnWidth(Point loc, Dimension size, int alignment) {
        Insets insets = this.getInsets();
        switch (alignment) {
            case 1: {
                loc.x = insets.left;
                break;
            }
            case 4: {
                loc.x = this.bounds.width - size.width - insets.right;
                break;
            }
            default: {
                loc.x = (this.bounds.width - size.width) / 2;
            }
        }
    }

    private void calculateAlignment() {
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                this.alignOnHeight(this.textLocation, this.getTextSize(), this.textAlignment);
                this.alignOnHeight(this.iconLocation, this.iconSize, this.iconAlignment);
                break;
            }
            case 1: 
            case 4: {
                this.alignOnWidth(this.textLocation, this.getSubStringTextSize(), this.textAlignment);
                this.alignOnWidth(this.iconLocation, this.iconSize, this.iconAlignment);
            }
        }
    }

    protected Dimension calculateLabelSize(Dimension txtSize) {
        int gap = this.iconTextGap;
        if (this.getIcon() == null || this.getText().equals("")) {
            gap = 0;
        }
        Dimension d = new Dimension(0, 0);
        if (this.textPlacement == 8 || this.textPlacement == 16) {
            d.width = this.iconSize.width + gap + txtSize.width;
            d.height = Math.max(this.iconSize.height, txtSize.height);
        } else {
            d.width = Math.max(this.iconSize.width, txtSize.width);
            d.height = this.iconSize.height + gap + txtSize.height;
        }
        return d;
    }

    private void calculateLocations() {
        this.textLocation = new Point();
        this.iconLocation = new Point();
        this.calculatePlacement();
        this.calculateAlignment();
        Dimension offset = this.getSize().getDifference(this.getPreferredSize());
        offset.width += this.getTextSize().width - this.getSubStringTextSize().width;
        switch (this.labelAlignment) {
            case 2: {
                offset.scale(0.5);
                break;
            }
            case 1: {
                offset.scale(0.0);
                break;
            }
            case 4: {
                offset.scale(1.0);
                break;
            }
            case 8: {
                offset.height = 0;
                offset.scale(0.5);
                break;
            }
            case 32: {
                offset.height *= 2;
                offset.scale(0.5);
                break;
            }
            default: {
                offset.scale(0.5);
            }
        }
        switch (this.textPlacement) {
            case 8: 
            case 16: {
                offset.height = 0;
                break;
            }
            case 1: 
            case 4: {
                offset.width = 0;
            }
        }
        this.textLocation.translate(offset);
        this.iconLocation.translate(offset);
    }

    private void calculatePlacement() {
        int gap = this.iconTextGap;
        if (this.icon == null || this.text.equals("")) {
            gap = 0;
        }
        Insets insets = this.getInsets();
        switch (this.textPlacement) {
            case 16: {
                this.iconLocation.x = insets.left;
                this.textLocation.x = this.iconSize.width + gap + insets.left;
                break;
            }
            case 8: {
                this.textLocation.x = insets.left;
                this.iconLocation.x = this.getSubStringTextSize().width + gap + insets.left;
                break;
            }
            case 1: {
                this.textLocation.y = insets.top;
                this.iconLocation.y = this.getTextSize().height + gap + insets.top;
                break;
            }
            case 4: {
                this.textLocation.y = this.iconSize.height + gap + insets.top;
                this.iconLocation.y = insets.top;
            }
        }
    }

    protected Dimension calculateSubStringTextSize() {
        return FigureUtilities.getTextExtents((String)this.getSubStringText(), (Font)this.getFont());
    }

    protected Dimension calculateTextSize() {
        return FigureUtilities.getTextExtents((String)this.getWrappedText(this.getSize().width, this.getSize().height), (Font)this.getFont());
    }

    private void clearLocations() {
        this.textLocation = null;
        this.iconLocation = null;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getIconAlignment() {
        return this.iconAlignment;
    }

    public Rectangle getIconBounds() {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.getLocation().translate(this.getIconLocation()), this.iconSize);
    }

    protected Point getIconLocation() {
        if (this.iconLocation == null) {
            this.calculateLocations();
        }
        return this.iconLocation;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Dimension getMinimumSize(int w, int h) {
        if (this.minSize != null) {
            return this.minSize;
        }
        this.minSize = new Dimension();
        if (this.getLayoutManager() != null) {
            this.minSize.setSize(this.getLayoutManager().getMinimumSize((IFigure)this, w, h));
        }
        Dimension labelSize = this.calculateLabelSize(FigureUtilities.getTextExtents((String)ELLIPSIS, (Font)this.getFont()).intersect(FigureUtilities.getTextExtents((String)this.getText(), (Font)this.getFont())));
        Insets insets = this.getInsets();
        labelSize.expand(insets.getWidth(), insets.getHeight());
        this.minSize.union(labelSize);
        return this.minSize;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null || wHint != this.prefSizeDimension.width || hHint != this.prefSizeDimension.height) {
            this.prefSize = this.calculateLabelSize(this.getTextSize(wHint, hHint));
            Insets insets = this.getInsets();
            this.prefSize.expand(insets.getWidth(), insets.getHeight());
            if (this.getLayoutManager() != null) {
                this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
            }
        }
        if (wHint >= 0 && wHint < this.prefSize.width) {
            Dimension minSize = this.getMinimumSize(wHint, hHint);
            Dimension result = this.prefSize.getCopy();
            result.width = Math.min(result.width, wHint);
            this.prefSizeDimension.width = result.width = Math.max(minSize.width, result.width);
            this.prefSizeDimension.height = result.width;
            return result;
        }
        return this.prefSize;
    }

    public String getSubStringText() {
        if (this.subStringText != null) {
            return this.subStringText;
        }
        this.subStringText = this.text;
        Dimension shrink = this.getPreferredSize(this.getSize().width, this.getSize().height).getDifference(this.getSize());
        Dimension effectiveSize = this.getTextSize().getExpanded(-shrink.width, -shrink.height);
        Font currentFont = this.getFont();
        int fontHeight = FigureUtilities.getFontMetrics((Font)currentFont).getHeight();
        int maxLines = (int)((double)effectiveSize.height / (double)fontHeight);
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(this.getText());
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), currentFont, effectiveSize.width);
            if (accumlatedText.length() > 0) {
                accumlatedText.append("\n");
            }
            if (i == 0 || remainingText.length() > i && j == maxLines) {
                int dotsWidth = FigureUtilities.getTextExtents((String)WrappableLabel.ELLIPSIS, (Font)currentFont).width;
                i = WrappableLabel.getLargestSubstringConfinedTo(remainingText.toString(), currentFont, Math.max(effectiveSize.width - dotsWidth, 0));
                accumlatedText.append(remainingText.substring(0, i));
                accumlatedText.append(ELLIPSIS);
            } else {
                accumlatedText.append(remainingText.substring(0, i));
            }
            remainingText.delete(0, i);
        }
        this.subStringText = accumlatedText.toString();
        return this.subStringText;
    }

    protected Dimension getSubStringTextSize() {
        if (this.subStringTextSize == null) {
            this.subStringTextSize = this.calculateSubStringTextSize();
        }
        return this.subStringTextSize;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.textAlignment;
    }

    public Rectangle getTextBounds() {
        Rectangle bounds = this.getBounds();
        return new Rectangle(bounds.getLocation().translate(this.getTextLocation()), this.textSize);
    }

    protected Point getTextLocation() {
        if (this.textLocation != null) {
            return this.textLocation;
        }
        this.calculateLocations();
        return this.textLocation;
    }

    public int getTextPlacement() {
        return this.textPlacement;
    }

    protected Dimension getTextSize() {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize();
        }
        return this.textSize;
    }

    protected Dimension getTextSize(int width, int height) {
        if (this.textSize == null) {
            this.textSize = this.calculateTextSize(width, height);
            this.textDimension.width = width;
            this.textDimension.height = height;
        }
        return this.textSize;
    }

    public void invalidate() {
        this.prefSize = null;
        this.minSize = null;
        this.clearLocations();
        this.textSize = null;
        this.subStringTextSize = null;
        this.subStringText = null;
        super.invalidate();
    }

    public boolean isTextTruncated() {
        return !this.getSubStringTextSize().equals((Object)this.getTextSize());
    }

    protected void paintFigure(Graphics graphics) {
        if (this.isSelected()) {
            graphics.pushState();
            graphics.setBackgroundColor(ColorConstants.menuBackgroundSelected);
            graphics.fillRectangle(this.getSelectionRectangle());
            graphics.popState();
            graphics.setForegroundColor(ColorConstants.white);
        }
        if (this.hasFocus()) {
            graphics.pushState();
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.menuBackgroundSelected);
            graphics.setBackgroundColor(ColorConstants.white);
            graphics.drawFocus(this.getSelectionRectangle().resize(-1, -1));
            graphics.popState();
        }
        if (this.isOpaque()) {
            super.paintFigure(graphics);
        }
        Rectangle bounds = this.getBounds();
        graphics.translate(bounds.x, bounds.y);
        if (this.icon != null) {
            graphics.drawImage(this.icon, this.getIconLocation());
        }
        if (!this.isEnabled()) {
            graphics.translate(1, 1);
            graphics.setForegroundColor(ColorConstants.buttonLightest);
            this.graphicsdrawText(graphics);
            graphics.drawText(this.getSubStringText(), this.getTextLocation());
            graphics.translate(-1, -1);
            graphics.setForegroundColor(ColorConstants.buttonDarker);
        }
        this.graphicsdrawText(graphics);
        graphics.translate(-bounds.x, -bounds.y);
    }

    public void setIcon(Image image) {
        if (this.icon == image) {
            return;
        }
        this.icon = image;
        this.repaint();
        if (this.icon == null) {
            this.setIconDimension(new Dimension());
        } else {
            this.setIconDimension(new Dimension(image));
        }
    }

    public void setIconAlignment(int align) {
        if (this.iconAlignment == align) {
            return;
        }
        this.iconAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setIconDimension(Dimension d) {
        if (d.equals((Object)this.iconSize)) {
            return;
        }
        this.iconSize = d;
        this.revalidate();
    }

    public void setIconTextGap(int gap) {
        if (this.iconTextGap == gap) {
            return;
        }
        this.iconTextGap = gap;
        this.repaint();
        this.revalidate();
    }

    public void setLabelAlignment(int align) {
        if (this.labelAlignment == align) {
            return;
        }
        this.labelAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setText(String s) {
        if (s == null) {
            s = "";
        }
        if (this.text.equals(s)) {
            return;
        }
        this.text = s;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int align) {
        if (this.textAlignment == align) {
            return;
        }
        this.textAlignment = align;
        this.clearLocations();
        this.repaint();
    }

    public void setTextPlacement(int where) {
        if (this.textPlacement == where) {
            return;
        }
        this.textPlacement = where;
        this.revalidate();
        this.repaint();
    }

    private Rectangle getSelectionRectangle() {
        Rectangle bounds = this.getTextBounds();
        bounds.expand(new Insets(2, 2, 0, 0));
        this.translateToParent((Translatable)bounds);
        bounds.intersect(this.getBounds());
        return bounds;
    }

    protected Dimension calculateTextSize(int width, int height) {
        return FigureUtilities.getTextExtents((String)this.getWrappedText(width, height), (Font)this.getFont());
    }

    private String getWrappedText(int width, int height) {
        if (!this.isTextWrapped() || width == -1) {
            return this.getText();
        }
        if (this.isIconExist()) {
            switch (this.textPlacement) {
                case 8: 
                case 16: {
                    width -= this.iconSize.width + this.getIconTextGap();
                    break;
                }
                case 1: 
                case 4: {
                    if (height == -1) break;
                    height -= this.iconSize.height + this.getIconTextGap();
                }
            }
        }
        Font f = this.getFont();
        int maxLines = Integer.MAX_VALUE;
        if (height != -1) {
            int fontHeight = FigureUtilities.getFontMetrics((Font)f).getHeight();
            maxLines = (int)((double)height / (double)fontHeight);
        }
        StringBuffer accumlatedText = new StringBuffer();
        StringBuffer remainingText = new StringBuffer(this.getText());
        int i = 0;
        int j = 0;
        while (remainingText.length() > 0 && j++ < maxLines) {
            i = this.getLineWrapPosition(remainingText.toString(), f, height);
            if (i == 0) break;
            if (accumlatedText.length() > 0) {
                accumlatedText.append("\n");
            }
            accumlatedText.append(remainingText.substring(0, i));
            remainingText.delete(0, i);
        }
        return accumlatedText.toString();
    }

    private boolean isIconExist() {
        return true;
    }

    private int getLineWrapPosition(String string, Font f, int width) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(string);
        int start = iter.first();
        int end = iter.next();
        if (FigureUtilities.getTextExtents((String)string.substring((int)start, (int)end), (Font)f).width > width) {
            iter = BreakIterator.getCharacterInstance();
            iter.setText(string);
            start = iter.first();
        }
        while ((end = iter.next()) != -1 && FigureUtilities.getTextExtents((String)string.substring((int)start, (int)end), (Font)f).width <= width) {
        }
        return end == -1 ? iter.last() : iter.previous();
    }

    static int getLargestSubstringConfinedTo(String s, Font f, int availableWidth) {
        FontMetrics metrics = FigureUtilities.getFontMetrics((Font)f);
        float avg = metrics.getAverageCharWidth();
        int min = 0;
        int max = s.length() + 1;
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += (int)((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getTextExtents((String)s.substring((int)0, (int)guess), (Font)f).width) < availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        return min;
    }

    public void setTextWrap(boolean b) {
        if (this.isTextWrapped() == b) {
            return;
        }
        this.setFlag(FLAG_WRAP, b);
        this.revalidate();
        this.repaint();
    }

    public boolean isTextWrapped() {
        return true;
    }

    public void setTextWrapWidth(int i) {
        if (this.wrapWidth == i) {
            return;
        }
        this.wrapWidth = i;
        this.revalidate();
        this.repaint();
    }

    public void setTextWrapAlignment(int i) {
        if (this.getTextWrapAlignment() == i) {
            return;
        }
        this.setAlignmentFlags(i, FLAG_WRAP_ALIGN);
        this.repaint();
    }

    private void setAlignmentFlags(int align, int flagOffset) {
        this.flags &= ~(7 * flagOffset);
        switch (align) {
            case 2: {
                this.flags |= 1 * flagOffset;
                break;
            }
            case 8: {
                this.flags |= 2 * flagOffset;
                break;
            }
            case 1: {
                this.flags |= 3 * flagOffset;
                break;
            }
            case 4: {
                this.flags |= 4 * flagOffset;
                break;
            }
            case 32: {
                this.flags |= 5 * flagOffset;
            }
        }
    }

    private int getAlignment(int flagOffset) {
        int wrapValue = this.flags & 7 * flagOffset;
        if (wrapValue == 1 * flagOffset) {
            return 2;
        }
        if (wrapValue == 2 * flagOffset) {
            return 8;
        }
        if (wrapValue == 3 * flagOffset) {
            return 1;
        }
        if (wrapValue == 4 * flagOffset) {
            return 4;
        }
        if (wrapValue == 5 * flagOffset) {
            return 32;
        }
        return 2;
    }

    public int getTextWrapAlignment() {
        return this.getAlignment(FLAG_WRAP_ALIGN);
    }

    public boolean hasFocus() {
        return (this.flags & FLAG_HASFOCUS) != 0;
    }

    public boolean isSelected() {
        return (this.flags & FLAG_SELECTED) != 0;
    }

    private void graphicsdrawText(Graphics graphics) {
        String subString = this.getSubStringText();
        StringTokenizer tokenizer = new StringTokenizer(subString, "\n");
        Font f = this.getFont();
        int fontHeight = FigureUtilities.getFontMetrics((Font)f).getHeight();
        int textWidth = FigureUtilities.getTextExtents((String)subString, (Font)f).width;
        int y = this.getTextLocation().y;
        if (FigureUtilities.getFontMetrics((Font)f).getLeading() == 0) {
            int offset = 2;
            y += offset;
        }
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            System.out.println("Text added to draw" + token);
            int tokenWidth = FigureUtilities.getTextExtents((String)token, (Font)f).width;
            int x = this.getTextLocation().x;
            switch (this.getTextWrapAlignment()) {
                case 2: {
                    x += (textWidth - tokenWidth) / 2;
                    break;
                }
                case 4: {
                    x += textWidth - tokenWidth;
                }
            }
            graphics.drawText(token, x, y);
            y += fontHeight;
        }
    }

    public void setFocus(boolean b) {
        if (this.hasFocus() == b) {
            return;
        }
        this.setFlag(FLAG_HASFOCUS, b);
        this.repaint();
    }

    public void setSelected(boolean b) {
        if (this.isSelected() == b) {
            return;
        }
        this.setFlag(FLAG_SELECTED, b);
        this.repaint();
    }
}

