/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.ConfigurationViewEditAction;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.LibraryViewEditAction;
import org.eclipse.epf.authoring.ui.actions.MethodCreateChildAction;
import org.eclipse.epf.authoring.ui.actions.MethodCreateSiblingAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class LibraryActionBarContributor
extends EditingDomainActionBarContributor
implements ILibraryActionBarContributor,
ISelectionChangedListener {
    protected IViewPart activeViewPart;
    protected ISelectionProvider selectionProvider;
    protected IActionBars viewActionBars;
    protected LibraryViewEditAction libraryViewEditAction;
    protected ConfigurationViewEditAction configViewEditAction;
    private EditingDomain editingDomain;
    protected IAction showPropertiesViewAction = new Action(this.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                try {
                    LibraryActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException exception) {
                    exception.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(this.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return LibraryActionBarContributor.this.activeViewPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (LibraryActionBarContributor.this.activeViewPart instanceof IViewerProvider && (viewer = ((IViewerProvider)LibraryActionBarContributor.this.activeViewPart).getViewer()) != null) {
                LibraryActionBarContributor.this.refreshViewer(viewer);
            }
        }
    };
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection createSiblingActions;
    protected IMenuManager createSiblingMenuManager;

    public LibraryActionBarContributor(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    protected void refreshViewer(Viewer viewer) {
        viewer.refresh();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("method-settings"));
        toolBarManager.add((IContributionItem)new Separator("method-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(this.getString("_UI_MethodEditor_menu"), "com.ibm.methodMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(this.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(this.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public IViewPart getActiveView() {
        return this.activeViewPart;
    }

    public void setActiveView(IViewPart part) {
        if (part != null) {
            super.setActiveView(part);
        }
        if (part == this.activeViewPart) {
            return;
        }
        if (this.activeViewPart != null) {
            this.deactivate();
        }
        if (part == null) {
            this.selectionProvider = null;
        }
        if (!(part instanceof IEditingDomainProvider)) {
            return;
        }
        this.activeViewPart = part;
        this.editingDomain = ((IEditingDomainProvider)part).getEditingDomain();
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
        this.activate();
    }

    public void deactivate() {
        this.activeViewPart.removePropertyListener((IPropertyListener)this);
        this.deleteAction.setEditingDomain(null);
        this.cutAction.setEditingDomain(null);
        this.copyAction.setEditingDomain(null);
        this.pasteAction.setEditingDomain(null);
        this.undoAction.setEditingDomain(null);
        this.redoAction.setEditingDomain(null);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setEditingDomain(null);
        }
        ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.libraryViewEditAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
    }

    public void disableGlobalEditMenu() {
        this.deleteAction.setEnabled(false);
        if (this.libraryViewEditAction != null) {
            this.libraryViewEditAction.setEnabled(false);
        }
        if (this.configViewEditAction != null) {
            this.configViewEditAction.setEnabled(false);
        }
        this.cutAction.setEnabled(false);
        this.copyAction.setEnabled(false);
        this.pasteAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    public void enableGlobalEditMenu() {
        this.deleteAction.setEnabled(true);
        if (this.libraryViewEditAction != null) {
            this.libraryViewEditAction.setEnabled(true);
        }
        if (this.configViewEditAction != null) {
            this.configViewEditAction.setEnabled(true);
        }
        this.cutAction.setEnabled(true);
        this.copyAction.setEnabled(true);
        this.pasteAction.setEnabled(true);
        this.undoAction.setEnabled(true);
        this.redoAction.setEnabled(true);
    }

    public void activate() {
        this.activeViewPart.addPropertyListener((IPropertyListener)this);
        this.deleteAction.setEditingDomain(this.editingDomain);
        this.cutAction.setEditingDomain(this.editingDomain);
        this.copyAction.setEditingDomain(this.editingDomain);
        this.pasteAction.setEditingDomain(this.editingDomain);
        this.undoAction.setEditingDomain(this.editingDomain);
        this.redoAction.setEditingDomain(this.editingDomain);
        if (this.loadResourceAction != null) {
            this.loadResourceAction.setEditingDomain(this.editingDomain);
        }
        ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.libraryViewEditAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.cutAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        this.update();
    }

    public void update() {
        if (this.activeViewPart == null) {
            return;
        }
        ISelectionProvider selectionProvider = this.activeViewPart instanceof ISelectionProvider ? (ISelectionProvider)this.activeViewPart : this.activeViewPart.getSite().getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        this.deleteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.libraryViewEditAction.updateSelection((IStructuredSelection)structuredSelection);
        this.cutAction.updateSelection((IStructuredSelection)structuredSelection);
        this.copyAction.updateSelection((IStructuredSelection)structuredSelection);
        this.pasteAction.updateSelection((IStructuredSelection)structuredSelection);
        this.undoAction.update();
        this.redoAction.update();
        if (this.loadResourceAction != null) {
            this.loadResourceAction.update();
        }
        if (this.validateAction != null) {
            this.validateAction.updateSelection((IStructuredSelection)structuredSelection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeViewPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
        ArrayList<MethodCreateChildAction> actions = new ArrayList<MethodCreateChildAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new MethodCreateChildAction(this.editingDomain, selection, i.next()));
            }
        }
        return actions;
    }

    protected Collection generateCreateSiblingActions(Collection descriptors, ISelection selection) {
        ArrayList<MethodCreateSiblingAction> actions = new ArrayList<MethodCreateSiblingAction>();
        if (descriptors != null) {
            Iterator i = descriptors.iterator();
            while (i.hasNext()) {
                actions.add(new MethodCreateSiblingAction(this.activeViewPart, selection, i.next()));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection actions, String contributionID) {
        if (actions != null) {
            Iterator i = actions.iterator();
            while (i.hasNext()) {
                IAction action = (IAction)i.next();
                if (contributionID != null) {
                    manager.insertBefore(contributionID, action);
                    continue;
                }
                manager.add(action);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(this.getString("_UI_CreateChild_menu_item"));
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("additions", (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        menuManager.insertBefore("additions-end", (IContributionItem)new Separator());
    }

    public void init(IActionBars actionBars, IWorkbenchPage page) {
        super.init(actionBars, page);
    }

    public void init(IActionBars actionBars) {
        this.viewActionBars = actionBars;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.libraryViewEditAction = new LibraryViewEditAction(AuthoringUIResources.getString("AuthoringUI.actionLabel.edit"));
        actionBars.setGlobalActionHandler(LibraryViewEditAction.ACTION_ID, (IAction)this.libraryViewEditAction);
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        this.libraryViewEditAction.setEnabled(false);
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction();
    }

    protected String getString(String key) {
        return AuthoringUIResources.getString(key);
    }
}

