/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodElement;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Role;
import com.ibm.uma.Task;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.util.AssociationHelper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ContentPackageDescriptionPage
extends FormPage
implements IRefreshable {
    private static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_CONTENT_PACKAGE) + ": ";
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private CheckboxTableViewer ctrl_dependency;
    private ScrolledForm form;
    private ContentPackage contentPackage;
    private Hashtable aPackageMap = new Hashtable();
    private MethodElementEditor.ModifyListener modelModifyListener;

    public ContentPackageDescriptionPage(FormEditor editor) {
        super(editor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        MethodElement obj = methodElementInput.getMethodElement();
        this.contentPackage = (ContentPackage)obj;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText(String.valueOf(FORM_PREFIX) + this.contentPackage.getName());
        TableWrapLayout layout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)layout);
        Section generalSection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        generalSection.setLayoutData((Object)td);
        generalSection.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        generalSection.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.contentPackage)));
        generalSection.setLayout((Layout)new GridLayout());
        Composite generalComposite = toolkit.createComposite((Composite)generalSection);
        generalComposite.setLayoutData((Object)new GridData(768));
        generalComposite.setLayout((Layout)new GridLayout(2, false));
        generalSection.setClient((Control)generalComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)generalComposite.getParent().getParent(), AuthoringUIHelpContexts.CONTENT_PACKAGE_EDITOR_ALL_CONTEXT);
        Label l_name = toolkit.createLabel(generalComposite, AuthoringUIText.NAME_TEXT);
        GridData gridData = new GridData(1);
        l_name.setLayoutData((Object)gridData);
        this.ctrl_name = toolkit.createText(generalComposite, "");
        gridData = new GridData(768);
        this.ctrl_name.setLayoutData((Object)gridData);
        Label l_brief_desc = toolkit.createLabel(generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        GridData gridData2 = new GridData(1);
        l_brief_desc.setLayoutData((Object)gridData2);
        this.ctrl_brief_desc = toolkit.createText(generalComposite, "", 578);
        gridData2 = new GridData(768);
        gridData2.heightHint = 40;
        gridData2.widthHint = 300;
        this.ctrl_brief_desc.setLayoutData((Object)gridData2);
        Section dependencySection = toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td1 = new TableWrapData(256);
        dependencySection.setLayoutData((Object)td1);
        dependencySection.setText(AuthoringUIText.DEPENDENCIES_SECTION_NAME);
        dependencySection.setDescription(AuthoringUIText.DEPENDENCIES_SECTION_DESC);
        dependencySection.setLayout((Layout)new GridLayout());
        Composite dependencyComposite = toolkit.createComposite((Composite)dependencySection);
        dependencyComposite.setLayoutData((Object)new GridData(768));
        dependencyComposite.setLayout((Layout)new GridLayout(2, false));
        dependencySection.setClient((Control)dependencyComposite);
        Table ctrl_table = new Table(dependencyComposite, 553);
        GridData gridData3 = new GridData(1809);
        gridData3.heightHint = 100;
        ctrl_table.setLayoutData((Object)gridData3);
        this.ctrl_dependency = new CheckboxTableViewer(ctrl_table);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return element.toString();
            }
        };
        this.ctrl_dependency.setLabelProvider((IBaseLabelProvider)labelProvider);
        Hashtable aMap = this.getDependenciesPackages(this.contentPackage);
        if (aMap != null) {
            Iterator it = aMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.ctrl_dependency.add((Object)key);
            }
        }
        this.ctrl_dependency.setAllChecked(true);
        this.ctrl_dependency.setAllGrayed(true);
        toolkit.paintBordersFor(generalComposite);
        toolkit.paintBordersFor(dependencyComposite);
        this.loadData();
        this.addListeners();
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ContentPackageDescriptionPage.this.ctrl_name.setFocus();
                    ContentPackageDescriptionPage.this.ctrl_name.setSelection(0, ContentPackageDescriptionPage.this.ctrl_name.getText().length());
                }
            });
        }
    }

    private void addListeners() {
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = editor.createModifyListener((EObject)this.contentPackage);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                ContentPackageDescriptionPage.this.ctrl_dependency.refresh();
                Hashtable aMap = ContentPackageDescriptionPage.this.getDependenciesPackages(ContentPackageDescriptionPage.this.contentPackage);
                if (aMap != null) {
                    Iterator it = aMap.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        ContentPackageDescriptionPage.this.ctrl_dependency.add((Object)key);
                    }
                }
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllChecked(true);
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllGrayed(true);
                if (TngUtil.isLocked((EObject)ContentPackageDescriptionPage.this.contentPackage)) {
                    ContentPackageDescriptionPage.this.enableControls(false);
                } else {
                    ContentPackageDescriptionPage.this.enableControls(true);
                }
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.modelModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }

            public void focusLost(FocusEvent e) {
                Set<EClass> eClasses = Collections.singleton(UmaPackage.eINSTANCE.getMethodPackage());
                String oldContent = ContentPackageDescriptionPage.this.contentPackage.getName();
                if (((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newName = ContentPackageDescriptionPage.this.ctrl_name.getText();
                String msg = TngUtil.checkName((NamedElement)ContentPackageDescriptionPage.this.contentPackage, (String)newName, eClasses);
                if (msg == null) {
                    if (!newName.equals(ContentPackageDescriptionPage.this.contentPackage.getName())) {
                        ContentPackageDescriptionPage.this.ctrl_name.setText(newName);
                        editor.getActionManager().doAction(1, (EObject)ContentPackageDescriptionPage.this.contentPackage, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)newName, -1);
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.renameDialog.title"), msg);
                    ContentPackageDescriptionPage.this.ctrl_name.setText(ContentPackageDescriptionPage.this.contentPackage.getName());
                    ContentPackageDescriptionPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ContentPackageDescriptionPage.access$0(4.access$0(this.this$1)).setFocus();
                            ContentPackageDescriptionPage.access$0(4.access$0(this.this$1)).selectAll();
                        }
                    });
                }
            }

            static /* synthetic */ ContentPackageDescriptionPage access$0(4 var0) {
                return var0.ContentPackageDescriptionPage.this;
            }
        });
        this.ctrl_brief_desc.addModifyListener((ModifyListener)this.modelModifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = ContentPackageDescriptionPage.this.contentPackage.getBriefDescription();
                if (((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newName = ContentPackageDescriptionPage.this.ctrl_brief_desc.getText();
                if (!newName.equals(ContentPackageDescriptionPage.this.contentPackage.getBriefDescription()) && (success = editor.getActionManager().doAction(1, (EObject)ContentPackageDescriptionPage.this.contentPackage, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newName, -1))) {
                    ContentPackageDescriptionPage.this.ctrl_brief_desc.setText(newName);
                }
            }
        });
        this.ctrl_dependency.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object obj = event.getSource();
                ((CheckboxTableViewer)obj).setAllChecked(true);
            }
        });
    }

    protected void enableControls(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_brief_desc.setEditable(editable);
    }

    private void loadData() {
        String name = this.contentPackage.getName();
        String desc = this.contentPackage.getBriefDescription();
        List dependencies = this.contentPackage.getReusedPackages();
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_brief_desc.setText(desc == null ? "" : desc);
        int i = 0;
        while (i < dependencies.size()) {
            Iterator it = this.aPackageMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (dependencies.get(i) != entry.getValue()) continue;
                this.ctrl_dependency.setChecked(entry.getKey(), true);
            }
            ++i;
        }
    }

    public Hashtable getDependenciesPackages(ContentPackage contentPackage) {
        ArrayList<Object> elements = new ArrayList<Object>();
        Iterator iter = contentPackage.getContentElements().iterator();
        while (iter.hasNext()) {
            ContentElement contentElement = (ContentElement)iter.next();
            if (contentElement.getVariabilityBasedOnElement() != null) {
                elements.add((ContentElement)contentElement.getVariabilityBasedOnElement());
            }
            elements.addAll(MethodElementUtil.getSelectedGuidances((EObject)contentElement));
            if (contentElement instanceof Role) {
                if (AssociationHelper.getModifiedWorkProducts((Role)((Role)contentElement)) != null) {
                    elements.addAll(AssociationHelper.getModifiedWorkProducts((Role)((Role)contentElement)));
                }
                if (AssociationHelper.getPrimaryTasks((Role)((Role)contentElement)) != null) {
                    elements.addAll(AssociationHelper.getPrimaryTasks((Role)((Role)contentElement)));
                }
                if (AssociationHelper.getSecondaryTasks((Role)((Role)contentElement)) != null) {
                    elements.addAll(AssociationHelper.getSecondaryTasks((Role)((Role)contentElement)));
                }
            }
            if (contentElement instanceof Task) {
                if (((Task)contentElement).getPerformedBy() != null) {
                    elements.add(((Task)contentElement).getPerformedBy());
                }
                if (((Task)contentElement).getAdditionallyPerformedBy() != null) {
                    elements.addAll(((Task)contentElement).getAdditionallyPerformedBy());
                }
                if (((Task)contentElement).getMandatoryInput() != null) {
                    elements.addAll(((Task)contentElement).getMandatoryInput());
                }
                if (((Task)contentElement).getOptionalInput() != null) {
                    elements.addAll(((Task)contentElement).getOptionalInput());
                }
                if (((Task)contentElement).getOutput() != null) {
                    elements.addAll(((Task)contentElement).getOutput());
                }
            }
            if (!(contentElement instanceof WorkProduct)) continue;
            if (AssociationHelper.getModifiedBy((WorkProduct)((WorkProduct)contentElement)) != null) {
                elements.addAll(AssociationHelper.getModifiedBy((WorkProduct)((WorkProduct)contentElement)));
            }
            if (AssociationHelper.getMandatoryInputToTasks((WorkProduct)((WorkProduct)contentElement)) != null) {
                elements.addAll(AssociationHelper.getMandatoryInputToTasks((WorkProduct)((WorkProduct)contentElement)));
            }
            if (AssociationHelper.getOutputtingTasks((WorkProduct)((WorkProduct)contentElement)) != null) {
                elements.addAll(AssociationHelper.getOutputtingTasks((WorkProduct)((WorkProduct)contentElement)));
            }
            if (AssociationHelper.getResponsibleRole((WorkProduct)((WorkProduct)contentElement)) == null) continue;
            elements.add(AssociationHelper.getResponsibleRole((WorkProduct)((WorkProduct)contentElement)));
        }
        int i = 0;
        while (i < elements.size()) {
            EObject object = ((ContentElement)elements.get(i)).eContainer();
            if (object instanceof ContentPackage && !contentPackage.equals(object)) {
                this.aPackageMap.put(((ContentPackage)object).getName(), (ContentPackage)object);
            }
            ++i;
        }
        return this.aPackageMap;
    }

    public void refreshName(String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener((ModifyListener)this.modelModifyListener);
            this.ctrl_name.setText(newName);
            this.ctrl_name.addModifyListener((ModifyListener)this.modelModifyListener);
            UIHelper.setFormText(this.form, (MethodElement)this.contentPackage);
        }
    }
}

