/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.UmaPackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessDescription;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class DeliveryProcessDescription
extends ProcessDescription {
    private IMethodRichText ctrl_scale;
    private IMethodRichText ctrl_project_characteristics;
    private IMethodRichText ctrl_risk_level;
    private IMethodRichText ctrl_estimating_techniques;
    private IMethodRichText ctrl_project_member_expertise;
    private IMethodRichText ctrl_type_of_contract;
    private DeliveryProcess deliveryProcess;

    public DeliveryProcessDescription(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.deliveryProcess = (DeliveryProcess)this.process;
    }

    protected void createDetailSection() {
        super.createDetailSection();
        this.ctrl_scale = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.Scale"), 40, 400, 2);
        this.ctrl_project_characteristics = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.ProjectCharacteristics"), 40, 400, 2);
        this.ctrl_risk_level = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.RiskLevel"), 40, 400, 2);
        this.ctrl_estimating_techniques = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.EstimatingTechnique"), 40, 400, 2);
        this.ctrl_project_member_expertise = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.ProjectMemberExpertise"), 40, 400, 2);
        this.ctrl_type_of_contract = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.TypeOfContract"), 40, 400, 2);
    }

    protected void loadData() {
        super.loadData();
        com.ibm.uma.DeliveryProcessDescription content = (com.ibm.uma.DeliveryProcessDescription)this.deliveryProcess.getPresentation();
        String scale = content.getScale();
        String projectChar = content.getProjectCharacteristics();
        String estimatingTechnique = content.getEstimatingTechnique();
        String riskLevel = content.getRiskLevel();
        String projectMemberExpertiese = content.getProjectMemberExpertise();
        String typeOfContract = content.getTypeOfContract();
        this.ctrl_scale.setText(scale == null ? "" : scale);
        this.ctrl_project_characteristics.setText(projectChar == null ? "" : projectChar);
        this.ctrl_estimating_techniques.setText(estimatingTechnique == null ? "" : estimatingTechnique);
        this.ctrl_risk_level.setText(riskLevel == null ? "" : riskLevel);
        this.ctrl_project_member_expertise.setText(projectMemberExpertiese == null ? "" : projectMemberExpertiese);
        this.ctrl_type_of_contract.setText(typeOfContract == null ? "" : typeOfContract);
    }

    protected void addListeners() {
        super.addListeners();
        MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        final IActionManager actionMgr = editor.getActionManager();
        final com.ibm.uma.DeliveryProcessDescription content = (com.ibm.uma.DeliveryProcessDescription)this.deliveryProcess.getPresentation();
        this.ctrl_scale.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_scale.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_Scale());
        this.ctrl_scale.addModifyListener(this.contentModifyListener);
        this.ctrl_scale.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_scale;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getScale();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_Scale(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_project_characteristics.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_project_characteristics.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_ProjectCharacteristics());
        this.ctrl_project_characteristics.addModifyListener(this.contentModifyListener);
        this.ctrl_project_characteristics.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_project_characteristics;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getProjectCharacteristics();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_ProjectCharacteristics(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_risk_level.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_risk_level.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_RiskLevel());
        this.ctrl_risk_level.addModifyListener(this.contentModifyListener);
        this.ctrl_risk_level.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_risk_level;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getRiskLevel();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_RiskLevel(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_estimating_techniques.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_estimating_techniques.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_EstimatingTechnique());
        this.ctrl_estimating_techniques.addModifyListener(this.contentModifyListener);
        this.ctrl_estimating_techniques.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_estimating_techniques;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getEstimatingTechnique();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_EstimatingTechnique(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_project_member_expertise.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_project_member_expertise.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_ProjectMemberExpertise());
        this.ctrl_project_member_expertise.addModifyListener(this.contentModifyListener);
        this.ctrl_project_member_expertise.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_project_member_expertise;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getProjectMemberExpertise();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_ProjectMemberExpertise(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_type_of_contract.setModalObject((EObject)this.deliveryProcess.getPresentation());
        this.ctrl_type_of_contract.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_TypeOfContract());
        this.ctrl_type_of_contract.addModifyListener(this.contentModifyListener);
        this.ctrl_type_of_contract.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = DeliveryProcessDescription.this.descExpandFlag ? DeliveryProcessDescription.this.ctrl_expanded : DeliveryProcessDescription.this.ctrl_type_of_contract;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getTypeOfContract();
                if (((MethodElementEditor)DeliveryProcessDescription.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)DeliveryProcessDescription.this.deliveryProcess.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliveryProcessDescription_TypeOfContract(), (Object)newContent, -1);
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_estimating_techniques.setEditable(editable);
        this.ctrl_project_characteristics.setEditable(editable);
        this.ctrl_project_member_expertise.setEditable(editable);
        this.ctrl_risk_level.setEditable(editable);
        this.ctrl_scale.setEditable(editable);
        this.ctrl_type_of_contract.setEditable(editable);
    }
}

