/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.ContentElement;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.TermDefinition;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GuidanceDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "guidanceDescriptionPage";
    protected Guidance guidance;
    private String elementLabel;
    private IMethodRichText ctrl_content;
    private int contentFieldHeight = 400;

    public GuidanceDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.guidance = (Guidance)this.contentElement;
        this.elementLabel = LibraryUIText.getUIText((MethodElement)this.guidance);
        this.setElementTypeOn(true);
        if (this.guidance instanceof TermDefinition) {
            this.setBriefDescOn(false);
        }
        this.setFullDescOn(false);
        this.setKeyConsiderationOn(false);
        this.setIconSectionOn(true);
    }

    protected String getFormPrefix() {
        return LibraryUIText.TEXT_GUIDANCE + " (" + this.elementLabel + "): ";
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.ctrl_content = this.createRichTextEditWithLinkForSection(toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, this.contentFieldHeight, 400, 2);
    }

    protected void addListeners() {
        super.addListeners();
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.ctrl_content.setModalObject((EObject)this.contentElement.getPresentation());
        this.ctrl_content.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_content.addModifyListener(this.contentModifyListener);
        this.ctrl_content.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                boolean success;
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = GuidanceDescriptionPage.this.descExpandFlag ? GuidanceDescriptionPage.this.ctrl_expanded : GuidanceDescriptionPage.this.ctrl_content;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = GuidanceDescriptionPage.this.guidance.getPresentation().getMainDescription();
                if (((MethodElementEditor)GuidanceDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent) && (success = editor.getActionManager().doAction(1, (EObject)GuidanceDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1)) && GuidanceDescriptionPage.this.isVersionSectionOn()) {
                    GuidanceDescriptionPage.this.updateChangeDate();
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_content.setEditable(editable);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            String content = null;
            if (this.guidance.getPresentation() != null) {
                content = this.guidance.getPresentation().getMainDescription();
            }
            this.ctrl_content.setText(content == null ? "" : content);
        }
    }

    protected Object getContentElement() {
        return this.guidance;
    }

    public int getContentFieldHeight() {
        return this.contentFieldHeight;
    }

    public void setContentFieldHeight(int contentFieldHeight) {
        this.contentFieldHeight = contentFieldHeight;
    }

    protected String getTabString() {
        return FilterConstants.GUIDANCE;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Guidance) {
                    return ((ContentElement)obj).getType().equals(((Guidance)GuidanceDescriptionPage.this.contentElement).getType());
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.guidance)});
        return this.filter;
    }
}

