/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.NamedElement;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.UmaUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessDescription;
import org.eclipse.epf.authoring.ui.forms.ProcessFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProcessDescription
extends ProcessFormPage {
    private static final String FORM_PAGE_ID = "processDescriptionPage";
    private static final int DEFAULT_VERTICAL_INDENT = 2;
    protected static final int GENERAL_SECTION_ID = 1;
    protected static final int DETAIL_SECTION_ID = 2;
    private IStructuredContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){};
    private ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    protected Section formSection;
    protected Composite sectionComposite;
    private Composite expandedComposite;
    private Text ctrl_name;
    private Text ctrl_presentation_name;
    private Text ctrl_brief_desc;
    private Text ctrl_external_id;
    private IMethodRichText ctrl_purpose;
    private IMethodRichText ctrl_full_desc;
    private IMethodRichText ctrl_scope;
    private IMethodRichText ctrl_usage_notes;
    private IMethodRichText ctrl_alternatives;
    private IMethodRichText ctrl_how_to_staff;
    private IMethodRichText ctrl_key_consideration;
    private IMethodRichText activeControl;
    private Section generalSection;
    private Section detailSection;
    private Section configSection;
    protected Composite generalComposite;
    protected Composite detailComposite;
    protected Composite configComposite;
    protected boolean descExpandFlag = false;
    protected boolean generalSectionExpandFlag = false;
    protected boolean detailSectionExpandFlag = false;
    protected boolean configSectionExpandFlag = false;
    protected IMethodRichTextEditor ctrl_expanded;
    private ImageHyperlink expandLink;
    private Label expandLabel;
    private org.eclipse.swt.widgets.List list_configurations;
    private ListViewer configListViewer;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonMakeDefault;
    private Text textConfigDescription;
    private ItemProviderAdapter configListAdapter;
    protected ModifyListener modifyListener;
    protected ModifyListener contentModifyListener;
    private String processType;
    private MethodElementEditor editor;
    private ModifyListener nameModifyListener;
    private boolean disposed;

    public ProcessDescription(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIResources.getString("AuthoringUI.descriptionPage.title"));
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.processType = LibraryUIText.getUITextLower((MethodElement)this.process);
        this.setFormText();
        this.createEditorContent(this.toolkit);
        this.loadData();
        this.addListeners();
        EditorsContextHelper.setHelp(this.getPartControl(), this.processType);
    }

    protected void createEditorContent(FormToolkit toolkit) {
        this.createFormComposites();
        this.createGeneralSection();
        this.createDetailSection();
        this.createConfigurationSection();
        toolkit.paintBordersFor(this.generalComposite);
        toolkit.paintBordersFor(this.detailComposite);
        toolkit.paintBordersFor(this.configComposite);
        toolkit.paintBordersFor(this.expandedComposite);
    }

    private void createFormComposites() {
        this.formSection = this.toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData td = new TableWrapData(256);
        this.formSection.setLayoutData((Object)td);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData());
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.expandedComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        td = new TableWrapData(256);
        this.expandedComposite.setLayoutData((Object)td);
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.expandedComposite, AuthoringUIHelpContexts.RICH_TEXT_EDITOR_CONTEXT_ID);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.getString("AuthoringUI.closeRTE"));
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProcessDescription.this.toggle(e);
            }
        });
        this.expandLabel = ProcessDescription.createLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void createGeneralSection() {
        this.generalSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)td);
        this.generalSection.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        this.generalSection.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, this.processType));
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(1808));
        this.generalComposite.setLayout((Layout)new GridLayout(3, false));
        this.generalSection.setClient((Control)this.generalComposite);
        this.ctrl_name = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT);
        this.ctrl_presentation_name = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT);
        this.ctrl_brief_desc = ProcessDescription.createTextEditWithLabel2(this.toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_external_id = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIResources.getString("Process.ExternalID"));
        this.ctrl_purpose = this.createRichTextEditWithLinkForSection(this.toolkit, this.generalComposite, AuthoringUIResources.getString("Process.Purpose"), 40, 400, 1);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ProcessDescription.this.ctrl_name.setFocus();
                }
            });
        }
    }

    protected void createDetailSection() {
        this.detailSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td = new TableWrapData(256);
        this.detailSection.setLayoutData((Object)td);
        this.detailSection.setText(AuthoringUIText.DETAIL_SECTION_NAME);
        this.detailSection.setDescription(MessageFormat.format(AuthoringUIText.DETAIL_SECTION_DESC, this.processType));
        this.detailSection.setLayout((Layout)new GridLayout());
        this.detailComposite = this.toolkit.createComposite((Composite)this.detailSection);
        this.detailComposite.setLayoutData((Object)new GridData(1808));
        this.detailComposite.setLayout((Layout)new GridLayout(3, false));
        this.detailSection.setClient((Control)this.detailComposite);
        this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        this.ctrl_scope = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.Scope"), 40, 400, 2);
        this.ctrl_usage_notes = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.UsageNotes"), 40, 400, 2);
        this.ctrl_alternatives = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.Alternatives"), 40, 400, 2);
        this.ctrl_how_to_staff = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.HowToStaff"), 40, 400, 2);
        this.ctrl_key_consideration = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.getString("Process.KeyConsideration"), 40, 400, 2);
    }

    protected void createConfigurationSection() {
        this.configSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData td1 = new TableWrapData(256);
        this.configSection.setLayoutData((Object)td1);
        this.configSection.setText(AuthoringUIResources.getString("AuthoringUI.processDescription.configurationSectionTitle"));
        this.configSection.setDescription(AuthoringUIResources.getString("AuthoringUI.processDescription.configurationSectionMessage"));
        this.configSection.setLayout((Layout)new GridLayout());
        this.configComposite = this.toolkit.createComposite((Composite)this.configSection);
        this.configComposite.setLayoutData((Object)new GridData(1808));
        this.configComposite.setLayout((Layout)new GridLayout(2, false));
        this.configSection.setClient((Control)this.configComposite);
        Label l_element = this.toolkit.createLabel(this.configComposite, AuthoringUIResources.getString("AuthoringUI.processDescription.configurations"));
        GridData gridData = new GridData(1, 0x1000008, true, true, 2, 1);
        l_element.setLayoutData((Object)gridData);
        this.list_configurations = UIHelper.createList(this.toolkit, this.configComposite, 2052);
        gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 2;
        gridData.heightHint = 80;
        gridData.widthHint = 200;
        this.list_configurations.setLayoutData((Object)gridData);
        this.configListViewer = new ListViewer(this.list_configurations);
        this.configListViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.configListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element == ProcessDescription.this.process.getDefaultContext()) {
                    return AuthoringUIPlugin.getDefault().getImage("icons/checked.gif");
                }
                return null;
            }

            public String getText(Object element) {
                String txt = ProcessDescription.this.labelProvider.getText(element);
                if (element == ProcessDescription.this.process.getDefaultContext()) {
                    txt = String.valueOf(txt) + " " + AuthoringUIResources.getString("AuthoringUI.processDescription.default");
                }
                return txt;
            }
        });
        Composite buttonPanel = this.toolkit.createComposite(this.configComposite);
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        gridData2.horizontalIndent = 4;
        buttonPanel.setLayoutData((Object)gridData2);
        buttonPanel.setLayout((Layout)new GridLayout());
        Button button = this.toolkit.createButton(buttonPanel, AuthoringUIResources.getString("AuthoringUI.addButton.text"), 0);
        GridData gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonAdd = button;
        button = this.toolkit.createButton(buttonPanel, AuthoringUIResources.getString("AuthoringUI.removeButton.text"), 0);
        gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonRemove = button;
        button = this.toolkit.createButton(buttonPanel, AuthoringUIResources.getString("AuthoringUI.makeDefaultButton.text"), 0);
        gridData3 = new GridData(768);
        button.setLayoutData((Object)gridData3);
        this.buttonMakeDefault = button;
        Label label = this.toolkit.createLabel(this.configComposite, AuthoringUIResources.getString("AuthoringUI.processDescription.configurationDescription"));
        GridData gridData4 = new GridData(1, 0x1000008, true, false, 2, 1);
        label.setLayoutData((Object)gridData4);
        this.textConfigDescription = this.toolkit.createText(this.configComposite, "");
        gridData4 = new GridData(4, 4, true, true);
        gridData4.verticalIndent = 2;
        gridData4.heightHint = 80;
        gridData4.widthHint = 400;
        this.textConfigDescription.setLayoutData((Object)gridData4);
        this.textConfigDescription.setEditable(false);
    }

    public void dispose() {
        if (this.configListAdapter != null) {
            this.configListAdapter.dispose();
        }
        super.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.disposed = true;
    }

    private void updateModelControls() {
        String str;
        if (this.ctrl_name != null && !this.ctrl_name.isDisposed() && !(str = TngUtil.checkNull((String)this.process.getName())).equals(this.ctrl_name.getText())) {
            this.ctrl_name.setText(str);
        }
        if (this.ctrl_brief_desc != null && !this.ctrl_brief_desc.isDisposed()) {
            this.ctrl_brief_desc.setText(TngUtil.checkNull((String)this.process.getBriefDescription()));
        }
        if (this.ctrl_presentation_name != null && !this.ctrl_presentation_name.isDisposed()) {
            this.ctrl_presentation_name.setText(TngUtil.checkNull((String)this.process.getPresentationName()));
        }
    }

    protected void loadData() {
        com.ibm.uma.ProcessDescription content = (com.ibm.uma.ProcessDescription)this.process.getPresentation();
        String externalID = content.getExternalId();
        String purpose = content.getPurpose();
        String fullDesc = content.getMainDescription();
        String scope = content.getScope();
        String usageNotes = content.getUsageNotes();
        String alternatives = content.getAlternatives();
        String howToStaff = content.getHowtoStaff();
        String keyConsideration = content.getKeyConsiderations();
        this.updateModelControls();
        this.ctrl_external_id.setText(TngUtil.checkNull((String)externalID));
        this.ctrl_purpose.setText(TngUtil.checkNull((String)purpose));
        this.ctrl_full_desc.setText(TngUtil.checkNull((String)fullDesc));
        this.ctrl_scope.setText(TngUtil.checkNull((String)scope));
        this.ctrl_usage_notes.setText(TngUtil.checkNull((String)usageNotes));
        this.ctrl_alternatives.setText(TngUtil.checkNull((String)alternatives));
        this.ctrl_how_to_staff.setText(TngUtil.checkNull((String)howToStaff));
        this.ctrl_key_consideration.setText(TngUtil.checkNull((String)keyConsideration));
        if (this.configListAdapter == null) {
            this.configListAdapter = new ConfigListItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        }
        this.configListViewer.setInput((Object)this.configListAdapter);
    }

    protected void addListeners() {
        this.editor = (MethodElementEditor)this.getEditor();
        final IActionManager actionMgr = this.editor.getActionManager();
        final com.ibm.uma.ProcessDescription content = (com.ibm.uma.ProcessDescription)this.process.getPresentation();
        this.modifyListener = this.editor.createModifyListener((EObject)this.process);
        this.contentModifyListener = this.editor.createModifyListener((EObject)this.process.getPresentation());
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (!ProcessDescription.this.descExpandFlag) {
                    return;
                }
                if (ProcessDescription.this.ctrl_expanded != null) {
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).heightHint = ProcessDescription.this.getRichTextEditorHeight();
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).widthHint = ProcessDescription.this.getRichTextEditorWidth();
                }
                ProcessDescription.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (ProcessDescription.this.disposed) {
                    return;
                }
                ProcessDescription.this.ctrl_presentation_name.removeModifyListener(ProcessDescription.this.modifyListener);
                ProcessDescription.this.ctrl_presentation_name.setText(ProcessDescription.this.process.getPresentationName());
                ProcessDescription.this.ctrl_presentation_name.addModifyListener(ProcessDescription.this.modifyListener);
                ProcessDescription.this.ctrl_brief_desc.removeModifyListener(ProcessDescription.this.modifyListener);
                ProcessDescription.this.ctrl_brief_desc.setText(ProcessDescription.this.process.getBriefDescription());
                ProcessDescription.this.ctrl_brief_desc.addModifyListener(ProcessDescription.this.modifyListener);
                ProcessDescription.this.ctrl_purpose.removeModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_purpose.setText(content.getPurpose());
                ProcessDescription.this.ctrl_purpose.addModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_full_desc.removeModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_full_desc.setText(content.getMainDescription());
                ProcessDescription.this.ctrl_full_desc.addModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_key_consideration.removeModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_key_consideration.setText(content.getKeyConsiderations());
                ProcessDescription.this.ctrl_key_consideration.addModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_alternatives.removeModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_alternatives.setText(content.getAlternatives());
                ProcessDescription.this.ctrl_alternatives.addModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_how_to_staff.removeModifyListener(ProcessDescription.this.contentModifyListener);
                ProcessDescription.this.ctrl_how_to_staff.setText(content.getHowtoStaff());
                ProcessDescription.this.ctrl_how_to_staff.addModifyListener(ProcessDescription.this.contentModifyListener);
                if (TngUtil.isLocked((EObject)ProcessDescription.this.process)) {
                    ProcessDescription.this.refresh(false);
                } else {
                    ProcessDescription.this.refresh(true);
                }
            }
        });
        this.nameModifyListener = this.editor.createModifyListener(this.process.eContainer(), true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleEvent(Event e) {
                String oldContent = ProcessDescription.this.process.getName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newName = ProcessDescription.this.ctrl_name.getText().trim();
                if (newName.equals(ProcessDescription.this.process.getName())) {
                    return;
                }
                ProcessComponent procComp = (ProcessComponent)ProcessDescription.this.process.eContainer();
                IValidator validator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)procComp, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                String msg = validator.isValid(newName);
                if (msg != null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.renameDialog.title"), msg);
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    e.doit = false;
                    ProcessDescription.this.ctrl_name.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ProcessDescription.access$1(7.access$0(this.this$1)).setFocus();
                            ProcessDescription.access$1(7.access$0(this.this$1)).selectAll();
                        }
                    });
                    return;
                }
                String title = AuthoringUIResources.getString("AuthoringUI.processDescriptionNameChangeConfirm.title");
                String message = AuthoringUIResources.getString("AuthoringUI.processDescriptionNameChangeConfirm.message");
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message)) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                e.doit = true;
                boolean status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                if (!status) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                actionMgr.doAction(1, (EObject)procComp, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                ProcessDescription.this.setFormText();
                BusyIndicator.showWhile((Display)ProcessDescription.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        MethodElementEditor editor = (MethodElementEditor)7.access$0(this.this$1).getEditor();
                        editor.addResourceToAdjustLocation(7.access$0(this.this$1).process.eResource());
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                });
            }

            static /* synthetic */ ProcessDescription access$0(7 var0) {
                return var0.ProcessDescription.this;
            }
        });
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.ctrl_presentation_name.addModifyListener(this.modifyListener);
        this.ctrl_presentation_name.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                String oldContent = ProcessDescription.this.process.getPresentationName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                if (ProcessDescription.this.ctrl_presentation_name.getText() != null && !ProcessDescription.this.ctrl_presentation_name.getText().equals("")) {
                    boolean status;
                    e.doit = true;
                    if (!ProcessDescription.this.ctrl_presentation_name.getText().equals(oldContent) && !(status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), (Object)ProcessDescription.this.ctrl_presentation_name.getText(), -1))) {
                        ProcessDescription.this.ctrl_presentation_name.setText(oldContent);
                        return;
                    }
                } else {
                    ProcessDescription.this.ctrl_presentation_name.setText(ProcessDescription.this.process.getPresentationName());
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.editDialog.title"), AuthoringUIResources.getString("AuthoringUI.invalidPresentationNameError.msg"));
                    e.doit = false;
                    ProcessDescription.this.ctrl_presentation_name.getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ 11 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            ProcessDescription.access$4(11.access$0(this.this$1)).setFocus();
                        }
                    });
                }
            }

            static /* synthetic */ ProcessDescription access$0(11 var0) {
                return var0.ProcessDescription.this;
            }
        });
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
            }
        });
        this.ctrl_brief_desc.addModifyListener(this.modifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = ProcessDescription.this.process.getBriefDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                String newContent = ProcessDescription.this.ctrl_brief_desc.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)newContent, -1))) {
                    ProcessDescription.this.ctrl_brief_desc.setText(newContent);
                }
            }
        });
        this.ctrl_external_id.addModifyListener(this.contentModifyListener);
        this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_ExternalId());
            }

            public void focusLost(FocusEvent e) {
                boolean success;
                String oldContent = content.getExternalId();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_external_id, oldContent)) {
                    return;
                }
                String newContent = ProcessDescription.this.ctrl_external_id.getText();
                if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_ExternalId(), (Object)newContent, -1))) {
                    ProcessDescription.this.ctrl_external_id.setText(newContent);
                }
            }
        });
        this.ctrl_purpose.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose());
        this.ctrl_purpose.addModifyListener(this.contentModifyListener);
        this.ctrl_purpose.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_purpose;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getPurpose();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_purpose, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_full_desc.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_full_desc.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_full_desc;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getMainDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_full_desc, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_scope.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_scope.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope());
        this.ctrl_scope.addModifyListener(this.contentModifyListener);
        this.ctrl_scope.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_scope;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getScope();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_scope, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_usage_notes.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_usage_notes.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes());
        this.ctrl_usage_notes.addModifyListener(this.contentModifyListener);
        this.ctrl_usage_notes.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_usage_notes;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getUsageNotes();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_usage_notes, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_alternatives.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_alternatives.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives());
        this.ctrl_alternatives.addModifyListener(this.contentModifyListener);
        this.ctrl_alternatives.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_alternatives;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getAlternatives();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_alternatives, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_how_to_staff.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_how_to_staff.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff());
        this.ctrl_how_to_staff.addModifyListener(this.contentModifyListener);
        this.ctrl_how_to_staff.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_how_to_staff;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getHowtoStaff();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_how_to_staff, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff(), (Object)newContent, -1);
                }
            }
        });
        this.ctrl_key_consideration.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_key_consideration.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
        this.ctrl_key_consideration.addModifyListener(this.contentModifyListener);
        this.ctrl_key_consideration.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                IMethodRichText control;
                IMethodRichText iMethodRichText = control = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_key_consideration;
                if (!control.getModified()) {
                    return;
                }
                String oldContent = content.getKeyConsiderations();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_key_consideration, oldContent)) {
                    return;
                }
                String newContent = control.getText();
                if (!newContent.equals(oldContent)) {
                    actionMgr.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)newContent, -1);
                }
            }
        });
        this.configListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (selection.size() == 1) {
                    MethodConfiguration config = (MethodConfiguration)selection.getFirstElement();
                    if (config == ProcessDescription.this.process.getDefaultContext()) {
                        ProcessDescription.this.buttonRemove.setEnabled(false);
                    } else {
                        ProcessDescription.this.buttonRemove.setEnabled(true);
                    }
                    String desc = config.getBriefDescription();
                    if (desc == null) {
                        desc = "";
                    }
                    ProcessDescription.this.textConfigDescription.setText(desc);
                }
            }
        });
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)ProcessDescription.this.process);
                ConfigurationsItemProvider input = new ConfigurationsItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), lib, "");
                ListSelectionDialog dlg = new ListSelectionDialog(this, Display.getCurrent().getActiveShell(), input, ProcessDescription.this.contentProvider, ProcessDescription.this.labelProvider, AuthoringUIResources.getString("AuthoringUI.ProcessDescription.selectConfiguration"), input){
                    final /* synthetic */ 24 this$1;
                    private final /* synthetic */ ConfigurationsItemProvider val$input;
                    {
                        this.this$1 = var1_1;
                        this.val$input = configurationsItemProvider;
                    }

                    protected Control createDialogArea(Composite parent) {
                        Control control = super.createDialogArea(parent);
                        this.getViewer().addFilter(new ViewerFilter(this){
                            final /* synthetic */ 25 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                return !24.access$0(25.access$0(this.this$2)).process.getValidContext().contains(element);
                            }
                        });
                        return control;
                    }

                    public boolean close() {
                        this.val$input.dispose();
                        return super.close();
                    }

                    static /* synthetic */ 24 access$0(25 var0) {
                        return var0.this$1;
                    }
                };
                if (dlg.open() == 0) {
                    Object[] obs = dlg.getResult();
                    int i = 0;
                    while (i < obs.length) {
                        MethodConfiguration config = (MethodConfiguration)obs[i];
                        if (config != null) {
                            actionMgr.doAction(3, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)config, -1);
                        } else {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.addConfigErrorDialog.title"), AuthoringUIResources.formatString("AuthoringUI.invalidConfigError.msg", config.getName()));
                        }
                        ++i;
                    }
                }
            }

            static /* synthetic */ ProcessDescription access$0(24 var0) {
                return var0.ProcessDescription.this;
            }
        });
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                actionMgr.doAction(6, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)selection.toList(), -1);
            }
        });
        this.buttonMakeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodConfiguration currentConfig;
                IStructuredSelection selection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (selection.size() == 1 && (currentConfig = ProcessDescription.this.process.getDefaultContext()) != selection.getFirstElement()) {
                    boolean isValid = true;
                    List validContext = ProcessDescription.this.process.getValidContext();
                    Iterator itor = validContext.iterator();
                    while (itor.hasNext()) {
                        MethodConfiguration config = (MethodConfiguration)itor.next();
                        if (ProcessDescription.this.checkValidityForSuperSet((MethodConfiguration)selection.getFirstElement(), config)) continue;
                        isValid = false;
                        break;
                    }
                    if (isValid) {
                        boolean status = actionMgr.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_DefaultContext(), selection.getFirstElement(), -1);
                        if (!status) {
                            return;
                        }
                        ProcessDescription.this.buttonRemove.setEnabled(false);
                    } else {
                        String selectedConfigName = ((MethodConfiguration)selection.getFirstElement()).getName();
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.setDefaultConfigErrorDialog.title"), AuthoringUIResources.formatString("AuthoringUI.setDefaultConfigError.msg", selectedConfigName));
                    }
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_presentation_name.setEditable(editable);
        this.ctrl_brief_desc.setEditable(editable);
        this.ctrl_purpose.setEditable(editable);
        this.ctrl_full_desc.setEditable(editable);
        this.ctrl_alternatives.setEditable(editable);
        this.ctrl_external_id.setEditable(editable);
        this.ctrl_key_consideration.setEditable(editable);
        this.ctrl_how_to_staff.setEditable(editable);
        this.ctrl_scope.setEditable(editable);
        this.ctrl_usage_notes.setEditable(editable);
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(editable);
        }
        this.buttonAdd.setEnabled(editable);
        this.buttonMakeDefault.setEnabled(editable);
        this.buttonRemove.setEnabled(editable);
    }

    protected void toggle(HyperlinkEvent e, int id) {
        this.toggle(e);
    }

    protected void toggle(HyperlinkEvent e) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1040, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.expandedComposite.setVisible(false);
            this.sectionComposite.setVisible(true);
            this.formSection.setClient((Control)this.sectionComposite);
            this.enableSections(true);
            IMethodRichText richText = this.getActiveRichTextControl();
            richText.setText(this.ctrl_expanded.getText());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            this.editor.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.enableSections(false);
            this.expandLabel.setText((String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_expanded.setText(richText.getText());
            this.ctrl_expanded.setModalObject(richText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            boolean editable = !TngUtil.isLocked((EObject)this.process);
            this.ctrl_expanded.setEditable(editable);
            if (editable) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(richText);
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private boolean checkValidityForSuperSet(MethodConfiguration defaultConfig, MethodConfiguration config) {
        List defaultPlugins = defaultConfig.getMethodPluginSelection();
        List defaultPackages = defaultConfig.getMethodPackageSelection();
        List packages = config.getMethodPackageSelection();
        List plugins = config.getMethodPluginSelection();
        boolean pluginContains = false;
        boolean packageContains = false;
        if (plugins != null && !plugins.isEmpty()) {
            pluginContains = defaultPlugins.containsAll(plugins);
        }
        if (packages != null && !packages.isEmpty()) {
            packageContains = defaultPackages.containsAll(packages);
        }
        return pluginContains && packageContains;
    }

    private void setActiveRichTextControl(IMethodRichText ctrl) {
        this.activeControl = ctrl;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    protected void enableSections(boolean enable) {
        this.generalSection.setVisible(enable);
        if (enable) {
            this.generalSection.setExpanded(this.generalSectionExpandFlag);
        } else {
            this.generalSectionExpandFlag = this.generalSection.isExpanded();
            this.generalSection.setExpanded(enable);
        }
        this.detailSection.setVisible(enable);
        if (enable) {
            this.detailSection.setExpanded(this.detailSectionExpandFlag);
        } else {
            this.detailSectionExpandFlag = this.detailSection.isExpanded();
            this.detailSection.setExpanded(enable);
        }
        this.configSection.setVisible(enable);
        if (enable) {
            this.configSection.setExpanded(this.configSectionExpandFlag);
        } else {
            this.configSectionExpandFlag = this.configSection.isExpanded();
            this.configSection.setExpanded(enable);
        }
    }

    public int getRichTextEditorHeight() {
        return this.form.getBounds().height - 96;
    }

    public int getRichTextEditorWidth() {
        return Math.max(560, this.form.getBounds().width - 64);
    }

    public void setFormText() {
        this.form.setText(String.valueOf(LibraryUIText.getUIText((MethodElement)this.process)) + ": " + this.methodElement.getName());
    }

    public void refreshElementName(String newName) {
        if (newName != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener(this.nameModifyListener);
            this.ctrl_name.setText(newName);
            this.ctrl_name.addModifyListener(this.nameModifyListener);
            this.setFormText();
        }
    }

    class ConfigListItemProvider
    extends ItemProviderAdapter
    implements IStructuredItemContentProvider {
        static /* synthetic */ Class class$0;

        public ConfigListItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            ProcessDescription.this.process.eAdapters().add((Object)this);
        }

        public Collection getChildren(Object object) {
            MethodConfiguration defaultConfig = ProcessDescription.this.process.getDefaultContext();
            if (defaultConfig != null && !ProcessDescription.this.process.getValidContext().contains(defaultConfig)) {
                ProcessDescription.this.process.getValidContext().add(0, defaultConfig);
            }
            return ProcessDescription.this.process.getValidContext();
        }

        public void notifyChanged(Notification msg) {
            boolean refresh = false;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.uma.Process");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (msg.getFeatureID((Class)clazz)) {
                case 36: {
                    switch (msg.getEventType()) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            refresh = true;
                        }
                    }
                    break;
                }
                case 35: {
                    refresh = true;
                }
            }
            if (refresh) {
                ProcessDescription.this.configListViewer.refresh();
            }
        }
    }
}

