/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Discipline;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Task;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class TaskCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "taskCategoriesPage";
    private Task task;

    public TaskCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.task = (Task)this.contentElement;
        this.setCategoryIsSingleSelection1(true);
        this.setAllowChange1(true);
        this.setAllowChange2(true);
        this.setUseCategory3(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<Discipline> list = new ArrayList<Discipline>();
                Discipline discipline = AssociationHelper.getDiscipline((Task)((Task)object));
                if (discipline != null) {
                    list.add(discipline);
                }
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Object discipline = addItems.get(0);
            LibraryManager.getInstance().addToDiscipline(this.getActionManager(), (Discipline)discipline, this.task);
            if (this.usedCategories.contains(discipline)) {
                this.usedCategories.remove(discipline);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                Discipline discipline = (Discipline)it.next();
                LibraryManager.getInstance().removeFromDiscipline(this.getActionManager(), discipline, this.task);
                if (this.usedCategories.contains(discipline)) continue;
                this.usedCategories.add(discipline);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((Task)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task);
                if (!this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.remove(customCategory);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.task);
                if (this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.add(customCategory);
            }
        }
    }

    protected Object getContentElement() {
        return this.task;
    }

    protected String getTabString() {
        return FilterConstants.DISCIPLINES;
    }

    protected String getTabString2() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof Discipline;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CustomCategoryFilter();
        return this.filter2;
    }
}

