/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Domain;
import com.ibm.uma.MethodElement;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductType;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "workProductCategoriesPage";
    private WorkProduct workProduct;

    public WorkProductCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.workProduct = (WorkProduct)this.contentElement;
        this.setUseCategory3(true);
        this.setCategoryIsSingleSelection1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<Domain> list = new ArrayList<Domain>();
                Domain domain = AssociationHelper.getDomain((WorkProduct)((WorkProduct)object));
                if (domain != null) {
                    list.add(domain);
                }
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Object domain = addItems.get(0);
            LibraryManager.getInstance().addToDomain(this.getActionManager(), (Domain)domain, this.workProduct);
            if (this.usedCategories.contains(domain)) {
                this.usedCategories.remove(domain);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                Domain domain = (Domain)it.next();
                LibraryManager.getInstance().removeFromDomain(this.getActionManager(), domain, this.workProduct);
                if (this.usedCategories.contains(domain)) continue;
                this.usedCategories.add(domain);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getWorkProductTypes((WorkProduct)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                WorkProductType wpType = (WorkProductType)it.next();
                LibraryManager.getInstance().addToWorkProductType(this.getActionManager(), wpType, this.workProduct);
                if (!this.usedCategories.contains(wpType)) continue;
                this.usedCategories.remove(wpType);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                WorkProductType wpType = (WorkProductType)it.next();
                LibraryManager.getInstance().removeFromWorkProductType(this.getActionManager(), wpType, this.workProduct);
                if (this.usedCategories.contains(wpType)) continue;
                this.usedCategories.add(wpType);
            }
        }
    }

    protected void initContentProviderSelected3() {
        this.contentProviderSelected3 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected3.setContentProvider((IContentProvider)this.contentProviderSelected3);
    }

    protected void addItemsToModel3(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            Iterator it = addItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct);
                if (!this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.remove(customCategory);
            }
        }
    }

    protected void removeItemsFromModel3(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            Iterator it = rmItems.iterator();
            while (it.hasNext()) {
                CustomCategory customCategory = (CustomCategory)it.next();
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct);
                if (this.usedCategories.contains(customCategory)) continue;
                this.usedCategories.add(customCategory);
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.DOMAINS;
    }

    protected String getTabString2() {
        return FilterConstants.WORKPRODUCTTYPES;
    }

    protected String getTabString3() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof Domain;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof WorkProductType;
            }
        };
        return this.filter2;
    }

    protected IFilter getFilter3() {
        this.filter3 = new CustomCategoryFilter();
        return this.filter3;
    }
}

