/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Process;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessSpecificWorkProductFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessWorkProductFilter;
import org.eclipse.epf.authoring.ui.properties.DescriptorGeneralSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.command.AssignWPToDeliverable;
import org.eclipse.epf.library.edit.process.command.LinkMethodElementCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class WorkProductDescriptorGeneralSection
extends DescriptorGeneralSection {
    protected WorkProductDescriptor element;
    private Text ctrl_method_element;
    private Text ctrl_workProduct_type;
    private Text activityEntryState;
    private Text activityExitState;
    private Button linkButton;
    private Table ctrl_table_1;
    private TableViewer viewer_1;
    private Button ctrl_add_1;
    private Button ctrl_add_proc_1;
    private Button ctrl_remove_1;
    private Section deliverableSection;
    private MethodElementEditor.ModifyListener wpModelModifyListener;
    static /* synthetic */ Class class$0;

    protected void init() {
        super.init();
        this.element = (WorkProductDescriptor)this.getElement();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    private void toggleSection() {
        if (!(this.element.getWorkProduct() instanceof Deliverable)) {
            if (this.deliverableSection.isExpanded()) {
                this.deliverableSection.setExpanded(false);
            }
            if (this.deliverableSection.isVisible()) {
                this.deliverableSection.setVisible(false);
            }
        } else {
            if (!this.deliverableSection.isExpanded()) {
                this.deliverableSection.setExpanded(true);
            }
            if (!this.deliverableSection.isVisible()) {
                this.deliverableSection.setVisible(true);
            }
        }
    }

    private void createDeliverableSection(Composite composite) {
        String sectionTitle = PropertiesResources.getString("WPDescriptor.DeliverablePart.SectionTitle");
        String sectionDesc = PropertiesResources.getString("WPDescriptor.DeliverablePart.SectionDescription");
        String tableTitle = PropertiesResources.getString("WPDescriptor.DeliverablePart.Table1");
        Section section = FormUI.createSection(this.toolkit, composite, sectionTitle, sectionDesc);
        Composite sectionComposite = FormUI.createComposite(this.toolkit, section, 2, false);
        Composite pane1 = FormUI.createComposite(this.toolkit, sectionComposite, 1808);
        FormUI.createLabel(this.toolkit, pane1, tableTitle);
        int tableHeight = 80;
        this.ctrl_table_1 = FormUI.createTable(this.toolkit, pane1, tableHeight);
        this.viewer_1 = new TableViewer(this.ctrl_table_1);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                ArrayList<WorkProductDescriptor> newList = new ArrayList<WorkProductDescriptor>();
                List deliverableParts = WorkProductDescriptorGeneralSection.this.element.getDeliverableParts();
                Iterator itor = deliverableParts.iterator();
                while (itor.hasNext()) {
                    WorkProductDescriptor wpDesc = (WorkProductDescriptor)itor.next();
                    if (wpDesc.getSuperActivities() != null && !wpDesc.getSuperActivities().isEmpty()) continue;
                    newList.add(wpDesc);
                }
                return WorkProductDescriptorGeneralSection.this.getFilteredList(newList).toArray();
            }
        };
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
        this.viewer_1.setContentProvider((IContentProvider)contentProvider);
        this.viewer_1.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer_1.setInput((Object)this.element);
        Composite pane2 = FormUI.createComposite(this.toolkit, sectionComposite, 68);
        this.ctrl_add_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Add"));
        this.ctrl_add_proc_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.AddFromProcess"));
        this.ctrl_remove_1 = FormUI.createButton(this.toolkit, pane2, PropertiesResources.getString("Process.Remove"));
        this.toolkit.paintBordersFor(pane1);
        this.deliverableSection = section;
    }

    public void dispose() {
        super.dispose();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("Process.Type.WorkProduct"));
        this.ctrl_method_element = FormUI.createText(this.toolkit, this.generalComposite, -1, 1);
        this.ctrl_method_element.setText(this.getMethodElementName(this.element));
        this.ctrl_method_element.setEnabled(false);
        this.linkButton = FormUI.createButton(this.toolkit, this.generalComposite, 8, 1);
        this.linkButton.setText(PropertiesResources.getString("Process.Button.LinkMethodElement"));
        FormUI.createLabel(this.toolkit, this.generalComposite, "", 1);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("WorkProduct.Type"));
        this.ctrl_workProduct_type = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.ctrl_workProduct_type.setText(this.getMethodElementType(this.element));
        this.ctrl_workProduct_type.setEnabled(false);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("WorkProductDescriptor.ActivityEntryState"));
        this.activityEntryState = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.getString("WorkProductDescriptor.ActivityExitState"));
        this.activityExitState = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.createDeliverableSection(composite);
        this.toggleSection();
    }

    private String getMethodElementName(WorkProductDescriptor element) {
        String str = PropertiesResources.getString("Process.None");
        if (element.getWorkProduct() != null) {
            str = element.getWorkProduct().getName();
        }
        return str;
    }

    private String getMethodElementType(WorkProductDescriptor element) {
        String str = PropertiesResources.getString("Process.None");
        if (element.getWorkProduct() != null) {
            str = element.getWorkProduct().getType().getName();
        }
        return str;
    }

    protected void addListeners() {
        super.addListeners();
        this.activityEntryState.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                WorkProductDescriptorGeneralSection.this.getEditor().setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                WorkProductDescriptor element = (WorkProductDescriptor)WorkProductDescriptorGeneralSection.this.getElement();
                String oldContent = element.getActivityEntryState();
                if (WorkProductDescriptorGeneralSection.this.getEditor().mustRestoreValue(WorkProductDescriptorGeneralSection.this.activityEntryState, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)WorkProductDescriptorGeneralSection.this.activityEntryState.getText());
                if (!newContent.equals(oldContent) && (status = WorkProductDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityEntryState(), (Object)newContent, -1))) {
                    WorkProductDescriptorGeneralSection.this.activityEntryState.setText(newContent);
                }
            }
        });
        this.activityExitState.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                WorkProductDescriptorGeneralSection.this.getEditor().setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState());
            }

            public void focusLost(FocusEvent e) {
                boolean status;
                WorkProductDescriptor element = (WorkProductDescriptor)WorkProductDescriptorGeneralSection.this.getElement();
                String oldContent = element.getActivityExitState();
                if (WorkProductDescriptorGeneralSection.this.getEditor().mustRestoreValue(WorkProductDescriptorGeneralSection.this.activityExitState, oldContent)) {
                    return;
                }
                String newContent = StrUtil.getPlainText((String)WorkProductDescriptorGeneralSection.this.activityExitState.getText());
                if (!newContent.equals(oldContent) && (status = WorkProductDescriptorGeneralSection.this.actionMgr.doAction(1, (EObject)element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_ActivityExitState(), (Object)newContent, -1))) {
                    WorkProductDescriptorGeneralSection.this.activityExitState.setText(newContent);
                }
            }
        });
        this.ctrl_table_1.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkProductDescriptorGeneralSection.this.viewer_1.getSelection();
                if (selection.size() > 0) {
                    WorkProductDescriptorGeneralSection.this.ctrl_remove_1.setEnabled(true);
                }
            }
        });
        this.ctrl_add_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessWorkProductFilter filter = new ProcessWorkProductFilter(WorkProductDescriptorGeneralSection.this.getConfiguration(), null, FilterConstants.WORKPRODUCTS);
                ArrayList<MethodElement> existingElements = new ArrayList<MethodElement>();
                existingElements.addAll(ProcessUtil.getAssociatedElementList((List)WorkProductDescriptorGeneralSection.this.element.getDeliverableParts()));
                existingElements.add(ProcessUtil.getAssociatedElement((Descriptor)WorkProductDescriptorGeneralSection.this.element));
                existingElements.addAll((Collection)WorkProductDescriptorGeneralSection.this.getParentWorkProducts((BreakdownElement)WorkProductDescriptorGeneralSection.this.element));
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, WorkProductDescriptorGeneralSection.this.element, FilterConstants.WORKPRODUCTS, existingElements);
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.WORKPRODUCTS);
                fd.open();
                WorkProductDescriptorGeneralSection.this.addItems(fd.getSelectedItems());
                WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
            }
        });
        this.ctrl_add_proc_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String tabName = FilterConstants.WORK_PRODUCT_DESCRIPTORS;
                ArrayList<WorkProductDescriptor> existingElements = new ArrayList<WorkProductDescriptor>();
                existingElements.addAll(WorkProductDescriptorGeneralSection.this.element.getDeliverableParts());
                existingElements.add(WorkProductDescriptorGeneralSection.this.element);
                existingElements.addAll(WorkProductDescriptorGeneralSection.this.getParentDeliverables((BreakdownElement)WorkProductDescriptorGeneralSection.this.element));
                Process process = TngUtil.getOwningProcess((BreakdownElement)WorkProductDescriptorGeneralSection.this.element);
                IFilter descriptorFilter = WorkProductDescriptorGeneralSection.this.getDescriptorFilter();
                if (descriptorFilter != null && process != null) {
                    ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), descriptorFilter, process, tabName, existingElements);
                    fd.setBlockOnOpen(true);
                    fd.setTitle(tabName);
                    fd.open();
                    WorkProductDescriptorGeneralSection.this.addFromProcessItems(fd.getSelectedItems());
                    WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
                }
            }
        });
        this.ctrl_remove_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkProductDescriptorGeneralSection.this.viewer_1.getSelection();
                if (selection.size() > 0) {
                    ArrayList rmItems = new ArrayList();
                    rmItems.addAll(selection.toList());
                    WorkProductDescriptorGeneralSection.this.removeItems(rmItems);
                    WorkProductDescriptorGeneralSection.this.viewer_1.refresh();
                    WorkProductDescriptorGeneralSection.this.viewer_1.setSelection(null, true);
                }
            }
        });
        this.linkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String tabName = FilterConstants.WORKPRODUCTS;
                Class<?> workProductType = null;
                if (WorkProductDescriptorGeneralSection.this.element.getWorkProduct() != null) {
                    workProductType = WorkProductDescriptorGeneralSection.this.element.getWorkProduct().getClass();
                }
                ArrayList<Object> existingElements = new ArrayList<Object>();
                if (WorkProductDescriptorGeneralSection.this.element.getWorkProduct() != null) {
                    WorkProduct wp = WorkProductDescriptorGeneralSection.this.element.getWorkProduct();
                    existingElements.add(wp);
                    if (wp instanceof Artifact) {
                        ArrayList subArtifacts = new ArrayList();
                        WorkProductDescriptorGeneralSection.this.getAllSubArtifacts((Artifact)wp, subArtifacts, ((Artifact)wp).getContainedArtifacts());
                        existingElements.addAll(subArtifacts);
                    }
                }
                LinkedList list = ProcessUtil.getSiblings((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (ItemProviderAdapter)WorkProductDescriptorGeneralSection.this.getAdapter(), (Object)WorkProductDescriptorGeneralSection.this.element);
                Iterator itor = list.iterator();
                while (itor.hasNext()) {
                    WorkProduct wp;
                    WorkProductDescriptor wpDesc;
                    Object obj = itor.next();
                    if (!(obj instanceof WorkProductDescriptor) || (wpDesc = (WorkProductDescriptor)obj).equals(WorkProductDescriptorGeneralSection.this.element) || wpDesc.getSuppressed().booleanValue() || (wp = wpDesc.getWorkProduct()) == null) continue;
                    existingElements.add(wp);
                    if (!(wp instanceof Artifact)) continue;
                    ArrayList subArtifacts = new ArrayList();
                    WorkProductDescriptorGeneralSection.this.getAllSubArtifacts((Artifact)wp, subArtifacts, ((Artifact)wp).getContainedArtifacts());
                    existingElements.addAll(subArtifacts);
                }
                ProcessSpecificWorkProductFilter filter = new ProcessSpecificWorkProductFilter(WorkProductDescriptorGeneralSection.this.getConfiguration(), null, tabName, workProductType);
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, WorkProductDescriptorGeneralSection.this.element, tabName, existingElements);
                fd.setBlockOnOpen(true);
                fd.setViewerSelectionSingle(true);
                fd.setTitle(tabName);
                fd.open();
                WorkProductDescriptorGeneralSection.this.setMethodElement(fd.getSelectedItems());
                WorkProductDescriptorGeneralSection.this.ctrl_method_element.setText(WorkProductDescriptorGeneralSection.this.getMethodElementName(WorkProductDescriptorGeneralSection.this.element));
            }

            public void widgetDefaultSelected(SelectionEvent e1) {
            }
        });
    }

    private void getAllSubArtifacts(Artifact artifact, List subArtifacts, List containedArtifacts) {
        Iterator itor = containedArtifacts.iterator();
        while (itor.hasNext()) {
            Object obj = itor.next();
            if (!(obj instanceof Artifact)) continue;
            if (!subArtifacts.contains(obj)) {
                subArtifacts.add(obj);
            }
            this.getAllSubArtifacts((Artifact)obj, subArtifacts, ((Artifact)obj).getContainedArtifacts());
        }
    }

    protected void updateControls() {
        super.updateControls();
        this.activityEntryState.setEditable(this.editable);
        this.activityExitState.setEditable(this.editable);
        this.linkButton.setEnabled(this.editable);
        if (this.ctrl_add_1 != null) {
            this.ctrl_add_1.setEnabled(this.editable);
        }
        if (this.ctrl_add_proc_1 != null) {
            this.ctrl_add_proc_1.setEnabled(this.editable);
        }
        if (this.ctrl_remove_1 != null) {
            this.ctrl_remove_1.setEnabled(this.editable);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof WorkProductDescriptor) {
                this.element = (WorkProductDescriptor)this.getElement();
                super.refresh();
                if (this.wpModelModifyListener != null) {
                    this.activityEntryState.removeModifyListener((ModifyListener)this.wpModelModifyListener);
                    this.activityExitState.removeModifyListener((ModifyListener)this.wpModelModifyListener);
                }
                this.wpModelModifyListener = this.getEditor().createModifyListener((EObject)this.element);
                if (this.wpModelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    this.wpModelModifyListener.setElement((EObject)this.element);
                    this.wpModelModifyListener.setDisable(true);
                }
                this.ctrl_method_element.setText(this.getMethodElementName(this.element));
                this.ctrl_workProduct_type.setText(this.getMethodElementType(this.element));
                this.activityEntryState.setText(this.element.getActivityEntryState());
                this.activityExitState.setText(this.element.getActivityExitState());
                if (this.wpModelModifyListener instanceof MethodElementEditor.ModifyListener) {
                    this.wpModelModifyListener.setDisable(false);
                }
                this.activityEntryState.addModifyListener((ModifyListener)this.wpModelModifyListener);
                this.activityExitState.addModifyListener((ModifyListener)this.wpModelModifyListener);
                if (this.viewer_1 != null) {
                    this.viewer_1.refresh();
                }
                this.toggleSection();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing WorkProductDescriptor general section : " + this.element, (Throwable)ex);
        }
    }

    private void addItems(List items) {
        if (items != null) {
            ArrayList<WorkProduct> wps = new ArrayList<WorkProduct>();
            Iterator itor = items.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof WorkProduct) || this.isPartOfDeliverable((WorkProduct)obj, this.element)) continue;
                wps.add((WorkProduct)obj);
            }
            if (!wps.isEmpty()) {
                AssignWPToDeliverable cmd = new AssignWPToDeliverable(this.element, wps);
                this.actionMgr.execute((IResourceAwareCommand)cmd);
            }
        }
        this.viewer_1.refresh();
    }

    protected IFilter getDescriptorFilter() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object obj) {
                if (obj instanceof Activity) {
                    ArrayList list = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (BreakdownElement)WorkProductDescriptorGeneralSection.this.element, list);
                    return list.contains(obj);
                }
                return obj instanceof WorkProductDescriptor;
            }
        };
    }

    private void addFromProcessItems(List items) {
        if (items != null) {
            Iterator itor = items.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (!(obj instanceof WorkProductDescriptor)) continue;
                WorkProduct wp = ((WorkProductDescriptor)obj).getWorkProduct();
                if (wp != null) {
                    if (!this.isPartOfDeliverable(wp, this.element)) {
                        WorkProductDescriptor wpDesc = ProcessUtil.createWorkProductDescriptor((WorkProduct)wp);
                        this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), (Object)wpDesc, -1);
                    }
                    this.actionMgr.doAction(3, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), obj, -1);
                    continue;
                }
                MessageFormat mf = new MessageFormat(PropertiesResources.getString("Process.DeliverableAssignError"));
                Object[] args = new Object[]{((WorkProductDescriptor)obj).getName(), this.element.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.getString("Process.AssignmentInfoTitle"), mf.format(args));
            }
        }
    }

    private void removeItems(List items) {
        if (!items.isEmpty()) {
            Iterator itor = items.iterator();
            while (itor.hasNext()) {
                Object obj = itor.next();
                if (obj instanceof WorkProductDescriptor) {
                    this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), (Object)((WorkProductDescriptor)obj), -1);
                }
                Object wpDesc = this.findDeliverableParts(obj);
                this.actionMgr.doAction(4, (EObject)this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts(), wpDesc, -1);
            }
        }
    }

    private Object findDeliverableParts(Object obj) {
        List parts = this.element.getDeliverableParts();
        Iterator itor = parts.iterator();
        while (itor.hasNext()) {
            WorkProduct itorWP;
            WorkProduct objWP;
            Object itorObject = itor.next();
            if (!(obj instanceof WorkProductDescriptor) || !(itorObject instanceof WorkProductDescriptor) || !(objWP = ((WorkProductDescriptor)obj).getWorkProduct()).equals(itorWP = ((WorkProductDescriptor)itorObject).getWorkProduct())) continue;
            return itorObject;
        }
        return null;
    }

    protected Object getProcess(BreakdownElement brElement) {
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Process)) {
            brElement = (BreakdownElement)parent;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz2);
            parent = adapter.getParent((Object)brElement);
        }
        return parent;
    }

    private List getParentDeliverables(BreakdownElement brElement) {
        ArrayList<WorkProductDescriptor> parentDeliverables = new ArrayList<WorkProductDescriptor>();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            Class<?> clazz2;
            WorkProductDescriptor wpdesc;
            brElement = (BreakdownElement)parent;
            if (parent instanceof WorkProductDescriptor && (wpdesc = (WorkProductDescriptor)parent).getWorkProduct() instanceof Deliverable) {
                parentDeliverables.add(wpdesc);
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz2);
            parent = adapter.getParent((Object)brElement);
        }
        return parentDeliverables;
    }

    private Object getParentWorkProducts(BreakdownElement brElement) {
        HashSet<WorkProduct> workProducts = new HashSet<WorkProduct>();
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz);
        Object parent = adapter.getParent((Object)brElement);
        while (!(parent instanceof Activity)) {
            Class<?> clazz2;
            WorkProductDescriptor wpdesc;
            brElement = (BreakdownElement)parent;
            if (parent instanceof WorkProductDescriptor && (wpdesc = (WorkProductDescriptor)parent).getWorkProduct() instanceof Deliverable) {
                workProducts.add(wpdesc.getWorkProduct());
            }
            if ((clazz2 = class$0) == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)brElement, (Object)clazz2);
            parent = adapter.getParent((Object)brElement);
        }
        if (parent instanceof Activity) {
            List brElements = ((Activity)parent).getBreakdownElements();
            Iterator itor = brElements.iterator();
            while (itor.hasNext()) {
                WorkProduct wp;
                Object obj = itor.next();
                if (!(obj instanceof WorkProductDescriptor) || (wp = ((WorkProductDescriptor)obj).getWorkProduct()) == null) continue;
                workProducts.add(wp);
            }
        }
        return workProducts;
    }

    public String getNamePrefix() {
        return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT_DESCRIPTOR) + ": ";
    }

    private void setMethodElement(List items) {
        if (items != null && items.size() >= 1 && items.get(0) instanceof WorkProduct) {
            WorkProduct wp = (WorkProduct)items.get(0);
            LinkedList list = ProcessUtil.getSiblings((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (ItemProviderAdapter)this.getAdapter(), (Object)this.element);
            boolean canAssign = true;
            Iterator itor = list.iterator();
            while (itor.hasNext()) {
                WorkProduct exisingWP;
                WorkProductDescriptor wpDesc;
                Object obj = itor.next();
                if (!(obj instanceof WorkProductDescriptor) || (wpDesc = (WorkProductDescriptor)obj).equals(this.element) || wpDesc.getSuppressed().booleanValue() || !wp.equals(exisingWP = wpDesc.getWorkProduct())) continue;
                canAssign = false;
                break;
            }
            if (canAssign) {
                LinkMethodElementCommand cmd = new LinkMethodElementCommand((Descriptor)this.element, (Object)wp, 21);
                this.actionMgr.execute((IResourceAwareCommand)cmd);
                this.getEditor().setSelection(this.getSelection());
            } else {
                MessageFormat mf = new MessageFormat(PropertiesResources.getString("Process.InvalidLinkMethodElement"));
                Object[] args = new Object[]{wp.getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.getString("Process.LinkMethodElementTitle"), mf.format(args));
            }
        }
    }

    private boolean isPartOfDeliverable(WorkProduct wp, WorkProductDescriptor deliverable) {
        List deliverableParts = ProcessUtil.getAssociatedElementList((List)deliverable.getDeliverableParts());
        return deliverableParts.contains(wp);
    }
}

