/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import com.ibm.uma.MethodElement;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.views.HTMLWrappers;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementHTMLViewer {
    private static final String DEFAULT_CONTENT_WRAPPER_START = "<html><head> <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><title>Rational Unfied Process</title><script language=\"javascript\">function init() { parent.ory_toc=\"disable\"; parent.contentframe.location=\"";
    private static final String DEFAULT_CONTENT_WRAPPER_END = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
    private static final String DEFAULT_PRINT_WRAPPER_START = "<html><head> <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"></head><title>Rational Unfied Process</title><script language=\"javascript\">function init() { parent.ory_toc=\"disable\"; parent.contentframe.location=\"print();";
    private static final String DEFAULT_PRINT_WRAPPER_END = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
    private static final String PRINT_FILE = "print.html";
    private String contentWrapperSart;
    private String contentWrapperEnd;
    private String printWrapperSart;
    private String printWrapperEnd;
    private Browser printBrowser;
    protected Browser browser = null;
    protected Composite parent;
    private String currentLocation = null;
    private String currentText = null;
    private HtmlBuilder htmlBuilder;
    private Cursor waitCursor = null;

    public ElementHTMLViewer(Composite parent) {
        this.parent = parent;
        this.htmlBuilder = new HtmlBuilder();
        this.createControl();
    }

    private void createControl() {
        try {
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent e) {
                }

                public void changing(LocationEvent e) {
                    String location = ElementHTMLViewer.this.getElementUrl(e.location);
                    if (location == null || location.startsWith("javascript:")) {
                        return;
                    }
                    if (ElementHTMLViewer.this.isLocationChanged(location)) {
                        ElementHTMLViewer.this.currentLocation = location;
                        ElementHTMLViewer.this.generateHtml(ElementHTMLViewer.this.currentLocation);
                    }
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    String text = event.text;
                    if (text != null && text.length() > 0) {
                        ElementHTMLViewer.this.currentText = text;
                    }
                }
            });
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent event) {
                    if (SWT.getPlatform().equals("win32")) {
                        return;
                    }
                    Display.getCurrent().asyncExec(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            try {
                                Shell shell = new Shell();
                                GridLayout layout = new GridLayout();
                                layout.marginHeight = 0;
                                layout.marginWidth = 0;
                                shell.setLayout((Layout)layout);
                                Browser popup_browser = new Browser((Composite)shell, 0);
                                popup_browser.setLayoutData((Object)new GridData(1808));
                                popup_browser.setUrl(ElementHTMLViewer.access$6(3.access$0(this.this$1)));
                                shell.open();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }

                static /* synthetic */ ElementHTMLViewer access$0(3 var0) {
                    return var0.ElementHTMLViewer.this;
                }
            });
            this.printBrowser = new Browser(this.parent, 0);
            this.printBrowser.setSize(1, 1);
            this.printBrowser.setVisible(false);
            GridData gd = new GridData();
            gd.heightHint = 1;
            this.printBrowser.setLayoutData((Object)gd);
            this.contentWrapperSart = HTMLWrappers.getString("CONTENT_WRAPPER_START");
            if (this.contentWrapperSart == null) {
                this.contentWrapperSart = DEFAULT_CONTENT_WRAPPER_START;
            }
            this.contentWrapperEnd = HTMLWrappers.getString("CONTENT_WRAPPER_END");
            if (this.contentWrapperEnd == null) {
                this.contentWrapperEnd = DEFAULT_CONTENT_WRAPPER_START;
            }
            this.printWrapperSart = HTMLWrappers.getString("PRINT_WRAPPER_START");
            if (this.printWrapperSart == null) {
                this.printWrapperSart = DEFAULT_PRINT_WRAPPER_START;
            }
            this.printWrapperEnd = HTMLWrappers.getString("PRINT_WRAPPER_END");
            if (this.printWrapperEnd == null) {
                this.printWrapperEnd = "\"; }</script></head><frameset rows=\"100%,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\" id=\"contentframeset\" name=\"contentframeset\"><frame src=\"about:blank\" id=\"contentframe\" name=\"contentframe\" scrolling=\"auto\"/><frame src=\"about:blank\" id=\"blankframe\" name=\"blankframe\" onload=\"init()\"/></frameset></html>";
            }
            this.waitCursor = this.parent.getShell().getDisplay().getSystemCursor(1);
        }
        catch (Exception e) {
            this.browser = null;
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private boolean isLocationChanged(String location) {
        if (location == null || this.currentLocation == null) {
            return false;
        }
        if (File.separatorChar != '/') {
            String oldLocation;
            return !(location = location.replace(File.separatorChar, '/')).endsWith(oldLocation = this.currentLocation.replace(File.separatorChar, '/')) && !oldLocation.endsWith(location);
        }
        return !location.endsWith(this.currentLocation) && !this.currentLocation.endsWith(location);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder builder) {
        this.htmlBuilder = builder;
    }

    public void setLayoutManager(ElementLayoutManager layoutMgr) {
        this.htmlBuilder.setLayoutManager(layoutMgr);
    }

    public void showElementContent(Object element) {
        this.startWait();
        try {
            String file_url = "about:blank";
            if (element instanceof MethodElement) {
                file_url = this.htmlBuilder.generateHtml((MethodElement)element);
                if (file_url == null) {
                    file_url = "about:blank";
                } else if (!SWT.getPlatform().equals("win32") && !file_url.startsWith("file://")) {
                    file_url = "file://" + file_url;
                }
            }
            this.currentLocation = file_url;
            this.browser.setUrl(file_url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private void generateHtml(String url) {
        this.startWait();
        try {
            this.htmlBuilder.generateHtml(url);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        this.endWait();
    }

    private String getElementUrl(String location) {
        if (location == null || location.length() == 0 || location.equals("about:blank") || location.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        if ((location = this.getUrl(location)).indexOf("pages_not_installed/") >= 0) {
            return null;
        }
        if (ResourceHelper.getGuidFromFileName((String)location) == null) {
            return null;
        }
        return location;
    }

    private String getUrl(String location) {
        String publish_dir = this.htmlBuilder.getPublishDir();
        String url = this.fixPath(location);
        int index = url.toLowerCase().indexOf(this.fixPath(publish_dir).toLowerCase());
        if (index >= 0) {
            url = url.substring(index + publish_dir.length());
        }
        if ((index = url.indexOf("#")) > 0) {
            url = url.substring(0, index);
        }
        return url;
    }

    private String fixPath(String path) {
        try {
            path = URLDecoder.decode(path, "utf-8");
            if (File.separatorChar != '/') {
                return path.replace(File.separatorChar, '/');
            }
            return path;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void print() {
        String printFile = String.valueOf(this.htmlBuilder.getPublishDir()) + PRINT_FILE;
        if (this.currentLocation != null) {
            StringBuffer wrapperHTML = new StringBuffer();
            wrapperHTML.append(this.printWrapperSart).append(this.currentLocation).append(this.printWrapperEnd);
            String htmlText = wrapperHTML.toString();
            if (FileUtil.writeUTF8File((String)printFile, (String)htmlText)) {
                this.printBrowser.setUrl(printFile);
            }
        }
    }

    private void startWait() {
        this.parent.getShell().setCursor(this.waitCursor);
    }

    private void endWait() {
        this.parent.getShell().setCursor(null);
    }

    public void refresh() {
        this.generateHtml(this.currentLocation);
        this.browser.refresh();
    }

    static /* synthetic */ String access$6(ElementHTMLViewer elementHTMLViewer) {
        return elementHTMLViewer.currentText;
    }
}

