/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.LibraryLocationData;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationMainPage;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewConfigurationWizard
extends Wizard
implements INewWizard {
    protected NewConfigurationMainPage mainPage;
    protected boolean okToComplete = false;
    protected LibraryLocationData llData;

    public NewConfigurationWizard(LibraryLocationData llData) {
        this.llData = llData;
        this.setWindowTitle(AuthoringUIResources.getString("AuthoringUIPlugin.newConfigurationWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.mainPage = new NewConfigurationMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean canFinish() {
        return this.okToComplete;
    }

    public boolean performFinish() {
        this.mainPage.saveDataToDTO(this);
        this.llData.setOkPressed(true);
        if (this.configNameExists(this.llData.getLibName().trim())) {
            this.llData.setOkPressed(false);
            return false;
        }
        return true;
    }

    private boolean configNameExists(String configName) {
        LibraryProcessor lp = LibraryProcessor.getInstance();
        String[] configNames = lp.getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            if (configName.equals(configNames[i])) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUIPlugin.newConfigurationWizard.title"), AuthoringUIResources.formatString("AuthoringUI.duplicateElementNameError.msg", configName));
                return true;
            }
            ++i;
        }
        return false;
    }
}

