/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.UmaFactory;
import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.export.services.ConfigurationSpec;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.services.ConfigSpecs;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigSpecsImportManager {
    ConfigSpecsImportManager() {
    }

    public ConfigSpecs getConfigSpecs(LibraryDocument document) {
        ConfigSpecs configSpecs = new ConfigSpecs();
        NodeList nodes = document.getConfigurations();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            ConfigSpecs.Entry entry = configSpecs.newEntry();
            entry.configSpec = document.getConfigurationSpec(node);
            entry.existingConfig = this.getExistingConfig(entry.configSpec.guid);
            ++i;
        }
        return configSpecs;
    }

    private MethodConfiguration getExistingConfig(String guid) {
        MethodConfiguration[] configs = LibraryProcessor.getInstance().getConfigurations();
        if (configs == null || configs.length == 0) {
            return null;
        }
        int i = 0;
        while (i < configs.length) {
            MethodConfiguration config = configs[i];
            if (config.getGuid().equals(guid)) {
                return config;
            }
            ++i;
        }
        return null;
    }

    public void doImport(ConfigSpecs specs) {
        try {
            MethodLibrary lib = LibraryProcessor.getInstance().getLibrary();
            LibraryUtil.loadAll((MethodLibrary)lib);
            Iterator it = specs.iterator();
            while (it.hasNext()) {
                ConfigSpecs.Entry entry = (ConfigSpecs.Entry)it.next();
                if (!entry.selected) continue;
                MethodConfiguration config = this.createConfig(entry.configSpec);
                if (entry.existingConfig != null) {
                    Object e;
                    List plugins = entry.existingConfig.getMethodPluginSelection();
                    List pkgs = entry.existingConfig.getMethodPackageSelection();
                    List views = entry.existingConfig.getProcessViews();
                    Iterator itp = config.getMethodPluginSelection().iterator();
                    while (itp.hasNext()) {
                        e = itp.next();
                        if (plugins.contains(e)) continue;
                        plugins.add(e);
                    }
                    itp = config.getMethodPackageSelection().iterator();
                    while (itp.hasNext()) {
                        e = itp.next();
                        if (pkgs.contains(e)) continue;
                        pkgs.add(e);
                    }
                    itp = config.getProcessViews().iterator();
                    while (itp.hasNext()) {
                        e = itp.next();
                        if (pkgs.contains(e)) continue;
                        views.add(e);
                    }
                    continue;
                }
                lib.getPredefinedConfigurations().add(config);
            }
            LibraryUtil.saveLibrary((MethodLibrary)lib, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private MethodConfiguration createConfig(ConfigurationSpec spec) {
        MethodPlugin e;
        String guid;
        MethodConfiguration config = UmaFactory.eINSTANCE.createMethodConfiguration();
        config.setName(spec.name);
        config.setBriefDescription(spec.brief_desc);
        config.setGuid(spec.guid);
        List plugins = config.getMethodPluginSelection();
        List pkgs = config.getMethodPackageSelection();
        List views = config.getProcessViews();
        LibraryProcessor libproc = LibraryProcessor.getInstance();
        Iterator it = spec.pluginIds.iterator();
        while (it.hasNext()) {
            guid = (String)it.next();
            e = libproc.getMethodPlugin(guid);
            if (e == null || plugins.contains(e)) continue;
            plugins.add(e);
        }
        it = spec.packageIds.iterator();
        while (it.hasNext()) {
            guid = (String)it.next();
            e = libproc.getElement(guid);
            if (e == null || pkgs.contains(e)) continue;
            pkgs.add(e);
        }
        it = spec.viewIds.iterator();
        while (it.hasNext()) {
            guid = (String)it.next();
            e = libproc.getElement(guid);
            if (e == null || views.contains(e)) continue;
            views.add(e);
        }
        return config;
    }
}

