/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.DiagramElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IFileManager;
import com.ibm.uma.util.UmaUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.ResourceScanner;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;

public class LibraryImportManager {
    private LibraryDiffManager diffMgr;
    private ElementDiffTree rootTree;
    private MethodLibrary baseLibrary = null;
    private MethodLibrary importingLibrary = null;
    private Map replacedElementMap = new HashMap();
    private List newElements = new ArrayList();
    private List deletedElements = new ArrayList();
    private boolean debug = ImportPlugin.getDefault().isDebugging();
    List checkedList = new ArrayList();
    IStatus fileCheckedOutStatus = null;
    List newResources = new ArrayList();
    ResourceScanner resScanner;
    private List processedNewElements = new ArrayList();

    public LibraryImportManager(LibraryDiffManager diffMgr, List checkedItems) {
        this.diffMgr = diffMgr;
        this.rootTree = diffMgr.getDiffTree();
        if (checkedItems != null) {
            this.checkedList.addAll(checkedItems);
            Iterator it = checkedItems.iterator();
            while (it.hasNext()) {
                ElementDiffTree diffTree = (ElementDiffTree)it.next();
                MethodElement e = diffTree.getBaseElement();
                if (e != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if ((e = diffTree.getImportElement()) != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if (!diffTree.isNew()) continue;
                if (e instanceof MethodPlugin) {
                    this.checkedList.addAll(LibraryUtil.getAllPackages((MethodPlugin)((MethodPlugin)e)));
                    continue;
                }
                if (!(e instanceof MethodPackage)) continue;
                LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
            }
        } else {
            this.checkedList = null;
        }
        this.init();
        this.baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        this.importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
        this.resScanner = new ResourceScanner(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary));
    }

    private void init() {
    }

    private boolean isSelected(ElementDiffTree diffTree) {
        if (this.checkedList == null || this.checkedList.contains(diffTree)) {
            return true;
        }
        MethodElement e = diffTree.getBaseElement();
        if (e == null) {
            e = diffTree.getImportElement();
        }
        return this.isSelected(e);
    }

    private boolean isSelected(MethodElement e) {
        if (this.checkedList == null || e instanceof ContentDescription || e.eContainer() instanceof ContentDescription || e instanceof MethodLibrary) {
            return true;
        }
        if (this.checkedList.size() == 0) {
            return false;
        }
        if (e instanceof MethodConfiguration) {
            return this.checkedList.contains(e);
        }
        MethodElement o = (MethodElement)LibraryUtil.getSelectable((EObject)e);
        if (o == null) {
            return false;
        }
        if (o instanceof MethodLibrary) {
            return true;
        }
        return this.checkedList.contains(o);
    }

    public void doMerge(boolean replaceExisting, IProgressMonitor monitor) throws Exception {
        if (this.debug) {
            System.out.println("Merging configuration ...");
        }
        LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary);
        LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary);
        if (this.debug) {
            System.out.println("loading library ...");
        }
        LibraryUtil.loadAll((MethodLibrary)this.baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)this.importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)this.importingLibrary);
        this.importingLibrary.setName("ImportingLib: " + this.importingLibrary.getName());
        if (this.debug) {
            System.out.println("Process configuration diff tree ...");
        }
        ArrayList oldResources = new ArrayList(this.baseLibrary.eResource().getResourceSet().getResources());
        this.processDiffTree(this.rootTree, replaceExisting);
        if (this.debug) {
            System.out.println("perform integrity checking ...");
        }
        this.doIntegrityCheck();
        this.handleNewResources(oldResources);
        if (this.debug) {
            System.out.println("check out files ...");
        }
        this.deleteResoruces();
        final List modifiedFiles = this.getModifiedResources(this.baseLibrary);
        modifiedFiles.addAll(this.resScanner.getFilesTobeReplaced());
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
            }
        });
        if (this.fileCheckedOutStatus.isOK()) {
            if (this.debug) {
                System.out.println("copying resource files ...");
            }
            this.resScanner.execute();
            if (this.debug) {
                System.out.println("saving library ...");
            }
            LibraryUtil.saveLibrary((MethodLibrary)this.baseLibrary, (boolean)false, (boolean)false);
        } else {
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String title = ImportResources.getString("Import.importConfigWizard.title");
                    String msg = ImportResources.getString("Import.ImportConfigurationWizard.ERR_Import_configuration");
                    new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(title, msg, LibraryImportManager.this.fileCheckedOutStatus);
                }
            });
            if (this.debug) {
                System.out.println("Checkout files failed ...");
            }
        }
        if (this.debug) {
            System.out.println("Merging configuration done...");
        }
    }

    private void handleNewResources(List oldResources) {
        Iterator it = this.baseLibrary.eResource().getResourceSet().getResources().iterator();
        while (it.hasNext()) {
            Resource res = (Resource)it.next();
            if (oldResources.contains(res)) continue;
            this.logNewResource(res);
        }
    }

    private void processDiffTree(ElementDiffTree diffTree, boolean replaceExisting) throws Exception {
        List children;
        if (diffTree == null || !this.isSelected(diffTree)) {
            return;
        }
        int state = diffTree.getDiffState();
        MethodElement base = diffTree.getBaseElement();
        MethodElement imp = diffTree.getImportElement();
        if (replaceExisting && state == 4) {
            if (base instanceof MethodConfiguration) {
                this.doReplaceConfiguration((MethodConfiguration)base, (MethodConfiguration)imp);
            } else if (base instanceof MethodPlugin) {
                this.doReplacePlugin((MethodPlugin)base, (MethodPlugin)imp);
            } else if (base instanceof MethodPackage) {
                this.doReplacePackage((MethodPackage)base, (MethodPackage)imp);
            } else if (this.debug) {
                System.out.println("What is this: " + LibraryUtil.getTypeName((MethodElement)base));
            }
        } else if (state == 1) {
            this.doAdd((EObject)diffTree.getBaseParentElement(), diffTree.getImportElement());
        }
        if (state != 1 && (children = diffTree.getChildren()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.processDiffTree((ElementDiffTree)it.next(), replaceExisting);
            }
        }
    }

    private void doReplaceConfiguration(MethodConfiguration oldObj, MethodConfiguration newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object newValue = newObj.eGet(feature);
                this.setFeatureValue((MethodElement)oldObj, feature, newValue, false);
                ++i;
            }
        }
    }

    private void doReplacePlugin(MethodPlugin oldObj, MethodPlugin newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List properties = oldObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                } else {
                    ContentPackage oldPkg = UmaUtil.findContentPackage((MethodPlugin)oldObj, (String[])ModelStructure.DEFAULT_CUSTOM_CATEGORY_PATH);
                    this.setReplaced((MethodElement)oldPkg);
                    CustomCategory oldCC = TngUtil.getRootCustomCategory((MethodPlugin)oldObj);
                    CustomCategory newCC = TngUtil.getRootCustomCategory((MethodPlugin)newObj);
                    oldPkg = (MethodPackage)oldCC.eContainer();
                    this.setReplaced((MethodElement)oldPkg);
                    this.doReplaceElement((MethodElement)oldCC, (MethodElement)newCC);
                }
                ++i;
            }
        }
    }

    private void doReplacePackage(MethodPackage oldObj, MethodPackage newObj) {
        List properties;
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        if (this.debug) {
            System.out.println("Replacing package " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplaceElement(MethodElement oldObj, MethodElement newObj) {
        List properties;
        if (this.isReplaced(oldObj)) {
            return;
        }
        if (this.diffMgr.selectable(oldObj)) {
            return;
        }
        if (!this.isSelected(oldObj)) {
            return;
        }
        if (oldObj instanceof ContentDescription && newObj instanceof ContentDescription && LibraryUtil.isIdentical((MethodElement)((ContentDescription)oldObj), (MethodElement)((ContentDescription)newObj))) {
            Resource res;
            if (this.debug && (res = oldObj.eResource()) != null) {
                System.out.println("Identical element not replaced: " + res.getURI().toFileString());
            }
            return;
        }
        this.setReplaced(oldObj);
        if (this.debug) {
            System.out.println("Replacing element " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((properties = oldObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages() && feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && !feature.isDerived()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue(oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFeatureValue(MethodElement element, EStructuralFeature feature, Object newValue, boolean doDelete) {
        if (this.canIgnore(feature)) {
            return;
        }
        oldNotify = element.eDeliver();
        try {
            try {
                block26: {
                    block28: {
                        block27: {
                            block25: {
                                block24: {
                                    element.eSetDeliver(false);
                                    if (!this.canReset(feature)) break block24;
                                    element.eSet(feature, newValue);
                                    ** GOTO lbl-1000
                                }
                                if (!feature.isMany() || !(newValue instanceof List)) break block25;
                                oldValue = (List)element.eGet(feature);
                                diff = new ElementListDiff(oldValue, (List)newValue);
                                if (doDelete && diff.deletedItems.size() > 0) {
                                    oldValue.removeAll(diff.deletedItems);
                                    this.logRemovedElements(diff.deletedItems);
                                    if (this.debug) {
                                        System.out.println("  Deleting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.deletedItems);
                                    }
                                }
                                if (diff.newItems.size() > 0) {
                                    itn = diff.newItems.iterator();
                                    while (true) {
                                        if (!itn.hasNext()) {
                                            if (!this.debug) break;
                                            System.out.println("  Adding feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.newItems);
                                            break;
                                        }
                                        newObj = (MethodElement)itn.next();
                                        if (!this.isSelected(newObj)) continue;
                                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                                        if (oldObj == null) {
                                            oldValue.add(newObj);
                                            this.logNewElement(newObj);
                                            continue;
                                        }
                                        oldValue.add(oldObj);
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                if (diff.oldNewMap.size() > 0) {
                                    it = diff.oldNewMap.entrySet().iterator();
                                    while (it.hasNext()) {
                                        entry = it.next();
                                        oldObj = (MethodElement)entry.getKey();
                                        if (!this.isSelected(oldObj)) continue;
                                        newObj = (MethodElement)entry.getValue();
                                        if (this.canReset(oldObj)) {
                                            if (this.debug) {
                                                System.out.println("  Resetting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)oldObj));
                                            }
                                            EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)oldObj, (Object)newObj);
                                            this.logResetElement(newObj);
                                            continue;
                                        }
                                        this.doReplaceElement(oldObj, newObj);
                                    }
                                }
                                ** GOTO lbl-1000
                            }
                            if (!(newValue instanceof MethodElement)) break block26;
                            o = (MethodElement)element.eGet(feature);
                            n = (MethodElement)newValue;
                            if (o != null && !this.isSelected(o) || !this.isSelected(n)) ** GOTO lbl-1000
                            if (this.debug) {
                                System.out.println("  Replacinging feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)o));
                            }
                            if (!(newValue instanceof ContentDescription)) break block27;
                            if (o.eContainer() != null || n.eContainer() != null) {
                                if (o.eContainer() == null) {
                                    element.eSet(feature, (Object)o);
                                }
                                this.doReplaceElement(o, n);
                            }
                            ** GOTO lbl-1000
                        }
                        if (!this.canReset(n)) break block28;
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                        ** GOTO lbl-1000
                    }
                    if (o != null && n != null && o.getGuid().equals(n.getGuid())) {
                        this.doReplaceElement(o, n);
                    } else {
                        element.eSet(feature, newValue);
                        this.logNewElement(n);
                    }
                    ** GOTO lbl-1000
                }
                element.eSet(feature, newValue);
                if (newValue instanceof String) {
                    this.resScanner.scan(element, newValue.toString());
                } else if (newValue instanceof URI) {
                    this.resScanner.copyResource(((URI)newValue).getPath());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Throwable var13_15) {
            var12_16 = null;
            element.eSetDeliver(oldNotify);
            throw var13_15;
        }
lbl-1000:
        // 10 sources

        {
            var12_17 = null;
        }
        element.eSetDeliver(oldNotify);
    }

    private void doAdd(EObject owner, MethodElement newObj) throws Exception {
        if (this.debug) {
            System.out.println("Adding element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if (owner == null) {
            return;
        }
        boolean error = false;
        if (owner instanceof MethodLibrary) {
            if (newObj instanceof MethodPlugin) {
                MethodPlugin plugin = (MethodPlugin)newObj;
                ((MethodLibrary)owner).getMethodPlugins().add(plugin);
                LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
            } else if (newObj instanceof MethodConfiguration) {
                ((MethodLibrary)owner).getPredefinedConfigurations().add(newObj);
                LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
            } else {
                error = true;
            }
        } else if (owner instanceof MethodPackage && owner.eContainer() != null && newObj instanceof MethodPackage) {
            ((MethodPackage)owner).getChildPackages().add(newObj);
        } else {
            error = true;
        }
        if (error) {
            String msg = "can't add " + LibraryUtil.getTypeName((MethodElement)newObj) + " to " + LibraryUtil.getTypeName((MethodElement)((MethodPackage)owner));
            ImportPlugin.getDefault().getLogger().logError(msg);
            if (this.debug) {
                System.out.println(msg);
            }
        } else {
            this.logNewElement(newObj);
        }
    }

    private void doIntegrityCheck() {
        while (this.newElements.size() > 0) {
            MethodElement newObj = (MethodElement)this.newElements.remove(0);
            try {
                if (newObj instanceof DiagramElement) {
                    this.fixDiagram((DiagramElement)newObj);
                    continue;
                }
                this.fixNewElementReferences(newObj);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("Exception while fixing new element " + LibraryUtil.getTypeName((MethodElement)newObj));
                }
                e.printStackTrace();
            }
        }
        List configs = this.baseLibrary.getPredefinedConfigurations();
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            LibraryUtil.validateMethodConfiguration((MethodConfiguration)config);
        }
    }

    private void fixNewElementReferences(MethodElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        this.fixNewElementFeatureValue(newObj, feature, o);
                    }
                } else {
                    this.fixNewElementFeatureValue(newObj, feature, value);
                }
                ++i;
            }
        }
    }

    private void fixDiagram(DiagramElement newObj) {
        List properties;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing diagram element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((properties = newObj.getInstanceProperties()) != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    Iterator it = new ArrayList((List)value).iterator();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof MethodElement)) continue;
                        if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                            this.fixNewElementFeatureValue((MethodElement)newObj, feature, o);
                            continue;
                        }
                        if (!(o instanceof DiagramElement)) continue;
                        this.fixDiagram((DiagramElement)o);
                    }
                } else if (value instanceof MethodElement) {
                    if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                        this.fixNewElementFeatureValue((MethodElement)newObj, feature, value);
                    } else if (value instanceof DiagramElement) {
                        this.fixDiagram((DiagramElement)value);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixNewElementFeatureValue(MethodElement element, EStructuralFeature feature, Object obj) {
        if (!(obj instanceof MethodElement)) {
            return;
        }
        if (this.debug) {
            System.out.println("fixing element feature value " + LibraryUtil.getTypeName((MethodElement)element) + ", feature=" + feature.getName());
        }
        boolean oldNotify = element.eDeliver();
        try {
            block12: {
                try {
                    element.eSetDeliver(false);
                    MethodElement newObj = (MethodElement)obj;
                    MethodElement oldObj = this.getReplaced(newObj.getGuid());
                    if (oldObj == null) {
                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                    }
                    if (oldObj == null) {
                        this.fixNewElementReferences(newObj);
                        break block12;
                    }
                    try {
                        EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)newObj, (Object)oldObj);
                    }
                    catch (Exception exception) {
                        EcoreUtil.remove((EObject)element, (EStructuralFeature)feature, (Object)newObj);
                        if (this.debug) {
                            System.out.println("Replaceing feature value failed for element [" + LibraryUtil.getTypeName((MethodElement)element) + "], feature [" + feature.getName() + "], value=" + newObj + ". The feature value is removed. ");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            element.eSetDeliver(oldNotify);
            throw throwable;
        }
        element.eSetDeliver(oldNotify);
    }

    private boolean canReset(MethodElement e) {
        boolean reset = false;
        if (e == null || e instanceof DiagramElement) {
            reset = true;
        }
        return reset;
    }

    private boolean canReset(EStructuralFeature feature) {
        return false;
    }

    private boolean canIgnore(EStructuralFeature feature) {
        if (feature == UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable()) {
            return true;
        }
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainerArtifact();
    }

    private boolean isReplaced(MethodElement oldObj) {
        return this.replacedElementMap.containsKey(oldObj.getGuid());
    }

    private void setReplaced(MethodElement oldObj) {
        String guid = oldObj.getGuid();
        if (!this.replacedElementMap.containsKey(guid)) {
            this.replacedElementMap.put(guid, oldObj);
            this.setModified((EObject)oldObj);
        }
    }

    private MethodElement getReplaced(String guid) {
        return (MethodElement)this.replacedElementMap.get(guid);
    }

    private void copyNewElementResources(MethodElement newObj) {
        List properties = newObj.getInstanceProperties();
        if (properties != null) {
            int i = 0;
            while (i < properties.size()) {
                EStructuralFeature feature = (EStructuralFeature)properties.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof URI) {
                    this.resScanner.copyResource(((URI)value).getPath());
                } else if (value instanceof String) {
                    this.resScanner.scan(newObj, (String)value);
                }
                ++i;
            }
        }
        Iterator it = newObj.eContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof MethodElement)) continue;
            this.copyNewElementResources((MethodElement)o);
        }
    }

    private void logNewElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj) && this.diffMgr.getExistingElement(newObj.getGuid()) == null) {
            this.newElements.add(newObj);
            this.copyNewElementResources(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logResetElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj)) {
            this.newElements.add(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logNewResource(Resource res) {
        if (res != null) {
            res.setModified(true);
            String file = res.getURI().toFileString();
            if (!this.newResources.contains(file)) {
                this.newResources.add(file);
            }
        }
    }

    private void logRemovedElements(List items) {
        if (items == null || items.size() == 0) {
            return;
        }
        Iterator it = items.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            if (e.eContainer() != null || this.deletedElements.contains(e)) continue;
            this.deletedElements.add(e);
        }
    }

    private void setModified(EObject obj) {
        Resource res;
        if (obj != null && (res = obj.eResource()) != null) {
            if (!res.isModified()) {
                res.setModified(true);
            }
            if (this.debug && res.isModified()) {
                System.out.println("Modified: " + res.getURI().toFileString());
            }
        }
    }

    private List getModifiedResources(MethodLibrary lib) {
        ArrayList<String> modifiedList = new ArrayList<String>();
        Resource res = lib.eResource();
        if (res != null) {
            ResourceSet resSet = res.getResourceSet();
            Iterator it = resSet.getResources().iterator();
            while (it.hasNext()) {
                String file;
                res = (Resource)it.next();
                if (res == null || !res.isModified() || this.newResources.contains(file = res.getURI().toFileString())) continue;
                if (this.debug) {
                    System.out.println("Resource modified: " + file);
                }
                modifiedList.add(file);
            }
        }
        return modifiedList;
    }

    private void deleteResoruces() {
        if (this.deletedElements.size() == 0) {
            return;
        }
        IFileManager fileMgr = ContentDescriptionFactory.getFileManager();
        Iterator it = this.deletedElements.iterator();
        while (it.hasNext()) {
            Resource res;
            MethodElement e = (MethodElement)it.next();
            ContentDescription obj = null;
            if (e instanceof DescribableElement) {
                obj = ((DescribableElement)e).getPresentation();
            } else if (e instanceof ContentDescription) {
                obj = e;
            }
            if (obj == null || (res = obj.eResource()) == null) continue;
            String file = res.getURI().toFileString();
            if (this.debug) {
                System.out.println("deleting resource: " + file);
            }
            if (fileMgr.delete(file) || !this.debug) continue;
            System.out.println("unable to delete file: " + file);
        }
    }

    public class ElementListDiff {
        List newItems = new ArrayList();
        List deletedItems = new ArrayList();
        Map oldNewMap = new LinkedHashMap();

        public ElementListDiff(List oldList, List newList) {
            Map newListGuidMap = this.getGuidMap(newList);
            this.newItems.addAll(newList);
            Iterator it = oldList.iterator();
            while (it.hasNext()) {
                MethodElement oldObj = (MethodElement)it.next();
                String guid = oldObj.getGuid();
                Object newObj = newListGuidMap.get(guid);
                if (newObj != null) {
                    this.oldNewMap.put(oldObj, newObj);
                    this.newItems.remove(newObj);
                    continue;
                }
                this.deletedItems.add(oldObj);
            }
        }

        private Map getGuidMap(List items) {
            HashMap<String, MethodElement> m = new HashMap<String, MethodElement>();
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e = (MethodElement)it.next();
                m.put(e.getGuid(), e);
            }
            return m;
        }
    }
}

