/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import com.ibm.uma.ContentCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.IconUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.layout.Bookmark;
import org.eclipse.epf.publishing.services.DefaultElementTypeResources;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public abstract class AbstractViewBuilder {
    private static final String APPLET_PATH = "applet" + File.separatorChar;
    private static final String NO_APPLET_PATH = "noapplet" + File.separatorChar;
    private static final String ICON_PATH = "images" + File.separatorChar;
    protected HtmlBuilder builder;
    protected MethodConfiguration config;
    protected Bookmark defaultView = null;
    protected PublishOptions options = null;
    protected File iconPath;
    protected static final int timeout_millis = 600000;

    public AbstractViewBuilder(HtmlBuilder builder, PublishOptions options) {
        this.builder = builder;
        this.options = options;
        this.config = builder.getLayoutManager().getConfiguration();
        this.iconPath = new File(builder.getPublishDir(), String.valueOf(APPLET_PATH) + ICON_PATH);
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.builder;
    }

    public PublishOptions getOptions() {
        return this.options;
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.builder.getLayoutManager();
    }

    public PublishingContentValidator getValidator() {
        return (PublishingContentValidator)this.getHtmlBuilder().getValidator();
    }

    protected boolean canPublish(MethodElement element) {
        return this.canShow(element);
    }

    protected boolean canShow(MethodElement element) {
        if (element == null) {
            return false;
        }
        if (this.getValidator().isDiscarded(null, null, element)) {
            return false;
        }
        if (!ConfigurationHelper.canShow((MethodElement)element, (MethodConfiguration)this.config)) {
            return false;
        }
        if (this.options != null && this.options.isPublishProcess()) {
            return this.getValidator().inClosure(element);
        }
        return true;
    }

    protected void discardElement(MethodElement element, boolean discard) {
        if (discard) {
            this.getValidator().setDiscardedElement(element);
        } else if (element instanceof ContentCategory) {
            this.getValidator().addValidCategory((ContentCategory)element);
        }
    }

    protected MethodElement calc01FeatureValue(MethodElement element, EStructuralFeature feature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)element, (EStructuralFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement element, EStructuralFeature feature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (EStructuralFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected MethodElement calc01FeatureValue(MethodElement element, OppositeFeature feature) {
        return ConfigurationHelper.calc01FeatureValue((MethodElement)element, (OppositeFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List calc0nFeatureValue(MethodElement element, OppositeFeature feature) {
        return ConfigurationHelper.calc0nFeatureValue((MethodElement)element, (OppositeFeature)feature, (ElementRealizer)this.getLayoutMgr().getElementRealizer());
    }

    protected List getPublishedElements() {
        return this.getValidator().getPublishedElements();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void publish(final IProgressMonitor monitor, final MethodElement element) {
        Runnable runnable = new Runnable(){

            public void run() {
                block6: {
                    try {
                        List linkedElements = AbstractViewBuilder.this.getValidator().getReferencedElements();
                        if (!AbstractViewBuilder.this.canPublish(element)) {
                            AbstractViewBuilder.this.builder.getValidator().logWarning(element, PublishingResources.getString("Publishing.invalidElementWarning.msg"));
                            break block6;
                        }
                        if (AbstractViewBuilder.this.getPublishedElements().contains(element)) break block6;
                        try {
                            if (monitor != null) {
                                String str = linkedElements != null ? PublishingResources.formatString("Publishing.publishingLinkedElementTask.name", Integer.toString(AbstractViewBuilder.this.getPublishedElements().size()), Integer.toString(linkedElements.size())) : PublishingResources.formatString("Publishing.publishingElementTask.name", element.getType().getName(), element.getName());
                                monitor.subTask(str);
                            }
                            AbstractViewBuilder.this.builder.generateHtml(element);
                        }
                        catch (Exception ex) {
                            AbstractViewBuilder.this.builder.getValidator().logError(element, PublishingResources.formatString("Publishing.publishElementError.msg", ex.getMessage()), (Throwable)ex);
                        }
                        AbstractViewBuilder.this.getPublishedElements().add(element);
                    }
                    catch (RuntimeException e) {
                        AbstractViewBuilder.this.builder.getValidator().logError(element, PublishingResources.formatString("Publishing.publishElementError.msg", e.getMessage()), (Throwable)e);
                    }
                }
            }
        };
        Timer timer = new Timer();
        try {
            try {
                this.getValidator().setTargetElement(element);
                Thread t = new Thread(runnable);
                t.start();
                t.join(600000L);
                if (t.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo(element, "publishing element takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    t.join();
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.getValidator().setTargetElement(null);
            this.getValidator().getReferencedElements().remove(element);
            timer.stop();
            this.getValidator().logInfo(element, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
            throw throwable;
        }
        {
            Object var6_9 = null;
            this.getValidator().setTargetElement(null);
            this.getValidator().getReferencedElements().remove(element);
        }
        timer.stop();
        this.getValidator().logInfo(element, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
    }

    private void copyNodeIcon(File source) {
        String name = source.getName();
        File dest = new File(this.iconPath, name);
        if (!ResourceHelper.copyFile((File)source, (File)dest)) {
            this.builder.getValidator().logWarning(PublishingResources.formatString("Publishing.copyFileWarning.msg", source.getAbsolutePath(), dest.getAbsolutePath()));
        }
    }

    private String getNodeIconName(Object obj) {
        File iconFile = null;
        String iconName = null;
        if (obj instanceof DescribableElement) {
            URI uri = ((DescribableElement)obj).getNodeicon();
            String elementName = ((DescribableElement)obj).getType().getName().toLowerCase();
            if (DefaultElementTypeResources.useDefaultIcon(elementName)) {
                uri = null;
            }
            if (uri != null) {
                boolean isFullPath = false;
                try {
                    URL url = uri.toURL();
                    if (url != null) {
                        iconFile = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                        isFullPath = true;
                    }
                }
                catch (Exception exception) {}
                if (!isFullPath) {
                    iconFile = new File(LibraryProcessor.getInstance().getLibraryRootPath(), URLDecoder.decode(uri.toString()));
                }
            }
        }
        if (iconFile != null && !iconFile.exists()) {
            iconFile = null;
        }
        if (iconFile == null && obj instanceof MethodElement) {
            String type = ((MethodElement)obj).getType().getName().toLowerCase();
            iconFile = IconUtil.getNodeIconFile((String)type);
        }
        if (iconFile != null) {
            if (!iconFile.exists()) {
                if (obj instanceof MethodElement) {
                    this.builder.getValidator().logWarning((MethodElement)obj, PublishingResources.formatString("Publishing.missingIconFileWarning.msg", iconFile.getAbsolutePath()));
                } else {
                    this.builder.getValidator().logWarning(PublishingResources.formatString("Publishing.AbstractViewBuilder.MSG15", iconFile.getAbsolutePath()));
                }
            }
            this.copyNodeIcon(iconFile);
            iconName = iconFile.getName();
        }
        if (iconName == null || iconName.length() == 0) {
            String name = obj instanceof MethodElement ? ((MethodElement)obj).getName() : obj.toString();
            this.builder.getValidator().logWarning(PublishingResources.formatString("Publishing.missingIconNameWarning.msg", name));
        }
        return iconName;
    }

    private String getOpenIconName(Object obj) {
        return "";
    }

    private String getName(Object obj) {
        String name = null;
        if (obj instanceof MethodElement) {
            int index;
            MethodElement e = (MethodElement)obj;
            name = ConfigurationHelper.getPresentationName((MethodElement)e, (MethodConfiguration)this.config);
            if ((name == null || name.equals("")) && (index = (name = e.getClass().getName()).lastIndexOf(".")) >= 0 && (name = name.substring(index + 1)).endsWith("Impl")) {
                name = name.substring(0, name.length() - 4);
            }
        } else if (obj instanceof ItemProviderAdapter) {
            ItemProviderAdapter provider = (ItemProviderAdapter)obj;
            name = provider.getText(obj);
        }
        return name;
    }

    private String getGUID(Object obj) {
        if (obj instanceof MethodElement) {
            return ((MethodElement)obj).getGuid();
        }
        return null;
    }

    private String getURL(Object obj) {
        if (obj instanceof MethodElement) {
            return this.getLayoutMgr().getLayout((MethodElement)obj, true).getUrl();
        }
        return "applet//empty.htm";
    }

    protected Bookmark createBookmark(IProgressMonitor monitor, Object element) {
        if (element instanceof MethodElement) {
            this.builder.getValidator().addReferencedElement(null, (MethodElement)element);
        }
        String name = this.getName(element);
        String guid = this.getGUID(element);
        String url = this.getURL(element);
        String nodeIcon = this.getNodeIconName(element);
        String msg = PublishingResources.formatString("Publishing.generatingBookmarkTask.name", name);
        monitor.subTask(msg);
        return this.createBookmark(name, guid, url, nodeIcon, nodeIcon);
    }

    protected Bookmark createBookmark(String name, String guid, String url, String closeIcon, String openIcon) {
        Bookmark b = new Bookmark(name);
        b.setPresentationName(name);
        b.setUniqueId(guid);
        b.setClosedIconName(closeIcon);
        b.setOpenIconName(openIcon);
        b.setFileName(url);
        b.setFromContentLibrary(true);
        b.setEnabled(true);
        b.setExist(true);
        b.setVisible(true);
        b.setTransparency(false);
        b.setDefault(true);
        b.setCurrent(false);
        return b;
    }

    public Bookmark getDefaultView() {
        return this.defaultView;
    }

    protected void copyIconsForNonApplet() {
        try {
            if (!this.options.useApplet) {
                LayoutResources.copyDir((String)this.iconPath.getAbsolutePath(), (String)(String.valueOf(this.builder.getPublishDir()) + NO_APPLET_PATH + ICON_PATH));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public abstract List buildViews(IProgressMonitor var1);

    public void dispose() {
        if (this.builder != null) {
            this.builder.getLayoutManager().clear();
            this.builder.dispose();
        }
        this.config = null;
        this.builder = null;
    }
}

